/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.ui.ADraw2DMouseState;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.SingleFrameSelection;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorTransition;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuHeader;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuItem;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.InteractionFigure;
import edu.cmu.cs.hcii.cogtool.view.ResizeThumb;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;

public class DesignEditorMouseState
extends ADraw2DMouseState {
    public static final int MouseUp = 0;
    public static final int PotentialMovingFrame = 1;
    public static final int PotentialMovingSelection = 2;
    public static final int MovingFrames = 3;
    public static final int PotentialTogglingSelection = 4;
    public static final int TogglingSelection = 5;
    public static final int PotentialSelectingFrames = 6;
    public static final int SelectingFrames = 7;
    public static final int PotentialCreatingTransition = 8;
    public static final int CreatingTransition = 9;
    public static final int PotentialSelectTransition = 10;
    public static final int PotentialToggleTransition = 11;
    public static final int PotentialChangeTarget = 12;
    public static final int PotentialChangeSource = 13;
    public static final int ChangingTarget = 14;
    public static final int ChangingSource = 15;
    protected DesignEditorUI ui;
    protected DesignEditorSelectionState selection;
    protected boolean stopMouseDragTimer = true;
    protected MouseDragTimerTask mouseDragTask = new MouseDragTimerTask();
    protected IFigure rootFigure = null;
    protected boolean cancelDynamic = false;
    protected boolean mouseDown = false;
    protected int mouseDownX = 0;
    protected int mouseDownY = 0;
    protected int mouseDownState = 0;
    protected double scaledMouseDownX = 0.0;
    protected double scaledMouseDownY = 0.0;
    protected int mouseListenerState = 0;
    protected IGraphicalSource potentialTransitionSource = null;
    protected PolylineConnection potentialTransition = null;
    protected PolygonDecoration endPtDecoration;
    protected DesignEditorFrame potentialTarget = null;
    protected RectangleFigure dynamicSelectionArea = null;
    protected DesignEditorTransition hitTransition = null;
    protected final int HYSTERESIS = 3;
    protected org.eclipse.swt.graphics.Point updateDelta = new org.eclipse.swt.graphics.Point(0, 0);

    public DesignEditorMouseState(DesignEditorUI editorUI) {
        super(editorUI);
        this.ui = editorUI;
        this.selection = this.ui.selection;
    }

    protected void setMouseDown(int x, int y, int state) {
        this.mouseDown = true;
        this.mouseDownX = x;
        this.mouseDownY = y;
        this.mouseDownState = state;
        double zoom = this.ui.getZoom();
        this.scaledMouseDownX = (double)x / zoom;
        this.scaledMouseDownY = (double)y / zoom;
    }

    protected void ensureDynamicTransition(int startX, int startY) {
        if (this.potentialTransition == null) {
            this.potentialTransition = new PolylineConnection();
            this.endPtDecoration = new PolygonDecoration();
            this.endPtDecoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
            this.potentialTransition.setStart(new Point(startX, startY));
            this.ui.getViewEditor().addInteractionFigure((IFigure)this.potentialTransition);
        } else if (!this.potentialTransition.isVisible()) {
            this.potentialTransition.setVisible(true);
            this.potentialTransition.setStart(new Point(startX, startY));
        }
    }

    protected void dynamicTransitionTarget(int x, int y) {
        this.potentialTransition.setTargetDecoration(null);
        this.potentialTransition.setTargetDecoration((RotatableDecoration)this.endPtDecoration);
        this.potentialTransition.setEnd(new Point(x, y));
        this.ui.performRepaintUpdates();
    }

    protected void dynamicTransitionSource(int x, int y) {
        this.potentialTransition.setStart(new Point(x, y));
        this.potentialTransition.setTargetDecoration(null);
        this.potentialTransition.setTargetDecoration((RotatableDecoration)this.endPtDecoration);
        this.ui.performRepaintUpdates();
    }

    protected void dynamicTransition(int x, int y) {
        if (this.potentialTransitionSource != null) {
            this.ensureDynamicTransition(this.mouseDownX, this.mouseDownY);
            this.dynamicTransitionTarget(x, y);
        }
    }

    protected void stopDynamicTransition() {
        if (this.potentialTransition != null) {
            this.potentialTransition.setVisible(false);
        }
    }

    protected void updateDynamicMove(int x, int y, boolean updateModel) {
        double zoom = this.ui.getZoom();
        double dx = (double)x / zoom - this.scaledMouseDownX;
        double dy = (double)y / zoom - this.scaledMouseDownY;
        Iterator frameFigs = this.selection.getSelectedFrameFigures();
        while (frameFigs.hasNext()) {
            DesignEditorFrame frameFig = (DesignEditorFrame)frameFigs.next();
            DoublePoint frameOrigin = frameFig.getFrame().getFrameOrigin();
            double newX = frameOrigin.x + dx;
            double newY = frameOrigin.y + dy;
            if (newX < 0.0) {
                newX = 0.0;
            }
            if (newY < 0.0) {
                newY = 0.0;
            }
            this.ui.setFigureOrigin((IFigure)frameFig, newX, newY);
        }
        this.ui.performRepaintUpdates();
        if (updateModel) {
            this.ui.performAction((ListenerIdentifier)DesignEditorLID.MoveFrames, new IDesignEditorUI.MoveParameters(dx, dy, this.selection));
        }
    }

    protected void updateDynamicSelectionArea(int x, int y) {
        if (!this.dynamicSelectionArea.isVisible()) {
            this.dynamicSelectionArea.setVisible(true);
        }
        Rectangle bounds = new Rectangle();
        if (x < this.mouseDownX) {
            bounds.x = x;
            bounds.width = this.mouseDownX - x;
        } else {
            bounds.x = this.mouseDownX;
            bounds.width = x - this.mouseDownX;
        }
        if (y < this.mouseDownY) {
            bounds.y = y;
            bounds.height = this.mouseDownY - y;
        } else {
            bounds.y = this.mouseDownY;
            bounds.height = y - this.mouseDownY;
        }
        this.dynamicSelectionArea.setBounds(bounds);
        this.ui.performRepaintUpdates();
    }

    public void setMouseState(int newState) {
        this.ui.getViewEditor().captureMouseEvents(newState != 0);
        this.mouseListenerState = newState;
    }

    public int getMouseState() {
        return this.mouseListenerState;
    }

    public void mouseDoubleClicked(IFigure figure, int button, int x, int y, int state) {
        this.ui.confirmRenameFrame();
        IFigure target = this.ui.structureView.getFigureAtXY(x, y, 1);
        if (target instanceof DesignEditorFrame.FrameLabel) {
            DesignEditorFrame.FrameLabel frameLabel = (DesignEditorFrame.FrameLabel)target;
            this.ui.initiateFrameRename(frameLabel.getFrameFigure());
        } else if (target instanceof DesignEditorFrame) {
            IFrame frame = ((DesignEditorFrame)target).getFrame();
            this.ui.performAction((ListenerIdentifier)DesignEditorLID.EditFrame, new SingleFrameSelection(frame));
        }
        this.setMouseState(0);
        this.cleanup();
    }

    protected void handleMousePressed(int filter) {
        ResizeThumb thumb;
        if (filter == 2 && (thumb = this.ui.getResizeAtXY(this.mouseDownX, this.mouseDownY)) != null) {
            this.hitTransition = (DesignEditorTransition)((Object)thumb.getData());
            this.selection.setSelectedTransition(this.hitTransition);
            if (thumb.thumbType == 0) {
                this.setMouseState(13);
            } else {
                this.setMouseState(12);
            }
            return;
        }
        IFigure target = this.ui.structureView.getFigureAtXY(this.mouseDownX, this.mouseDownY, filter);
        if (target instanceof DesignEditorTransition) {
            this.hitTransition = (DesignEditorTransition)target;
            if ((this.mouseDownState & 0x20000) != 0) {
                this.setMouseState(11);
            } else {
                this.setMouseState(10);
            }
        } else if (target instanceof IGraphicalSource) {
            this.potentialTransitionSource = (IGraphicalSource)target;
            this.setMouseState(8);
        } else if (target instanceof DesignEditorFrame) {
            DesignEditorFrame frameFigure = (DesignEditorFrame)target;
            IFrame frame = frameFigure.getFrame();
            if ((this.mouseDownState & 0x20000) != 0) {
                this.setMouseState(4);
            } else if (this.selection.isFrameSelected(frame)) {
                this.setMouseState(2);
            } else {
                this.selection.setSelectedFrame(frameFigure);
                this.setMouseState(1);
            }
        } else if ((this.mouseDownState & 0x20000) != 0) {
            this.setMouseState(4);
        } else {
            this.selection.deselectAll();
            this.setMouseState(6);
        }
    }

    public void mousePressed(IFigure figure, int button, int x, int y, int state) {
        super.mousePressed(figure, button, x, y, state);
        this.ui.confirmRenameFrame();
        if (button != 1) {
            return;
        }
        if (this.dynamicSelectionArea == null) {
            this.dynamicSelectionArea = new RectangleFigure();
            this.dynamicSelectionArea.setVisible(false);
            this.dynamicSelectionArea.setOutline(true);
            this.dynamicSelectionArea.setFill(false);
            this.ui.getViewEditor().addInteractionFigure((IFigure)this.dynamicSelectionArea);
        }
        this.setMouseDown(x, y, state);
        switch (this.getMouseState()) {
            case 0: {
                this.handleMousePressed(2);
                break;
            }
        }
        this.cleanup();
    }

    public void mouseReleased(IFigure figure, int button, int x, int y, int state) {
        super.mouseReleased(figure, button, x, y, state);
        this.stopMouseDragTimer = true;
        if (this.cancelDynamic) {
            this.cancelDynamicOperation();
            return;
        }
        double zoom = this.ui.getZoom();
        double scaledMouseUpX = (double)x / zoom;
        double scaledMouseUpY = (double)y / zoom;
        IFigure figureAtXY = this.ui.structureView.getFigureAtXY((int)scaledMouseUpX, (int)scaledMouseUpY, 5);
        DesignEditorFrame frameAtXY = this.ui.structureView.getFrameAtXY(this.mouseDownX, this.mouseDownY);
        if (frameAtXY != null) {
            frameAtXY.hideAllMenuItems();
        }
        int leftX = PrecisionUtilities.round(scaledMouseUpX < this.scaledMouseDownX ? scaledMouseUpX : this.scaledMouseDownX);
        int topY = PrecisionUtilities.round(scaledMouseUpY < this.scaledMouseDownY ? scaledMouseUpY : this.scaledMouseDownY);
        int width = PrecisionUtilities.round(scaledMouseUpX < this.scaledMouseDownX ? this.scaledMouseDownX - scaledMouseUpX + 1.0 : scaledMouseUpX - this.scaledMouseDownX + 1.0);
        int height = PrecisionUtilities.round(scaledMouseUpY < this.scaledMouseDownY ? this.scaledMouseDownY - scaledMouseUpY + 1.0 : scaledMouseUpY - this.scaledMouseDownY + 1.0);
        Rectangle selectionBox = new Rectangle(leftX, topY, width, height);
        switch (this.getMouseState()) {
            case 1: {
                break;
            }
            case 2: {
                DesignEditorFrame frameFig = this.ui.structureView.getFrameAtXY(this.mouseDownX, this.mouseDownY);
                this.selection.setSelectedFrame(frameFig);
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                if (!(figureAtXY instanceof IGraphicalMenuWidget)) break;
                IGraphicalMenuWidget menuToOpen = (IGraphicalMenuWidget)figureAtXY;
                if (menuToOpen instanceof IGraphicalMenuItem && !((IGraphicalMenuItem)menuToOpen).isSubmenu()) {
                    menuToOpen = ((IGraphicalMenuItem)menuToOpen).getParentHeader();
                }
                menuToOpen.openMenu();
                break;
            }
            case 3: {
                this.updateDynamicMove(x, y, true);
                break;
            }
            case 4: {
                this.dynamicSelectionArea.setVisible(false);
                DesignEditorFrame frameFig = this.ui.structureView.getFrameAtXY(this.mouseDownX, this.mouseDownY);
                if (frameFig == null) break;
                if (this.selection.isFrameSelected(frameFig.getFrame())) {
                    this.selection.deselectFrame(frameFig);
                    break;
                }
                if (this.selection.getSelectedTransitionCount() > 0) {
                    this.selection.deselectAll();
                }
                this.selection.selectFrame(frameFig);
                break;
            }
            case 5: {
                this.dynamicSelectionArea.setVisible(false);
                Iterator frameFigures = this.ui.structureView.getAllFrameFigures();
                while (frameFigures.hasNext()) {
                    DesignEditorFrame frameFig = (DesignEditorFrame)frameFigures.next();
                    IFrame frame = frameFig.getFrame();
                    if (!frameFig.intersects(selectionBox)) continue;
                    if (this.selection.isFrameSelected(frame)) {
                        this.selection.deselectFrame(frameFig);
                        continue;
                    }
                    if (this.selection.getSelectedTransitionCount() > 0) {
                        this.selection.deselectAll();
                    }
                    this.selection.selectFrame(frameFig);
                }
                break;
            }
            case 7: {
                this.dynamicSelectionArea.setVisible(false);
                Iterator frameFigures = this.ui.structureView.getAllFrameFigures();
                while (frameFigures.hasNext()) {
                    DesignEditorFrame frameFig = (DesignEditorFrame)frameFigures.next();
                    if (!frameFig.intersects(selectionBox)) continue;
                    this.selection.selectFrame(frameFig);
                }
                break;
            }
            case 9: {
                this.stopDynamicTransition();
                if (this.potentialTarget != null) {
                    this.potentialTarget.paintSelected();
                    this.potentialTarget = null;
                }
                if (this.potentialTransitionSource == null) break;
                DesignEditorFrame targetFigure = this.ui.structureView.getFrameAtXY(x, y);
                ITransitionSource source = this.potentialTransitionSource.getModel();
                IFrame target = targetFigure != null ? targetFigure.getFrame() : (IFrame)null;
                IDesignEditorUI.NewTransitionParameters prms = new IDesignEditorUI.NewTransitionParameters(source, target, scaledMouseUpX, scaledMouseUpY);
                this.ui.performAction((ListenerIdentifier)DesignEditorLID.NewTransition, prms);
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                this.selection.setSelectedTransition(this.hitTransition);
                this.hitTransition = null;
                break;
            }
            case 11: {
                ITransition transition = this.hitTransition.getTransition();
                if (this.selection.isTransitionSelected(transition)) {
                    this.selection.deselectTransition(this.hitTransition);
                } else {
                    if (this.selection.getSelectedFrameCount() > 0) {
                        this.selection.deselectAll();
                    }
                    this.selection.selectTransition(this.hitTransition);
                }
                this.hitTransition = null;
                break;
            }
            case 14: {
                DesignEditorFrame newTargetFigure;
                this.stopDynamicTransition();
                if (this.potentialTarget != null) {
                    this.potentialTarget.paintSelected();
                    this.potentialTarget = null;
                }
                if ((newTargetFigure = this.ui.structureView.getFrameAtXY(x, y)) != null) {
                    ITransition transition = this.hitTransition.getTransition();
                    IDesignEditorUI.ChangeTargetParameters prms = new IDesignEditorUI.ChangeTargetParameters(transition, newTargetFigure.getFrame());
                    this.ui.performAction((ListenerIdentifier)DesignEditorLID.ChangeTarget, prms);
                }
                this.hitTransition.setVisible(true);
                break;
            }
            case 15: {
                this.stopDynamicTransition();
                InteractionFigure drawLayer = this.ui.getViewEditor().getInteractionFigure();
                drawLayer.setCursor(new Cursor((Device)WindowUtil.globalDisplay, 0));
                IGraphicalSource newSourceFigure = this.ui.structureView.getSourceAtXY(x, y);
                this.hitTransition.setVisible(true);
                if (newSourceFigure != null) {
                    ITransition transition = this.hitTransition.getTransition();
                    IDesignEditorUI.ChangeSourceParameters prms = new IDesignEditorUI.ChangeSourceParameters(transition, newSourceFigure.getModel());
                    this.ui.performAction((ListenerIdentifier)DesignEditorLID.ChangeSource, prms);
                }
                this.hitTransition = null;
                break;
            }
        }
        this.setMouseState(0);
        this.mouseDown = false;
        this.cleanup();
    }

    protected boolean withinHysteresis(int eventX, int eventY) {
        return Math.abs(eventX - this.mouseDownX) < 3 && Math.abs(eventY - this.mouseDownY) < 3;
    }

    public void mouseDragged(IFigure figure, int button, int eventX, int eventY, int state) {
        if (this.mouseDown) {
            InteractionDrawingEditor editor = this.ui.getViewEditor();
            this.stopMouseDragTimer = true;
            this.cancelDynamic = editor.movePointNearEdge(eventX, eventY, this.updateDelta);
            switch (this.getMouseState()) {
                case 1: 
                case 2: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.setMouseState(3);
                }
                case 3: {
                    this.updateDynamicMove(eventX, eventY, false);
                    break;
                }
                case 4: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.setMouseState(5);
                }
                case 5: {
                    this.updateDynamicSelectionArea(eventX, eventY);
                    break;
                }
                case 6: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.setMouseState(7);
                }
                case 7: {
                    this.updateDynamicSelectionArea(eventX, eventY);
                    break;
                }
                case 8: {
                    IFigure target;
                    if (this.withinHysteresis(eventX, eventY) || (target = this.ui.structureView.getFigureAtXY(this.mouseDownX, this.mouseDownY, 5)) instanceof IGraphicalMenuHeader || target instanceof IGraphicalMenuItem && ((IGraphicalMenuItem)target).isSubmenu()) break;
                    this.setMouseState(9);
                    this.selection.deselectAll();
                }
                case 9: {
                    this.dynamicTransition(eventX, eventY);
                    DesignEditorFrame targetFigure = this.ui.structureView.getFrameAtXY(eventX, eventY);
                    if (targetFigure == this.potentialTarget) break;
                    if (this.potentialTarget != null) {
                        this.potentialTarget.paintSelected();
                    }
                    this.potentialTarget = targetFigure;
                    if (this.potentialTarget == null) break;
                    this.potentialTarget.dynamicHighlight();
                    break;
                }
                case 10: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.handleMousePressed(3);
                    switch (this.getMouseState()) {
                        case 1: {
                            this.setMouseState(3);
                            this.updateDynamicMove(eventX, eventY, false);
                            break;
                        }
                        case 6: {
                            this.setMouseState(7);
                            this.updateDynamicSelectionArea(eventX, eventY);
                            break;
                        }
                        case 8: {
                            this.setMouseState(9);
                            this.dynamicTransition(eventX, eventY);
                        }
                    }
                    break;
                }
                case 11: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.handleMousePressed(3);
                    this.setMouseState(5);
                    this.updateDynamicSelectionArea(eventX, eventY);
                    break;
                }
                case 12: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.setMouseState(14);
                    Point start = this.hitTransition.getStart();
                    this.hitTransition.setVisible(false);
                    double zoom = this.ui.getZoom();
                    double startX = (double)start.x * zoom;
                    double startY = (double)start.y * zoom;
                    this.ensureDynamicTransition(PrecisionUtilities.round(startX), PrecisionUtilities.round(startY));
                }
                case 14: {
                    this.dynamicTransitionTarget(eventX, eventY);
                    DesignEditorFrame targetFigure = this.ui.structureView.getFrameAtXY(eventX, eventY);
                    if (targetFigure == this.potentialTarget) break;
                    if (this.potentialTarget != null) {
                        this.potentialTarget.paintSelected();
                    }
                    this.potentialTarget = targetFigure;
                    if (this.potentialTarget == null) break;
                    this.potentialTarget.dynamicHighlight();
                    break;
                }
                case 13: {
                    if (this.withinHysteresis(eventX, eventY)) break;
                    this.setMouseState(15);
                    this.hitTransition.setVisible(false);
                    this.ensureDynamicTransition(this.mouseDownX, this.mouseDownY);
                    Point endPt = this.hitTransition.getEnd();
                    double zoom = this.ui.getZoom();
                    double endX = (double)endPt.x * zoom;
                    double endY = (double)endPt.y * zoom;
                    this.dynamicTransitionTarget(PrecisionUtilities.round(endX), PrecisionUtilities.round(endY));
                    break;
                }
                case 15: {
                    this.dynamicTransitionSource(eventX, eventY);
                    IGraphicalSource sourceFigure = this.ui.structureView.getSourceAtXY(eventX, eventY);
                    InteractionFigure drawLayer = this.ui.getViewEditor().getInteractionFigure();
                    if (sourceFigure != null) {
                        drawLayer.setCursor(new Cursor((Device)WindowUtil.globalDisplay, 2));
                        break;
                    }
                    drawLayer.setCursor(new Cursor((Device)WindowUtil.globalDisplay, 0));
                    break;
                }
            }
            if (this.updateDelta.x != 0 || this.updateDelta.y != 0) {
                if (this.rootFigure == null) {
                    this.rootFigure = this.ui.getViewEditor().getInteractionFigure();
                }
                this.stopMouseDragTimer = false;
                this.mouseDragTask.setNextMousePosition(eventX + this.updateDelta.x, eventY + this.updateDelta.y, button, state);
                WindowUtil.globalDisplay.timerExec(100, (Runnable)this.mouseDragTask);
            }
        }
        this.cleanup();
    }

    public void mouseExited(IFigure figure, int x, int y, int state) {
        this.stopMouseDragTimer = true;
        this.cancelDynamic = true;
    }

    public void mouseEntered(IFigure figure, int x, int y, int state) {
        this.cancelDynamic = false;
    }

    protected void cancelDynamicOperation() {
        this.cancelDynamic = false;
        switch (this.getMouseState()) {
            case 3: {
                this.updateDynamicMove(this.mouseDownX, this.mouseDownY, false);
                break;
            }
            case 5: 
            case 7: {
                this.dynamicSelectionArea.setVisible(false);
                break;
            }
            case 9: {
                this.stopDynamicTransition();
                if (this.potentialTarget == null) break;
                this.potentialTarget.paintSelected();
                this.potentialTarget = null;
                break;
            }
            case 14: 
            case 15: {
                this.stopDynamicTransition();
                if (this.potentialTarget != null) {
                    this.potentialTarget.paintSelected();
                    this.potentialTarget = null;
                }
                this.hitTransition.setVisible(true);
            }
        }
        this.setMouseState(0);
        this.ui.resetVisibleArea();
    }

    public void keyPressed(KeyEvent ke) {
        switch (ke.keycode) {
            case 27: {
                this.cancelDynamicOperation();
                break;
            }
            case 0x1000001: {
                this.ui.performAction(CogToolLID.NudgeUp);
                break;
            }
            case 0x1000002: {
                this.ui.performAction(CogToolLID.NudgeDown);
                break;
            }
            case 0x1000003: {
                this.ui.performAction(CogToolLID.NudgeLeft);
                break;
            }
            case 0x1000004: {
                this.ui.performAction(CogToolLID.NudgeRight);
                break;
            }
            case 13: {
                this.ui.performAction(DesignEditorLID.InitiateFrameRename);
                break;
            }
            case 8: 
            case 127: {
                this.ui.performAction(CogToolLID.Delete);
            }
        }
    }

    protected class MouseDragTimerTask
    implements Runnable {
        protected int mouseX;
        protected int mouseY;
        protected int mouseButton;
        protected int mouseState;

        protected MouseDragTimerTask() {
        }

        public void run() {
            if (!DesignEditorMouseState.this.stopMouseDragTimer) {
                DesignEditorMouseState.this.mouseDragged(DesignEditorMouseState.this.rootFigure, this.mouseButton, this.mouseX, this.mouseY, this.mouseState);
            }
        }

        public void setNextMousePosition(int newMouseX, int newMouseY, int button, int state) {
            this.mouseX = newMouseX;
            this.mouseY = newMouseY;
            this.mouseButton = button;
            this.mouseState = state;
        }
    }
}

