/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.ui.DefaultInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.util.FontUtils;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.ActionChangePropertySet;
import edu.cmu.cs.hcii.cogtool.view.IActionChangePropertySet;
import edu.cmu.cs.hcii.cogtool.view.IView;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;

public class DesignEditorInteraction
extends DefaultInteraction
implements IDesignEditorInteraction {
    protected static final String needSelectionMsg = L10N.get("DE.NeedSelection", "You must select a frame or transition.");
    protected static final String needSingleFrameSelectionMsg = L10N.get("DE.NeedSingleFrameSelection", "You must select a single frame for renaming.");
    protected static final String cannotEditMultipleTransitions = L10N.get("DE.CannotEditMultipleTransitions", "We cannot edit multiple transitions at the same time.");
    protected static final String confirmDeleteFramesMsg = L10N.get("DE.ConfirmDeleteFrames", "Please confirm the deletion of the following Frame(s):");
    protected static final String confirmDeleteTransitionsMsg = L10N.get("DE.ConfirmDeleteTransitions", "Please confirm the deletion of the selected Transition(s).");
    protected static final String confirmTitle = L10N.get("DE.ConfirmTitle", "Confirm Deletion");
    protected static final String errorTitle = L10N.get("DE.ErrorTitle", "Design Editor Error");
    protected static final String frameNotUniqueMsg = L10N.get("DE.NotUniqueFrameName", "Frame names must be unique.\nWould you like to try again?");
    protected static final String frameEmptyNameMsg = L10N.get("DE.EmptyFrameName", "Frame names must not be empty.\nWould you like to try again?");
    protected static final String inconsistentSourceMsg = L10N.get("DE.InconsistentSource", "One cannot change a transition's source to an incompatible widget type.");
    protected static final String emptyVoiceMsg = L10N.get("DE.EmptyVoice", "What voice command should activate this transition?");
    protected static final String askForVoice = L10N.get("DE.AskForVoice", "Voice Command:");
    protected static final String emptyKeysMsg = L10N.get("DE.EmptyKeys", "What sequence of keystrokes should activate this transition?");
    protected static final String askForKeys = L10N.get("DE.AskForKeys", "Key Sequence:");
    protected static final String emptyGraffitiMsg = L10N.get("DE.EmptyGraffiti", "What sequence of Graffiti\u00ae gestures should activate this transition?");
    protected static final String askForGraffiti = L10N.get("DE.AskForGraffiti", "Graffiti\u00ae Gestures:");
    protected static final String nonuniqueActionMsg = L10N.get("DE.NonuniqueAction", "Cannot have two transitions using this action from this source: ");
    protected static final String actionsInUseMsg = L10N.get("DE.ActionsInUse", "Actions currently in use: ");
    protected static final String unacceptableActionMsg = L10N.get("DE.UnacceptableAction", "Unacceptable action for this source: ");
    protected int deviceTypes;

    protected static String convertToDisplay(IAction a) {
        return KeyDisplayUtil.convertActionToDisplay(a.getLocalizedString());
    }

    public DesignEditorInteraction(IView view, int devTypes) {
        super(view);
        this.deviceTypes = devTypes;
    }

    public void protestNoSelection() {
        this.reportProblem(errorTitle, needSelectionMsg);
    }

    public void protestMultipleFrameSelection() {
        this.reportProblem(errorTitle, needSingleFrameSelectionMsg);
    }

    public void protestMultipleTransitionSelection() {
        this.reportProblem(errorTitle, cannotEditMultipleTransitions);
    }

    public boolean confirmDeleteFrames(IFrame[] frames) {
        return 32 == WindowUtil.presentConfirmItemsDialog(this.window, confirmTitle, confirmDeleteFramesMsg, frames);
    }

    public boolean confirmDeleteTransitions(ITransition[] transitions) {
        String msg = confirmDeleteTransitionsMsg;
        return 32 == WindowUtil.presentConfirmDialog(this.window, confirmTitle, msg);
    }

    public boolean protestNotUniqueFrameName() {
        return this.reportAndRetry(errorTitle, frameNotUniqueMsg);
    }

    public boolean protestEmptyFrameName() {
        return this.reportAndRetry(errorTitle, frameEmptyNameMsg);
    }

    public void protestInconsistentSource() {
        this.reportProblem(errorTitle, inconsistentSourceMsg);
    }

    protected boolean protestEmptyText(IDesignEditorUI.ActionProperties properties, int limitMode, String specificComplaint) {
        NewActionChangeDialog newAction = new NewActionChangeDialog();
        newAction.setProperties(properties, limitMode, specificComplaint);
        Object response = newAction.open();
        return response != null && response.equals("OK");
    }

    public boolean protestEmptyVoice(IDesignEditorUI.ActionProperties properties, int limitMode) {
        return this.protestEmptyText(properties, limitMode, emptyVoiceMsg);
    }

    public boolean protestEmptyKeys(IDesignEditorUI.ActionProperties properties, int limitMode) {
        return this.protestEmptyText(properties, limitMode, emptyKeysMsg);
    }

    public boolean protestEmptyGraffiti(IDesignEditorUI.ActionProperties properties, int limitMode) {
        return this.protestEmptyText(properties, limitMode, emptyGraffitiMsg);
    }

    protected String promptForStringOrCancel(WindowUtil.PromptDialog dialog) {
        Object result = dialog.open();
        if (result != null && result.equals("OK")) {
            return dialog.getPromptResponse();
        }
        return null;
    }

    public boolean protestNotUniqueAction(IAction action, ITransitionSource source, boolean allowRetry) {
        String actionStr = KeyDisplayUtil.convertActionToMenuText(action.getLocalizedString());
        if (allowRetry) {
            return this.reportAndRetry(errorTitle, nonuniqueActionMsg + actionStr + " on " + source.getName());
        }
        this.reportProblem(errorTitle, nonuniqueActionMsg + actionStr + " on " + source.getName());
        return false;
    }

    public void protestUnacceptableAction(IAction action, ITransitionSource source) {
        String actionStr = KeyDisplayUtil.convertActionToMenuText(action.getLocalizedString());
        this.reportProblem(errorTitle, unacceptableActionMsg + actionStr + " on " + source.getName());
    }

    public boolean determineNewAction(IDesignEditorUI.ActionProperties props, int limitMode) {
        return this.determineNewAction(props, limitMode, null, null, null);
    }

    public boolean determineNewAction(IDesignEditorUI.ActionProperties props, int limitMode, IAction action, ITransitionSource source, ITransition actionTransition) {
        NewActionChangeDialog newAction = new NewActionChangeDialog();
        newAction.setProperties(props, limitMode, action, source, actionTransition);
        Object response = newAction.open();
        return response != null && response.equals("OK");
    }

    public String askForImageDir() {
        DirectoryDialog dialog = new DirectoryDialog(this.window);
        dialog.setText(L10N.get("DE.SelectImages", "Select a directory of images"));
        dialog.setMessage(L10N.get("DE.DirectoryOfImages", "Select a directory with a set of images (.JPG, .PNG or .GIF) to import."));
        return dialog.open();
    }

    protected class NewActionChangeDialog
    extends WindowUtil.CustomDialog {
        protected IActionChangePropertySet propertySet;
        protected IDesignEditorUI.ActionProperties properties;
        protected int mode;
        protected String complaint;
        protected Label complaintLabel;
        protected int complaintMode;

        public NewActionChangeDialog() {
            super(DesignEditorInteraction.this.window, L10N.get("DE.ChangeActionType", "Change Action Type"), 32768, 16);
            this.propertySet = null;
            this.properties = null;
            this.mode = 6;
            this.complaint = null;
            this.complaintLabel = null;
            this.complaintMode = -1;
        }

        public void setProperties(IDesignEditorUI.ActionProperties props, int limitMode, String complaintStr) {
            if (props == null) {
                throw new InvalidParameterException("Attempted to set Action properties to a null value");
            }
            this.properties = props;
            this.mode = limitMode;
            this.complaint = complaintStr;
        }

        public void setProperties(IDesignEditorUI.ActionProperties props, int limitMode, IAction action, ITransitionSource source, ITransition actionTransition) {
            if (props != null) {
                this.properties = props;
                this.mode = limitMode;
                if (action != null) {
                    StringBuffer buff = new StringBuffer(nonuniqueActionMsg + "\n    " + DesignEditorInteraction.convertToDisplay(action) + " on " + source.getName());
                    Map transitions = source.getTransitions();
                    if (transitions.size() > 1) {
                        buff.append("\n" + actionsInUseMsg);
                        Iterator transitionIt = transitions.values().iterator();
                        while (transitionIt.hasNext()) {
                            ITransition t = (ITransition)transitionIt.next();
                            if (t == actionTransition) continue;
                            buff.append("\n    " + DesignEditorInteraction.convertToDisplay(t.getAction()));
                        }
                    }
                    this.complaint = buff.toString();
                }
            } else {
                throw new InvalidParameterException("Attempted to set Action properties to a null value");
            }
        }

        protected void onOK() {
            this.propertySet.getProperties(this.properties);
            super.onOK();
        }

        protected void addMoreFields() {
            GridData reqLayout;
            if (this.complaint != null) {
                reqLayout = new GridData();
                reqLayout.grabExcessHorizontalSpace = true;
                reqLayout.horizontalSpan = 4;
                this.complaintLabel = new Label((Composite)this.dialog, 0);
                this.complaintLabel.setText(this.complaint);
                this.complaintLabel.setLayoutData((Object)reqLayout);
                this.complaintLabel.setFont(FontUtils.SYMBOL_FONT);
                this.complaintMode = this.properties.useWhichParts;
            }
            reqLayout = new GridData(256);
            reqLayout.grabExcessHorizontalSpace = true;
            reqLayout.horizontalSpan = 4;
            Composite c = new Composite((Composite)this.dialog, 0);
            c.setLayoutData((Object)reqLayout);
            this.propertySet = new ActionChangePropertySet(this, DesignEditorInteraction.this.deviceTypes, c, this){
                private final /* synthetic */ NewActionChangeDialog this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2);
                }

                protected void userSelectedMode(int mode) {
                    super.userSelectedMode(mode);
                    if (this.this$1.complaintLabel != null) {
                        this.this$1.complaintLabel.setVisible(mode == this.this$1.complaintMode);
                    }
                }
            };
            this.propertySet.layOutPropertiesPane();
            if (this.properties == null) {
                throw new InvalidParameterException("Properties is still null!");
            }
            this.propertySet.setProperties(this.properties, this.mode);
        }
    }
}

