/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.ControllerNexus;
import edu.cmu.cs.hcii.cogtool.controller.ControllerRegistry;
import edu.cmu.cs.hcii.cogtool.controller.DefaultController;
import edu.cmu.cs.hcii.cogtool.controller.IController;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.ui.AUI;
import edu.cmu.cs.hcii.cogtool.ui.DefaultWindowMenuData;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.UndoManagerFactory;
import edu.cmu.cs.hcii.cogtool.view.MenuFactory;
import java.util.EventObject;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public abstract class DefaultUI
extends AUI
implements MenuFactory.ILeadItemUpdater {
    protected static String WINDOW_TITLE = L10N.get("PM.WindowTitle", " - CogTool");
    protected IProject project;
    protected String modificationFlag;
    protected ShellAdapter closeListener;
    protected MenuFactory.IWindowMenuData menuData = null;
    protected IAlertHandler undoMgrTitleHandler = new IAlertHandler(){

        public void handleAlert(EventObject evt) {
            UndoManagerFactory.SavePointChange chg = (UndoManagerFactory.SavePointChange)evt;
            DefaultUI.this.updateModificationFlag(chg.nowAtSavePoint);
            DefaultUI.this.updateTitle();
        }
    };
    protected IAlertHandler renameHandler = new IAlertHandler(){

        public void handleAlert(EventObject evt) {
            DefaultUI.this.updateTitle();
            DefaultUI.this.updateWindowMenus();
        }
    };
    protected static final String OPEN_PROJECT_LABEL = L10N.get("MI.OpenProject", "Display Project");
    protected static final String OPEN_DESIGN_LABEL = L10N.get("MI.OpenDesign", "Display Design");

    protected static MenuUtil.MenuItemDefinition[] buildLeadItems(IProject p, IDesign d) {
        RestoreParentControllerLID openProjectLID = null;
        RestoreParentControllerLID openDesignLID = null;
        boolean openProjectEnabled = false;
        boolean openDesignEnabled = false;
        String openProjectLabel = OPEN_PROJECT_LABEL;
        String openDesignLabel = OPEN_DESIGN_LABEL;
        if (p != null) {
            openProjectLID = new RestoreParentControllerLID(p, null);
            openProjectEnabled = true;
            openProjectLabel = openProjectLabel + ": " + p.getName();
            if (d != null) {
                openDesignLID = new RestoreParentControllerLID(p, d);
                openDesignEnabled = true;
                openDesignLabel = openDesignLabel + ": " + d.getName();
            }
        }
        return new MenuUtil.MenuItemDefinition[]{new MenuUtil.SimpleMenuItemDefinition(openProjectLabel, (ListenerIdentifier)openProjectLID, openProjectEnabled), new MenuUtil.SimpleMenuItemDefinition(openDesignLabel, openDesignLID, openDesignEnabled), MenuUtil.SEPARATOR};
    }

    protected static MenuUtil.MenuItemDefinition[] buildLeadItems(IProject p) {
        return DefaultUI.buildLeadItems(p, null);
    }

    protected static MenuUtil.MenuItemDefinition[] buildLeadItems() {
        return DefaultUI.buildLeadItems(null, null);
    }

    public DefaultUI(IProject proj, String windowMenuLabel, MenuUtil.MenuItemDefinition[] leadItems) {
        this.project = proj;
        if (this.project != null) {
            this.updateModificationFlag(CogTool.undoManagerFactory.isAtSavePoint(this.project));
            this.project.addHandler(this, NameChangeAlert.class, this.renameHandler);
            CogTool.undoManagerFactory.addSavePointChangeHandler(this.project, this.undoMgrTitleHandler);
        }
        this.menuData = new DefaultWindowMenuData(this.project, windowMenuLabel, leadItems);
    }

    protected abstract Object getModelObject();

    protected void updateModificationFlag(boolean atSavePoint) {
        this.modificationFlag = atSavePoint ? "" : "* ";
    }

    protected void updateTitle() {
    }

    protected abstract String buildWindowMenuLabel();

    public void updateLeadItem(MenuItem leadItem, int position) {
        Object itemData = leadItem.getData();
        if (itemData != null && itemData instanceof RestoreParentControllerLID) {
            RestoreParentControllerLID lid = (RestoreParentControllerLID)itemData;
            if (lid.design != null) {
                leadItem.setText(OPEN_DESIGN_LABEL + ": " + lid.design.getName());
            } else if (lid.project != null) {
                leadItem.setText(OPEN_PROJECT_LABEL + ": " + lid.project.getName());
            }
        }
    }

    protected void updateWindowMenus() {
        this.menuData.setEntryLabel(this.buildWindowMenuLabel());
        MenuFactory.updateMenuLabels(this.menuData, this);
    }

    protected void setInitiallyEnabled() {
        super.setInitiallyEnabled();
        this.setEnabled(CogToolLID.Paste, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SaveProject, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SaveProjectAs, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.CloseWindow, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.CloseProject, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.Properties, ListenerIdentifierMap.ALL, true);
        final Shell window = this.getShell();
        this.closeListener = new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ControllerNexus.ONLY.saveWindowLocation(DefaultUI.this.project, DefaultUI.this.getModelObject(), window.getBounds());
                e.doit = DefaultUI.this.performAction(CogToolLID.CloseWindow, null, false);
            }
        };
        if (window != null) {
            window.addShellListener((ShellListener)this.closeListener);
        }
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        if (originalLID instanceof RestoreParentControllerLID) {
            return ((RestoreParentControllerLID)originalLID).restoreWindow();
        }
        return super.getParameters(originalLID, transmutedLID, isContextSelection);
    }

    public void dispose() {
        this.project.removeAllHandlers(this);
        CogTool.undoManagerFactory.removeSavePointChangeHandler(this.project, this.undoMgrTitleHandler);
        Shell window = this.getShell();
        if (window != null && this.closeListener != null) {
            window.removeShellListener((ShellListener)this.closeListener);
        }
        super.dispose();
    }

    public Rectangle getWindowLocation() {
        return ControllerNexus.ONLY.getWindowLocation(this.project, this.getModelObject());
    }

    public double getWindowZoom(Object model) {
        return ControllerNexus.ONLY.getWindowZoom(this.project, model);
    }

    public void saveWindowZoom(Object model, double zoom) {
        ControllerNexus.ONLY.saveWindowZoom(this.project, model, zoom);
    }

    protected void closeOpenController() {
        DefaultController c = ControllerRegistry.ONLY.findOpenController(this.getModelObject());
        if (c != null) {
            c.dispose();
        }
    }

    public static class RestoreParentControllerLID
    extends ListenerIdentifier {
        public final IProject project;
        public final IDesign design;

        public RestoreParentControllerLID(IProject p, IDesign d) {
            this.project = p;
            this.design = d;
        }

        public IController restoreWindow() {
            DefaultController window = null;
            if (this.design == null) {
                boolean notModified = CogTool.undoManagerFactory.isAtSavePoint(this.project);
                window = CogTool.projectControllerFactory.openController(this.project, false, notModified);
            } else {
                window = CogTool.designEditorControllerFactory.openController(this.design, this.project);
            }
            return window;
        }
    }
}

