/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.util.ErrorDialog;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.ICancelable;
import edu.cmu.cs.hcii.cogtool.util.IEnableDisable;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.ThreadProgressBar;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.PersistenceView;
import java.io.File;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DefaultInteraction
implements IInteraction {
    protected static final String errorTitle = L10N.get("DEFINT.Error", "File Error");
    protected static final String unreadableFileMsg = L10N.get("DEFINT.CannotReadFile", "The selected file cannot be read.");
    protected static final String invalidImageFileMsg = L10N.get("DEFINT.InvalidImageFile", "The selected file does not contain a valid image.");
    protected static final String selectWebPageExportDialogTitle = L10N.get("PM.webpageExportDialigTitle", "Select a Directory to Export the Design Into");
    protected static final String selectWebPageExportDialogMessage = L10N.get("PM.webpageExportDialigMessage", "The contents of the selected directory will be 'replaced' with the exported design.");
    protected static final String projectPropertiesTitle = L10N.get("DI.ProjectPropertiesTitle", "Project Properties");
    protected static final String buildVersionLabel = L10N.get("DI.BuildVersionLabel", "Build Version");
    protected static final String unknownBuildVersion = L10N.get("DI.UnknownBuildVersion", "Unknown build version");
    protected static final String unsavedProject = L10N.get("DI.UnsavedProject", "Unsaved project");
    protected static final String fileInUse = L10N.get("DI.FileInUse", "The file selected is being used by another project being edited:");
    protected IView view;
    protected Shell window;
    protected PersistenceView persistView;
    protected int csvNum = 1;
    protected static String OVERWRITE = L10N.get("DI.Overwrite", "Overwrite");
    protected static String SELECT_AGAIN = L10N.get("DI.SelectAgain", "Select another file");
    protected static String CANCEL_SAVE = L10N.get("DI.Cancel", "Cancel");
    protected static final String exportCanceledMsg = L10N.get("DEFINT.ExportCanceled", "Export canceled.");

    public DefaultInteraction(IView v) {
        this.view = v;
        this.window = v.getShell();
        this.persistView = new PersistenceView(this.window);
    }

    public void reportProblem(String title, String msg) {
        WindowUtil.presentErrorDialog(this.window, title, msg);
    }

    public boolean reportAndRetry(String title, String msg) {
        return 1024 == WindowUtil.presentErrorAbortDialog(this.window, title, msg);
    }

    public File[] selectFileSources() {
        return this.persistView.selectFileSources();
    }

    public File selectFileDest(String projectName) {
        return this.persistView.selectFileDest(projectName, ".cgt");
    }

    public int protestBeingEdited(File saveFileAttempt) {
        BeingEditedDialog dialog = new BeingEditedDialog(saveFileAttempt);
        Object response = dialog.open();
        if (response == OVERWRITE) {
            return 0;
        }
        if (response == SELECT_AGAIN) {
            return 1;
        }
        return 2;
    }

    public int askSaveBeforeClose(String projectName) {
        MessageBox saveBeforeCloseDialog = WindowUtil.createYesNoCancelDialog(this.window, L10N.get("PM.SaveBeforeCloseTitle", "Save Changes?"), L10N.get("PM.SaveBeforeClose", "Save project before closing?\nUnsaved changes in project:") + "\n    " + projectName);
        switch (saveBeforeCloseDialog.open()) {
            case 64: {
                return 0;
            }
            case 128: {
                return 1;
            }
            case 256: {
                return 2;
            }
        }
        return 2;
    }

    public Integer selectColor(int oldColor, String dialogTitle) {
        RGB newColor;
        RGB old = GraphicsUtil.getRGBFromColor(oldColor);
        ColorDialog dialog = new ColorDialog(this.window);
        dialog.setRGB(old);
        if (dialogTitle != null) {
            dialog.setText(dialogTitle);
        }
        if ((newColor = dialog.open()) != null) {
            return new Integer(GraphicsUtil.getColorFromRGB(newColor));
        }
        return null;
    }

    public Integer selectColor(int oldColor) {
        return this.selectColor(oldColor, null);
    }

    public Integer selectColor() {
        return this.selectColor(0);
    }

    public void protestUnreadableFile() {
        this.reportProblem(errorTitle, unreadableFileMsg);
    }

    public void protestInvalidImageFile() {
        this.reportProblem(errorTitle, invalidImageFileMsg);
    }

    protected FileDialog selectFileName(int mode, String[] filterNames, String[] extensions) {
        FileDialog dialog = new FileDialog(this.window, mode);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(extensions);
        if (dialog.open() != null) {
            return dialog;
        }
        return null;
    }

    public String selectImageFile() {
        FileDialog dialog = this.selectFileName(4096, new String[]{"JPG Images (*.jpg)", "GIF Images (*.gif)", "PNG Images (*.png)", "BMP Images (*.bmp)", "ICO Icon Files (*.ico)", "All Files (*.*)"}, new String[]{"*.jpg", "*.gif", "*.png", "*.bmp", "*.ico", "*.*"});
        if (dialog != null) {
            return dialog.getFilterPath() + File.separator + dialog.getFileName();
        }
        return null;
    }

    public File selectCSVFile() {
        FileDialog dialog = this.selectFileName(4096, new String[]{"CSV Files (*.csv)"}, new String[]{"*.csv"});
        if (dialog == null) {
            return null;
        }
        File path = new File(dialog.getFilterPath());
        return new File(path, dialog.getFileName());
    }

    public File selectXMLFile() {
        FileDialog dialog = this.selectFileName(4096, new String[]{"XML Files (*.xml)"}, new String[]{"*.xml"});
        if (dialog == null) {
            return null;
        }
        File path = new File(dialog.getFilterPath());
        return new File(path, dialog.getFileName());
    }

    public File selectCSVFileDest(String projectName) {
        File dest;
        FileDialog dialog = this.selectFileName(8192, new String[]{"CSV Files (*.csv)"}, new String[]{"*.csv"});
        if (dialog == null) {
            this.setStatusMessage(exportCanceledMsg);
            return null;
        }
        File path = new File(dialog.getFilterPath());
        String name = dialog.getFileName();
        if (!name.endsWith(".csv")) {
            name = name + ".csv";
        }
        if ((dest = new File(path, name)).exists() && OSUtils.WINDOWS) {
            int choice = this.shouldReplaceFile(dest);
            if (choice == 128) {
                return this.selectCSVFileDest(projectName);
            }
            if (choice == 256) {
                this.setStatusMessage(exportCanceledMsg);
                return null;
            }
        }
        return dest;
    }

    protected int shouldReplaceFile(File file) {
        MessageBox replaceBox = new MessageBox(this.window, 33220);
        replaceBox.setMessage(L10N.get("DEFINT.ReplaceFile", "File exists.  Replace file?\n") + file.getAbsolutePath());
        return replaceBox.open();
    }

    public IInteraction.IProgressBar createProgressBar(String windowTitle, ICancelable cancelable, String initialStatusText, boolean style) {
        return this.createProgressBar(windowTitle, cancelable, initialStatusText, style, null);
    }

    public IInteraction.IProgressBar createModalProgressBar(String windowTitle, ICancelable cancelable, String initialStatusText, boolean style) {
        return this.createProgressBar(windowTitle, cancelable, initialStatusText, style, null);
    }

    public IInteraction.IProgressBar createProgressBar(String windowTitle, ICancelable cancelable, String initialStatusText, boolean style, Shell window) {
        final ThreadProgressBar progressBar = new ThreadProgressBar(window, windowTitle, cancelable, initialStatusText, style ? 65536 : 2);
        progressBar.buildAndDisplay();
        return new IInteraction.IProgressBar(){

            public void dispose() {
                progressBar.dispose();
            }

            public IEnableDisable getDisabler() {
                return progressBar.getDisabler();
            }

            public void updateProgress(double progress, String status) {
                progressBar.updateProgress(progress, status);
            }
        };
    }

    public String askUserForWebPageDestination() {
        DirectoryDialog dialog = new DirectoryDialog(this.window);
        dialog.setText(selectWebPageExportDialogTitle);
        dialog.setMessage(selectWebPageExportDialogMessage);
        return dialog.open();
    }

    public void showProjectProperties(IProject project) {
        String buildVersion = project.getBuildVersion();
        if (buildVersion == IProject.NOT_YET_SAVED) {
            buildVersion = unsavedProject;
        } else if (buildVersion == "") {
            buildVersion = unknownBuildVersion;
        }
        WindowUtil.presentInformationDialog(this.window, projectPropertiesTitle + ": " + project.getName(), buildVersionLabel + ": " + buildVersion);
    }

    public void setStatusMessage(String message) {
        this.view.setStatusMessage(message);
    }

    public void setStatusMessage(String message, int duration) {
        this.view.setStatusMessage(message, duration);
    }

    public File selectDirectory(String message) {
        DirectoryDialog saveDialog = new DirectoryDialog(this.window);
        saveDialog.setMessage(message);
        String path = saveDialog.open();
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public void reportException(String title, String msg, Exception e) {
        ErrorDialog dlog = new ErrorDialog(title, msg, e);
        dlog.open();
    }

    protected class BeingEditedDialog
    extends WindowUtil.SimpleDialog {
        protected File destination;

        public BeingEditedDialog(File saveFileAttempt) {
            super(DefaultInteraction.this.window, errorTitle, 32768, 2144);
            this.destination = saveFileAttempt;
        }

        protected void addLabel(String text, int span, int width) {
            Label element = new Label((Composite)this.dialog, 0);
            if (text != null) {
                element.setText(text);
                if (this.textFont != null) {
                    element.setFont(this.textFont);
                }
            }
            GridData eltLayout = new GridData();
            if (span > 0) {
                eltLayout.grabExcessHorizontalSpace = true;
                eltLayout.horizontalSpan = span;
            } else {
                eltLayout.widthHint = width;
            }
            element.setLayoutData((Object)eltLayout);
        }

        protected void addButton(String label) {
            Button nextButton = new Button((Composite)this.dialog, 8);
            nextButton.setText(label);
            if (this.buttonFont != null) {
                nextButton.setFont(this.buttonFont);
            }
            GridData buttonLayout = new GridData(128);
            buttonLayout.horizontalSpan = 2;
            nextButton.setLayoutData((Object)buttonLayout);
            nextButton.addListener(13, new Listener(this, label){
                private final /* synthetic */ String val$label;
                private final /* synthetic */ BeingEditedDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$label = val$label;
                }

                public void handleEvent(Event evt) {
                    BeingEditedDialog.access$002(this.this$1, this.val$label);
                    BeingEditedDialog.access$100(this.this$1).close();
                }
            });
        }

        protected void buildDialog() {
            GridLayout layout = new GridLayout(8, false);
            layout.marginLeft = 19;
            layout.marginRight = 13;
            layout.marginTop = 7;
            layout.marginBottom = 12;
            this.dialog.setLayout((Layout)layout);
            this.addLabel(fileInUse, 8, 0);
            this.addLabel(null, 0, 35);
            this.addLabel(this.destination.getName(), 7, 0);
            this.addLabel(null, 8, 0);
            this.addLabel(null, 0, 35);
            this.addButton(OVERWRITE);
            this.addButton(SELECT_AGAIN);
            this.addButton(CANCEL_SAVE);
        }

        static /* synthetic */ Object access$002(BeingEditedDialog x0, Object x1) {
            x0.userResponse = x1;
            return x0.userResponse;
        }

        static /* synthetic */ Shell access$100(BeingEditedDialog x0) {
            return x0.dialog;
        }
    }
}

