/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.ui.RcvrExceptionHandler;
import edu.cmu.cs.hcii.cogtool.util.IEnableDisable;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.util.RecoverableException;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.AboutView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AUI
implements IUI,
ListenerIdentifier.ILIDTransmuter {
    protected static final int CutTextCode = 51;
    protected static final int CopyTextCode = 52;
    protected static final int PasteTextCode = 53;
    protected static final int SelectAllTextCode = 54;
    protected static final int DeselectAllTextCode = 55;
    protected static final CogToolLID CutText = new TextLID("CutText", 51);
    protected static final CogToolLID CopyText = new TextLID("CopyText", 52);
    protected static final CogToolLID PasteText = new TextLID("PasteText", 53);
    protected static final CogToolLID SelectAllText = new TextLID("SelectAllText", 54);
    protected static final CogToolLID DeselectAllText = new TextLID("DeselectAllText", 55);
    public static final Map textLIDs = AUI.initTextLIDs();
    protected ListenerIdentifierMap lIDMap = new ListenerIdentifierMap();

    protected static Map initTextLIDs() {
        HashMap<CogToolLID, CogToolLID> textLIDs = new HashMap<CogToolLID, CogToolLID>();
        textLIDs.put(CogToolLID.Cut, CutText);
        textLIDs.put(CogToolLID.Copy, CopyText);
        textLIDs.put(CogToolLID.Paste, PasteText);
        textLIDs.put(CogToolLID.SelectAll, SelectAllText);
        textLIDs.put(CogToolLID.DeselectAll, DeselectAllText);
        return textLIDs;
    }

    protected void setInitiallyEnabled() {
        this.setEnabled(CogToolLID.NewProject, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.OpenProject, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ExitApplication, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.About, ListenerIdentifierMap.ALL, true);
    }

    public static Text getFocusedText() {
        Control focused = WindowUtil.globalDisplay.getFocusControl();
        if (focused instanceof Text) {
            return (Text)focused;
        }
        return null;
    }

    public abstract IView getView();

    public Shell getShell() {
        IView view = this.getView();
        if (view != null) {
            return view.getShell();
        }
        throw new RcvrUIException("No view available for fetching the associated window.");
    }

    public void dispose() {
        IView view = this.getView();
        if (view == null) {
            throw new RcvrUIException("No view available for recovering system resources.");
        }
        view.dispose();
    }

    public void setVisible(boolean visible) {
        IView view = this.getView();
        if (view == null) {
            throw new RcvrUIException("No view available for setting view visibility.");
        }
        view.setVisible(visible);
    }

    public void takeFocus() {
        IView view = this.getView();
        if (view == null) {
            throw new RcvrUIException("No view available for taking focus.");
        }
        view.takeFocus();
    }

    public boolean requestClose() {
        IView view = this.getView();
        if (view != null) {
            return view.requestClose();
        }
        throw new RcvrUIException("No view available for requesting close.");
    }

    public IListenerAction setAction(CogToolLID id, IListenerAction action) {
        return this.lIDMap.setAction(id, action);
    }

    public IListenerAction removeAction(CogToolLID id) {
        return this.lIDMap.removeAction(id);
    }

    protected void setUpPerformAction(ListenerIdentifier id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAction(ListenerIdentifier id, Object actionParms, boolean doCleanup) {
        IView view = this.getView();
        boolean okToProceed = false;
        boolean wasPerforming = view.isPerformingAction();
        view.setStatusMessage("");
        view.setPerformingAction(true);
        try {
            if (doCleanup) {
                this.setUpPerformAction(id);
            }
            okToProceed = this.lIDMap.performAction(id, actionParms);
            if (doCleanup) {
                this.cleanup(okToProceed, false);
            }
        }
        catch (RecoverableException ex) {
            RcvrExceptionHandler.recover(ex, this.getStandardInteraction());
        }
        finally {
            view.setPerformingAction(wasPerforming);
        }
        return okToProceed;
    }

    public boolean performAction(ListenerIdentifier id, Object actionParms) {
        return this.performAction(id, actionParms, true);
    }

    public boolean performAction(ListenerIdentifier id) {
        return this.performAction(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAction(ListenerIdentifier id, boolean isContextSelection) {
        IView view = this.getView();
        boolean wasPerforming = view.isPerformingAction();
        view.setPerformingAction(true);
        try {
            boolean bl = this.lIDMap.performAction(this, id, isContextSelection);
            return bl;
        }
        catch (RecoverableException ex) {
            RcvrExceptionHandler.recover(ex, this.getStandardInteraction());
        }
        finally {
            view.setPerformingAction(wasPerforming);
        }
        return false;
    }

    protected void setEnabled(Object target, boolean enable, String newLabel) {
        if (target instanceof IEnableDisable) {
            ((IEnableDisable)target).setEnabled(enable);
        } else if (target instanceof Control) {
            ((Control)target).setEnabled(enable);
            if (newLabel != null) {
                if (target instanceof Button) {
                    ((Button)target).setText(newLabel);
                } else if (target instanceof Label) {
                    ((Label)target).setText(newLabel);
                }
            }
        } else if (target instanceof MenuItem) {
            ((MenuItem)target).setEnabled(enable);
            if (newLabel != null) {
                MenuUtil.relabelItem((MenuItem)target, newLabel);
            }
        } else if (target instanceof Menu) {
            ((Menu)target).setEnabled(enable);
        }
    }

    public void setEnabled(CogToolLID id, Boolean availability, boolean enable) {
        this.setEnabled(id, availability, enable, null);
    }

    public void setEnabled(CogToolLID id, Boolean availability, boolean enable, String newLabel) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            this.setEnabled(targets.next(), enable, newLabel);
        }
    }

    public boolean isEnabled(CogToolLID id, Boolean availability) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (target instanceof IEnableDisable) {
                return ((IEnableDisable)target).isEnabled();
            }
            if (target instanceof Control) {
                return ((Control)target).isEnabled();
            }
            if (target instanceof MenuItem) {
                return ((MenuItem)target).getEnabled();
            }
            if (!(target instanceof Menu)) continue;
            return ((Menu)target).getEnabled();
        }
        return true;
    }

    public boolean getEnabled(CogToolLID id, Boolean availability) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (target instanceof IEnableDisable) {
                return ((IEnableDisable)target).isEnabled();
            }
            if (target instanceof Control) {
                return ((Control)target).getEnabled();
            }
            if (target instanceof MenuItem) {
                return ((MenuItem)target).getEnabled();
            }
            if (!(target instanceof Menu)) continue;
            return ((Menu)target).getEnabled();
        }
        return true;
    }

    public void setAccelerator(CogToolLID id, Boolean availability, int accelerator) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (!(target instanceof MenuItem)) continue;
            ((MenuItem)target).setAccelerator(accelerator);
        }
    }

    public int getAccelerator(CogToolLID id, Boolean availability) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (!(target instanceof MenuItem)) continue;
            return ((MenuItem)target).getAccelerator();
        }
        return 0;
    }

    public void setVisible(CogToolLID id, Boolean availability, boolean visible) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (target instanceof Control) {
                ((Control)target).setVisible(visible);
                continue;
            }
            if (!(target instanceof Menu)) continue;
            ((Menu)target).setVisible(visible);
        }
    }

    public boolean isVisible(CogToolLID id, Boolean availability) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (target instanceof Control) {
                return ((Control)target).isVisible();
            }
            if (!(target instanceof Menu)) continue;
            return ((Menu)target).isVisible();
        }
        return true;
    }

    public void setSelected(CogToolLID id, Boolean availability, boolean selected) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (target instanceof Button) {
                ((Button)target).setSelection(selected);
                continue;
            }
            if (!(target instanceof MenuItem)) continue;
            ((MenuItem)target).setSelection(selected);
        }
    }

    public boolean isSelected(CogToolLID id, Boolean availability) {
        Iterator targets = this.lIDMap.getWidgets(id, availability);
        while (targets.hasNext()) {
            Object target = targets.next();
            if (target instanceof Button) {
                return ((Button)target).getSelection();
            }
            if (!(target instanceof MenuItem)) continue;
            return ((MenuItem)target).getSelection();
        }
        return true;
    }

    public IListenerAction popAboutBox() {
        Shell window = this.getShell();
        if (window != null) {
            return new AboutView.PopAction(this.getShell());
        }
        throw new RcvrUIException("No parent window available for About.");
    }

    public ListenerIdentifier transmute(ListenerIdentifier id, boolean isContextSelection) {
        TextLID specificLID;
        this.getView().setStatusMessage("");
        Text textWidgetWithFocus = AUI.getFocusedText();
        if (textWidgetWithFocus != null && (specificLID = (TextLID)textLIDs.get(id)) != null) {
            switch (specificLID.getLIDCode()) {
                case 51: {
                    textWidgetWithFocus.cut();
                    break;
                }
                case 52: {
                    textWidgetWithFocus.copy();
                    break;
                }
                case 53: {
                    textWidgetWithFocus.paste();
                    break;
                }
                case 54: {
                    textWidgetWithFocus.selectAll();
                    break;
                }
                case 55: {
                    int start = textWidgetWithFocus.getSelection().x;
                    textWidgetWithFocus.setSelection(start, start);
                    break;
                }
            }
            return specificLID;
        }
        return id;
    }

    protected static int canCauseSelection(ListenerIdentifier lid) {
        if (lid instanceof CogToolLID) {
            return ((CogToolLID)lid).causesSelection;
        }
        return 0;
    }

    protected static boolean isSelectionFlagSet(int mask, int flag) {
        return (mask & flag) != 0;
    }

    protected static int canCauseSelection(ListenerIdentifier lid, UndoManager undoMgr) {
        if (lid == CogToolLID.Undo) {
            return AUI.canCauseSelection(undoMgr.editToBeUndone().getLID());
        }
        if (lid == CogToolLID.Redo) {
            return AUI.canCauseSelection(undoMgr.editToBeRedone().getLID());
        }
        return AUI.canCauseSelection(lid);
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        return null;
    }

    public void cleanup(boolean okToContinue, boolean menuHidden) {
        CogTool.delayedWorkMgr.doDelayedWork(okToContinue);
    }

    public void showContextMenu() {
    }

    public void showContextMenu(int x, int y) {
        this.showContextMenu();
    }

    public DoublePoint getLocation() {
        Shell window = this.getShell();
        if (window != null) {
            Point loc = window.getLocation();
            return new DoublePoint(loc.x, loc.y);
        }
        return null;
    }

    public void setLocation(DoublePoint loc) {
        Shell window = this.getShell();
        if (window != null) {
            window.setLocation((int)loc.x, (int)loc.y);
        }
    }

    protected static class TextLID
    extends CogToolLID {
        public TextLID(String newLabel, int newPersistenceValue) {
            super(newLabel, newPersistenceValue);
        }

        public int getLIDCode() {
            return this.persistenceValue;
        }
    }
}

