/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IShape;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.ShapeType;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import java.util.EventObject;
import java.util.Random;
import junit.framework.TestCase;

public class WidgetTest
extends TestCase
implements IAlertHandler {
    Widget widget;
    Widget widget2;
    Random r = new Random();
    IWidget.WidgetChange alert;

    protected void setUp() throws Exception {
        super.setUp();
        this.widget = new Widget(WidgetType.Button);
        this.widget2 = new Widget(WidgetType.Button);
        this.widget.addHandler(this, EventObject.class, this);
    }

    protected void tearDown() throws Exception {
        this.alert = null;
        super.tearDown();
    }

    public void testEquals() {
        WidgetTest.assertTrue((!this.widget.equals(this.widget2) ? 1 : 0) != 0);
        WidgetTest.assertTrue((!this.widget2.equals(this.widget) ? 1 : 0) != 0);
    }

    public void testHashCode() {
        WidgetTest.assertEquals((int)this.widget.hashCode(), (int)this.widget2.hashCode());
        this.widget.setName(this.widget.getName() + " abc");
        WidgetTest.assertEquals((int)this.widget.hashCode(), (int)this.widget2.hashCode());
    }

    public void testToString() {
        WidgetTest.assertNotNull((Object)this.widget.toString());
        WidgetTest.assertTrue((this.widget.toString().length() > 0 ? 1 : 0) != 0);
    }

    public void testGetName() {
        WidgetTest.assertNotNull((Object)this.widget.getName());
    }

    public void testSetName() {
        try {
            this.widget.setName(null);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String name = this.widget.getName() + " abc";
        this.widget.setName(name);
        WidgetTest.assertEquals((String)this.widget.getName(), (String)name);
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 6) {
            WidgetTest.fail();
        }
    }

    public void testWidget() {
        WidgetTest.assertEquals((Object)this.widget.getShape().getBounds(), (Object)new DoubleRectangle(0.0, 0.0, 100.0, 100.0));
        WidgetTest.assertEquals((Object)this.widget.getShape().getShapeType(), (Object)ShapeType.Rectangle);
        WidgetTest.assertEquals((Object)this.widget.getWidgetType(), (Object)WidgetType.Button);
    }

    public void testWidgetDoubleRectangle() {
        try {
            new Widget((DoubleRectangle)null);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DoubleRectangle rect = new DoubleRectangle(1.2, 3.4, 5.6, 7.8);
        this.widget = new Widget(rect);
        WidgetTest.assertEquals((Object)this.widget.getShape().getBounds(), (Object)rect);
        WidgetTest.assertEquals((Object)this.widget.getShape().getShapeType(), (Object)ShapeType.Rectangle);
    }

    public void testWidgetDoubleRectangleWidgetType() {
        WidgetType type = WidgetType.MenuItem;
        DoubleRectangle rect = new DoubleRectangle(1.2, 3.4, 5.6, 7.8);
        try {
            new Widget(null, type);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            new Widget(rect, null);
            WidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.widget = new Widget(rect, type);
        WidgetTest.assertEquals((Object)this.widget.getShape().getBounds(), (Object)rect);
        WidgetTest.assertEquals((Object)this.widget.getWidgetType(), (Object)type);
        WidgetTest.assertEquals((Object)this.widget.getShape().getShapeType(), (Object)ShapeType.Rectangle);
    }

    public void testWidgetWidgetTypeIShape() {
        WidgetType type = WidgetType.Menu;
        IShape shape = ShapeType.getShape(ShapeType.Ellipse, new DoubleRectangle(1.2, 3.4, 5.6, 7.8));
        try {
            new Widget(null, shape);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            new Widget(type, null);
            WidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.widget = new Widget(type, shape);
        WidgetTest.assertEquals((Object)this.widget.getWidgetType(), (Object)type);
        WidgetTest.assertEquals((Object)this.widget.getShape(), (Object)shape);
    }

    public void testGetTitle() {
        WidgetTest.assertNotNull((Object)this.widget.getTitle());
        WidgetTest.assertEquals((String)this.widget.getTitle(), (String)this.widget2.getTitle());
    }

    public void testSetTitle() {
        this.widget.setTitle(null);
        WidgetTest.assertEquals((String)this.widget.getTitle(), (String)"");
        String title = this.widget.getTitle() + " def";
        this.widget.setTitle(title);
        WidgetTest.assertEquals((String)this.widget.getTitle(), (String)title);
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 3) {
            WidgetTest.fail();
        }
    }

    public void testGetImage() {
        WidgetTest.assertEquals((Object)this.widget.getImage(), (Object)this.widget2.getImage());
    }

    public void testSetImage() {
        this.widget.setImage(null);
        Object image = this.widget.getImage();
        image = image == null ? new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0} : null;
        this.widget.setImage((byte[])image);
        WidgetTest.assertEquals((Object)this.widget.getImage(), (Object)image);
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 4) {
            WidgetTest.fail();
        }
    }

    public void testSetWidgetType() {
        try {
            this.widget.setWidgetType(null);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        WidgetType type = this.widget.getWidgetType();
        type = !type.equals(WidgetType.Radio) ? WidgetType.Radio : WidgetType.Button;
        this.widget.setWidgetType(type);
        WidgetTest.assertEquals((Object)this.widget.getWidgetType(), (Object)type);
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 2) {
            WidgetTest.fail();
        }
    }

    public void testGetWidgetType() {
        WidgetTest.assertNotNull((Object)this.widget.getWidgetType());
        WidgetTest.assertEquals((Object)this.widget.getWidgetType(), (Object)this.widget2.getWidgetType());
    }

    public void testGetShape() {
        WidgetTest.assertNotNull((Object)this.widget.getShape());
        WidgetTest.assertEquals((Object)this.widget.getShape(), (Object)this.widget2.getShape());
    }

    public void testSetShape() {
        try {
            this.widget.setShape(null);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        IShape shape = this.widget.getShape();
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        double w = this.r.nextDouble();
        double h = this.r.nextDouble();
        shape.setBounds(new DoubleRectangle(x, y, w, h));
        this.widget.setShape(shape);
        WidgetTest.assertEquals((Object)this.widget.getShape(), (Object)shape);
        if (this.alert == null || this.alert.getChangeType() != 1) {
            WidgetTest.fail();
        }
    }

    public void testGetLevel() {
        WidgetTest.assertEquals((int)this.widget.getLevel(), (int)this.widget2.getLevel());
    }

    public void testSetLevel() {
        this.widget.setLevel(0);
        this.widget.setLevel(-1);
        this.widget.setLevel(Integer.MAX_VALUE);
        int level = this.widget.getLevel() + 1;
        this.widget.setLevel(level);
        WidgetTest.assertEquals((int)this.widget.getLevel(), (int)level);
    }

    public void testMoveWidget() {
        DoubleRectangle bounds = this.widget.getShape().getBounds();
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        this.widget.moveWidget(x, y);
        bounds.x += x;
        bounds.y += y;
        WidgetTest.assertEquals((Object)bounds, (Object)this.widget.getShape().getBounds());
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 1) {
            WidgetTest.fail();
        }
    }

    public void testSetWidgetOrigin() {
        this.widget.setWidgetOrigin(0.0, 0.0);
        this.widget.setWidgetOrigin(-1.0, -2.0);
        this.widget.setWidgetOrigin(Double.MAX_VALUE, -1.7976931348623157E308);
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        this.widget.setWidgetOrigin(x, y);
        WidgetTest.assertEquals((Object)this.widget.getShape().getOrigin(), (Object)new DoublePoint(x, y));
        if (this.alert == null || this.alert.getChangeType() != 1) {
            WidgetTest.fail();
        }
    }

    public void testSetWidgetSize() {
        this.widget.setWidgetSize(0.0, 0.0);
        this.widget.setWidgetSize(-1.0, -2.0);
        this.widget.setWidgetSize(Double.MAX_VALUE, -1.7976931348623157E308);
        double w = this.r.nextDouble();
        double h = this.r.nextDouble();
        this.widget.setWidgetSize(w, h);
        WidgetTest.assertEquals((Object)this.widget.getShape().getSize(), (Object)new DoubleSize(w, h));
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 1) {
            WidgetTest.fail();
        }
    }

    public void testSetShapeType() {
        try {
            this.widget.setShapeType(null);
            WidgetTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        ShapeType shape = this.widget.getShape().getShapeType();
        shape = !shape.equals(ShapeType.RoundedRectangle) ? ShapeType.RoundedRectangle : ShapeType.Rectangle;
        this.widget.setShapeType(shape);
        WidgetTest.assertEquals((Object)this.widget.getShape().getShapeType(), (Object)shape);
        if (this.alert == null || !this.alert.getSource().equals(this.widget) || this.alert.getChangeType() != 1) {
            WidgetTest.fail();
        }
    }

    public void handleAlert(EventObject event) {
        if (event instanceof IWidget.WidgetChange) {
            this.alert = (IWidget.WidgetChange)event;
        } else {
            WidgetTest.fail();
        }
    }
}

