/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.CogToolFrameFactory;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.InputDevice;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.VoiceAction;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import java.util.EventObject;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class TransitionTest
extends TestCase
implements IAlertHandler {
    CogToolFrameFactory factory = new CogToolFrameFactory();
    ITransitionSource source;
    IFrame frame;
    IAction action;
    Transition trans;
    Transition trans2;
    EventObject alert;

    protected void setUp() throws Exception {
        super.setUp();
        this.source = new InputDevice(DeviceType.Voice.toString(), DeviceType.Voice);
        this.frame = this.factory.createFrame("test frame");
        this.action = new VoiceAction("test action", true);
        this.trans = new Transition(this.source, this.frame, this.action);
        this.trans2 = new Transition(this.source, this.frame, this.action);
        this.trans.addHandler(this, EventObject.class, this);
    }

    protected void tearDown() throws Exception {
        this.alert = null;
        super.tearDown();
    }

    public void testEquals() {
        TransitionTest.assertTrue((!this.trans.equals(this.trans2) ? 1 : 0) != 0);
        TransitionTest.assertTrue((!this.trans2.equals(this.trans) ? 1 : 0) != 0);
    }

    public void testTransition() {
        try {
            new Transition(null, this.frame, this.action);
            TransitionTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            new Transition(this.source, null, this.action);
            TransitionTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            new Transition(this.source, this.frame, null);
            TransitionTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Iterator handlers = this.frame.getHandlers(IFrame.WidgetChange.class);
        try {
            handlers.next();
            try {
                handlers.next();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            TransitionTest.fail();
        }
        catch (NoSuchElementException e) {
            TransitionTest.fail();
        }
    }

    public void testGetSource() {
        Widget source = new Widget(WidgetType.Button);
        Transition transition = new Transition(null, this.frame, new VoiceAction("voice 5", true));
        TransitionTest.assertNull((Object)transition.getSource());
        transition = new Transition(source, this.frame, new VoiceAction("voice 5", true));
        TransitionTest.assertEquals((Object)transition.getSource(), (Object)source);
    }

    public void testGetDestination() {
        TransitionTest.assertNotNull((Object)this.trans.getDestination());
        TransitionTest.assertEquals((Object)this.trans.getDestination(), (Object)this.trans2.getDestination());
    }

    public void testGetAction() {
        TransitionTest.assertNotNull((Object)this.trans.getAction());
        TransitionTest.assertEquals((Object)this.trans.getAction(), (Object)this.trans2.getAction());
    }

    public void testSetAction() {
        try {
            this.trans.setAction(null);
            TransitionTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        VoiceAction a = new VoiceAction("alternative action", true);
        this.trans.setAction(a);
        TransitionTest.assertEquals((Object)a, (Object)this.trans.getAction());
        TransitionTest.assertNotNull((Object)this.alert);
        TransitionTest.assertEquals((Object)this.alert.getSource(), (Object)this.trans);
    }

    public void handleAlert(EventObject alt) {
        this.alert = alt;
    }
}

