/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.TaskGroup;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import java.util.EventObject;
import java.util.Iterator;
import junit.framework.TestCase;

public class TaskGroupTest
extends TestCase
implements IAlertHandler {
    String name = "test group";
    TaskGroup group;
    TaskGroup group2;
    EventObject alert;

    protected void setUp() throws Exception {
        super.setUp();
        this.group = new TaskGroup(this.name, GroupNature.MEAN);
        this.group2 = new TaskGroup(this.name, GroupNature.MEAN);
        this.group.addHandler(this, EventObject.class, this);
    }

    protected void tearDown() throws Exception {
        this.alert = null;
        super.tearDown();
    }

    public void testEquals() {
        TaskGroupTest.assertTrue((!this.group.equals(this.group2) ? 1 : 0) != 0);
        TaskGroupTest.assertTrue((!this.group2.equals(this.group) ? 1 : 0) != 0);
    }

    public void testTaskGroup() {
        try {
            new TaskGroup(this.name, null);
            TaskGroupTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            new TaskGroup(null, GroupNature.SUM);
            TaskGroupTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetNature() {
        TaskGroupTest.assertNotNull((Object)this.group.getNature());
        TaskGroupTest.assertEquals((Object)this.group.getNature(), (Object)this.group2.getNature());
    }

    public void testSetNature() {
        try {
            this.group.setNature(null);
            TaskGroupTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        GroupNature nature = GroupNature.SUM;
        this.group.setNature(nature);
        TaskGroupTest.assertEquals((Object)nature, (Object)this.group.getNature());
        TaskGroupTest.assertNotNull((Object)this.alert);
        TaskGroupTest.assertEquals((Object)this.alert.getSource(), (Object)this.group);
    }

    public void testGetUndertakings() {
        TaskGroupTest.assertNotNull((Object)this.group.getUndertakings());
        Iterator i = this.group.getUndertakings().iterator();
        while (i.hasNext()) {
            TaskGroupTest.assertTrue((boolean)(i.next() instanceof IUndertaking));
        }
    }

    public void testGetUndertaking() {
        TaskGroupTest.assertNull((Object)this.group.getUndertaking("some stupid undertaking name"));
        this.group.addUndertaking(this.group2);
        TaskGroupTest.assertEquals((Object)this.group.getUndertaking(this.name), (Object)this.group2);
    }

    public void testAddUndertakingIUndertaking() {
        try {
            this.group.addUndertaking(null);
            TaskGroupTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        int size = this.group.getUndertakings().size();
        this.group.addUndertaking(this.group2);
        TaskGroupTest.assertEquals((int)this.group.getUndertakings().size(), (int)(size + 1));
        TaskGroupTest.assertNotNull((Object)this.alert);
        TaskGroupTest.assertEquals((Object)this.alert.getSource(), (Object)this.group);
        TaskGroupTest.assertEquals(this.alert.getClass(), (Object)ITaskGroup.TaskChange.class);
        TaskGroupTest.assertEquals((Object)((ITaskGroup.TaskChange)this.alert).element, (Object)this.group2);
        TaskGroupTest.assertTrue((boolean)((ITaskGroup.TaskChange)this.alert).isAdd);
        try {
            this.group.addUndertaking(this.group2);
            TaskGroupTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testAddUndertakingIntIUndertaking() {
        try {
            this.group.addUndertaking(0, null);
            TaskGroupTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.group.addUndertaking(-1, null);
            TaskGroupTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.group.addUndertaking(new TaskGroup("abc1", GroupNature.SUM));
        this.group.addUndertaking(new TaskGroup("abc2", GroupNature.SUM));
        this.group.addUndertaking(new TaskGroup("abc3", GroupNature.SUM));
        int index = 1;
        this.group.addUndertaking(index, this.group2);
        TaskGroupTest.assertEquals((int)this.group.getUndertakings().size(), (int)4);
        TaskGroupTest.assertEquals(this.group.getUndertakings().get(index), (Object)this.group2);
        TaskGroupTest.assertNotNull((Object)this.alert);
        TaskGroupTest.assertEquals((Object)this.alert.getSource(), (Object)this.group);
        TaskGroupTest.assertEquals(this.alert.getClass(), (Object)ITaskGroup.TaskChange.class);
        TaskGroupTest.assertEquals((Object)((ITaskGroup.TaskChange)this.alert).element, (Object)this.group2);
        TaskGroupTest.assertEquals((int)((ITaskGroup.TaskChange)this.alert).atIndex, (int)index);
        TaskGroupTest.assertTrue((boolean)((ITaskGroup.TaskChange)this.alert).isAdd);
        try {
            this.group.addUndertaking(2, this.group2);
            TaskGroupTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testRemoveUndertakingString() {
        TaskGroupTest.assertTrue((!this.group.removeUndertaking(this.group2.getName()) ? 1 : 0) != 0);
        TaskGroupTest.assertNull((Object)this.alert);
        this.group.addUndertaking(this.group2);
        TaskGroupTest.assertTrue((boolean)this.group.removeUndertaking(this.group2.getName()));
        TaskGroupTest.assertNotNull((Object)this.alert);
        TaskGroupTest.assertEquals((Object)this.alert.getSource(), (Object)this.group);
        TaskGroupTest.assertEquals(this.alert.getClass(), (Object)ITaskGroup.TaskChange.class);
        TaskGroupTest.assertEquals((Object)((ITaskGroup.TaskChange)this.alert).element, (Object)this.group2);
        TaskGroupTest.assertTrue((!((ITaskGroup.TaskChange)this.alert).isAdd ? 1 : 0) != 0);
    }

    public void testRemoveUndertakingIUndertaking() {
        TaskGroupTest.assertTrue((!this.group.removeUndertaking(this.group2) ? 1 : 0) != 0);
        TaskGroupTest.assertNull((Object)this.alert);
        this.group.addUndertaking(this.group2);
        TaskGroupTest.assertTrue((boolean)this.group.removeUndertaking(this.group2));
        TaskGroupTest.assertNotNull((Object)this.alert);
        TaskGroupTest.assertEquals((Object)this.alert.getSource(), (Object)this.group);
        TaskGroupTest.assertEquals(this.alert.getClass(), (Object)ITaskGroup.TaskChange.class);
        TaskGroupTest.assertEquals((Object)((ITaskGroup.TaskChange)this.alert).element, (Object)this.group2);
    }

    public void testCopyUndertakingStringString() {
        String name = "name of copy";
        IUndertaking undertakingToCopy = this.group.getUndertaking(this.group2.getName());
        TaskGroupTest.assertNull((Object)undertakingToCopy);
        this.group.addUndertaking(this.group2);
        undertakingToCopy = this.group.getUndertaking(this.group2.getName());
        IUndertaking copy = undertakingToCopy.duplicate(name);
        TaskGroupTest.assertNotNull((Object)copy);
        TaskGroupTest.assertEquals((String)copy.getName(), (String)name);
        TaskGroupTest.assertNotSame((Object)this.group2, (Object)copy);
    }

    public void handleAlert(EventObject alt) {
        this.alert = alt;
    }
}

