/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.ShapeRectangle;
import edu.cmu.cs.hcii.cogtool.model.ShapeType;
import java.util.Random;
import junit.framework.TestCase;

public class ShapeRectangleTest
extends TestCase {
    ShapeRectangle shape;
    ShapeRectangle shape2;
    Random r = new Random();

    public void setUp() throws Exception {
        super.setUp();
        double x = 1.2;
        double y = 3.4;
        double w = 5.6;
        double h = 7.8;
        this.shape = new ShapeRectangle(x, y, w, h);
        this.shape2 = new ShapeRectangle(x, y, w, h);
    }

    public void testClone() {
        ShapeRectangleTest.assertEquals((Object)this.shape.clone(), (Object)this.shape);
        ShapeRectangleTest.assertEquals((int)this.shape.clone().hashCode(), (int)this.shape.hashCode());
    }

    public void testShapeRectangleDoubleRectangle() {
        try {
            new ShapeRectangle(null);
            ShapeRectangleTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        double w = this.r.nextDouble();
        double h = this.r.nextDouble();
        DoubleRectangle rec = new DoubleRectangle(x, y, w, h);
        this.shape = new ShapeRectangle(rec);
        ShapeRectangleTest.assertEquals((Object)this.shape.getBounds(), (Object)rec);
    }

    public void testShapeRectangleDoubleDoubleDoubleDouble() {
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        double w = this.r.nextDouble();
        double h = this.r.nextDouble();
        DoubleRectangle rec = new DoubleRectangle(x, y, w, h);
        this.shape = new ShapeRectangle(x, y, w, h);
        ShapeRectangleTest.assertEquals((Object)this.shape.getBounds(), (Object)rec);
    }

    public void testHashCode() {
        ShapeRectangleTest.assertEquals((int)this.shape.hashCode(), (int)this.shape2.hashCode());
        this.shape.setSize(this.shape.getSize().width + 1.0, this.shape.getSize().height - 1.0);
        ShapeRectangleTest.assertEquals((int)this.shape.hashCode(), (int)this.shape2.hashCode());
    }

    public void testEquals() {
        ShapeRectangleTest.assertEquals((Object)this.shape, (Object)this.shape2);
        ShapeRectangleTest.assertEquals((Object)this.shape2, (Object)this.shape);
        this.shape2 = new ShapeRectangle(1.3, 3.4, 5.6, 7.8);
        ShapeRectangleTest.assertTrue((!this.shape.equals(this.shape2) ? 1 : 0) != 0);
        ShapeRectangleTest.assertTrue((!this.shape2.equals(this.shape) ? 1 : 0) != 0);
        this.shape2 = new ShapeRectangle(1.2, 3.5, 5.6, 7.8);
        ShapeRectangleTest.assertTrue((!this.shape.equals(this.shape2) ? 1 : 0) != 0);
        ShapeRectangleTest.assertTrue((!this.shape2.equals(this.shape) ? 1 : 0) != 0);
        this.shape2 = new ShapeRectangle(1.2, 3.4, 5.7, 7.8);
        ShapeRectangleTest.assertTrue((!this.shape.equals(this.shape2) ? 1 : 0) != 0);
        ShapeRectangleTest.assertTrue((!this.shape2.equals(this.shape) ? 1 : 0) != 0);
        this.shape2 = new ShapeRectangle(1.2, 3.4, 5.6, 7.9);
        ShapeRectangleTest.assertTrue((!this.shape.equals(this.shape2) ? 1 : 0) != 0);
        ShapeRectangleTest.assertTrue((!this.shape2.equals(this.shape) ? 1 : 0) != 0);
    }

    public void testGetOrigin() {
        ShapeRectangleTest.assertNotNull((Object)this.shape.getOrigin());
        ShapeRectangleTest.assertEquals((Object)this.shape.getOrigin(), (Object)this.shape2.getOrigin());
    }

    public void testGetBounds() {
        ShapeRectangleTest.assertNotNull((Object)this.shape.getBounds());
        ShapeRectangleTest.assertEquals((Object)this.shape.getBounds(), (Object)this.shape2.getBounds());
    }

    public void testGetSize() {
        ShapeRectangleTest.assertNotNull((Object)this.shape.getSize());
        ShapeRectangleTest.assertEquals((Object)this.shape.getSize(), (Object)this.shape2.getSize());
    }

    public void testSetSizeDoubleDouble() {
        this.shape.setSize(0.0, 0.0);
        this.shape.setSize(-1.0, -1.0);
        this.shape.setSize(Double.MAX_VALUE, Double.MAX_VALUE);
        double w = this.r.nextDouble();
        double h = this.r.nextDouble();
        this.shape.setSize(w, h);
        ShapeRectangleTest.assertEquals((Object)this.shape.getSize(), (Object)new DoubleSize(w, h));
    }

    public void testSetSizeDoubleSize() {
        try {
            this.shape.setSize(null);
            ShapeRectangleTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DoubleSize size = new DoubleSize(this.r.nextDouble(), this.r.nextDouble());
        this.shape.setSize(size);
        ShapeRectangleTest.assertEquals((Object)this.shape.getSize(), (Object)size);
    }

    public void testSetOriginDoubleDouble() {
        this.shape.setOrigin(0.0, 0.0);
        this.shape.setOrigin(-1.0, -1.0);
        this.shape.setOrigin(Double.MAX_VALUE, Double.MAX_VALUE);
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        this.shape.setOrigin(x, y);
        ShapeRectangleTest.assertEquals((Object)this.shape.getOrigin(), (Object)new DoublePoint(x, y));
    }

    public void testSetOriginDoublePoint() {
        try {
            this.shape.setOrigin(null);
            ShapeRectangleTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DoublePoint origin = new DoublePoint(this.r.nextDouble(), this.r.nextDouble());
        this.shape.setOrigin(origin);
        ShapeRectangleTest.assertEquals((Object)this.shape.getOrigin(), (Object)origin);
    }

    public void testSetBounds() {
        try {
            this.shape.setBounds(null);
            ShapeRectangleTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DoubleRectangle bounds = new DoubleRectangle(this.r.nextDouble(), this.r.nextDouble(), this.r.nextDouble(), this.r.nextDouble());
        this.shape.setBounds(bounds);
        ShapeRectangleTest.assertEquals((Object)this.shape.getBounds(), (Object)bounds);
        DoubleRectangle copy = new DoubleRectangle(bounds);
        bounds.x = 12345.0;
        ShapeRectangleTest.assertEquals((Object)this.shape.getBounds(), (Object)copy);
    }

    public void testGetShapeType() {
        ShapeRectangleTest.assertEquals((Object)this.shape.getShapeType(), (Object)ShapeType.Rectangle);
    }
}

