/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.Project;
import edu.cmu.cs.hcii.cogtool.model.Script;
import edu.cmu.cs.hcii.cogtool.model.Task;
import edu.cmu.cs.hcii.cogtool.model.TaskGroup;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;

public class ProjectTest
extends TestCase
implements IAlertHandler {
    Project project;
    Project project2;
    EventObject alert;

    protected void setUp() throws Exception {
        super.setUp();
        String name = "test project";
        this.project = new Project(name);
        this.project2 = new Project(name);
        this.project.addHandler(this, EventObject.class, this);
    }

    protected void tearDown() throws Exception {
        this.alert = null;
        super.tearDown();
    }

    public void testEquals() {
        ProjectTest.assertTrue((!this.project.equals(this.project2) ? 1 : 0) != 0);
        ProjectTest.assertTrue((!this.project2.equals(this.project) ? 1 : 0) != 0);
    }

    public void testProject() {
        try {
            new Project(null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            new Project("");
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String name = "nice name here";
        this.project = new Project(name);
        ProjectTest.assertEquals((String)this.project.getName(), (String)name);
        ProjectTest.assertEquals((int)this.project.getDesigns().size(), (int)0);
        ProjectTest.assertEquals((int)this.project.getUndertakings().size(), (int)0);
    }

    public void testGetName() {
        ProjectTest.assertNotNull((Object)this.project.getName());
    }

    public void testSetName() {
        try {
            this.project.setName(null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String name = "nice name here";
        this.project.setName(name);
        ProjectTest.assertEquals((String)this.project.getName(), (String)name);
        ProjectTest.assertNotNull((Object)this.alert);
        ProjectTest.assertEquals((Object)this.alert.getSource(), (Object)this.project);
    }

    public void testGetDesigns() {
        ProjectTest.assertNotNull((Object)this.project.getDesigns());
    }

    public void testGetDesign() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        this.project.addDesign(new Design("test design 2", devices));
        ProjectTest.assertNull((Object)this.project.getDesign(null));
        ProjectTest.assertNull((Object)this.project.getDesign("some stupid name here"));
        Design design = new Design("test design 1", devices);
        this.project.addDesign(design);
        ProjectTest.assertEquals((Object)this.project.getDesign(design.getName()), (Object)design);
    }

    public void testAddDesignIDesign() {
        int i;
        try {
            this.project.addDesign(null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        try {
            String name = "test design 1";
            this.project2.addDesign(new Design(name, devices));
            this.project2.addDesign(new Design(name, devices));
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        IDesign[] designs = new IDesign[]{new Design("test design 1", devices), new Design("test design 2", devices), new Design("test design 3", devices)};
        for (i = 0; i < 3; ++i) {
            this.project.addDesign(designs[i]);
        }
        for (i = 0; i < 3; ++i) {
            ProjectTest.assertEquals(this.project.getDesigns().get(i), (Object)designs[i]);
        }
        if (!(this.alert != null && this.alert.getClass().equals(IProject.DesignChange.class) && ((IProject.DesignChange)this.alert).getSource().equals(this.project) && ((IProject.DesignChange)this.alert).element.equals(designs[designs.length - 1]) && ((IProject.DesignChange)this.alert).isAdd)) {
            ProjectTest.fail();
        }
    }

    public void testAddDesignIntIDesign() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        try {
            this.project.addDesign(0, null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.project.addDesign(1, new Design("blah", devices));
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            String name = "test design 1";
            this.project2.addDesign(0, new Design(name, devices));
            this.project2.addDesign(0, new Design(name, devices));
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        IDesign[] designs = new IDesign[]{new Design("test design 1", devices), new Design("test design 2", devices), new Design("test design 3", devices)};
        this.project.addDesign(0, designs[0]);
        this.project.addDesign(1, designs[1]);
        this.project.addDesign(0, designs[2]);
        ProjectTest.assertEquals(this.project.getDesigns().get(0), (Object)designs[2]);
        ProjectTest.assertEquals(this.project.getDesigns().get(1), (Object)designs[0]);
        ProjectTest.assertEquals(this.project.getDesigns().get(2), (Object)designs[1]);
        if (!(this.alert != null && this.alert.getClass().equals(IProject.DesignChange.class) && ((IProject.DesignChange)this.alert).getSource().equals(this.project) && ((IProject.DesignChange)this.alert).element.equals(designs[designs.length - 1]) && ((IProject.DesignChange)this.alert).isAdd)) {
            ProjectTest.fail();
        }
    }

    public void testRemoveDesignString() {
        HashSet designs = new HashSet(this.project.getDesigns());
        ProjectTest.assertFalse((boolean)this.project.removeDesign("no one will use this stupid name"));
        ProjectTest.assertEquals((int)this.project.getDesigns().size(), (int)0);
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        int size = this.project.getDesigns().size();
        Design design = new Design("this is a cool name", devices);
        this.project.addDesign(design);
        ProjectTest.assertTrue((boolean)this.project.removeDesign(design.getName()));
        ProjectTest.assertEquals((int)this.project.getDesigns().size(), (int)size);
        if (this.alert == null || !this.alert.getClass().equals(IProject.DesignChange.class) || !((IProject.DesignChange)this.alert).getSource().equals(this.project) || !((IProject.DesignChange)this.alert).element.equals(design) || ((IProject.DesignChange)this.alert).isAdd) {
            ProjectTest.fail();
        }
    }

    public void testRemoveDesignIDesign() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        HashSet designs = new HashSet(this.project.getDesigns());
        ProjectTest.assertTrue((!this.project.removeDesign(new Design("no one will use this stupid name", devices)) ? 1 : 0) != 0);
        ProjectTest.assertEquals((int)this.project.getDesigns().size(), (int)0);
        int size = this.project.getDesigns().size();
        Design design = new Design("this is a cool name", devices);
        this.project.addDesign(design);
        ProjectTest.assertTrue((boolean)this.project.removeDesign(design));
        ProjectTest.assertEquals((int)this.project.getDesigns().size(), (int)size);
        if (this.alert == null || !this.alert.getClass().equals(IProject.DesignChange.class) || !((IProject.DesignChange)this.alert).getSource().equals(this.project) || !((IProject.DesignChange)this.alert).element.equals(design) || ((IProject.DesignChange)this.alert).isAdd) {
            ProjectTest.fail();
        }
    }

    public void testCopyDesignStringString() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        Design design = new Design("nice name here", devices);
        this.project.addDesign(design);
        IDesign designToCopy = this.project.getDesign("no one will use this stupid name");
        ProjectTest.assertNull((Object)designToCopy);
        designToCopy = this.project.getDesign("nice name here");
        String name = "some stupid name";
        IDesign copy = designToCopy.duplicate(name);
        ProjectTest.assertNotNull((Object)copy);
        ProjectTest.assertEquals((String)copy.getName(), (String)name);
        ProjectTest.assertNotSame((Object)design, (Object)copy);
        ProjectTest.assertNull((Object)this.project.getDesign(copy.getName()));
    }

    public void testGetScript() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        Design design = new Design("test design 1", devices);
        this.project.addDesign(design);
        TaskGroup undertaking = new TaskGroup("test undertaking 1", GroupNature.SUM);
        this.project.addUndertaking(undertaking);
        ProjectTest.assertNull((Object)this.project.getTaskApplication(null, null));
        ProjectTest.assertNull((Object)this.project.getTaskApplication(undertaking, null));
        ProjectTest.assertNull((Object)this.project.getTaskApplication(null, design));
        ProjectTest.assertNull((Object)this.project.getTaskApplication(new Task("some stupid name here"), design));
        ProjectTest.assertNull((Object)this.project.getTaskApplication(undertaking, new Design("some stupid name here", devices)));
    }

    public void testSetScript() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        Design design = new Design("test design 1", devices);
        TaskGroup undertaking = new TaskGroup("test undertaking 1", GroupNature.SUM);
        Script script = new Script(design);
        try {
            this.project2.addUndertaking(undertaking);
            ProjectTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.project.addDesign(design);
            ProjectTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.project.setTaskApplication(undertaking, design, null);
            ProjectTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.project.addUndertaking(undertaking);
        ProjectTest.assertEquals((Object)this.project.getTaskApplication(undertaking, design), (Object)script);
    }

    public void testRemoveScript() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        Design design = new Design("test design 1", devices);
        TaskGroup undertaking = new TaskGroup("test undertaking 1", GroupNature.SUM);
        Script script = new Script(design);
        this.project.addDesign(design);
        this.project.addUndertaking(undertaking);
        ProjectTest.assertNull((Object)this.project.removeTaskApplication(null, null));
        ProjectTest.assertNull((Object)this.project.removeTaskApplication(undertaking, null));
        ProjectTest.assertNull((Object)this.project.removeTaskApplication(null, design));
        ProjectTest.assertNull((Object)this.project.removeTaskApplication(new Task("some stupid name here"), design));
        ProjectTest.assertNull((Object)this.project.removeTaskApplication(undertaking, new Design("some stupid name here", devices)));
        ProjectTest.assertEquals((Object)this.project.removeTaskApplication(undertaking, design), (Object)script);
        ProjectTest.assertNull((Object)this.project.removeTaskApplication(undertaking, design));
    }

    public void testScriptsForTask() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        ProjectTest.assertNotNull((Object)this.project.taskApplicationsForTask(null));
        ProjectTest.assertEquals((int)this.project.taskApplicationsForTask(null).size(), (int)0);
        IDesign[] designs = new IDesign[]{new Design("test design 1", devices), new Design("test design 2", devices), new Design("test design 3", devices)};
        Script[] scripts = new Script[designs.length];
        for (int i = 0; i < scripts.length; ++i) {
            scripts[i] = new Script(designs[i]);
        }
        TaskGroup undertaking = new TaskGroup("test undertaking 1", GroupNature.SUM);
        TaskGroup undertaking2 = new TaskGroup("test undertaking 2", GroupNature.MEAN);
        this.project.addUndertaking(undertaking);
        for (int i = 0; i < scripts.length; ++i) {
            this.project.addDesign(designs[i]);
        }
        this.project.addUndertaking(undertaking2);
        Map stored = this.project.taskApplicationsForTask(undertaking);
        ProjectTest.assertEquals((int)stored.size(), (int)scripts.length);
        for (int i = 0; i < scripts.length; ++i) {
            stored.remove(scripts[i]);
        }
        ProjectTest.assertEquals((int)stored.size(), (int)0);
    }

    public void testScriptsForDesign() {
        ProjectTest.assertNotNull((Object)this.project.taskApplicationsForTask(null));
        ProjectTest.assertEquals((int)this.project.taskApplicationsForTask(null).size(), (int)0);
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        Design design = new Design("test design 1", devices);
        Design design2 = new Design("test design 2", devices);
        IUndertaking[] undertakings = new IUndertaking[]{new Task("test undertaking 1"), new Task("test undertaking 2"), new Task("test undertaking 3")};
        Script[] scripts = new Script[undertakings.length];
        this.project.addDesign(design);
        for (int i = 0; i < scripts.length; ++i) {
            this.project.addUndertaking(undertakings[i]);
            scripts[i] = new Script(design);
        }
        this.project.addDesign(design2);
        Map stored = this.project.taskApplicationsForDesign(design);
        ProjectTest.assertEquals((int)stored.size(), (int)scripts.length);
        for (int i = 0; i < scripts.length; ++i) {
            stored.remove(scripts[i]);
        }
        ProjectTest.assertEquals((int)stored.size(), (int)0);
    }

    public void testGetUndertakings() {
        ProjectTest.assertNotNull((Object)this.project.getUndertakings());
    }

    public void testGetUndertaking() {
        this.project.addUndertaking(new TaskGroup("test design 2", GroupNature.SUM));
        ProjectTest.assertNull((Object)this.project.getUndertaking(null));
        ProjectTest.assertNull((Object)this.project.getUndertaking("some stupid name here"));
        Task undertaking = new Task("test undertaking 1");
        this.project.addUndertaking(undertaking);
        ProjectTest.assertEquals((Object)this.project.getUndertaking(undertaking.getName()), (Object)undertaking);
    }

    public void testAddUndertakingIUndertaking() {
        try {
            this.project.addUndertaking(null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            String name = "test undertaking 1";
            this.project2.addUndertaking(new TaskGroup(name, GroupNature.SUM));
            this.project2.addUndertaking(new Task(name));
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task undertaking = new Task("valid test undertaking");
        this.project.addUndertaking(undertaking);
        ProjectTest.assertEquals((int)this.project.getUndertakings().size(), (int)1);
        ProjectTest.assertEquals(this.project.getUndertakings().iterator().next(), (Object)undertaking);
        if (!(this.alert != null && this.alert.getClass().equals(IProject.TaskChange.class) && ((IProject.TaskChange)this.alert).getSource().equals(this.project) && ((IProject.TaskChange)this.alert).element.equals(undertaking) && ((IProject.TaskChange)this.alert).isAdd)) {
            ProjectTest.fail();
        }
    }

    public void testAddUndertakingIntIUndertaking() {
        try {
            this.project.addUndertaking(0, null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.project.addUndertaking(-1, null);
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            String name = "test undertaking 1";
            this.project2.addUndertaking(0, new TaskGroup(name, GroupNature.SUM));
            this.project2.addUndertaking(0, new Task(name));
            ProjectTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.project.addUndertaking(new TaskGroup("abc1", GroupNature.SUM));
        this.project.addUndertaking(new TaskGroup("abc2", GroupNature.MEAN));
        this.project.addUndertaking(new Task("abc3"));
        Task undertaking = new Task("abc4");
        int index = 1;
        this.project.addUndertaking(index, undertaking);
        ProjectTest.assertEquals((int)this.project.getUndertakings().size(), (int)4);
        ProjectTest.assertEquals(this.project.getUndertakings().get(index), (Object)undertaking);
        if (!(this.alert != null && this.alert.getClass().equals(IProject.TaskChange.class) && ((IProject.TaskChange)this.alert).getSource().equals(this.project) && ((IProject.TaskChange)this.alert).element.equals(undertaking) && ((IProject.TaskChange)this.alert).atIndex == index && ((IProject.TaskChange)this.alert).isAdd)) {
            ProjectTest.fail();
        }
    }

    public void testRemoveUndertakingString() {
        String nameG = "test undertaking 2";
        String nameT = "test undertaking 3";
        GroupNature nature = GroupNature.SUM;
        this.project.addUndertaking(new TaskGroup(nameG, nature));
        this.project.addUndertaking(new Task(nameT));
        ProjectTest.assertTrue((!this.project.removeUndertaking(new TaskGroup(nameT, nature)) ? 1 : 0) != 0);
        ProjectTest.assertTrue((!this.project.removeUndertaking(new Task(nameG)) ? 1 : 0) != 0);
        Task undertaking = new Task("test undertaking 1");
        this.project.addUndertaking(undertaking);
        ProjectTest.assertTrue((boolean)this.project.removeUndertaking(undertaking.getName()));
        ProjectTest.assertTrue((!this.project.removeUndertaking(undertaking.getName()) ? 1 : 0) != 0);
        if (this.alert == null || !this.alert.getClass().equals(IProject.TaskChange.class) || !((IProject.TaskChange)this.alert).getSource().equals(this.project) || !((IProject.TaskChange)this.alert).element.equals(undertaking) || ((IProject.TaskChange)this.alert).isAdd) {
            ProjectTest.fail();
        }
    }

    public void testRemoveUndertakingIUndertaking() {
        Task undertaking = new Task("test undertaking 1");
        TaskGroup undertaking2 = new TaskGroup("test undertaking 2", GroupNature.MEAN);
        this.project.addUndertaking(undertaking);
        this.project.addUndertaking(undertaking2);
        ProjectTest.assertTrue((!this.project.removeUndertaking(new Task("some stupid name")) ? 1 : 0) != 0);
        ProjectTest.assertTrue((boolean)this.project.removeUndertaking(undertaking2));
        ProjectTest.assertTrue((!this.project.removeUndertaking(undertaking2) ? 1 : 0) != 0);
        ProjectTest.assertTrue((boolean)this.project.removeUndertaking(undertaking));
        ProjectTest.assertTrue((!this.project.removeUndertaking(undertaking) ? 1 : 0) != 0);
        if (this.alert == null || !this.alert.getClass().equals(IProject.TaskChange.class) || !((IProject.TaskChange)this.alert).getSource().equals(this.project) || !((IProject.TaskChange)this.alert).element.equals(undertaking) || ((IProject.TaskChange)this.alert).isAdd) {
            ProjectTest.fail();
        }
    }

    public void testCopyUndertakingStringString() {
        String name = "test undertaking 1";
        Task undertaking = new Task(name);
        this.project.addUndertaking(undertaking);
        IUndertaking undertakingToCopy = this.project.getUndertaking("no one will use this stupid name");
        ProjectTest.assertNull((Object)undertakingToCopy);
        undertakingToCopy = this.project.getUndertaking(undertaking.getName());
        IUndertaking copy = undertakingToCopy.duplicate(name);
        ProjectTest.assertNotNull((Object)copy);
        ProjectTest.assertEquals((String)copy.getName(), (String)name);
        ProjectTest.assertNotSame((Object)undertaking, (Object)copy);
        copy = undertakingToCopy.duplicate("some stupid name");
        ProjectTest.assertNotNull((Object)copy);
        ProjectTest.assertEquals((String)copy.getName(), (String)name);
        ProjectTest.assertNotSame((Object)undertaking, (Object)copy);
        ProjectTest.assertNull((Object)this.project.getUndertaking(copy.getName()));
    }

    public void handleAlert(EventObject event) {
        this.alert = event;
    }
}

