/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import junit.framework.TestCase;

public class KeyActionTest
extends TestCase {
    KeyAction action;
    KeyAction action2;

    protected void setUp() throws Exception {
        super.setUp();
        String command = "test action";
        this.action = new KeyAction(command, true, 0);
        this.action2 = new KeyAction(command, true, 0);
    }

    public void testEquals() {
        KeyActionTest.assertEquals((Object)this.action, (Object)this.action2);
        KeyActionTest.assertEquals((Object)this.action2, (Object)this.action);
        this.action = new KeyAction("some command", true, 2);
        this.action2 = new KeyAction(this.action.getText() + " blah", true, 2);
        KeyActionTest.assertTrue((!this.action.equals(this.action2) ? 1 : 0) != 0);
        KeyActionTest.assertTrue((!this.action2.equals(this.action) ? 1 : 0) != 0);
        this.action = new KeyAction('0', KeyPressType.Up, 4);
        this.action2 = new KeyAction('0', KeyPressType.Down, 4);
        KeyActionTest.assertTrue((!this.action.equals(this.action2) ? 1 : 0) != 0);
        KeyActionTest.assertTrue((!this.action2.equals(this.action) ? 1 : 0) != 0);
        this.action = new KeyAction('*', KeyPressType.Stroke, 0);
        this.action2 = new KeyAction('*', KeyPressType.Stroke, 1);
        KeyActionTest.assertTrue((!this.action.equals(this.action2) ? 1 : 0) != 0);
        KeyActionTest.assertTrue((!this.action2.equals(this.action) ? 1 : 0) != 0);
    }

    public void testKeyActionStringInt() {
        try {
            new KeyAction(null, true, 0);
            KeyActionTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String command = "nice command here";
        int state = 1;
        this.action = new KeyAction(command, true, state);
        KeyActionTest.assertEquals((String)this.action.getText(), (String)command);
        KeyActionTest.assertEquals((int)this.action.getModifiers(), (int)state);
        KeyActionTest.assertEquals((Object)this.action.getPressType(), (Object)KeyPressType.Stroke);
    }

    public void testKeyActionIntIntInt() {
        char key = '4';
        KeyPressType click = KeyPressType.Up;
        int state = 8;
        this.action = new KeyAction(key, click, state);
        KeyActionTest.assertEquals((String)this.action.getText(), (String)(key + ""));
        KeyActionTest.assertEquals((Object)this.action.getPressType(), (Object)click);
        KeyActionTest.assertEquals((int)this.action.getModifiers(), (int)state);
    }

    public void testGetCommand() {
        KeyActionTest.assertNotNull((Object)this.action.getText());
    }

    public void testSetCommand() {
        try {
            this.action.setText(null);
            KeyActionTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String command = "nice command here";
        this.action.setText(command);
        KeyActionTest.assertEquals((String)this.action.getText(), (String)command);
    }

    public void testSetClick() {
        KeyPressType click = this.action.getPressType() == KeyPressType.Down ? KeyPressType.Up : KeyPressType.Down;
        this.action.setPressType(click);
        KeyActionTest.assertEquals((Object)this.action.getPressType(), (Object)click);
    }

    public void testSetState() {
        int state = this.action.getModifiers() == 1 ? 8 : 1;
        this.action.setModifiers(state);
        KeyActionTest.assertEquals((int)this.action.getModifiers(), (int)state);
    }

    public void testActionType() {
        KeyActionTest.assertEquals((Object)this.action.getType(), (Object)ActionType.KeyPress);
    }
}

