/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.VoiceAction;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.DuplicateNameException;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;

public class FrameTest
extends TestCase
implements IAlertHandler {
    Frame frame;
    Frame frame2;
    Random r = new Random();
    EventObject alert;

    protected void setUp() throws Exception {
        super.setUp();
        this.frame = new Frame("test frame", new HashSet());
        this.frame2 = new Frame("test frame", new HashSet());
        this.frame.addHandler(this, EventObject.class, this);
    }

    protected void tearDown() throws Exception {
        this.alert = null;
        super.tearDown();
    }

    public void testEquals() {
        FrameTest.assertTrue((!this.frame.equals(this.frame2) ? 1 : 0) != 0);
        FrameTest.assertTrue((!this.frame2.equals(this.frame) ? 1 : 0) != 0);
    }

    public void testFrameStringSet() {
        try {
            this.frame = new Frame(null, new HashSet());
            FrameTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.frame = new Frame("", new HashSet());
            FrameTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Frame("test", null);
            FrameTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FrameTest.assertEquals((int)this.frame2.getWidgets().size(), (int)0);
    }

    public void testGetName() {
        FrameTest.assertNotNull((Object)this.frame.getName());
    }

    public void testSetName() {
        try {
            this.frame.setName(null);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.frame.setName("");
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String name = this.frame.getName() + " abc";
        this.frame.setName(name);
        FrameTest.assertEquals((String)this.frame.getName(), (String)name);
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || this.alert.getClass() != NameChangeAlert.class) {
            FrameTest.fail();
        }
    }

    public void testGetFrameOrigin() {
        FrameTest.assertNotNull((Object)this.frame.getFrameOrigin());
        FrameTest.assertEquals((Object)this.frame.getFrameOrigin(), (Object)this.frame2.getFrameOrigin());
    }

    public void testSetFrameOriginDoubleDouble() {
        this.frame.setFrameOrigin(0.0, 0.0);
        this.frame.setFrameOrigin(-1.0, -2.0);
        this.frame.setFrameOrigin(Double.MAX_VALUE, -1.7976931348623157E308);
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        this.frame.setFrameOrigin(x, y);
        FrameTest.assertEquals((Object)this.frame.getFrameOrigin(), (Object)new DoublePoint(x, y));
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || !this.alert.getClass().equals(IFrame.OriginChange.class)) {
            FrameTest.fail();
        }
    }

    public void testSetFrameOriginDoublePoint() {
        try {
            this.frame.setFrameOrigin(null);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        DoublePoint origin = new DoublePoint(x, y);
        this.frame.setFrameOrigin(origin);
        FrameTest.assertEquals((Object)this.frame.getFrameOrigin(), (Object)origin);
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || !this.alert.getClass().equals(IFrame.OriginChange.class)) {
            FrameTest.fail();
        }
    }

    public void testMoveFrameOriginDoubleDouble() {
        DoublePoint origin = this.frame.getFrameOrigin();
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        this.frame.moveFrameOrigin(x, y);
        origin.x += x;
        origin.y += y;
        FrameTest.assertEquals((Object)this.frame.getFrameOrigin(), (Object)origin);
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || this.alert.getClass() != IFrame.OriginChange.class) {
            FrameTest.fail();
        }
    }

    public void testMoveFrameOriginDoublePoint() {
        try {
            this.frame.moveFrameOrigin(null);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DoublePoint origin = this.frame.getFrameOrigin();
        double x = this.r.nextDouble();
        double y = this.r.nextDouble();
        this.frame.moveFrameOrigin(new DoublePoint(x, y));
        origin.x += x;
        origin.y += y;
        FrameTest.assertEquals((Object)this.frame.getFrameOrigin(), (Object)origin);
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || !this.alert.getClass().equals(IFrame.OriginChange.class)) {
            FrameTest.fail();
        }
    }

    public void testGetBackgroundImage() {
        FrameTest.assertEquals((Object)this.frame.getBackgroundImage(), (Object)this.frame2.getBackgroundImage());
    }

    public void testSetBackgroundImage() {
        this.frame.setBackgroundImage(null, null);
        Object image = this.frame.getBackgroundImage();
        image = image == null ? new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0} : null;
        this.frame.setBackgroundImage((byte[])image, GraphicsUtil.getImageBounds(image));
        FrameTest.assertEquals((Object)this.frame.getBackgroundImage(), (Object)image);
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || !this.alert.getClass().equals(IFrame.BackgroundImageChange.class)) {
            FrameTest.fail();
        }
    }

    public void testGetWidgets() {
        Set widgets = this.frame.getWidgets();
        FrameTest.assertNotNull((Object)widgets);
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof IWidget) continue;
            FrameTest.fail();
        }
    }

    public void testGetWidget() {
        FrameTest.assertNull((Object)this.frame.getWidget(null));
        FrameTest.assertNull((Object)this.frame.getWidget("this is a STUPID name"));
    }

    public void testAddWidget() {
        try {
            this.frame.addWidget(null);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String name = "this is a valid name";
        Widget widget = new Widget(WidgetType.Button);
        widget.setName(name);
        this.frame.addWidget(widget);
        FrameTest.assertEquals((Object)this.frame.getWidget(name), (Object)widget);
        if (!(this.alert != null && this.alert.getSource().equals(this.frame) && this.alert.getClass().equals(IFrame.WidgetChange.class) && ((IFrame.WidgetChange)this.alert).widget.equals(widget) && ((IFrame.WidgetChange)this.alert).action == 0)) {
            FrameTest.fail();
        }
        FrameTest.assertEquals((int)widget.getLevel(), (int)(this.frame.getWidgets().size() - 1));
        boolean[] levels = new boolean[this.frame.getWidgets().size()];
        Iterator i = this.frame.getWidgets().iterator();
        while (i.hasNext()) {
            levels[((IWidget)i.next()).getLevel()] = true;
        }
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (levels[i2]) continue;
            FrameTest.fail();
        }
        try {
            this.frame.addWidget(widget);
            FrameTest.fail();
        }
        catch (DuplicateNameException e) {
            // empty catch block
        }
    }

    public void testRemoveWidgetString() {
        HashSet widgets = new HashSet(this.frame.getWidgets());
        FrameTest.assertTrue((!this.frame.removeWidget("no one will use this stupid name") ? 1 : 0) != 0);
        FrameTest.assertEquals((Object)this.frame.getWidgets(), widgets);
        int size = this.frame.getWidgets().size();
        Widget widget = new Widget(WidgetType.Button);
        widget.setName("this is a cool name");
        this.frame.addWidget(widget);
        FrameTest.assertTrue((boolean)this.frame.removeWidget(widget.getName()));
        FrameTest.assertEquals((int)this.frame.getWidgets().size(), (int)size);
        if (!(this.alert != null && this.alert.getSource().equals(this.frame) && this.alert.getClass().equals(IFrame.WidgetChange.class) && ((IFrame.WidgetChange)this.alert).widget.equals(widget) && ((IFrame.WidgetChange)this.alert).action == 1)) {
            FrameTest.fail();
        }
        boolean[] levels = new boolean[size];
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            levels[((IWidget)i.next()).getLevel()] = true;
        }
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (levels[i2]) continue;
            FrameTest.fail();
        }
    }

    public void testRemoveWidgetIWidget() {
        Widget widget = new Widget(WidgetType.Button);
        widget.setName("no one will use this stupid name");
        HashSet widgets = new HashSet(this.frame.getWidgets());
        FrameTest.assertEquals((boolean)this.frame.removeWidget(widget), (boolean)false);
        FrameTest.assertEquals((Object)this.frame.getWidgets(), widgets);
        int size = this.frame.getWidgets().size();
        this.frame.addWidget(widget);
        FrameTest.assertEquals((boolean)this.frame.removeWidget(widget), (boolean)true);
        FrameTest.assertEquals((int)this.frame.getWidgets().size(), (int)size);
        if (!(this.alert != null && this.alert.getSource().equals(this.frame) && this.alert.getClass().equals(IFrame.WidgetChange.class) && ((IFrame.WidgetChange)this.alert).widget.equals(widget) && ((IFrame.WidgetChange)this.alert).action == 1)) {
            FrameTest.fail();
        }
        boolean[] levels = new boolean[size];
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            levels[((IWidget)i.next()).getLevel()] = true;
        }
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (levels[i2]) continue;
            FrameTest.fail();
        }
    }

    public void testCopyWidgetStringString() {
        IWidget widgetToCopy = this.frame.getWidget("no one will use this stupid name");
        FrameTest.assertNull((Object)widgetToCopy);
        Widget widget = new Widget(WidgetType.Button);
        widget.setName("nice name here");
        widgetToCopy = this.frame.getWidget("nice name here");
        IWidget copy = widgetToCopy.duplicate(new IFrame.FrameDuplicator(){

            public IFrame getOrDuplicate(IFrame f) {
                return f;
            }

            public void recordDuplicateFrame(IFrame oldF, IFrame newF) {
            }
        });
        copy.setName("some stupid name");
        FrameTest.assertNotNull((Object)copy);
        FrameTest.assertNotSame((Object)widget, (Object)copy);
        FrameTest.assertNull((Object)this.frame.getWidget(copy.getName()));
    }

    public void testSetWidgetLevel() {
        int i;
        IWidget[] widgets = new IWidget[15];
        for (int i2 = 0; i2 < widgets.length; ++i2) {
            widgets[i2] = new Widget(WidgetType.Button);
            widgets[i2].setLevel(i2);
            widgets[i2].setName(String.valueOf(i2));
            this.frame.addWidget(widgets[i2]);
        }
        int level = 3;
        int index = 12;
        this.frame.setWidgetLevel(level, widgets[index]);
        FrameTest.assertEquals((int)widgets[index].getLevel(), (int)level);
        if (!(this.alert != null && this.alert.getSource().equals(this.frame) && this.alert.getClass().equals(IFrame.WidgetChange.class) && ((IFrame.WidgetChange)this.alert).widget.equals(widgets[index]) && ((IFrame.WidgetChange)this.alert).action == 2)) {
            FrameTest.fail();
        }
        boolean[] levels = new boolean[15];
        for (i = 0; i < levels.length; ++i) {
            levels[widgets[i].getLevel()] = true;
        }
        for (i = 0; i < levels.length; ++i) {
            if (levels[i]) continue;
            FrameTest.fail();
        }
    }

    public void testGetInputDevice() {
        FrameTest.assertNull((Object)this.frame.getInputDevice(null));
        FrameTest.assertNull((Object)this.frame.getInputDevice((DeviceType)DeviceType.VALUES.get(0)));
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        this.frame2 = new Frame("test", devices);
        FrameTest.assertNotNull((Object)this.frame2.getInputDevice((DeviceType)DeviceType.VALUES.get(0)));
    }

    public void testGetInputDevices() {
        FrameTest.assertNotNull((Object)this.frame.getInputDevices());
        FrameTest.assertEquals((int)this.frame.getInputDevices().size(), (int)0);
        FrameTest.assertEquals((int)this.frame2.getInputDevices().size(), (int)0);
    }

    public void testAddIncidentTransition() {
        Widget source = new Widget(WidgetType.Button);
        Transition transition = new Transition(source, this.frame, new VoiceAction("voice 1", true));
        try {
            this.frame.addIncidentTransition(null);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.frame.addIncidentTransition(new Transition(source, this.frame2, new VoiceAction("voice 2", true)));
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        int size = this.frame.getIncidentTransitions().size();
        this.frame.addIncidentTransition(transition);
        FrameTest.assertEquals((int)this.frame.getIncidentTransitions().size(), (int)(size + 1));
    }

    public void testRemoveIncidentTransition() {
        Widget source = new Widget(WidgetType.Button);
        Transition transition = new Transition(source, this.frame, new VoiceAction("voice 3", true));
        try {
            this.frame.removeIncidentTransition(null);
            FrameTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.frame.removeIncidentTransition(new Transition(source, this.frame2, new VoiceAction("voice 4", true)));
            FrameTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        FrameTest.assertFalse((boolean)this.frame.removeIncidentTransition(transition));
        this.frame.addIncidentTransition(transition);
        int size = this.frame.getIncidentTransitions().size();
        FrameTest.assertEquals((int)this.frame.getIncidentTransitions().size(), (int)(size - 1));
    }

    public void testGetIncidentTransitions() {
        FrameTest.assertNotNull((Object)this.frame.getIncidentTransitions());
        FrameTest.assertEquals((Object)this.frame.getIncidentTransitions(), (Object)this.frame2.getIncidentTransitions());
    }

    public void testIsWidgetNameTaken() {
        FrameTest.assertTrue((!this.frame.isWidgetNameTaken("no one will use this name") ? 1 : 0) != 0);
        Widget widget = new Widget(WidgetType.Button);
        widget.setName("an example name");
        this.frame.addWidget(widget);
        FrameTest.assertTrue((boolean)this.frame.isWidgetNameTaken(widget.getName()));
    }

    public void testSetWidgetName() {
        String name = "just a name for testing";
        Widget widget = new Widget(WidgetType.Button);
        widget.setName(name);
        this.frame.addWidget(widget);
        try {
            this.frame.setWidgetName(null, widget);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.frame.setWidgetName(name, null);
            FrameTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.frame.setWidgetName(name, widget);
        FrameTest.assertEquals((String)widget.getName(), (String)name);
        Widget widget2 = new Widget(WidgetType.Button);
        widget2.setName("some other name");
        this.frame.addWidget(widget2);
        try {
            this.frame.setWidgetName(name, widget2);
            FrameTest.fail();
        }
        catch (DuplicateNameException e) {
            // empty catch block
        }
        this.frame.setWidgetName(name, widget);
    }

    public void testGetWidgetColor() {
        FrameTest.assertEquals((int)this.frame.getWidgetColor(), (int)this.frame2.getWidgetColor());
    }

    public void testSetWidgetColor() {
        int color = this.frame.getWidgetColor() + 1;
        this.frame.setWidgetColor(color);
        FrameTest.assertEquals((int)this.frame.getWidgetColor(), (int)color);
        if (this.alert == null || !this.alert.getSource().equals(this.frame) || !this.alert.getClass().equals(IFrame.WidgetChange.class) || ((IFrame.WidgetChange)this.alert).action != 3) {
            FrameTest.fail();
        }
    }

    public void handleAlert(EventObject event) {
        this.alert = event;
    }
}

