/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import java.util.EventObject;
import java.util.HashSet;
import junit.framework.TestCase;

public class DesignTest
extends TestCase
implements IAlertHandler {
    Design design;
    Design design2;
    EventObject alert;

    protected void setUp() throws Exception {
        super.setUp();
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        this.design = new Design("test design 1", devices);
        this.design2 = new Design("test design 2", devices);
        this.design.addHandler(this, EventObject.class, this);
    }

    protected void tearDown() throws Exception {
        this.alert = null;
        super.tearDown();
    }

    public void testEquals() {
        DesignTest.assertTrue((!this.design.equals(this.design2) ? 1 : 0) != 0);
        DesignTest.assertTrue((!this.design2.equals(this.design) ? 1 : 0) != 0);
    }

    public void testDesign() {
        HashSet devices = new HashSet();
        devices.add(DeviceType.VALUES.get(0));
        try {
            new Design(null, devices);
            DesignTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Design("", devices);
            DesignTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String name = "nice name here";
        this.design = new Design(name, devices);
        DesignTest.assertEquals((String)this.design.getName(), (String)name);
        DesignTest.assertEquals((int)this.design.getFrames().size(), (int)0);
    }

    public void testGetName() {
        DesignTest.assertNotNull((Object)this.design.getName());
    }

    public void testSetName() {
        try {
            this.design.setName(null);
            DesignTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.design.setName("");
            DesignTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String name = "nice name here";
        this.design.setName(name);
        DesignTest.assertEquals((String)this.design.getName(), (String)name);
        DesignTest.assertNotNull((Object)this.alert);
        DesignTest.assertEquals((Object)this.alert.getSource(), (Object)this.design);
    }

    public void testGetFrames() {
        DesignTest.assertNotNull((Object)this.design.getFrames());
    }

    public void testGetFrame() {
        DesignTest.assertNull((Object)this.design.getFrame(null));
        DesignTest.assertNull((Object)this.design.getFrame("some stupid name here"));
        Frame frame = new Frame("test frame 1", new HashSet());
        this.design.addFrame(new Frame("test frame 2", new HashSet()));
        this.design.addFrame(frame);
        DesignTest.assertEquals((Object)this.design.getFrame(frame.getName()), (Object)frame);
    }

    public void testAddFrame() {
        try {
            this.design.addFrame(null);
            DesignTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            String name = "test frame 1";
            this.design2.addFrame(new Frame(name, new HashSet()));
            this.design2.addFrame(new Frame(name, new HashSet()));
            DesignTest.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Frame frame = new Frame("valid test frame", new HashSet());
        this.design.addFrame(frame);
        DesignTest.assertEquals((int)this.design.getFrames().size(), (int)1);
        DesignTest.assertEquals(this.design.getFrames().iterator().next(), (Object)frame);
        if (!(this.alert != null && this.alert.getClass().equals(IDesign.FrameChange.class) && ((IDesign.FrameChange)this.alert).getSource().equals(this.design) && ((IDesign.FrameChange)this.alert).element.equals(frame) && ((IDesign.FrameChange)this.alert).isAdd)) {
            DesignTest.fail();
        }
    }

    public void testRemoveFrameString() {
        HashSet frames = new HashSet(this.design.getFrames());
        DesignTest.assertEquals((boolean)this.design.removeFrame("no one will use this stupid name"), (boolean)false);
        DesignTest.assertEquals((Object)this.design.getFrames(), frames);
        int size = this.design.getFrames().size();
        Frame frame = new Frame("valid test frame", new HashSet());
        this.design.addFrame(frame);
        DesignTest.assertEquals((boolean)this.design.removeFrame(frame.getName()), (boolean)true);
        DesignTest.assertEquals((int)this.design.getFrames().size(), (int)size);
        if (this.alert == null || !this.alert.getClass().equals(IDesign.FrameChange.class) || !((IDesign.FrameChange)this.alert).getSource().equals(this.design) || !((IDesign.FrameChange)this.alert).element.equals(frame) || ((IDesign.FrameChange)this.alert).isAdd) {
            DesignTest.fail();
        }
    }

    public void testRemoveFrameIFrame() {
        HashSet frames = new HashSet(this.design.getFrames());
        DesignTest.assertTrue((!this.design.removeFrame(new Frame("no one will use this stupid name", new HashSet())) ? 1 : 0) != 0);
        DesignTest.assertEquals((Object)this.design.getFrames(), frames);
        int size = this.design.getFrames().size();
        Frame frame = new Frame("valid test frame", new HashSet());
        this.design.addFrame(frame);
        DesignTest.assertEquals((boolean)this.design.removeFrame(frame), (boolean)true);
        DesignTest.assertEquals((int)this.design.getFrames().size(), (int)size);
        if (this.alert == null || !this.alert.getClass().equals(IDesign.FrameChange.class) || !((IDesign.FrameChange)this.alert).getSource().equals(this.design) || !((IDesign.FrameChange)this.alert).element.equals(frame) || ((IDesign.FrameChange)this.alert).isAdd) {
            DesignTest.fail();
        }
    }

    public void testCopyFrameStringString() {
        IFrame frameToCopy = this.design.getFrame("no one will use this stupid name");
        DesignTest.assertNull((Object)frameToCopy);
        Frame frame = new Frame("valid test frame", new HashSet());
        frameToCopy = this.design.getFrame("valid test frame");
        IFrame copy = frameToCopy.duplicate("some stupid name", new IFrame.FrameDuplicator(){

            public IFrame getOrDuplicate(IFrame f) {
                return null;
            }

            public void recordDuplicateFrame(IFrame oldF, IFrame newF) {
            }
        });
        DesignTest.assertNotNull((Object)copy);
        DesignTest.assertNotSame((Object)frame, (Object)copy);
        DesignTest.assertNull((Object)this.design.getFrame(copy.getName()));
    }

    public void handleAlert(EventObject event) {
        this.alert = event;
    }
}

