/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.tests;

import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import junit.framework.TestCase;

public class ButtonActionTest
extends TestCase {
    ButtonAction action;
    ButtonAction action2;

    protected void setUp() throws Exception {
        super.setUp();
        this.action = new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0);
        this.action2 = new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0);
    }

    public void testEquals() {
        ButtonActionTest.assertEquals((Object)this.action, (Object)this.action2);
        ButtonActionTest.assertEquals((Object)this.action2, (Object)this.action);
        this.action = new ButtonAction(MouseButtonState.Left, MousePressType.Up, 4);
        this.action2 = new ButtonAction(MouseButtonState.Middle, MousePressType.Up, 4);
        ButtonActionTest.assertTrue((!this.action.equals(this.action2) ? 1 : 0) != 0);
        ButtonActionTest.assertTrue((!this.action2.equals(this.action) ? 1 : 0) != 0);
        this.action = new ButtonAction(MouseButtonState.Right, MousePressType.Up, 2);
        this.action2 = new ButtonAction(MouseButtonState.Right, MousePressType.Down, 2);
        ButtonActionTest.assertTrue((!this.action.equals(this.action2) ? 1 : 0) != 0);
        ButtonActionTest.assertTrue((!this.action2.equals(this.action) ? 1 : 0) != 0);
        this.action = new ButtonAction(MouseButtonState.Left, MousePressType.Up, 0);
        this.action2 = new ButtonAction(MouseButtonState.Left, MousePressType.Up, 8);
        ButtonActionTest.assertTrue((!this.action.equals(this.action2) ? 1 : 0) != 0);
        ButtonActionTest.assertTrue((!this.action2.equals(this.action) ? 1 : 0) != 0);
    }

    public void testButtonAction() {
        MouseButtonState button = MouseButtonState.Right;
        MousePressType click = MousePressType.Double;
        int state = 8;
        this.action = new ButtonAction(button, click, state);
        ButtonActionTest.assertEquals((Object)this.action.getButton(), (Object)button);
        ButtonActionTest.assertEquals((Object)this.action.getPressType(), (Object)click);
        ButtonActionTest.assertEquals((int)this.action.getModifiers(), (int)state);
    }

    public void testSetButton() {
        MouseButtonState button = this.action.getButton() == MouseButtonState.Middle ? MouseButtonState.Left : MouseButtonState.Middle;
        this.action.setButton(button);
        ButtonActionTest.assertEquals((Object)this.action.getButton(), (Object)button);
    }

    public void testSetClick() {
        MousePressType click = this.action.getPressType() == MousePressType.Down ? MousePressType.Up : MousePressType.Down;
        this.action.setPressType(click);
        ButtonActionTest.assertEquals((Object)this.action.getPressType(), (Object)click);
    }

    public void testSetState() {
        int state = this.action.getModifiers() == 1 ? 8 : 1;
        this.action.setModifiers(state);
        ButtonActionTest.assertEquals((int)this.action.getModifiers(), (int)state);
    }

    public void testActionType() {
        ButtonActionTest.assertEquals((Object)this.action.getType(), (Object)ActionType.ButtonPress);
    }
}

