/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ATransitionSource;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IShape;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.ShapeRectangle;
import edu.cmu.cs.hcii.cogtool.model.ShapeType;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.TransitionSourceType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class Widget
extends ATransitionSource
implements IWidget {
    public static final int edu_cmu_cs_hcii_cogtool_model_Widget_version = 0;
    protected static final String titleVAR = "title";
    protected static final String levelVAR = "level";
    protected static final String widgetImageVAR = "widgetImage";
    protected static final String shapeVAR = "shape";
    protected static final String widgetTypeVAR = "widgetType";
    protected static final String parentGroupVAR = "parentGroup";
    protected String title = "";
    protected WidgetType widgetType;
    protected IShape shape;
    protected byte[] widgetImage;
    protected int level;
    protected IWidgetGroup parentGroup;
    protected static final int defaultX = 0;
    protected static final int defaultY = 0;
    protected static final int defaultWidth = 100;
    protected static final int defaultHeight = 100;
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            Widget v = (Widget)value;
            saver.saveString(v.title, Widget.titleVAR);
            saver.saveInt(v.level, Widget.levelVAR);
            saver.saveObject(v.widgetImage, Widget.widgetImageVAR);
            saver.saveObject(v.shape, Widget.shapeVAR);
            saver.saveObject(v.widgetType, Widget.widgetTypeVAR);
            if (v.isSaveFilteringRequired() && saver.getPurpose() == "TransitionSourceOnly") {
                saver.saveObject(saver.filterObject(v.parentGroup), Widget.parentGroupVAR);
            } else {
                saver.saveObject(v.parentGroup, Widget.parentGroupVAR);
            }
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new WidgetLoader();

    public static void registerSaver() {
        ObjectSaver.registerSaver(Widget.class.getName(), SAVER);
    }

    protected static ObjectLoader.IObjectLoader getImportLoader() {
        return LOADER;
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(Widget.class.getName(), 0, LOADER);
    }

    protected Widget() {
        this(WidgetType.Button);
    }

    public Widget(WidgetType t) {
        ShapeRectangle s = new ShapeRectangle(0.0, 0.0, 100.0, 100.0);
        this.setWidgetType(t);
        this.setShape(s);
    }

    public Widget(DoubleRectangle bounds) {
        this.shape = new ShapeRectangle(bounds);
        this.widgetType = WidgetType.Button;
        this.setShape(new ShapeRectangle(bounds));
    }

    public Widget(DoubleRectangle bounds, WidgetType t) {
        this.setWidgetType(t);
        this.setShape(new ShapeRectangle(bounds));
    }

    public Widget(WidgetType t, IShape s) {
        this.setWidgetType(t);
        this.setShape(s);
    }

    public boolean canAccept(IAction action) {
        return this.getWidgetType() != WidgetType.Noninteractive;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newtitle) {
        if (newtitle == null) {
            newtitle = "";
        }
        if (!this.title.equals(newtitle)) {
            this.title = newtitle;
            this.raiseAlert(new IWidget.WidgetChange(this, 3));
        }
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Cannot set name with null identifier!");
        }
        if (this.name != newName) {
            super.setName(newName);
            this.raiseAlert(new IWidget.WidgetChange(this, 6));
        }
    }

    public byte[] getImage() {
        return this.widgetImage;
    }

    public void setImage(byte[] i) {
        if (this.widgetImage != i) {
            this.widgetImage = i;
            this.raiseAlert(new IWidget.WidgetChange(this, 4));
        }
    }

    public void setWidgetType(WidgetType t) {
        if (t == null) {
            throw new IllegalArgumentException("Cannot set the WidgetType with null identifier!");
        }
        if (this.widgetType != t) {
            this.widgetType = t;
            this.raiseAlert(new IWidget.WidgetChange(this, 2));
        }
    }

    public WidgetType getWidgetType() {
        return this.widgetType;
    }

    public IShape getShape() {
        return this.shape;
    }

    public void setShape(IShape s) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot set the shape with a null identifier!");
        }
        if (!s.equals(this.shape)) {
            this.shape = s;
            this.raiseAlert(new IWidget.WidgetChange(this, 1));
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int newLevel) {
        this.level = newLevel;
    }

    public void moveWidget(double diffX, double diffY) {
        DoublePoint origin = this.shape.getOrigin();
        this.setWidgetOrigin(origin.x + diffX, origin.y + diffY);
    }

    public void setWidgetOrigin(double x, double y) {
        this.shape.setOrigin(x, y);
        this.raiseAlert(new IWidget.WidgetChange(this, 1));
    }

    public void setWidgetSize(double newWidth, double newHeight) {
        this.shape.setSize(newWidth, newHeight);
        this.raiseAlert(new IWidget.WidgetChange(this, 1));
    }

    public void setShapeType(ShapeType newtype) {
        IShape newShape = ShapeType.getShape(newtype, this.getShape().getBounds());
        this.setShape(newShape);
    }

    public IWidgetGroup getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(IWidgetGroup newParentGroup) {
        this.parentGroup = newParentGroup;
    }

    public String toString() {
        return "Widget " + this.getName() + " " + this.shape;
    }

    public TransitionSourceType getTransitionSourceType() {
        return TransitionSourceType.Widget;
    }

    public boolean acceptsFreeFormInput() {
        return this.widgetType == WidgetType.TextBox || this.widgetType == WidgetType.Text || this.widgetType == WidgetType.Graffiti;
    }

    public static boolean isIdentical(Widget l, Widget r) {
        return l.name.equals(r.name) && l.title.equals(r.title) && l.level == r.level && l.widgetType.equals(r.widgetType) && l.shape.equals(r.shape) && (l.widgetImage == r.widgetImage || l.widgetImage != null && Arrays.equals(l.widgetImage, r.widgetImage)) && ((Object)l.transitions).equals(r.transitions);
    }

    public boolean isIdentical(IWidget r) {
        return this.name.equals(r.getName()) && this.title.equals(r.getTitle()) && this.widgetType.equals(r.getWidgetType()) && this.shape.equals(r.getShape());
    }

    public boolean sameLocation(IWidget r) {
        if (r != null && this.shape != null) {
            return this.shape.sameBounds(r.getShape());
        }
        return false;
    }

    public boolean sameName(IWidget r) {
        if (r != null && this.name != null) {
            return this.name.equals(r.getName());
        }
        return false;
    }

    protected void copyState(Widget widgetCopy, IFrame.FrameDuplicator duplicator) {
        IShape shapeCopy = ShapeType.getShape(this.shape.getShapeType(), new DoubleRectangle(this.shape.getBounds()));
        widgetCopy.setName(this.name);
        widgetCopy.setTitle(this.title);
        widgetCopy.setLevel(this.level);
        widgetCopy.setImage(this.widgetImage);
        widgetCopy.setShape(shapeCopy);
        widgetCopy.setWidgetType(this.widgetType);
        this.duplicateTransitions(widgetCopy, duplicator);
    }

    public IWidget duplicate(IFrame.FrameDuplicator duplicator) {
        Widget widgetCopy = new Widget();
        this.copyState(widgetCopy, duplicator);
        return widgetCopy;
    }

    protected boolean isSaveFilteringRequired() {
        return false;
    }

    public Object clone() {
        Widget clone = new Widget();
        clone.name = this.name;
        clone.title = this.title;
        clone.level = this.level;
        clone.widgetType = this.widgetType;
        clone.shape = (IShape)this.shape.clone();
        if (this.widgetImage == null) {
            clone.widgetImage = null;
        } else {
            clone.widgetImage = new byte[this.widgetImage.length];
            System.arraycopy(this.widgetImage, 0, clone.widgetImage, 0, this.widgetImage.length);
        }
        clone.transitions = new HashMap(this.transitions);
        return clone;
    }

    public static class WidgetLoader
    extends ObjectLoader.AObjectLoader {
        public Object createObject() {
            return new Widget();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(Widget.titleVAR)) {
                    ((Widget)target).title = (String)value;
                } else if (variable.equals(Widget.shapeVAR)) {
                    ((Widget)target).shape = (IShape)value;
                } else if (variable.equals(Widget.widgetTypeVAR)) {
                    ((Widget)target).widgetType = (WidgetType)value;
                } else if (variable.equals(Widget.widgetImageVAR)) {
                    ((Widget)target).widgetImage = (byte[])value;
                } else if (variable.equals(Widget.parentGroupVAR)) {
                    ((Widget)target).parentGroup = (IWidgetGroup)value;
                }
            }
        }

        public void set(Object target, String variable, int value) {
            if (variable != null && variable.equals(Widget.levelVAR)) {
                ((Widget)target).level = value;
            }
        }

        public void set(Object target, String variable, boolean value) {
            if (variable != null && variable.equals("renderWidget") && value) {
                ((Widget)target).getFrame().getDesign().setSkin(SkinType.WireFrame);
            }
        }
    }
}

