/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.DelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DriveScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IButtonAction;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IGraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IKeyAction;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IShape;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IVoiceAction;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.model.ThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.util.RcvrComputationException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUnimplementedFnException;
import java.io.PrintWriter;

public class ToIRG {
    protected int stepNum = 0;
    protected boolean actAsMoveAndTap = false;
    protected StringBuffer stepBuffer = new StringBuffer();
    protected StringBuffer parameterBuffer = new StringBuffer();
    protected String lastWidgetName = "StartLoc";
    protected int lastX = 0;
    protected int lastY = 0;
    protected int voiceCommandNum = 0;
    protected int delayNum = 0;
    protected int thinkNum = 0;
    protected int widgetNum = 0;
    static String irgStart = "text( 32, bold, 'KLM Model' ).\ntext( 'Guy Pyrzak' ).\ntext( 'Febuary 2006' ).\n\n:- ['cogtool.klm.CASCADE.pl'].\n\n    /* --------------------------------\n\n    SCHEDULING PREDICATES\n    \n    -------------------------------- */\n\nschedule_name( 1 ).\n\nschedule( 1, Strategy ) :-\n  get_all_vars( start, Strategy, Vars ),\n  \n  labeling( [], Vars ),\n  fd_statistics.\n  \nschedule( 8, Strategy ) :-\n  get_all_vars( start, Strategy, SList ),\n  get_all_vars( duration, Strategy, DList),\n  get_processes_for_resource( Strategy, wm, Processes ),\n  get_all_durations(Processes, Dur),\n  doSquared(Dur,SDur),\n  sum(SDur, #=, DurSum),\n  domain([DurSum], 0, 1000000),\n  append(SList, [DurSum], Vars1),\n%  append(DList, [DurSum], Vars),\n%  append(Vars1, DList , Vars3),\n%  append(Dur, [DurSum], Vars4),\n  write('pre vars3'),nl,\n  labeling( [ minimize(DurSum)], Vars1 ),\n  write(' pre vars 1'), nl,\n%    labeling( [minimize(DurSum)], Vars),\n  write('pre vars'), nl,\n%  labeling([minimize(DurSum)], Vars),\n % write('post vars'), nl,\n%  labeling( [], SList ),\n  write('done'),\n  fd_statistics.  \n  \nschedule( 9, Strategy ) :-\n  get_all_vars( start, Strategy, SList ),\n  get_all_vars( duration, Strategy, DList),\n  get_processes_for_resource( Strategy, wm, Processes ),\n  get_all_durations(Processes, Dur),\n  sum(Dur, #=, DurSum),\n  %domain([DurSum], 0, 10000),\n  append(SList, [DurSum], Vars1),\n%  append(DList, [DurSum], Vars),\n % append(Vars1, DList , Vars3),\n%  append(Dur, [DurSum], Vars4),\n  write('pre vars3'),nl,\n  labeling( [ minimize(DurSum)], Vars1),\n  write(' pre vars 1'), nl,\n%    labeling( [minimize(DurSum)], Vars),\n  write('pre vars'), nl,\n%  labeling([minimize(DurSum)], Vars),\n % write('post vars'), nl,\n%  labeling( [], SList ),\n  write('done'),\n  fd_statistics.  \n  \n\n  \n  doConstrain([],[]).\n  doConstrain([H|T],[U|V]):-\n     H#=U,\n     doConstrain(T,V).\n  \n  \n  doSquared([],[]).\n  doSquared([H|T],[U|V]):-\n     U#=H * H,\n     doSquared(T,V).\n    /* The idea behind the following schedule predicate was that DURATIONS could be labelled prior to STARTS.  In this way, memory usage could be approximately minimized using an algorithm that was greedy for memory.  However, it appears that the complexity of the search space is still high.\n    \n    If greedy scheduling could be used efficiently to find approximately minimal memory use schedules then it could possibly also be used to find approximately minimal payoff schedules.  I.e. use a scheduling algorithm that was greedy for payoff rather than greedy for time.  AH November 2005.\n    \n    */\n    \nschedule( 2, Strategy ) :-\n  write( '+ Label Durations using ff and only then label starts.'),nl,\n  get_all_vars( duration, Strategy, DL ),\n  write(DL),nl,\n  get_all_vars( start, Strategy, SL ),\n  labeling( [ff], DL ),\n  %write(DL),nl,\n  labeling( [ffc], SL ),\n  fd_statistics.\n\n    /* The following scheduling predicate also suffers from a lack of efficiency.  Scheduling durations explcitly seems hard.  Not sure at present why it has such negative consequences for the size of the search space.\n    */\n    \nschedule( 3, Strategy ) :-\n  write( '+ Greedy minimize durations.'),nl,\n  get_all_vars( duration, Strategy, DL ),\n  write(DL),nl,\n  get_all_vars( start, Strategy, SL ),\n  write(SL),nl,\n  append( DL, SL, VARS ),\n  labeling( [ffc, bisect], VARS ),\n  fd_statistics.\n\n\n/* optimize for total duration */\n\nschedule( 4, Strategy ) :-\n  get_all_vars( start, Strategy, SL ),\n  get_all_vars( duration, Strategy, DL ),\n  % get the max for the domain\n  clp_duration_range( MINEND, MAXEND ),\n  % set the domain for end since it's a new variable\n  domain([END], MINEND, MAXEND), \n  % set the domain for SL cause it wasn't happy otherwise\n  domain(SL, MINEND, MAXEND),\n  % a function i wrote to contrain end to being larger than the end of all the processes\n  gp_after(SL, DL, END),\n  % make it one list of start times\n  append(SL, [END], VARS),\n  % label stuff, aka assign start times\n  labeling( [minimize(END)], VARS ),\n  fd_statistics.  \n  \n  \nschedule( 5, Strategy, wm, WMCap ) :-\n  write('attempting to schedule with schedule 5'),nl,\n  findall(SItem ,sResourceSize( Name, _, SItem) ,SLIST),  \n  sResourceSize(wm, _, WMCap),\n  WMCap #= 1,\n   write('pre labeling BIG list is'), write(SLIST), nl,\n   write('pre labeling is'), write(WMCap), nl,\n   write('pre start times are:'), write(Vars), nl,\n  match_check_gp(WMCap, SLIST),\n  delete(SLIST, WMCap, RL2),\n  domain([WMCap], 1, 3),\n  domain(RL2, 1, 50),\n  append(RL2, [WMCap], NEWLIST),\n  write('resource list is:'), write(NEWLIST), nl,\n  labeling( [minimize(WMCap)], NEWLIST ),\n   write('post labeling list is'), write(WMCap), nl,\n  write('resource list is:'), write(NEWLIST), nl,\n  write('start times are:'), write(Vars), nl\n\n  .\n  schedule( 5, Strategy, Name, WMCap):-\n     sResourceSize(Name, _, WMCap)\n  .\n\nschedule( 6, Strategy ) :-\n  get_all_vars( start, Strategy, Vars ),\n  \n  get_all_vars( amount, Strategy, ReqList ),\n  % get all the wm guys\n  get_processes_for_resource( Strategy, wm, Processes ),\n  % get all the Req for the WM\n  get_all_requirements( Processes, Req ),\n  % set values to the req for WM from the highest possible values\n  labeling( [down], Req),\n  \n  \n  %if you want to use more then 1 then you'll need to get the Req for that and \n  % append the lists together. I will try to make a small set of functions to make\n  % creating such a list easier for ya if you'd like. But for today this is it.\n  \n  % assign the start times with respect to the already set Req\n  labeling( [], Vars ),\n  \n  write('trying amount'),write(Others),nl,\n  fd_statistics.\n  \nschedule( 7, Strategy ) :-\n  get_all_vars( start, Strategy, Vars ),\n  get_processes_for_resource( Strategy, wm, Processes ),\n  get_all_durations(Processes, Durations),\n  labeling( [down], Durations),\n  write('done labeling durations'),nl,\n  labeling( [], Vars ),\n  fd_statistics.\n  \n  \n\n  match_check_gp(Wm, List):-\n  \n     member(Wm, List),\n     write('wm is already in the list'),nl\n  \n  .\n  \n  match_check_gp(Wm, List):-\n  \n   write('wm is not in the list'),nl\n  .\nget_StreachyCapacity( Name, StreachyCapacity).\n\n\ngp_after([], [], _). \ngp_after([S|Ss], [D|Ds], E) :- E #>= S+D, gp_after(Ss, Ds, E). \n\n\ntask_color( file, '#999' ).\ntask_color( edit, '#DDD' ).\n\n%task_color( pattern, '#DD0' ).\n%task_color( tonetask, '#0DD' ).\n%task_color( tonetask, '#0D0' ).\n\ntrials(100).\n\n/*\n The Following MUST be set properly.\n*/\nclp_start_range( 0, 50000 ).\nclp_duration_range( 0, 50000 ).\n\ntask_color( pattern, '#999' ).\n\n    /* -------------------------------\n    TASK\n    note that 'file' and 'edit' tasks are used just so that different names\n    are available for the two 'moveclick' tasks.  The names are used to set a \n    a color with thet task_color features.\n    \n    klm_TaskT1_Bravo - Done.\n    \n    --------------------------------*/\n\nirg( \"\n\ntop _ _\n --> \n cogtool_core - Done.\n\n\ncogtool_core -                   Done\n-->\n";
    static String irgMid = "\").\n\n\nirg(\"\n\n actsimple_move_hand DEVICE - SOURCES                                    - OUTPUT\n -->\n     parameter( duration actsimple move hand DEVICE D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=move_hand\n                 duration=D\n                 resource=hand\n                 output=OUTPUT   ]).\n                 \n actsimple_move DEVICE from WIDGET_START to WIDGET_DEST  - SOURCES       - OUTPUT \n -->\n     parameter( duration actsimple move DEVICE from WIDGET_START to WIDGET_DEST D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=move\n                 duration=D\n                 resource=DEVICE\n                 output=OUTPUT   ]).\n \n actsimple_drag DEVICE from WIDGET_START to WIDGET_DEST  - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple drag DEVICE from WIDGET_START to WIDGET_DEST D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=drag\n                 duration=D\n                 resource=DEVICE\n                 output=OUTPUT   ]).\n \n actsimple_click DEVICE with HAND_FINGER                 - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple click DEVICE with HAND_FINGER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=click\n                 duration=D\n                 resource=HAND_FINGER\n                 output=OUTPUT   ]).\n \n actsimple_tap with HAND_FINGER                          - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple tap with HAND_FINGER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=tap\n                 duration=D\n                 resource=HAND_FINGER\n                 output=OUTPUT   ]).\n \n actsimple_press_mouse with HAND_FINGER                  - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple press_mouse with HAND_FINGER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=press_mouse\n                 duration=D\n                 resource=HAND_FINGER\n                 output=OUTPUT   ]).\n \n \n actsimple_release_mouse with HAND_FINGER                - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple release_mouse with HAND_FINGER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 duration=D\n                 label=release_mouse\n                 resource=HAND_FINGER\n                 output=OUTPUT   ]).\n                 \n actsimple_press_key KEYBOARD_KEY                        - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple press_key KEYBOARD_KEY HAND_FINGER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=press_key\n                 duration=D\n                 resource=HAND_FINGER\n                 output=OUTPUT   ]).\n                 \n                 \n actsimple_press_key KEYBOARD_KEY with HAND_FINGER       - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple press_key KEYBOARD_KEY HAND_FINGER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 resource=HAND_FINGER\n                 label=press_key\n                 duration=D\n                 resource=HAND_FINGER\n                 output=OUTPUT   ]).\n \n actsimple_graffiti_gesture CHARACTER                    - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple graffiti gesture CHARACTER D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=graffiti_gesture\n                 duration=D\n                 resource=right\n                 output=OUTPUT   ]).\n \n actsimple_speak MSG                                     - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple speak MSG D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=speak\n                 duration=D\n                 resource=voice\n                 output=OUTPUT   ]).\n \n actsimple_listen EVENT                                  - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple listen EVENT D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=listen\n                 duration=D\n                 resource=audition\n                 output=OUTPUT   ]).\n \n actsimple_lookat WIDGET                                 - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple lookat WIDGET D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=lookat\n                 duration=D\n                 resource=eyes\n                 output=OUTPUT   ]).\n \n actsimple_think INFORMATION                             - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple think INFORMATION D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=think\n                 duration=D\n                 resource=cognition\n                 output=OUTPUT   ]).\n \n actsimple_recall INFORMATION                            - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple recall INFORMATION D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=recall\n                 duration=D\n                 resource=cognition\n                 output=OUTPUT   ]).\n         \n actsimple_system_wait SYSEVENT                          - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple system_wait SYSEVENT D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=system_wait\n                 duration=D\n                 resource=system\n                 output=OUTPUT   ]).\n     \n actsimple_do_transition STATE1 to STATE2            - SOURCES       - OUTPUT\n -->\n     parameter( duration actsimple do_transition STATE1 to STATE2 D),\n     process([   distribution=basic\n                 inputs=SOURCES\n                 label=sys_transition\n                 duration=D\n                 resource=system\n                 output=OUTPUT   ]).\n \n klm_k_op EXPERTISE          - SOURCES                           - OUTPUT\n -->\n     parameter( duration klm_k_op EXPERTISE D),\n     process([   distribution=basic\n                 duration=D\n                 inputs=SOURCES\n                 label=key_press\n                 resource=hands\n                 output=OUTPUT   ]).\n \n klm_m_op                    - SOURCES                           - OUTPUT\n -->\n     parameter( duration klm_m_op D),\n     process([   distribution=basic\n                 duration=D\n                 inputs=SOURCES\n                 label=mental\n                 resource=cognition\n                 output=OUTPUT   ]).\n \n klm_d_op                    - SOURCES                           - OUTPUT\n -->\n     parameter(  duration klm_d_op D),\n     process([   distribution=basic\n                 duration=D\n                 inputs=SOURCES\n                 label=draw\n                 resource=hands\n                 output=OUTPUT   ]).\n             \n klm_h_op                    - SOURCES                           - OUTPUT\n -->\n     parameter( duration klm_h_op D),\n     process([   distribution=basic\n                 duration=D\n                 inputs=SOURCES\n                 label=home\n                 resource=hands\n                 output=OUTPUT   ]).\n \n klm_p_op TARGET             - SOURCES                           - OUTPUT\n -->\n     parameter( duration klm_p_op TARGET D),\n     process([   distribution=basic\n                 duration=D\n                 inputs=SOURCES\n                 label=point\n                 resource=hands\n                 output=OUTPUT   ]).\n                 \n klm_r_op SYSEVENT       - SOURCES                               - OUTPUT\n -->\n     parameter( duration klm_r_op SYSEVENT D),\n     process([   distribution=basic\n                 duration=D\n                 inputs=SOURCES\n                 label=system_response\n                 resource=system\n                 output=OUTPUT   ]).\n \n \n \n \n\").\n\n\n\n\n\n\n\n/*\nPARAMETERS\n*/\n     parameter( duration, actsimple, move, hand, _, 570).\n     parameter( duration, actsimple, move, _, from, _, to, _, 1030).\n     parameter( duration, actsimple, drag, _, from, _, to, _, 1030).\n     parameter( duration, actsimple, click, _, with, _, 1030).\n     parameter( duration, actsimple, tap, with, _, 20).\n     parameter( duration, actsimple, press_mouse, with, _, 20).\n     parameter( duration, actsimple, release_mouse, with, _, 20).\n     parameter( duration, actsimple, press_key, _, _, 150).\n     parameter( duration, actsimple, graffiti, gesture, _, 580).\n     parameter( duration, actsimple, speak, _, 20).\n     parameter( duration, actsimple, listen, _, 20).\n     parameter( duration, actsimple, lookat, _, 20).     \n     parameter( duration, actsimple, think, _, 1350).\n     parameter( duration, actsimple, recall, _, 20).\n     parameter( duration, actsimple, system_wait, _, 20).    \n     parameter( duration, actsimple, do_transition, _, to, _, 20).\n     parameter( duration, klm_m_op, 1350).\n     parameter( duration, klm_d_op, 50).\n     parameter( duration, klm_h_op, 400).\n     parameter( duration, klm_r_op, _, 1000).\n     parameter( duration, klm_k_op, _, 200).\n";
    static String irgEnd = "\n\n    /* -------------------------------\n    RESOURCES\n    --------------------------------*/\n \n% altering working memory\n% vary from 1 to 5\n\n \nresources( [\n (cognition,1),\n (wm,10),\n    (eyes, 1),   \n (left,1),\n (right,1),\n (hand,2),\n (hands,1),\n (system,1),\n (mouse,1)\n ]).\n";

    public static double fittsTime(int startX, int startY, Widget targetWidget) {
        double widgetCenterX = targetWidget.getShape().getOrigin().getX() + 0.5 * targetWidget.getShape().getSize().width;
        double widgetCenterY = targetWidget.getShape().getOrigin().getY() + 0.5 * targetWidget.getShape().getSize().height;
        double distance = Math.sqrt(Math.pow(widgetCenterX - (double)startX, 2.0) + Math.pow(widgetCenterY - (double)startY, 2.0));
        double size = targetWidget.getShape().getSize().getWidth() * targetWidget.getShape().getSize().getHeight();
        return 0.8 + 0.1 * Math.log(distance / size + 0.5) / Math.log(2.0);
    }

    protected void addStepData(String stepString) {
        if (this.stepNum == 0) {
            this.stepBuffer.append(stepString);
            this.stepBuffer.append("\t - _");
        } else {
            this.stepBuffer.append("\t - RESULT" + Integer.toString(this.stepNum) + ",\n");
            this.stepBuffer.append("\t\t" + stepString);
            this.stepBuffer.append("\t - RESULT" + Integer.toString(this.stepNum));
        }
        ++this.stepNum;
    }

    protected void addClickAction(int numClicks) {
        for (int i = 0; i < numClicks; ++i) {
            String stepData = "klm_k_op dummy";
            this.addStepData(stepData);
        }
    }

    protected void addMoveMouseAction(Widget widget) {
        String widgetId = "widget" + Integer.toString(this.widgetNum);
        ++this.widgetNum;
        String stepData = "klm_p_op " + widgetId;
        this.addStepData(stepData);
        int moveTime = (int)(1000.0 * ToIRG.fittsTime(this.lastX, this.lastY, widget));
        this.parameterBuffer.append("parameter( duration, klm_p_op, ");
        this.parameterBuffer.append(widgetId);
        this.parameterBuffer.append(", ");
        this.parameterBuffer.append(Integer.toString(moveTime));
        this.parameterBuffer.append(").\n");
        IShape widgetShape = widget.getShape();
        DoubleRectangle widgetBounds = widgetShape.getBounds();
        this.lastX = (int)(widgetBounds.x + 0.5 * widgetBounds.width);
        this.lastY = (int)(widgetBounds.y + 0.5 * widgetBounds.height);
        this.lastWidgetName = widgetId;
    }

    protected void addKeyAction(char c) {
        String stepData = "klm_k_op key_x";
        this.addStepData(stepData);
    }

    protected void addGraffitiLetterAction(char c) {
        String stepData = "actsimple_graffiti_gesture graffiti_" + c;
        this.addStepData(stepData);
    }

    protected void addSpeechAction(String voiceCommand) {
        String voiceCommandId = "voice" + Integer.toString(this.voiceCommandNum);
        ++this.voiceCommandNum;
        String stepData = "actsimple_speak " + voiceCommandId;
        this.addStepData(stepData);
    }

    protected void addHomeKeyboardAction() {
        String stepData = "klm_h_op";
        this.addStepData(stepData);
    }

    protected void addHomeMouseAction() {
        String stepData = "klm_h_op";
        this.addStepData(stepData);
    }

    protected void addTapScreenAction() {
        String stepData = "klm_k_op dummy";
        this.addStepData(stepData);
    }

    protected void addDelayAction(double delay) {
        String delayId = "delay" + Integer.toString(this.delayNum);
        ++this.delayNum;
        String stepData = "klm_r_op " + delayId;
        this.addStepData(stepData);
        this.parameterBuffer.append("parameter ( duration, klm_r_op, ");
        this.parameterBuffer.append(delayId + ", " + Double.toString(delay * 1000.0) + ").\n");
    }

    protected void addLookAtAction(IWidget widget) {
    }

    protected void addThinkAction(double thinkTime) {
        String stepData = "klm_m_op";
        this.addStepData(stepData);
    }

    public void createIRG(IScript script, IDesign design, PrintWriter out) {
        for (int n = 0; n < script.getScriptSteps().size(); ++n) {
            IScriptStep step = script.getScriptStep(n);
            if (step instanceof TextActionSegment) {
                String cmd = ((TextActionSegment)step).getText();
                for (int i = 0; i < cmd.length(); ++i) {
                    this.addKeyAction(cmd.charAt(i));
                }
                continue;
            }
            if (step instanceof ActionScriptStep) {
                String cmd;
                Widget widget;
                ActionScriptStep actionStep = (ActionScriptStep)step;
                IAction action = actionStep.getAction();
                ActionType type = action.getType();
                ITransitionSource source = actionStep.getStepFocus();
                if (type.equals(ActionType.ButtonPress)) {
                    MousePressType pt = ((IButtonAction)action).getPressType();
                    this.addClickAction(pt.equals(MousePressType.Double) ? 2 : 1);
                    continue;
                }
                if (type.equals(ActionType.MouseOver) || type.equals(ActionType.MoveMouse)) {
                    IScriptStep peekStep;
                    if (n + 1 < script.getScriptSteps().size() && (peekStep = script.getScriptStep(n + 1)) instanceof ActionScriptStep) {
                        IActionScriptStep peekActionStep = (IActionScriptStep)peekStep;
                        boolean bl = this.actAsMoveAndTap = peekActionStep.getAction().getType() == ActionType.Tap;
                    }
                    if (this.actAsMoveAndTap) continue;
                    action.getType();
                    widget = (Widget)source;
                    this.addMoveMouseAction(widget);
                    continue;
                }
                if (type.equals(ActionType.KeyPress)) {
                    cmd = ((IKeyAction)action).getText();
                    for (int i = 0; i < cmd.length(); ++i) {
                        this.addKeyAction(cmd.charAt(i));
                    }
                    continue;
                }
                if (type.equals(ActionType.GraffitiStroke)) {
                    cmd = ((IGraffitiAction)action).getText();
                    for (int i = 0; i < cmd.length(); ++i) {
                        this.addGraffitiLetterAction(cmd.charAt(i));
                    }
                    continue;
                }
                if (type.equals(ActionType.Voice)) {
                    this.addSpeechAction(((IVoiceAction)action).getText());
                    continue;
                }
                if (type.equals(ActionType.HomeKeyboard)) {
                    this.addHomeKeyboardAction();
                    continue;
                }
                if (type.equals(ActionType.HomeMouse)) {
                    this.addHomeMouseAction();
                    continue;
                }
                if (type.equals(ActionType.Tap)) {
                    if (this.actAsMoveAndTap) {
                        action.getType();
                        widget = (Widget)source;
                        this.addMoveMouseAction(widget);
                    }
                    this.addTapScreenAction();
                    this.actAsMoveAndTap = false;
                    continue;
                }
                throw new RcvrComputationException("An unexpected Action type " + type + " was associated with an ActionScriptStep. " + "Check the FSM.");
            }
            if (step instanceof DelayScriptStep) {
                DelayScriptStep delayStep = (DelayScriptStep)step;
                this.addDelayAction(delayStep.getDelayDuration());
                continue;
            }
            if (step instanceof DriveScriptStep) {
                throw new RcvrUnimplementedFnException("Driving is not currently supported.");
            }
            if (step instanceof LookAtScriptStep) {
                LookAtScriptStep lookStep = (LookAtScriptStep)step;
                IWidget widget = lookStep.getLookAtTarget();
                this.addLookAtAction(widget);
                continue;
            }
            if (!(step instanceof ThinkScriptStep)) continue;
            ThinkScriptStep thinkStep = (ThinkScriptStep)step;
            this.addThinkAction(thinkStep.duration);
        }
        this.stepBuffer.append(" - Done.");
        out.print(irgStart);
        out.print(this.stepBuffer.toString());
        out.print(irgMid);
        out.print(this.parameterBuffer.toString());
        out.print(irgEnd);
    }
}

