/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.DelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.DriveScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IButtonAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IGraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IKeyAction;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITapAction;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.model.TapScriptStep;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.model.ThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ToActr;
import edu.cmu.cs.hcii.cogtool.util.RcvrComputationException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUnimplementedFnException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ToActr6ScriptStepVisitor
implements ToActr.IToActrScriptStepVisitor {
    protected int nextStep = 1;
    protected IScript script;
    protected int stepCount;
    protected PrintWriter out;
    protected int nameCounter = 1;
    protected int state = 1;
    protected String kind = null;
    protected String buffers = null;
    IFrame previousFrame = null;
    StringBuffer properties = null;
    protected boolean actAsMoveAndTap = false;
    protected static final Pattern NEEDS_ESCAPE = Pattern.compile("[\\\\$]");
    protected static final Pattern TEMPLATE_ITEM = Pattern.compile("%.");

    public ToActr6ScriptStepVisitor(IScript s, PrintWriter outWriter) {
        this.script = s;
        this.stepCount = this.script.getScriptSteps().size();
        this.out = outWriter;
    }

    public void next() {
        ++this.nextStep;
    }

    protected static String escapeForRegex(String s) {
        return NEEDS_ESCAPE.matcher(s).replaceAll("\\\\$0");
    }

    protected void emitProduction(IScriptStep step, boolean transition, String template, String sub1, String sub2) {
        this.actAsMoveAndTap = false;
        this.addProperty(":current-frame", ToActr.lispString(step.getCurrentFrame().getName()));
        if (this.previousFrame == null) {
            this.previousFrame = step.getCurrentFrame();
        }
        IFrame d = step.getDestinationFrame();
        if (transition && d != null && d != this.previousFrame) {
            this.addProperty(":destination-frame", ToActr.lispString(d.getName()));
            this.previousFrame = d;
        }
        StringBuffer result = new StringBuffer(2 * template.length());
        Matcher m = TEMPLATE_ITEM.matcher(template);
        while (m.find()) {
            String rep = null;
            switch (m.group(0).charAt(1)) {
                case 'c': {
                    rep = Integer.toString(this.nameCounter);
                    break;
                }
                case 's': {
                    rep = Integer.toString(this.state);
                    break;
                }
                case 'S': {
                    rep = Integer.toString(++this.state);
                    break;
                }
                case '1': {
                    if (sub1 == null) {
                        throw new IllegalStateException("No first substitution provided.");
                    }
                    rep = ToActr6ScriptStepVisitor.escapeForRegex(sub1);
                    break;
                }
                case '2': {
                    if (sub2 == null) {
                        throw new IllegalStateException("No second substitution provided.");
                    }
                    rep = ToActr6ScriptStepVisitor.escapeForRegex(sub2);
                    break;
                }
                case 'p': {
                    this.addProperty(":script-step", "'" + this.kind);
                    if (this.buffers != null) {
                        this.addProperty(":buffers", "'(" + this.buffers + ")");
                    }
                    this.addProperty(":script-step-count", Integer.toString(this.nextStep));
                    rep = ToActr6ScriptStepVisitor.escapeForRegex("(set-cogtool-plist " + this.properties.toString() + ")");
                }
            }
            m.appendReplacement(result, rep);
        }
        m.appendTail(result);
        result.append("\n");
        this.out.println(result.toString());
        ++this.nameCounter;
        this.properties = null;
    }

    protected void emitProduction(IScriptStep step, boolean transition, String template, String sub) {
        this.emitProduction(step, transition, template, sub, null);
    }

    protected void emitProduction(IScriptStep step, boolean transition, String template) {
        this.emitProduction(step, transition, template, null, null);
    }

    protected void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new StringBuffer(key.length() + value.length() + 1);
        } else {
            this.properties.append(" ");
        }
        this.properties.append(key);
        this.properties.append(" ");
        this.properties.append(value);
    }

    public void visit(TextActionSegment step) {
        String cmd = step.getText();
        this.addProperty(":script-step", "'TEXT");
        this.addProperty(":buffers", "'(MANUAL)");
        for (int i = 0; i < cmd.length(); ++i) {
            String key = ToActr.encodeKey(cmd.charAt(i));
            this.addProperty(":key", "'" + key);
            this.emitProduction(step, i + 1 >= cmd.length(), "(p press-key-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa press-key\n    key %1\n  =goal>\n    state %S)", key);
        }
    }

    protected void startVisit(String stepKind, String buffersUsed) {
        this.kind = stepKind;
        this.buffers = buffersUsed;
    }

    public void visit(ActionScriptStep step) {
        IAction action = step.getAction();
        ActionType type = action.getType();
        ITransitionSource source = step.getStepFocus();
        if (type.equals(ActionType.ButtonPress)) {
            int i;
            MousePressType pt = ((IButtonAction)action).getPressType();
            boolean isDouble = pt.equals(MousePressType.Double);
            String target = ToActr.lispString(source.getName());
            this.startVisit("BUTTON-PRESS", "MANUAL");
            int n = i = isDouble ? 2 : 1;
            while (i > 0) {
                this.addProperty(":target", target);
                this.emitProduction(step, false, "(p prepare-click-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    preparation free\n==>\n  !eval! %p\n  +manual>\n    isa prepare\n    style punch\n    features (:hand right :finger index)\n  =goal>\n    state %S)");
                this.addProperty(":target", target);
                this.emitProduction(step, i == 1, "(p click-mouse-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa click-mouse\n  =goal>\n    state %S)");
                --i;
            }
        } else if (type.equals(ActionType.MouseOver) || type.equals(ActionType.MoveMouse)) {
            IScriptStep peekStep;
            boolean tapIsNext = false;
            this.startVisit(type.equals(ActionType.MouseOver) ? "HOVER" : "MOVE-MOUSE", "MANUAL VISUAL-LOCATION");
            if (this.nextStep < this.stepCount && (peekStep = this.script.getScriptStep(this.nextStep)) instanceof ActionScriptStep) {
                IActionScriptStep peekActionStep = (IActionScriptStep)peekStep;
                boolean bl = tapIsNext = peekActionStep.getAction().getType() == ActionType.Tap;
            }
            if (tapIsNext) {
                this.actAsMoveAndTap = true;
            } else {
                String target = ToActr.lispString(source.getName());
                this.emitProduction(step, false, "(p find-location-%c\n  =goal>\n    isa klm\n    state %s\n==>\n  !eval! %p\n  +visual-location>\n    isa visual-location\n    value %1\n  =goal>\n    state %s)\n\n(spp find-location-%c :p 0.1)", target);
                this.emitProduction(step, true, "(p move-mouse-%c\n  =goal>\n    isa klm\n    state %s\n  =visual-location>\n    isa visual-location\n    value %1\n  ?manual>\n    preparation free\n    execution free\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa move-cursor\n    loc =visual-location\n  =visual-location>\n  =goal>\n    state %S)", target);
            }
        } else if (type.equals(ActionType.KeyPress)) {
            String cmd = ((IKeyAction)action).getText();
            this.startVisit("KEY-PRESS", "MANUAL");
            for (int i = 0; i < cmd.length(); ++i) {
                String key = ToActr.encodeKey(cmd.charAt(i));
                this.addProperty(":key", "'" + key);
                this.emitProduction(step, i + 1 >= cmd.length(), "(p press-key-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa press-key\n    key %1\n  =goal>\n    state %S)", key);
            }
        } else if (type.equals(ActionType.GraffitiStroke)) {
            String cmd = ((IGraffitiAction)action).getText();
            this.startVisit("GRAFFITI", "MANUAL");
            for (int i = 0; i < cmd.length(); ++i) {
                String key = ToActr.encodeKey(cmd.charAt(i));
                this.addProperty(":key", "'" + key);
                this.emitProduction(step, i + 1 >= cmd.length(), "(p graffiti-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa graffiti-gesture\n    key %1\n  =goal>\n    state %S)", key);
            }
        } else {
            if (type.equals(ActionType.Voice)) {
                throw new RcvrUnimplementedFnException("Voice is not currently supported.");
            }
            if (type.equals(ActionType.HomeKeyboard)) {
                this.startVisit("HOME-KEYBOARD", "MANUAL");
                this.addProperty(":target", "'keyboard");
                this.emitProduction(step, false, "(p move-hand-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa hand-to-home\n  =goal>\n    state %S)");
            } else if (type.equals(ActionType.HomeMouse)) {
                this.startVisit("HOME-MOUSE", "MANUAL");
                this.addProperty(":target", "'mouse");
                this.emitProduction(step, false, "(p move-hand-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa hand-to-mouse\n  =goal>\n    state %S)");
            } else if (type.equals(ActionType.Tap)) {
                this.tap(step, this.actAsMoveAndTap ? source.getName() : null, 1, this.actAsMoveAndTap);
            } else {
                throw new RcvrComputationException("An unexpected Action type " + type + " was associated with an ActionScriptStep. " + "Check the FSM.");
            }
        }
    }

    public void visit(TapScriptStep tss) {
        TapPressType tpt = ((ITapAction)tss.getAction()).getTapPressType();
        int tapCount = tpt == TapPressType.DoubleTap ? 2 : 1;
        Object target = null;
        this.startVisit("TAP", "MANUAL VISUAL-LOCATION");
        if (tss.getMoveRequired()) {
            ITransitionSource source = tss.getStepFocus();
            this.tap(tss, ToActr.lispString(source.getName()), tapCount, true);
        } else {
            this.tap(tss, null, tapCount, false);
        }
    }

    protected void tap(IScriptStep step, String target, int count, boolean moveRequired) {
        if (moveRequired) {
            this.emitProduction(step, false, "(p find-location-%c\n  =goal>\n    isa klm\n    state %s\n==>\n  !eval! %p\n  +visual-location>\n    isa visual-location\n    value %1\n  =goal>\n    state %s)\n\n(spp find-location-%c :p 0.1)", target);
            this.emitProduction(step, count == 1, "(p move-finger-%c\n  =goal>\n    isa klm\n    state %s\n  =visual-location>\n    isa visual-location\n    value %1\n  ?manual>\n    preparation free\n    execution free\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa move-cursor\n    loc =visual-location\n  =visual-location>\n  =goal>\n    state %S)", target);
            --count;
        }
        while (count > 0) {
            if (target != null) {
                this.addProperty(":target", target);
            }
            this.emitProduction(step, false, "(p prepare-tap-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    preparation free\n==>\n  !eval! %p\n  +manual>\n    isa prepare\n    style punch\n    features (:hand right :finger index)\n  =goal>\n    state %S)");
            if (target != null) {
                this.addProperty(":target", target);
            }
            this.emitProduction(step, count == 1, "(p tap-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  +manual>\n    isa click-mouse\n  =goal>\n    state %S)");
            --count;
        }
    }

    public void visit(DelayScriptStep delayss) {
        String duration = Double.toString(delayss.getDelayDuration());
        this.startVisit("DELAY", "MANUAL VISUAL");
        this.addProperty(":duration", duration);
        this.emitProduction(delayss, false, "(p wait-for-system-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n  ?visual>\n    state free\n==>\n  !eval! (progn\n            %p\n            (set-cogtool-delay %1))\n  =goal>\n    state %S)\n\n(spp wait-for-system-%c :effort 0.0)", duration);
    }

    public void visit(DriveScriptStep drivess) {
        throw new RcvrUnimplementedFnException("Driving is not currently supported.");
    }

    public void visit(LookAtScriptStep lass) {
        String target = ToActr.lispString(lass.getLookAtTarget().getName());
        this.startVisit("LOOK-AT", "VISUAL VISUAL-LOCATION");
        this.addProperty(":target", target);
        this.emitProduction(lass, false, "(p find-%c\n  =goal>\n    isa klm\n    state %s\n==>\n  !eval! %p\n  +visual-location>\n    isa visual-location\n    value %1\n  =goal>\n    state #.(1+ %s))\n\n(spp find-%c :p 0.1)", target);
        this.addProperty(":target", target);
        this.emitProduction(lass, false, "(p look-at-%c\n  =goal>\n    isa klm\n    state %s\n  =visual-location>\n    isa visual-location\n    value %1\n  ?visual>\n    state free\n==>\n  !eval! %p\n  +visual>\n    isa move-attention\n    screen-pos =visual-location\n  =visual-location>\n  =goal>\n    state #.(1+ %S))", target);
        this.addProperty(":target", target);
        this.emitProduction(lass, false, "(p look-at-%c\n  =goal>\n    isa klm\n    state %s\n  =visual-location>\n    isa visual-location\n    value %1\n  ?visual>\n    state free\n==>\n  !eval! %p\n  +visual>\n    isa move-attention\n    screen-pos =visual-location\n  =visual-location>\n  =goal>\n    state %S)", target);
    }

    public void visit(ThinkScriptStep tss) {
        String duration = Double.toString(tss.getThinkDuration());
        this.startVisit("THINK", null);
        this.addProperty(":duration", duration);
        this.emitProduction(tss, false, "(p think-%c\n  =goal>\n    isa klm\n    state %s\n  ?manual>\n    state free\n==>\n  !eval! %p\n  =goal>\n    state %S)\n\n(spp think-%c :effort %1)", duration);
    }
}

