/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.DelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.DriveScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IButtonAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IGraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IKeyAction;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITapAction;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.model.TapScriptStep;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.model.ThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ToActr;
import edu.cmu.cs.hcii.cogtool.util.RcvrComputationException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUnimplementedFnException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ToActr5ScriptStepVisitor
implements ToActr.IToActrScriptStepVisitor {
    protected int nextStep = 1;
    protected IScript script;
    protected int stepCount;
    protected PrintWriter out;
    protected int nameCounter = 1;
    protected int state = 1;
    protected StringBuffer sppCommand;
    protected String[] freeList;
    protected List traceList = new ArrayList();
    protected List conditionAdditions = new ArrayList();
    protected List evalAdditions = new ArrayList();
    protected List actionAdditions = new ArrayList();
    protected boolean advanceState;
    protected boolean setPlist;
    protected boolean isLast;
    protected String stateType;
    IFrame previousFrame = null;
    IScriptStep currentStep = null;
    StringBuffer properties = null;
    protected boolean actAsMoveAndTap = false;
    public static boolean stubOutAction = false;

    public ToActr5ScriptStepVisitor(IScript s, PrintWriter outWriter) {
        this.script = s;
        this.stepCount = this.script.getScriptSteps().size();
        this.out = outWriter;
    }

    public void next() {
        ++this.nextStep;
    }

    protected void prepareActrProduction(IScriptStep step) {
        this.properties = new StringBuffer();
        this.currentStep = step;
        this.setCurrentFrame(step.getCurrentFrame());
        this.sppCommand = null;
        this.freeList = null;
        this.traceList.clear();
        this.conditionAdditions.clear();
        this.evalAdditions.clear();
        this.actionAdditions.clear();
        this.advanceState = true;
        this.setPlist = true;
        this.isLast = true;
        this.stateType = "manual";
        this.actAsMoveAndTap = false;
    }

    protected String stq(String s) {
        return "\"" + ToActr.clean(s) + "\"";
    }

    protected void addProperty(String key, String value, boolean addStringQuotes) {
        this.properties.append(" :" + key + " '");
        if (addStringQuotes) {
            this.properties.append(this.stq(value));
        } else {
            this.properties.append(value);
        }
    }

    protected void addSpp(String key, String value) {
        if (this.sppCommand == null) {
            this.sppCommand = new StringBuffer();
        }
        this.sppCommand.append(" :");
        this.sppCommand.append(key);
        this.sppCommand.append(" ");
        this.sppCommand.append(value);
    }

    protected void setFree(String[] values) {
        if (this.freeList != null) {
            throw new IllegalStateException("Attempt to re-set free list");
        }
        this.freeList = values;
    }

    protected void setFree(String value) {
        this.setFree(new String[]{value});
    }

    protected void addTrace(String value) {
        this.traceList.add(value);
    }

    protected void addVisualBuffer(String target, boolean isMouse) {
        this.conditionAdditions.add(isMouse ? "=mouse-loc>" : "=visual-location>");
        this.conditionAdditions.add("  isa visual-location");
        this.conditionAdditions.add("  value " + this.stq(target));
    }

    protected void addEval(String value) {
        this.evalAdditions.add(value);
    }

    protected void sendCommand(String cmd) {
        this.actionAdditions.add(0, "!send-command! " + cmd);
    }

    protected void addActionBuffer(String name, String type, String additional) {
        this.actionAdditions.add("+" + name + ">");
        this.actionAdditions.add("  isa " + type);
        if (additional != null) {
            this.actionAdditions.add("  " + additional);
        }
    }

    protected void setNotLast() {
        this.isLast = false;
    }

    protected void suppressPlist() {
        this.setPlist = false;
    }

    protected void dontAdvanceState() {
        this.advanceState = false;
    }

    protected void setStateType(String typ) {
        this.stateType = typ;
    }

    protected void emitActrProduction(String klmType) {
        Iterator it;
        String name = "klm-" + klmType + "-" + this.nameCounter++;
        if (this.isLast) {
            if (this.previousFrame == null) {
                this.previousFrame = this.currentStep.getCurrentFrame();
            }
            if (this.currentStep.getDestinationFrame() != null && this.currentStep.getDestinationFrame() != this.previousFrame) {
                this.setDestination(this.currentStep.getDestinationFrame().getName());
                this.previousFrame = this.currentStep.getDestinationFrame();
            }
        }
        this.out.println("(p " + name);
        this.out.println("  =goal>");
        this.out.println("    isa   klm");
        this.out.println("    state " + this.state);
        if (this.conditionAdditions.size() > 0) {
            it = this.conditionAdditions.iterator();
            while (it.hasNext()) {
                this.out.println("  " + (String)it.next());
            }
        }
        this.out.println("  =" + this.stateType + "-state>");
        this.out.println("    isa module-state");
        if (this.freeList == null) {
            this.out.println("    modality free");
        } else {
            for (int i = 0; i < this.freeList.length; ++i) {
                this.out.println("    " + this.freeList[i] + " free");
            }
        }
        this.out.println("==>");
        if (this.setPlist) {
            this.evalAdditions.add(0, "(set-cogtool-plist " + this.properties + ")");
        }
        switch (this.evalAdditions.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.out.println("  !eval! " + (String)this.evalAdditions.get(0));
                break;
            }
            default: {
                this.out.println("  !eval! (progn");
                it = this.evalAdditions.iterator();
                while (it.hasNext()) {
                    this.out.println("             " + (String)it.next());
                }
                this.out.println("          )");
            }
        }
        switch (this.traceList.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.out.println("  !output! " + (String)this.traceList.get(0));
                break;
            }
            default: {
                this.out.println("  !output! (progn");
                it = this.traceList.iterator();
                while (it.hasNext()) {
                    this.out.println("                " + (String)it.next());
                }
                break block4;
            }
        }
        if (this.actionAdditions.size() > 0) {
            it = this.actionAdditions.iterator();
            while (it.hasNext()) {
                this.out.println("  " + (String)it.next());
            }
        }
        if (this.advanceState) {
            this.out.println("  =goal>");
            this.out.println("    state " + ++this.state);
        }
        this.out.println(")\n");
        if (this.sppCommand != null) {
            this.out.print("(spp ");
            this.out.print(name);
            this.out.print(this.sppCommand);
            this.out.println(")");
            this.out.println();
        }
    }

    protected void setTarget(String target) {
        this.addProperty("target", target, true);
    }

    protected void setLispVarTarget(String target) {
        this.addProperty("target", target, false);
    }

    protected void setKey(char c) {
        this.addProperty("key", ToActr.encodeKey(c), false);
    }

    protected void setTextToSpeak(String text) {
        this.addProperty("text-to-speak", text, true);
    }

    protected void setDuration(double f) {
        this.addProperty("duration", Double.toString(f), false);
    }

    protected void setCurrentFrame(IFrame f) {
        this.addProperty("current-frame", f.getName(), true);
    }

    protected void setDestination(String dest) {
        this.addProperty("destination-frame", dest, true);
    }

    protected void singleClick(ActionScriptStep step, String target, boolean last) {
        this.prepareActrProduction(step);
        this.setTarget(target);
        this.setFree("preparation");
        this.sendCommand(":motor prepare punch :hand right :finger index");
        if (!last) {
            this.setNotLast();
        }
        this.emitActrProduction("prepare-click");
        this.prepareActrProduction(step);
        this.setTarget(target);
        this.addTrace("(clicking mouse " + this.stq(target) + ")");
        this.addActionBuffer("manual", "click-mouse", null);
        this.setNotLast();
        this.emitActrProduction("click-mouse");
    }

    public void visit(TextActionSegment step) {
        String cmd = step.getText();
        for (int i = 0; i < cmd.length(); ++i) {
            this.prepareActrProduction(step);
            char key = cmd.charAt(i);
            this.setKey(key);
            this.addTrace("(pressing key " + ToActr.encodeKey(key) + ")");
            this.addActionBuffer("manual", "press-key", "key " + ToActr.encodeKey(key));
            if (i < cmd.length() - 1) {
                this.setNotLast();
            }
            this.emitActrProduction("press-key");
        }
    }

    public void visit(ActionScriptStep step) {
        if (stubOutAction) {
            this.out.println("\n\n;;; ActionScriptStep stubbed out\n");
            return;
        }
        IAction action = step.getAction();
        ActionType type = action.getType();
        ITransitionSource source = step.getStepFocus();
        if (type.equals(ActionType.ButtonPress)) {
            MousePressType pt = ((IButtonAction)action).getPressType();
            boolean isDouble = pt.equals(MousePressType.Double);
            if (isDouble) {
                this.singleClick(step, source.getName(), false);
            }
            this.singleClick(step, source.getName(), true);
        } else if (type.equals(ActionType.MouseOver) || type.equals(ActionType.MoveMouse)) {
            IScriptStep peekStep;
            boolean tapIsNext = false;
            if (this.nextStep < this.stepCount && (peekStep = this.script.getScriptStep(this.nextStep)) instanceof ActionScriptStep) {
                IActionScriptStep peekActionStep = (IActionScriptStep)peekStep;
                boolean bl = tapIsNext = peekActionStep.getAction().getType() == ActionType.Tap;
            }
            if (tapIsNext) {
                this.actAsMoveAndTap = true;
            } else {
                String target = source.getName();
                this.prepareActrProduction(step);
                this.setTarget(target);
                this.addVisualBuffer(target, true);
                this.setFree(new String[]{"preparation", "execution", "modality"});
                this.addTrace("(pointing mouse at " + this.stq(target) + " [ =mouse-loc ])");
                this.addActionBuffer("manual", "move-cursor", "loc =mouse-loc");
                this.emitActrProduction("move-mouse");
            }
        } else if (type.equals(ActionType.KeyPress)) {
            String cmd = ((IKeyAction)action).getText();
            for (int i = 0; i < cmd.length(); ++i) {
                this.prepareActrProduction(step);
                char key = cmd.charAt(i);
                this.setKey(key);
                this.addTrace("(pressing key " + ToActr.encodeKey(key) + ")");
                this.addActionBuffer("manual", "press-key", "key " + ToActr.encodeKey(key));
                if (i < cmd.length() - 1) {
                    this.setNotLast();
                }
                this.emitActrProduction("press-key");
            }
        } else if (type.equals(ActionType.GraffitiStroke)) {
            String cmd = ((IGraffitiAction)action).getText();
            for (int i = 0; i < cmd.length(); ++i) {
                this.prepareActrProduction(step);
                char key = cmd.charAt(i);
                this.setKey(key);
                this.addTrace("(graffiti-gesture " + ToActr.encodeKey(key) + ")");
                this.addActionBuffer("manual", "graffiti-gesture", "key " + ToActr.encodeKey(key));
                if (i < cmd.length() - 1) {
                    this.setNotLast();
                }
                this.emitActrProduction("graffiti-gesture");
            }
        } else {
            if (type.equals(ActionType.Voice)) {
                throw new RcvrUnimplementedFnException("Voice is not currently supported.");
            }
            if (type.equals(ActionType.HomeKeyboard)) {
                this.prepareActrProduction(step);
                this.setLispVarTarget("keyboard");
                this.addTrace("(moving hand to keyboard)");
                this.addActionBuffer("manual", "hand-to-home", null);
                this.emitActrProduction("move-hand");
            } else if (type.equals(ActionType.HomeMouse)) {
                this.prepareActrProduction(step);
                this.setLispVarTarget("keyboard");
                this.addTrace("(moving hand to mouse)");
                this.addActionBuffer("manual", "hand-to-mouse", null);
                this.emitActrProduction("move-hand");
            } else if (type.equals(ActionType.Tap)) {
                this.singleTap(step, this.actAsMoveAndTap ? source.getName() : null, true);
            } else {
                throw new RcvrComputationException("An unexpected Action type " + type + " was associated with an ActionScriptStep. " + "Check the FSM.");
            }
        }
    }

    protected void singleTap(IScriptStep tss, String target, boolean last) {
        if (target != null) {
            this.prepareActrProduction(tss);
            this.setTarget(target);
            if (!last) {
                this.setNotLast();
            }
            this.addVisualBuffer(target, true);
            this.setFree(new String[]{"preparation", "execution", "modality"});
            this.addTrace("(pointing finger at " + this.stq(target) + " [ =mouse-loc ])");
            this.addActionBuffer("manual", "move-cursor", "loc =mouse-loc");
            this.emitActrProduction("move-mouse");
        } else {
            this.prepareActrProduction(tss);
            if (!last) {
                this.setNotLast();
            }
            this.setFree("preparation");
            this.sendCommand(":motor prepare punch :hand right :finger index");
            this.emitActrProduction("prepare-click");
            this.prepareActrProduction(tss);
            this.addTrace("(press button)");
            this.addActionBuffer("manual", "mouse-click", null);
            this.emitActrProduction("click-mouse");
        }
    }

    public void visit(TapScriptStep tss) {
        TapPressType tpt = ((ITapAction)tss.getAction()).getTapPressType();
        boolean isDouble = tpt == TapPressType.DoubleTap;
        String target = null;
        if (tss.getMoveRequired()) {
            ITransitionSource source = tss.getStepFocus();
            target = source.getName();
        }
        if (isDouble) {
            this.singleTap(tss, target, false);
            this.singleTap(tss, null, true);
        } else {
            this.singleTap(tss, target, true);
        }
    }

    public void visit(DelayScriptStep delayss) {
        this.prepareActrProduction(delayss);
        double t = delayss.getDelayDuration();
        this.setDuration(t);
        this.addEval("(set-cogtool-delay " + t + ")");
        this.addTrace("(waiting for system " + Math.max(0.0, t) + " seconds)");
        this.addSpp("effort", "0");
        this.emitActrProduction("wait-for-system");
    }

    public void visit(DriveScriptStep drivess) {
        throw new RcvrUnimplementedFnException("Driving is not currently supported.");
    }

    public void visit(LookAtScriptStep lass) {
        this.prepareActrProduction(lass);
        String target = lass.getLookAtTarget().getName();
        this.setTarget(target);
        this.addSpp("p", ".01");
        this.dontAdvanceState();
        this.setStateType("visual");
        this.addActionBuffer("visual-location", "visual-location", "value " + this.stq(target));
        this.addTrace("(finding " + this.stq(target) + ")");
        this.emitActrProduction("find");
        this.prepareActrProduction(lass);
        this.setTarget(target);
        this.setStateType("visual");
        this.addVisualBuffer(target, false);
        this.addTrace("(looking at " + this.stq(target) + " [ =visual-location ])");
        this.addActionBuffer("visual", "visual-object", "screen-pos =visual-location");
        this.emitActrProduction("look-at");
    }

    public void visit(ThinkScriptStep tss) {
        this.prepareActrProduction(tss);
        this.setDuration(tss.getThinkDuration());
        this.addSpp("effort", Double.toString(tss.getThinkDuration()));
        this.emitActrProduction("think");
    }
}

