/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.ToActr5ScriptStepVisitor;
import edu.cmu.cs.hcii.cogtool.model.ToActr6ScriptStepVisitor;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.RcvrComputationException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;

public class ToActr {
    public static final String ACT_R_VERSION = System.getProperty("edu.cmu.cs.hcii.cogtool.actr_version", "6");
    public static final String COGTOOL_MODULE_NAME = "COGTOOL";
    protected static final Pattern NEEDS_ESCAPE = Pattern.compile("[\\\\\"]");
    protected static final HashMap widgetTypeNames = new HashMap(12);

    private ToActr() {
    }

    public static String clean(String str) {
        return NEEDS_ESCAPE.matcher(str).replaceAll("\\\\$0");
    }

    public static String lispString(String str) {
        return "\"" + ToActr.clean(str) + "\"";
    }

    public static void design(IDesign d, IFrame startFrame, PrintWriter out) {
        out.println("(setq *cogtool-module-keyword* :COGTOOL)\n");
        out.println(";; ==== Design ====\n");
        out.println("(setq *cogtool-design* (make-instance 'cogtool-device :initial-frame-name " + ToActr.lispString(startFrame.getName()) + "))");
        out.println("\n(let ((frames (frames *cogtool-design*)) frame widget)");
        Iterator it = d.getFrames().iterator();
        while (it.hasNext()) {
            IFrame f = (IFrame)it.next();
            ToActr.frame(f, out);
            out.print("\n\n  (setf (gethash \"");
            out.print(ToActr.clean(f.getName()));
            out.println("\" frames) frame)\n");
        }
        out.println(") ; close (let... above\n");
    }

    public static void frame(IFrame f, PrintWriter out) {
        IInputDevice keyDevice = f.getInputDevice(DeviceType.Keyboard);
        IInputDevice voiceDevice = f.getInputDevice(DeviceType.Voice);
        out.println("\n  ;; ==== New Frame ====\n");
        out.print("  (setq frame (make-instance 'cogtool-frame :name \"");
        out.print(ToActr.clean(f.getName()));
        out.print("\"))");
        Iterator it = f.getWidgets().iterator();
        while (it.hasNext()) {
            IWidget widget = (IWidget)it.next();
            ToActr.widget(widget, out);
            out.print("  (push widget (widgets frame))");
        }
    }

    public static void widget(IWidget w, PrintWriter out) {
        out.print("\n\n  (setf widget (make-instance 'cogtool-widget :name \"");
        out.print(ToActr.clean(w.getName()));
        out.print("\" :title \"");
        out.println(ToActr.clean(w.getTitle()) + "\"");
        out.print("                              :x ");
        DoubleRectangle bounds = w.getShape().getBounds();
        out.print(bounds.getX());
        out.print(" :y ");
        out.print(bounds.getY());
        out.print(" :width ");
        out.print(bounds.getWidth());
        out.print(" :height ");
        out.println(bounds.getHeight());
        out.print("                              :wtype '");
        String wTypeName = (String)widgetTypeNames.get(w.getWidgetType());
        if (wTypeName == null) {
            throw new RcvrComputationException("Unknown widget type: " + w.getWidgetType().toString());
        }
        out.print(wTypeName);
        out.println("))");
    }

    public static String encodeKey(char val) {
        if ('0' <= val && val <= '9') {
            return Character.toString(val);
        }
        if ('a' <= val && val <= 'z') {
            return Character.toString(Character.toUpperCase(val));
        }
        if ('A' <= val && val <= 'Z') {
            return Character.toString(val);
        }
        switch (val) {
            case ' ': {
                return "space";
            }
            case ',': {
                return "comma";
            }
            case '.': {
                return "period";
            }
            case '/': {
                return "slash";
            }
            case ';': {
                return "semicolon";
            }
            case '\'': {
                return "quote";
            }
            case '`': {
                return "backquote";
            }
            case '-': {
                return "hyphen";
            }
            case '=': {
                return "hyphen";
            }
            case '\t': 
            case '\ue009': {
                return "tab";
            }
            case '[': {
                return "P";
            }
            case ']': {
                return "P";
            }
            case '\\': {
                return "backslash";
            }
            case '\n': 
            case '\r': 
            case '\ue007': {
                return "return";
            }
            case '\ue008': {
                return "Z";
            }
            case '\b': 
            case '\u007f': 
            case '\ue006': 
            case '\ue00a': {
                return "delete";
            }
            case '\ue005': {
                return "Q";
            }
            case '\ue000': 
            case '\ue001': 
            case '\ue002': 
            case '\ue003': 
            case '\ue004': {
                return "Z";
            }
        }
        throw new RcvrComputationException("Unsupported character: " + val);
    }

    public static void script(IScript script, PrintWriter out) {
        out.println(";; ==== Script ==== \n");
        if ("5".equals(ACT_R_VERSION)) {
            ToActr5ScriptStepVisitor visitor = new ToActr5ScriptStepVisitor(script, out);
            Iterator it = script.getScriptSteps().iterator();
            while (it.hasNext()) {
                IScriptStep step = (IScriptStep)it.next();
                step.accept(visitor);
                visitor.next();
            }
        } else if ("6".equals(ACT_R_VERSION)) {
            out.println("(define-cogtool-model\n");
            ToActr6ScriptStepVisitor visitor = new ToActr6ScriptStepVisitor(script, out);
            Iterator it = script.getScriptSteps().iterator();
            while (it.hasNext()) {
                IScriptStep step = (IScriptStep)it.next();
                step.accept(visitor);
                visitor.next();
            }
            out.println(")");
        } else {
            throw new RcvrComputationException("Unknown ACT-R version: " + ACT_R_VERSION);
        }
    }

    static {
        widgetTypeNames.put(WidgetType.Button, "cogtool-button");
        widgetTypeNames.put(WidgetType.Menu, "cogtool-menu");
        widgetTypeNames.put(WidgetType.Submenu, "cogtool-submenu");
        widgetTypeNames.put(WidgetType.MenuItem, "cogtool-menu-item");
        widgetTypeNames.put(WidgetType.TextBox, "cogtool-text-box");
        widgetTypeNames.put(WidgetType.Text, "cogtool-text");
        widgetTypeNames.put(WidgetType.PullDownList, "cogtool-pull-down-list");
        widgetTypeNames.put(WidgetType.PullDownItem, "cogtool-pull-down-item");
        widgetTypeNames.put(WidgetType.ListBoxItem, "cogtool-list-box-item");
        widgetTypeNames.put(WidgetType.Radio, "cogtool-radio-button");
        widgetTypeNames.put(WidgetType.Check, "cogtool-checkbox");
        widgetTypeNames.put(WidgetType.Graffiti, "cogtool-graffiti");
        widgetTypeNames.put(WidgetType.Noninteractive, "cogtool-non-interactive");
    }

    static interface IToActrScriptStepVisitor
    extends IScriptStep.IScriptStepVisitor {
        public void next();
    }
}

