/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IResultRevalidator;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.ResultRevalidator;
import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TaskApplication
extends GlobalAttributed
implements ITaskApplication {
    public static final int edu_cmu_cs_hcii_cogtool_model_TaskApplication_version = 0;
    protected static final String scriptsVAR = "scripts";
    protected static final String resultsVAR = "results";
    protected static final String invalidAlgorithmsVAR = "invalidAlgorithms";
    protected Map scripts = new HashMap();
    protected Map results = new HashMap();
    protected Map allValidators = new HashMap();
    private boolean loading = true;
    protected Set invalidAlgorithms = new HashSet(){

        public boolean add(Object arg0) {
            boolean changed = super.add(arg0);
            if (TaskApplication.this.loading) {
                TaskApplication.this.invalidateResult((IPredictionAlgo)arg0);
            }
            return changed;
        }
    };
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            TaskApplication v = (TaskApplication)value;
            saver.saveObject(v.scripts, TaskApplication.scriptsVAR);
            saver.saveObject(v.results, TaskApplication.resultsVAR);
            saver.saveObject(v.invalidAlgorithms, TaskApplication.invalidAlgorithmsVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new TaskApplication();
        }

        public Collection createCollection(Object target, String variable, int size) {
            if (variable != null && variable.equals(TaskApplication.invalidAlgorithmsVAR)) {
                return ((TaskApplication)target).invalidAlgorithms;
            }
            return null;
        }

        public Map createMap(Object target, String variable, int size) {
            if (variable != null) {
                if (variable.equals(TaskApplication.scriptsVAR)) {
                    return ((TaskApplication)target).scripts;
                }
                if (variable.equals(TaskApplication.resultsVAR)) {
                    return ((TaskApplication)target).results;
                }
            }
            return null;
        }

        public ObjectLoader.IAggregateLoader getLoader(String variable) {
            return super.getLoader(variable);
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(TaskApplication.class.getName(), SAVER);
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(TaskApplication.class.getName(), 0, LOADER);
    }

    public void setScript(IPredictionAlgo alg, IScript script) {
        this.scripts.put(alg, script);
    }

    public IScript getScript(IPredictionAlgo alg) {
        return (IScript)this.scripts.get(alg);
    }

    public Map getScripts() {
        return this.scripts;
    }

    public void setResult(IPredictionAlgo alg, Object result) {
        if (this.getScript(alg) == null) {
            throw new IllegalStateException("Can't set a result for a non-existent script!");
        }
        this.results.put(alg, result);
        IDesign design = this.getScript(alg).getDesign();
        design.raiseAlert(new ITaskApplication.TaskApplicationResultChange(design, this));
    }

    public IPredictionResult getResult(IPredictionAlgo alg) {
        if (this.getScript(alg) != null) {
            return (IPredictionResult)this.results.get(alg);
        }
        throw new IllegalStateException("Can't get a result for a non-existent script!");
    }

    public void clearAllScriptResults() {
        this.results.clear();
        this.scripts.clear();
    }

    public boolean isResultCurrent(IPredictionAlgo alg) {
        if (this.getScript(alg) != null) {
            Set validators = (Set)this.allValidators.get(alg);
            return validators == null || validators.isEmpty();
        }
        throw new IllegalStateException("Can't check the validity of the result for a non-existent script!");
    }

    public IResultRevalidator invalidateResult(IPredictionAlgo alg) {
        if (this.getScript(alg) != null) {
            ResultRevalidator validator = new ResultRevalidator(this.getResult(alg), this, alg);
            this.restoreValidator(validator);
            IDesign design = this.getScript(alg).getDesign();
            design.raiseAlert(new ITaskApplication.TaskApplicationResultChange(design, this));
            return validator;
        }
        throw new IllegalStateException("Can't invalidate the result for a non-existent script!");
    }

    public boolean restoreValidator(IResultRevalidator validator) {
        IPredictionAlgo alg = validator.getAlgo();
        if (this.getScript(alg) != null) {
            HashSet<IResultRevalidator> validators = (HashSet<IResultRevalidator>)this.allValidators.get(alg);
            boolean result = false;
            if (validators == null) {
                result = true;
                validators = new HashSet<IResultRevalidator>();
                this.allValidators.put(alg, validators);
            }
            result = validators.add(validator);
            this.loading = false;
            this.invalidAlgorithms.add(alg);
            if (validators.size() == 1) {
                IDesign design = this.getScript(alg).getDesign();
                design.raiseAlert(new ITaskApplication.TaskApplicationResultChange(design, this));
            }
            return result;
        }
        throw new IllegalStateException("Can't invalidate the result for a non-existent script!");
    }

    public boolean removeValidator(IResultRevalidator validator) {
        IPredictionAlgo alg = validator.getAlgo();
        if (this.getScript(alg) != null) {
            Set validators = (Set)this.allValidators.get(alg);
            if (validators != null) {
                boolean result = validators.remove(validator);
                if (validators.isEmpty()) {
                    this.invalidAlgorithms.remove(alg);
                    IDesign design = this.getScript(alg).getDesign();
                    design.raiseAlert(new ITaskApplication.TaskApplicationResultChange(design, this));
                }
                return result;
            }
            return false;
        }
        throw new IllegalStateException("Can't revalidate the result for a non-existent script!");
    }

    public void toggleValidator(IResultRevalidator validator) {
        IPredictionAlgo alg = validator.getAlgo();
        if (this.getScript(alg) != null) {
            if (!this.removeValidator(validator)) {
                this.restoreValidator(validator);
            }
        } else {
            throw new IllegalStateException("Can't revalidate the result for a non-existent script!");
        }
    }

    public IResultRevalidator[] recalculate(IPredictionAlgo alg) {
        if (this.getScript(alg) != null) {
            IScript script = this.getScript(alg);
            this.setResult(alg, alg.computePrediction(script));
            IResultRevalidator[] validators = this.clearValidators(alg);
            IDesign design = script.getDesign();
            design.raiseAlert(new ITaskApplication.TaskApplicationResultChange(design, this));
            return validators;
        }
        throw new IllegalStateException("Can't recalculate the result for a non-existent script!");
    }

    public IResultRevalidator[][] recalculateAll() {
        Iterator algoScripts = this.scripts.entrySet().iterator();
        IDesign design = null;
        LinkedList<IResultRevalidator[]> validators = new LinkedList<IResultRevalidator[]>();
        LinkedList<ResultRevalidator> newResults = new LinkedList<ResultRevalidator>();
        while (algoScripts.hasNext()) {
            Map.Entry algoScript = algoScripts.next();
            IPredictionAlgo alg = (IPredictionAlgo)algoScript.getKey();
            IScript script = (IScript)algoScript.getValue();
            design = script.getDesign();
            validators.add(this.clearValidators(alg));
            this.setResult(alg, alg.computePrediction(script));
            newResults.add(new ResultRevalidator(this.getResult(alg), this, alg));
        }
        IResultRevalidator[] newResArray = newResults.toArray(new IResultRevalidator[newResults.size()]);
        validators.addFirst(newResArray);
        design.raiseAlert(new ITaskApplication.TaskApplicationResultChange(design, this));
        return (IResultRevalidator[][])validators.toArray((T[])new IResultRevalidator[validators.size()][]);
    }

    protected IResultRevalidator[] clearValidators(IPredictionAlgo alg) {
        this.invalidAlgorithms.remove(alg);
        Set validators = (Set)this.allValidators.get(alg);
        if (validators != null) {
            IResultRevalidator[] retval = validators.toArray(new IResultRevalidator[validators.size()]);
            validators.clear();
            return retval;
        }
        return new IResultRevalidator[0];
    }
}

