/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ACTR5TraceParser;
import edu.cmu.cs.hcii.cogtool.model.ACTR6TraceParser;
import edu.cmu.cs.hcii.cogtool.model.APredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.AResult;
import edu.cmu.cs.hcii.cogtool.model.CORETraceParser;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITraceParser;
import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import edu.cmu.cs.hcii.cogtool.model.ToActr;
import edu.cmu.cs.hcii.cogtool.model.ToIRG;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.RcvrComputationException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOTempException;
import edu.cmu.cs.hcii.cogtool.util.Subprocess;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class StandaloneAlgo
extends APredictionAlgo {
    public static final int edu_cmu_cs_hcii_cogtool_model_StandaloneAlgo_version = 0;
    public static final int TIMEOUT = 600;
    public static final String ACT_R_DEBUG = System.getProperty("edu.cmu.cs.hcii.cogtool.actr_debug", "0");
    public static final StandaloneAlgo ONLY = new StandaloneAlgo();
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return ONLY;
        }
    };
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult;

    public static void registerSaver() {
        ObjectSaver.registerSaver(StandaloneAlgo.class.getName(), SAVER);
        StandaloneResult.registerSaver();
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(StandaloneAlgo.class.getName(), 0, LOADER);
        StandaloneResult.registerLoader();
    }

    public Object computePrediction(IScript script) {
        String alg = System.getProperty("cogtool.algorithm");
        if (alg != null && alg.equals("CORE")) {
            return this.computeCorePrediction(script);
        }
        return this.computeACTRPrediction(script);
    }

    public static void copyResourceToFile(String resourceId, File dst) throws IOException {
        int len;
        InputStream in = ClassLoader.getSystemResourceAsStream(resourceId);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public Object computeCorePrediction(IScript script) {
        String[] resultParts;
        File dataFile;
        PrintWriter out = null;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
            tempDir = tempDir + System.getProperty("file.separator");
        }
        File irgFile = new File(tempDir + "cogtool_irg.pl");
        File cascadeFile = new File(tempDir + "cogtool.klm.CASCADE.pl");
        try {
            StandaloneAlgo.copyResourceToFile("edu/cmu/cs/hcii/cogtool/resources/cogtool.klm.CASCADE.PL", cascadeFile);
        }
        catch (IOException e) {
            throw new RcvrIOTempException("Error in copying required core files: " + e.getMessage(), e);
        }
        ToIRG irgCreator = new ToIRG();
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(irgFile)));
            irgCreator.createIRG(script, script.getDesign(), out);
            out.close();
            out = null;
        }
        catch (Exception e) {
            throw new RcvrIOTempException("Error in generating core IRG inputs: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        File curDir = new File(tempDir);
        String corePath = System.getProperty("cogtool.corepath");
        if (corePath == null) {
            throw new RcvrComputationException("Core path not set correctly");
        }
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(corePath + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "core");
        cmds.add("cogtool_irg.pl");
        ArrayList<String> envp = new ArrayList<String>();
        envp.add("COREDIR=" + corePath);
        envp.add("PROLOGMAXSIZE=786M");
        envp.add("PATH=$PATH:/usr/local/bin");
        LinkedList traceLines = new LinkedList();
        LinkedList errorLines = new LinkedList();
        Subprocess.exec(cmds, envp, curDir, traceLines, errorLines);
        String lastGoodLine = null;
        LinkedList<String> outputLines = new LinkedList<String>();
        try {
            String line;
            dataFile = new File(tempDir + "example_output.csv");
            BufferedReader resultReader = new BufferedReader(new FileReader(dataFile));
            while ((line = resultReader.readLine()) != null) {
                String[] stepComponents;
                outputLines.add(line);
                if ((line = line.trim()).length() <= 0 || (stepComponents = line.split(",")).length <= 7) continue;
                lastGoodLine = line;
            }
        }
        catch (FileNotFoundException e) {
            throw new RcvrIOTempException("Error in parsing core output: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RcvrIOTempException("Error in parsing core output: " + e.getMessage(), e);
        }
        cascadeFile.delete();
        irgFile.delete();
        dataFile.delete();
        if (lastGoodLine != null && (resultParts = lastGoodLine.split(",")).length > 3) {
            double taskTime;
            try {
                taskTime = (Double.parseDouble(resultParts[1]) + Double.parseDouble(resultParts[2])) / 1000.0;
            }
            catch (NumberFormatException e) {
                return new StandaloneResult(traceLines, errorLines);
            }
            CORETraceParser parser = new CORETraceParser();
            List steps = parser.parseTrace(outputLines);
            return new StandaloneResult(steps, taskTime, outputLines, errorLines);
        }
        return new StandaloneResult(traceLines, errorLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object computeACTRPrediction(IScript script) {
        File actrFile = null;
        try {
            actrFile = File.createTempFile("cogtool-actr-model-", ".lisp");
            actrFile.deleteOnExit();
            PrintWriter out = null;
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(actrFile)));
                out.println(";; === For ACT-R " + ToActr.ACT_R_VERSION + " ====\n");
                ToActr.design(script.getDesign(), script.getStartFrame(), out);
                ToActr.script(script, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new RcvrIOTempException("IOException writing temp file", e);
        }
        File sourceDir = new File("lisp", "cogtool-actr" + ToActr.ACT_R_VERSION);
        Object[] fileArray = sourceDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".lisp") && !name.startsWith(".");
            }
        });
        ArrayList<Object> files = null;
        if (fileArray != null) {
            Arrays.sort(fileArray);
            files = new ArrayList<Object>(fileArray.length);
            for (int i = 0; i < fileArray.length; ++i) {
                files.add(fileArray[i]);
            }
        }
        String cmd = "(cogtool-run-model " + (script.getHandStartsOnMouse() ? "t " : "nil ") + 600 + " " + ACT_R_DEBUG + " \"" + ToActr.clean(actrFile.getAbsolutePath()) + "\")";
        LinkedList traceLines = new LinkedList();
        LinkedList errorLines = new LinkedList();
        Subprocess.execLisp("actr" + ToActr.ACT_R_VERSION + ".mem", files, cmd, traceLines, errorLines);
        if (traceLines.size() > 0) {
            try {
                double taskTime = Double.parseDouble((String)traceLines.getLast());
                ITraceParser parser = Integer.parseInt(ToActr.ACT_R_VERSION) == 6 ? new ACTR6TraceParser() : new ACTR5TraceParser();
                List rSteps = parser.parseTrace(traceLines);
                return new StandaloneResult(rSteps, taskTime, traceLines, errorLines);
            }
            catch (NumberFormatException e) {
                System.out.println("Can't parse a result from the ACT-R trace");
                return new StandaloneResult(traceLines, errorLines);
            }
        }
        System.out.println("There is no ACT-R output");
        return new StandaloneResult(traceLines, errorLines);
    }

    public void accept(IPredictionAlgo.IPredictionAlgoVisitor visitor) {
        visitor.visit(this);
    }

    public static class StandaloneResult
    extends AResult {
        public static final int edu_cmu_cs_hcii_cogtool_model_StandaloneAlgo$StandaloneResult_version = 0;
        protected static final String taskTimeVAR = "taskTime";
        protected static final String traceLinesVAR = "traceLines";
        protected static final String errorLinesVAR = "errorLines";
        protected static final String modelStepsVAR = "modelSteps";
        protected double taskTime = -1.0;
        protected List traceLines;
        protected List errorLines;
        protected List modelSteps;
        private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

            public int getVersion() {
                return 0;
            }

            public void saveData(Object value, ObjectSaver saver) throws IOException {
                StandaloneResult v = (StandaloneResult)value;
                saver.saveDouble(v.taskTime, "taskTime");
                saver.saveObject(v.traceLines, "traceLines");
                saver.saveObject(v.errorLines, "errorLines");
                saver.saveObject(v.modelSteps, "modelSteps");
            }
        };
        private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

            public Object createObject() {
                return new StandaloneResult();
            }

            public void set(Object target, String variable, Object value) {
                if (variable != null) {
                    if (variable.equals("traceLines")) {
                        ((StandaloneResult)target).traceLines = (LinkedList)value;
                    } else if (variable.equals("errorLines")) {
                        ((StandaloneResult)target).errorLines = (LinkedList)value;
                    }
                }
            }

            public void set(Object target, String variable, double value) {
                if (variable != null && variable.equals("taskTime")) {
                    ((StandaloneResult)target).taskTime = value;
                }
            }

            public Collection createCollection(Object target, String variable, int size) {
                if (variable != null) {
                    if (variable.equals("traceLines")) {
                        ((StandaloneResult)target).traceLines = new LinkedList<E>();
                        return ((StandaloneResult)target).traceLines;
                    }
                    if (variable.equals("errorLines")) {
                        ((StandaloneResult)target).errorLines = new LinkedList<E>();
                        return ((StandaloneResult)target).errorLines;
                    }
                    if (variable.equals("modelSteps")) {
                        ((StandaloneResult)target).modelSteps = new ArrayList<E>();
                        return ((StandaloneResult)target).modelSteps;
                    }
                }
                return null;
            }
        };

        public static void registerSaver() {
            ObjectSaver.registerSaver((class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult == null ? (class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult = StandaloneAlgo.class$("edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo$StandaloneResult")) : class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult).getName(), SAVER);
            ResultStep.registerSaver();
        }

        public static void registerLoader() {
            ObjectLoader.registerLoader((class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult == null ? (class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult = StandaloneAlgo.class$("edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo$StandaloneResult")) : class$edu$cmu$cs$hcii$cogtool$model$StandaloneAlgo$StandaloneResult).getName(), 0, LOADER);
            ResultStep.registerLoader();
        }

        public StandaloneResult(List modelSteps, double taskTime, LinkedList traceLines, LinkedList errorLines) {
            this.taskTime = taskTime;
            this.traceLines = traceLines;
            this.errorLines = errorLines;
            this.modelSteps = modelSteps;
        }

        public StandaloneResult(double taskTime, LinkedList traceLines, LinkedList errorLines) {
            this.taskTime = taskTime;
            this.traceLines = traceLines;
            this.errorLines = errorLines;
            this.modelSteps = new ArrayList();
        }

        public StandaloneResult(LinkedList traceLines, LinkedList errorLines) {
            this.traceLines = traceLines;
            this.errorLines = errorLines;
            this.modelSteps = new ArrayList();
        }

        public StandaloneResult() {
            this.modelSteps = new ArrayList();
        }

        public double getTaskTime() {
            return this.taskTime;
        }

        public List getTraceLines() {
            return this.traceLines;
        }

        public List getErrorLines() {
            return this.errorLines;
        }

        public List getModelSteps() {
            return this.modelSteps;
        }

        public void accept(IPredictionResult.IPredictionResultVisitor visitor) {
            visitor.visit(this);
        }
    }
}

