/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.HomeKeyboardAction;
import edu.cmu.cs.hcii.cogtool.model.HomeMouseAction;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IButtonAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IGraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IKeyAction;
import edu.cmu.cs.hcii.cogtool.model.ILookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IMenuItem;
import edu.cmu.cs.hcii.cogtool.model.IMenuWidget;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IScriptStepGeneration;
import edu.cmu.cs.hcii.cogtool.model.ITapAction;
import edu.cmu.cs.hcii.cogtool.model.IThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MoveMouseAction;
import edu.cmu.cs.hcii.cogtool.model.TapScriptStep;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.model.ThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.RcvrCogModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class ScriptStepGenerationFSM
implements IScriptStepGeneration {
    protected static final int INITIAL_STATE = 0;
    protected static final int MENU_HEADER_STATE = 1;
    protected static final int SUBMENU_STATE = 2;
    protected static final int MENU_ITEM_STATE = 3;
    protected static final int CLICKABLE_OBJECT_STATE = 4;
    protected static final int TEXTBOX_FIELD_STATE = 5;
    protected static final int PULLDOWN_LIST_STATE = 6;
    protected static final int PULLDOWN_ITEM_STATE = 7;
    protected static final int LISTBOX_ITEM_STATE = 8;
    protected static final int KEYSTROKE_STATE = 9;
    protected static final int ENTER_KEY_STATE = 10;
    protected static final int GRAFFITI_COMMAND_STATE = 11;
    protected static final int FREEFORM_GRAFFITI_STATE = 12;
    protected static final int SPEECH_STATE = 13;
    protected static final int TEXT_FIELD_STATE = 14;
    protected int currentState = 0;
    protected boolean handIsOnMouse = true;
    protected IWidget previousWidget;
    protected IWidget cursorWidget;
    protected IWidget lookAtWidget;
    protected IScriptStepGeneration.IScriptStepState initialState = this.getState();
    public static HashSet COMPLETE_TERMINATOR_LIST = new HashSet();
    public static HashSet CANCEL_TERMINATOR_LIST;
    protected boolean isRightHandedUser = true;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState;

    protected void convertToKLM(char c, StringBuffer segment) {
        if (Character.isUpperCase(c)) {
            segment.append('\ue000');
            segment.append(Character.toLowerCase(c));
        } else {
            switch (c) {
                case '~': {
                    segment.append('\ue000');
                    segment.append('`');
                    break;
                }
                case '!': {
                    segment.append('\ue000');
                    segment.append('1');
                    break;
                }
                case '@': {
                    segment.append('\ue000');
                    segment.append('2');
                    break;
                }
                case '#': {
                    segment.append('\ue000');
                    segment.append('3');
                    break;
                }
                case '$': {
                    segment.append('\ue000');
                    segment.append('4');
                    break;
                }
                case '%': {
                    segment.append('\ue000');
                    segment.append('5');
                    break;
                }
                case '^': {
                    segment.append('\ue000');
                    segment.append('6');
                    break;
                }
                case '&': {
                    segment.append('\ue000');
                    segment.append('7');
                    break;
                }
                case '*': {
                    segment.append('\ue000');
                    segment.append('8');
                    break;
                }
                case '(': {
                    segment.append('\ue000');
                    segment.append('9');
                    break;
                }
                case ')': {
                    segment.append('\ue000');
                    segment.append('0');
                    break;
                }
                case '_': {
                    segment.append('\ue000');
                    segment.append('-');
                    break;
                }
                case '+': {
                    segment.append('\ue000');
                    segment.append('=');
                    break;
                }
                case ':': {
                    segment.append('\ue000');
                    segment.append(';');
                    break;
                }
                case '\"': {
                    segment.append('\ue000');
                    segment.append('\'');
                    break;
                }
                case '{': {
                    segment.append('\ue000');
                    segment.append('[');
                    break;
                }
                case '}': {
                    segment.append('\ue000');
                    segment.append(']');
                    break;
                }
                case '|': {
                    segment.append('\ue000');
                    segment.append('\\');
                    break;
                }
                case '<': {
                    segment.append('\ue000');
                    segment.append(',');
                    break;
                }
                case '>': {
                    segment.append('\ue000');
                    segment.append('.');
                    break;
                }
                case '?': {
                    segment.append('\ue000');
                    segment.append('/');
                    break;
                }
                default: {
                    segment.append(c);
                }
            }
        }
    }

    protected void handleKeyInput(IKeyAction ka, ITransitionSource source, IFrame currentFrame, ArrayList productionList) {
        char[] keys = ka.getText().toCharArray();
        int returnKey = 10;
        if (ka.isCommand()) {
            this.think(currentFrame, productionList);
            this.currentState = 10;
        }
        int homeHandIndex = productionList.size();
        StringBuffer segment = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            switch (this.currentState) {
                case 10: {
                    if (this.isCommandKey(keys[i])) {
                        this.currentState = 10;
                        break;
                    }
                    this.currentState = 9;
                    break;
                }
                default: {
                    if (this.isCommandKey(keys[i])) {
                        if (segment.length() > 0) {
                            this.flushTextSegment(ka, source, currentFrame, segment, productionList, false);
                        }
                        this.think(currentFrame, productionList);
                        this.currentState = 10;
                        break;
                    }
                    this.currentState = 9;
                }
            }
            this.convertToKLM(keys[i], segment);
            this.produceKeySubstate(keys[i], source, currentFrame, productionList, homeHandIndex);
        }
        this.flushTextSegment(ka, source, currentFrame, segment, productionList, true);
    }

    protected void flushTextSegment(IKeyAction ka, ITransitionSource source, IFrame currentFrame, StringBuffer segment, ArrayList productionList, boolean isLastSegment) {
        ITransition transition;
        TextActionSegment step = isLastSegment ? ((transition = source.getTransition(ka)) != null ? new TextActionSegment(transition, segment.toString(), this.getState(), ka.getPressType().toString()) : new TextActionSegment(ka, source, currentFrame, segment.toString(), this.getState(), ka.getPressType().toString())) : new TextActionSegment(ka, source, currentFrame, segment.toString(), this.getState(), ka.getPressType().toString());
        segment.setLength(0);
        productionList.add(step);
    }

    public ArrayList produceScriptSteps(IScriptStep ss, IFrame currentFrame) {
        ArrayList<IScriptStep> productionList = new ArrayList<IScriptStep>();
        if (ss instanceof ILookAtScriptStep) {
            this.think(currentFrame, productionList);
            productionList.add(ss);
            ss.setResultState(this.getState());
        } else {
            productionList.add(ss);
            ss.setResultState(this.getState());
        }
        return productionList;
    }

    public ArrayList produceDeviceScriptSteps(IAction action, ITransitionSource device, IFrame currentFrame) {
        ArrayList productionList = new ArrayList();
        boolean performEpsilon = true;
        switch (this.currentState) {
            case 0: {
                IKeyAction ka;
                if (action.getType() == ActionType.KeyPress) {
                    ka = (IKeyAction)action;
                    if (ka.getText() == "MENU-KEY") {
                        this.think(currentFrame, productionList);
                        this.produceSubstate(action, device, currentFrame, productionList);
                        this.userAction(ka, device, currentFrame, productionList);
                        this.currentState = 1;
                        performEpsilon = false;
                        break;
                    }
                    this.handleKeyInput(ka, device, currentFrame, productionList);
                    performEpsilon = false;
                    break;
                }
                if (action.getType() != ActionType.Voice) break;
                this.userAction(action, device, currentFrame, productionList);
                performEpsilon = false;
                break;
            }
            case 9: {
                if (!(action instanceof IKeyAction)) break;
                IKeyAction ka = (IKeyAction)action;
                this.handleKeyInput(ka, device, currentFrame, productionList);
                performEpsilon = false;
                break;
            }
            case 10: {
                if (!(action instanceof IKeyAction)) break;
                IKeyAction ka = (IKeyAction)action;
                this.handleKeyInput(ka, device, currentFrame, productionList);
                performEpsilon = false;
                break;
            }
        }
        if (performEpsilon) {
            if (this.currentState != 0) {
                this.currentState = 0;
                productionList.addAll(this.produceDeviceScriptSteps(action, device, currentFrame));
            } else {
                throw new RcvrCogModelException("You have hit something which the FSM does not support. See external documentation.\n\nTheir is no transition for " + action.getLocalizedString());
            }
        }
        IScriptStep ss = (IScriptStep)productionList.get(productionList.size() - 1);
        ss.setResultState(this.getState());
        return productionList;
    }

    protected void produceMenuSteps(IAction action, IMenuWidget widget, IFrame currentFrame, ArrayList productionList) {
        if (widget instanceof IMenuItem) {
            this.produceMenuSteps(action, ((IMenuItem)widget).getParent(), currentFrame, productionList);
            if (action.getType() == ActionType.MouseOver) {
                this.lookAtHoverMouse(action, widget, currentFrame, productionList);
            } else {
                this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                this.userAction(action, widget, currentFrame, productionList);
            }
            this.currentState = 2;
        } else {
            if (action.getType() == ActionType.Tap) {
                this.produceSubstate(action, widget, currentFrame, productionList);
                this.think(currentFrame, productionList);
                this.lookAt(widget, currentFrame, productionList);
                this.userMoveTAPAction((ITapAction)action, widget, currentFrame, productionList);
            } else if (action.getType() == ActionType.ButtonPress) {
                this.thinkLookAtMoveMouseClick(action, widget, currentFrame, productionList);
            } else if (action.getType() == ActionType.MouseOver) {
                this.think(currentFrame, productionList);
                this.lookAtHoverMouse(action, widget, currentFrame, productionList);
            }
            this.currentState = 1;
        }
        this.previousWidget = widget;
    }

    protected void produceItemSteps(IAction action, IMenuItem widget, IFrame currentFrame, ArrayList productionList) {
        this.produceMenuSteps(action, widget.getParent(), currentFrame, productionList);
        if (action.getType() == ActionType.MouseOver) {
            this.lookAtHoverMouse(action, widget, currentFrame, productionList);
        } else {
            this.lookAtMoveMouse(action, widget, currentFrame, productionList);
            this.userAction(action, widget, currentFrame, productionList);
        }
        this.previousWidget = widget;
        this.currentState = 3;
    }

    public ArrayList produceScriptSteps(IAction action, IWidget widget, IFrame currentFrame) {
        ArrayList productionList = new ArrayList();
        boolean performEpsilon = true;
        switch (this.currentState) {
            case 0: {
                IGraffitiAction ga;
                ITapAction ta;
                if (action.getType() == ActionType.MouseOver) {
                    if (widget.getWidgetType() == WidgetType.Menu) {
                        this.think(currentFrame, productionList);
                        this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 1;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Button || widget.getWidgetType() == WidgetType.Check || widget.getWidgetType() == WidgetType.Radio || widget.getWidgetType() == WidgetType.TextBox || widget.getWidgetType() == WidgetType.Text) {
                        this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (!(widget instanceof IMenuItem)) break;
                    this.produceItemSteps(action, (IMenuItem)widget, currentFrame, productionList);
                    performEpsilon = false;
                    break;
                }
                if (action instanceof IButtonAction && action.getType() == ActionType.ButtonPress && ((IButtonAction)action).getButton() == MouseButtonState.Right) {
                    this.thinkLookAtMoveMouseClick(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 1;
                    performEpsilon = false;
                    break;
                }
                if (action.getType() == ActionType.ButtonPress) {
                    if (widget.getWidgetType() == WidgetType.Menu) {
                        this.thinkLookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 1;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Button) {
                        this.thinkLookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Check || widget.getWidgetType() == WidgetType.Radio) {
                        this.lookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.TextBox) {
                        this.thinkLookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 5;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Text) {
                        this.lookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 14;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.PullDownList) {
                        this.lookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 6;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.ListBoxItem) {
                        this.lookAtMoveMouseClick(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 8;
                        performEpsilon = false;
                        break;
                    }
                    if (!(widget instanceof IMenuItem)) break;
                    this.produceItemSteps(action, (IMenuItem)widget, currentFrame, productionList);
                    performEpsilon = false;
                    break;
                }
                if (action.getType() == ActionType.Tap) {
                    ta = (ITapAction)action;
                    if (widget.getWidgetType() == WidgetType.Menu) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.think(currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 1;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Button) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.think(currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Check || widget.getWidgetType() == WidgetType.Radio) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.TextBox) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.think(currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 5;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.Text) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 14;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.PullDownList) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 6;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.ListBoxItem) {
                        this.produceSubstate(ta, widget, currentFrame, productionList);
                        this.lookAt(widget, currentFrame, productionList);
                        this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 8;
                        performEpsilon = false;
                        break;
                    }
                    if (!(widget instanceof IMenuItem)) break;
                    this.produceItemSteps(action, (IMenuItem)widget, currentFrame, productionList);
                    performEpsilon = false;
                    break;
                }
                if (action.getType() == ActionType.GraffitiStroke) {
                    ga = (IGraffitiAction)action;
                    if (ga.isCommand()) {
                        this.thinkLookAtMoveMouse(ga, widget, currentFrame, productionList);
                        this.userAction(ga, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 11;
                        performEpsilon = false;
                        break;
                    }
                    this.lookAtMoveMouse(ga, widget, currentFrame, productionList);
                    this.userAction(ga, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 12;
                    performEpsilon = false;
                    break;
                }
                if (action.getType() != ActionType.KeyPress && action.getType() != ActionType.Voice) break;
                productionList.addAll(this.produceDeviceScriptSteps(action, widget, currentFrame));
                performEpsilon = false;
                break;
            }
            case 1: {
                if (action.getType() == ActionType.MouseOver) {
                    if (widget == this.previousWidget) {
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() == WidgetType.MenuItem) {
                        this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 3;
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() != WidgetType.Submenu) break;
                    this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 2;
                    performEpsilon = false;
                    break;
                }
                if (action.getType() != ActionType.ButtonPress && action.getType() != ActionType.Tap) break;
                if (widget == this.previousWidget) {
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 1;
                    performEpsilon = false;
                    break;
                }
                if (widget.getWidgetType() == WidgetType.MenuItem) {
                    this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 3;
                    performEpsilon = false;
                    break;
                }
                if (widget.getWidgetType() != WidgetType.Submenu) break;
                this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                this.userAction(action, widget, currentFrame, productionList);
                this.previousWidget = widget;
                this.currentState = 2;
                performEpsilon = false;
                break;
            }
            case 2: {
                if (action.getType() == ActionType.MouseOver) {
                    if (widget == this.previousWidget) {
                        performEpsilon = false;
                    } else if (widget.getWidgetType() == WidgetType.MenuItem) {
                        this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 3;
                        performEpsilon = false;
                    } else if (widget.getWidgetType() == WidgetType.Submenu) {
                        this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 3;
                        performEpsilon = false;
                    }
                }
                if (action.getType() != ActionType.ButtonPress && action.getType() != ActionType.Tap) break;
                if (widget == this.previousWidget) {
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 2;
                    performEpsilon = false;
                    break;
                }
                if (widget.getWidgetType() == WidgetType.MenuItem) {
                    this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 3;
                    performEpsilon = false;
                    break;
                }
                if (widget.getWidgetType() != WidgetType.Submenu) break;
                this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                this.userAction(action, widget, currentFrame, productionList);
                this.previousWidget = widget;
                this.currentState = 2;
                performEpsilon = false;
                break;
            }
            case 3: {
                if (action.getType() == ActionType.MouseOver) {
                    if (widget == this.previousWidget) {
                        performEpsilon = false;
                        break;
                    }
                    if (widget.getWidgetType() != WidgetType.MenuItem) break;
                    this.lookAtHoverMouse(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 3;
                    performEpsilon = false;
                    break;
                }
                if (action.getType() != ActionType.ButtonPress && action.getType() != ActionType.Tap) break;
                if (widget == this.previousWidget) {
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 3;
                    performEpsilon = false;
                    break;
                }
                if (widget instanceof IMenuItem) {
                    this.produceItemSteps(action, (IMenuItem)widget, currentFrame, productionList);
                    performEpsilon = false;
                    break;
                }
                if (widget.getWidgetType() != WidgetType.MenuItem) break;
                this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                this.userAction(action, widget, currentFrame, productionList);
                this.previousWidget = widget;
                this.currentState = 3;
                performEpsilon = false;
                break;
            }
            case 4: {
                if (action.getType() == ActionType.MouseOver) {
                    if (!widget.isIdentical(this.previousWidget)) break;
                    performEpsilon = false;
                    break;
                }
                if (action.getType() == ActionType.ButtonPress) {
                    if (widget.isIdentical(this.previousWidget)) {
                        this.userAction(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (COMPLETE_TERMINATOR_LIST.contains(widget.getName().toLowerCase()) && COMPLETE_TERMINATOR_LIST.contains(this.previousWidget.getName().toLowerCase())) {
                        this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                        this.userAction(action, widget, currentFrame, productionList);
                        this.previousWidget = widget;
                        this.currentState = 4;
                        performEpsilon = false;
                        break;
                    }
                    if (!CANCEL_TERMINATOR_LIST.contains(widget.getName().toLowerCase()) || !CANCEL_TERMINATOR_LIST.contains(this.previousWidget.getName().toLowerCase())) break;
                    this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 4;
                    performEpsilon = false;
                    break;
                }
                if (action.getType() != ActionType.Tap) break;
                ITapAction ta = (ITapAction)action;
                if (widget.isIdentical(this.previousWidget)) {
                    this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 4;
                    performEpsilon = false;
                    break;
                }
                if (COMPLETE_TERMINATOR_LIST.contains(widget.getName().toLowerCase()) && COMPLETE_TERMINATOR_LIST.contains(this.previousWidget.getName().toLowerCase())) {
                    this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                    this.userAction(action, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 4;
                    performEpsilon = false;
                    break;
                }
                if (!CANCEL_TERMINATOR_LIST.contains(widget.getName().toLowerCase()) || !CANCEL_TERMINATOR_LIST.contains(this.previousWidget.getName().toLowerCase())) break;
                this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                this.userAction(action, widget, currentFrame, productionList);
                this.previousWidget = widget;
                this.currentState = 4;
                performEpsilon = false;
                break;
            }
            case 5: {
                break;
            }
            case 14: {
                break;
            }
            case 6: {
                ITapAction ta;
                if (action.getType() != ActionType.ButtonPress && action.getType() != ActionType.Tap || widget.getWidgetType() != WidgetType.PullDownItem) break;
                if (action.getType() == ActionType.Tap) {
                    ta = (ITapAction)action;
                    this.produceSubstate(ta, widget, currentFrame, productionList);
                    this.lookAt(widget, currentFrame, productionList);
                    this.userMoveTAPAction(ta, widget, currentFrame, productionList);
                } else {
                    this.lookAtMoveMouse(action, widget, currentFrame, productionList);
                    this.userAction(action, widget, currentFrame, productionList);
                }
                this.previousWidget = widget;
                this.currentState = 7;
                performEpsilon = false;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 11: {
                if (action.getType() != ActionType.GraffitiStroke || !widget.isIdentical(this.previousWidget)) break;
                IGraffitiAction ga = (IGraffitiAction)action;
                if (ga.isCommand()) {
                    this.think(currentFrame, productionList);
                    this.userAction(ga, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 11;
                    performEpsilon = false;
                    break;
                }
                this.userAction(ga, widget, currentFrame, productionList);
                this.previousWidget = widget;
                this.currentState = 12;
                performEpsilon = false;
                break;
            }
            case 12: {
                if (action.getType() != ActionType.GraffitiStroke || !widget.isIdentical(this.previousWidget)) break;
                IGraffitiAction ga = (IGraffitiAction)action;
                if (ga.isCommand()) {
                    this.think(currentFrame, productionList);
                    this.userAction(ga, widget, currentFrame, productionList);
                    this.previousWidget = widget;
                    this.currentState = 11;
                    performEpsilon = false;
                    break;
                }
                this.userAction(ga, widget, currentFrame, productionList);
                this.previousWidget = widget;
                this.currentState = 12;
                performEpsilon = false;
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            default: {
                System.out.println("UNKNOWN STATE in FSM");
                throw new RcvrCogModelException("CurrentState " + this.currentState + " is an unknown state.");
            }
        }
        if (performEpsilon) {
            if (this.currentState != 0) {
                this.currentState = 0;
                productionList.addAll(this.produceScriptSteps(action, widget, currentFrame));
            } else {
                throw new RcvrCogModelException("You have hit something which the FSM does not support. See external documentation.\n\nThere is no transition for " + action.getLocalizedString() + " and " + widget.getName() + " and type");
            }
        }
        if (productionList.size() > 0) {
            IScriptStep ss = (IScriptStep)productionList.get(productionList.size() - 1);
            ss.setResultState(this.getState());
        }
        return productionList;
    }

    public void updateState(IScriptStep scriptStep) {
        if (scriptStep instanceof ILookAtScriptStep) {
            ILookAtScriptStep lookat = (ILookAtScriptStep)scriptStep;
            this.lookAtWidget = lookat.getLookAtTarget();
        }
        scriptStep.setResultState(this.getState());
    }

    public IScriptStepGeneration.IScriptStepState getInitialState() {
        return this.initialState;
    }

    protected void userMoveTAPAction(ITapAction tap, IWidget widget, IFrame currentFrame, ArrayList productionList) {
        boolean moveMouse = false;
        moveMouse = !widget.sameLocation(this.previousWidget);
        productionList.add(new TapScriptStep(tap, widget, currentFrame, this.getState(), moveMouse, true));
    }

    protected void userAction(IAction action, ITransitionSource source, IFrame currentFrame, ArrayList productionList) {
        if (action instanceof IButtonAction) {
            StringBuffer segment = new StringBuffer();
            int modifiers = ((IButtonAction)action).getModifiers();
            if ((modifiers & 1) != 0) {
                segment.append('\ue000');
            }
            if ((modifiers & 2) != 0) {
                segment.append('\ue001');
            }
            if ((modifiers & 4) != 0) {
                segment.append('\ue002');
            }
            if ((modifiers & 8) != 0) {
                segment.append('\ue003');
            }
            if ((modifiers & 0x10) != 0) {
                segment.append('\ue004');
            }
            if (segment.length() > 0) {
                productionList.add(new TextActionSegment(action, source, currentFrame, segment.toString(), this.getState(), KeyPressType.Stroke.toString()));
            }
        }
        productionList.add(new ActionScriptStep(action, source, currentFrame, this.getState(), true));
    }

    protected void think(IFrame currentFrame, ArrayList productionList) {
        if (productionList.isEmpty() || !(productionList.get(productionList.size() - 1) instanceof IThinkScriptStep)) {
            productionList.add(new ThinkScriptStep(currentFrame, this.getState(), false));
        }
    }

    protected void lookAt(IWidget widget, IFrame currentFrame, ArrayList productionList) {
        if (!widget.sameLocation(this.lookAtWidget)) {
            this.lookAtWidget = widget;
            productionList.add(new LookAtScriptStep(currentFrame, widget, this.getState(), false));
        }
    }

    protected void moveMouse(IWidget widget, IFrame currentFrame, ArrayList productionList) {
        if (!widget.sameLocation(this.cursorWidget)) {
            this.cursorWidget = widget;
            productionList.add(new ActionScriptStep(new MoveMouseAction(), widget, currentFrame, this.getState(), false));
        }
    }

    protected void lookAtHoverMouse(IAction hover, IWidget widget, IFrame currentFrame, ArrayList productionList) {
        this.produceSubstate(hover, widget, currentFrame, productionList);
        this.lookAt(widget, currentFrame, productionList);
        if (!widget.sameLocation(this.cursorWidget)) {
            this.cursorWidget = widget;
            productionList.add(new ActionScriptStep(hover, widget, currentFrame, this.getState(), true));
        }
    }

    protected void homeMouse(ITransitionSource source, IFrame currentFrame, ArrayList productionList) {
        this.handIsOnMouse = true;
        productionList.add(new ActionScriptStep(new HomeMouseAction(), source, currentFrame, this.getState(), false));
    }

    protected void homeKeyboard(ITransitionSource source, IFrame currentFrame, ArrayList productionList, int atIndex) {
        this.handIsOnMouse = false;
        productionList.add(atIndex, new ActionScriptStep(new HomeKeyboardAction(), source, currentFrame, this.getState(), false));
    }

    protected void lookAtMoveMouse(IAction action, IWidget widget, IFrame currentFrame, ArrayList productionList) {
        this.produceSubstate(action, widget, currentFrame, productionList);
        this.lookAt(widget, currentFrame, productionList);
        this.moveMouse(widget, currentFrame, productionList);
    }

    protected void thinkLookAtMoveMouse(IAction action, IWidget widget, IFrame currentFrame, ArrayList productionList) {
        this.produceSubstate(action, widget, currentFrame, productionList);
        this.think(currentFrame, productionList);
        this.lookAtMoveMouse(action, widget, currentFrame, productionList);
    }

    protected void thinkLookAtMoveMouseClick(IAction action, IWidget widget, IFrame currentFrame, ArrayList productionList) {
        this.thinkLookAtMoveMouse(action, widget, currentFrame, productionList);
        this.userAction(action, widget, currentFrame, productionList);
    }

    protected void lookAtMoveMouseClick(IAction action, IWidget widget, IFrame currentFrame, ArrayList productionList) {
        this.lookAtMoveMouse(action, widget, currentFrame, productionList);
        this.userAction(action, widget, currentFrame, productionList);
    }

    protected void produceKeySubstate(char key, ITransitionSource source, IFrame currentFrame, ArrayList productionList, int atIndex) {
        if (this.handIsOnMouse) {
            if (this.isRightHandedUser && this.isRightHand(key)) {
                this.handIsOnMouse = false;
                this.homeKeyboard(source, currentFrame, productionList, atIndex);
            } else if (!this.isRightHandedUser && this.isLeftHand(key)) {
                this.handIsOnMouse = false;
                this.homeKeyboard(source, currentFrame, productionList, atIndex);
            }
        }
    }

    protected void produceSubstate(IAction action, ITransitionSource source, IFrame currentFrame, ArrayList productionList) {
        if (this.handIsOnMouse) {
            if (action instanceof IKeyAction) {
                IKeyAction ka = (IKeyAction)action;
                this.produceKeySubstate(ka.getText().charAt(0), source, currentFrame, productionList, productionList.size());
            }
        } else if (action.getType() == ActionType.ButtonPress || action.getType() == ActionType.MouseOver || action.getType() == ActionType.MoveMouse || action.getType() == ActionType.Tap || action.getType() == ActionType.GraffitiStroke) {
            this.handIsOnMouse = true;
            this.homeMouse(source, currentFrame, productionList);
        }
    }

    protected void produceSingleKey(IKeyAction ka, ITransitionSource source, IFrame currentFrame, ArrayList productionList) {
        this.produceSubstate(ka, source, currentFrame, productionList);
        this.addShiftKey(ka.getText().charAt(0), ka, source, currentFrame, productionList);
        KeyAction subAction = new KeyAction();
        subAction.setText(ka.getText().substring(0, 1));
        subAction.setModifiers(ka.getModifiers());
        subAction.setPressType(ka.getPressType());
        this.userAction(subAction, source, currentFrame, productionList);
    }

    protected void addShiftKey(char key, IKeyAction ka, ITransitionSource source, IFrame currentFrame, ArrayList productionList) {
        if (this.isShifted(key)) {
            // empty if block
        }
    }

    protected boolean isCommandKey(char ch) {
        return ch == '\ue007' || ch == '\ue005' || ch == '\ue009' || ch == '\ue006' || ch == '\ue00a' || ch == '\ue008' || ch == '\ue000' || ch == '\ue001' || ch == '\ue002' || ch == '\ue003' || ch == '\ue004';
    }

    protected boolean isRightHand(char ch) {
        return ch == '6' || ch == '^' || ch == '7' || ch == '&' || ch == '8' || ch == '*' || ch == '9' || ch == '(' || ch == ')' || ch == '0' || ch == 'y' || ch == 'Y' || ch == 'u' || ch == 'u' || ch == 'i' || ch == 'I' || ch == 'o' || ch == 'O' || ch == 'p' || ch == 'P' || ch == '[' || ch == '{' || ch == ']' || ch == '}' || ch == '\\' || ch == '|' || ch == 'h' || ch == 'H' || ch == 'j' || ch == 'J' || ch == 'k' || ch == 'K' || ch == 'l' || ch == 'L' || ch == ';' || ch == ':' || ch == '\'' || ch == '\"' || ch == 'n' || ch == 'N' || ch == 'm' || ch == 'M' || ch == ',' || ch == '<' || ch == '.' || ch == '>' || ch == '/' || ch == '?' || ch == '-' || ch == '_' || ch == '=' || ch == '+' || ch == '\ue006' || ch == '\ue007' || ch == '\ue00a';
    }

    protected boolean isLeftHand(char ch) {
        return !this.isRightHand(ch);
    }

    protected boolean isShifted(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch == '~' || ch == '!' || ch == '@' || ch == '#' || ch == '$' || ch == '%' || ch == '^' || ch == '&' || ch == '*' || ch == '(' || ch == ')' || ch == '_' || ch == '+' || ch == '{' || ch == '}' || ch == ':' || ch == '\"' || ch == '<' || ch == '>' || ch == '?';
    }

    public IScriptStepGeneration.IScriptStepState getState() {
        return new ScriptStepState(this.currentState, this.handIsOnMouse, this.previousWidget, this.cursorWidget, this.lookAtWidget);
    }

    public void setState(IScriptStepGeneration.IScriptStepState state) throws UnsupportedOperationException {
        if (!(state instanceof ScriptStepState)) {
            throw new UnsupportedOperationException("ScriptStepGeneration did not get a ScriptStepState object");
        }
        ScriptStepState scriptState = (ScriptStepState)state;
        this.currentState = scriptState.currentState;
        this.handIsOnMouse = scriptState.handIsOnMouse;
        this.previousWidget = scriptState.previousWidget;
        this.cursorWidget = scriptState.cursorWidget;
        this.lookAtWidget = scriptState.lookAtWidget;
    }

    public void setInitialState(IWidget cursorWidget, IWidget lookAtWidget, boolean isHandOnMouse) {
        this.initialState = new ScriptStepState(0, isHandOnMouse, null, cursorWidget, lookAtWidget);
    }

    static {
        COMPLETE_TERMINATOR_LIST.add("save");
        COMPLETE_TERMINATOR_LIST.add("yes");
        COMPLETE_TERMINATOR_LIST.add("done");
        COMPLETE_TERMINATOR_LIST.add("ok");
        CANCEL_TERMINATOR_LIST = new HashSet();
        CANCEL_TERMINATOR_LIST.add("cancel");
        CANCEL_TERMINATOR_LIST.add("no");
        CANCEL_TERMINATOR_LIST.add("exit");
        CANCEL_TERMINATOR_LIST.add("abort");
    }

    public static class ScriptStepState
    implements IScriptStepGeneration.IScriptStepState {
        public static final int edu_cmu_cs_hcii_cogtool_model_ScriptStepState_version = 0;
        protected static final String currentStateVAR = "currentState";
        protected static final String handIsOnMouseVAR = "handIsOnMouse";
        protected static final String previousWidgetVAR = "previousWidget";
        protected static final String cursorWidgetVAR = "cursorWidget";
        protected static final String lookAtWidgetVAR = "lookAtWidget";
        public int currentState;
        public boolean handIsOnMouse;
        public IWidget previousWidget;
        public IWidget cursorWidget;
        public IWidget lookAtWidget;
        private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

            public int getVersion() {
                return 0;
            }

            public void saveData(Object value, ObjectSaver saver) throws IOException {
                ScriptStepState sss = (ScriptStepState)value;
                saver.saveInt(sss.currentState, "currentState");
                saver.saveBoolean(sss.handIsOnMouse, "handIsOnMouse");
                saver.saveObject(sss.previousWidget, "previousWidget");
                saver.saveObject(sss.cursorWidget, "cursorWidget");
                saver.saveObject(sss.lookAtWidget, "lookAtWidget");
            }
        };
        private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

            public Object createObject() {
                return new ScriptStepState();
            }

            public void set(Object target, String variable, Object value) {
                if (variable != null) {
                    if (variable.equals("previousWidget")) {
                        ((ScriptStepState)target).previousWidget = (IWidget)value;
                    } else if (variable.equals("cursorWidget")) {
                        ((ScriptStepState)target).cursorWidget = (IWidget)value;
                    } else if (variable.equals("lookAtWidget")) {
                        ((ScriptStepState)target).lookAtWidget = (IWidget)value;
                    }
                }
            }

            public void set(Object target, String variable, int value) {
                if (variable != null && variable.equals("currentState")) {
                    ((ScriptStepState)target).currentState = value;
                }
            }

            public void set(Object target, String variable, boolean value) {
                if (variable != null && variable.equals("handIsOnMouse")) {
                    ((ScriptStepState)target).handIsOnMouse = value;
                }
            }
        };

        private ScriptStepState() {
        }

        private int getCurrentState() {
            return this.currentState;
        }

        public boolean getHandIsOnMouse() {
            return this.handIsOnMouse;
        }

        public IWidget getPreviousWidget() {
            return this.previousWidget;
        }

        public IWidget getCursorWidget() {
            return this.cursorWidget;
        }

        public IWidget getLookAtWidget() {
            return this.lookAtWidget;
        }

        private void setCurrentState(int s) {
            this.currentState = s;
        }

        private void setHandIsOnMouse(boolean m) {
            this.handIsOnMouse = m;
        }

        private void setPreviousWidget(IWidget w) {
            this.previousWidget = w;
        }

        private void setCursorWidget(IWidget w) {
            this.cursorWidget = w;
        }

        public static void registerSaver() {
            ObjectSaver.registerSaver((class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState == null ? (class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState = ScriptStepGenerationFSM.class$("edu.cmu.cs.hcii.cogtool.model.ScriptStepGenerationFSM$ScriptStepState")) : class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState).getName(), SAVER);
        }

        public static void registerLoader() {
            ObjectLoader.registerLoader((class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState == null ? (class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState = ScriptStepGenerationFSM.class$("edu.cmu.cs.hcii.cogtool.model.ScriptStepGenerationFSM$ScriptStepState")) : class$edu$cmu$cs$hcii$cogtool$model$ScriptStepGenerationFSM$ScriptStepState).getName(), 0, LOADER);
        }

        public ScriptStepState(int current, boolean onMouse, IWidget prevWidget, IWidget cursWidget, IWidget lookWidget) {
            this.currentState = current;
            this.handIsOnMouse = onMouse;
            this.previousWidget = prevWidget;
            this.cursorWidget = cursWidget;
            this.lookAtWidget = lookWidget;
        }
    }
}

