/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.IActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.ILookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IScriptStepGeneration;
import edu.cmu.cs.hcii.cogtool.model.IThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ScriptStepGenerationFSM;
import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Script
extends GlobalAttributed
implements IScript {
    public static final int edu_cmu_cs_hcii_cogtool_model_Script_version = 1;
    protected static final String designVAR = "design";
    protected static final String startFrameVAR = "startFrame";
    protected static final String scriptStepsVAR = "scriptSteps";
    protected static final String handStartsOnMouseVAR = "handStartsOnMouse";
    protected IDesign design;
    protected IFrame startFrame;
    protected List scriptSteps;
    protected boolean handStartsOnMouse = true;
    protected IScriptStepGeneration stepGenerator = new ScriptStepGenerationFSM();
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 1;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            Script v = (Script)value;
            saver.saveObject(v.design, Script.designVAR);
            saver.saveObject(v.startFrame, Script.startFrameVAR);
            saver.saveObject(v.scriptSteps, Script.scriptStepsVAR);
            saver.saveBoolean(v.handStartsOnMouse, Script.handStartsOnMouseVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new Script();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(Script.designVAR)) {
                    ((Script)target).design = (IDesign)value;
                } else if (variable.equals(Script.startFrameVAR)) {
                    ((Script)target).startFrame = (IFrame)value;
                }
            }
        }

        public Collection createCollection(Object target, String variable, int size) {
            if (variable != null && variable.equals(Script.scriptStepsVAR)) {
                ((Script)target).scriptSteps = new ArrayList();
                return ((Script)target).scriptSteps;
            }
            return null;
        }

        public void set(Object target, String variable, boolean value) {
            if (variable != null && variable.equals(Script.handStartsOnMouseVAR)) {
                ((Script)target).handStartsOnMouse = value;
            }
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(Script.class.getName(), SAVER);
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(Script.class.getName(), 0, LOADER);
        ObjectLoader.registerLoader(Script.class.getName(), 1, LOADER);
    }

    public Script(IDesign d) {
        if (d == null) {
            throw new IllegalArgumentException("Design for Script cannot be null or empty!");
        }
        this.design = d;
        this.scriptSteps = new ArrayList();
    }

    protected Script() {
    }

    public IDesign getDesign() {
        return this.design;
    }

    public void setDesign(IDesign d) {
        if (d == null) {
            throw new IllegalArgumentException("Design for Script cannot be null!");
        }
        if (d != this.design) {
            this.design = d;
        }
    }

    public IFrame getStartFrame() {
        return this.startFrame;
    }

    public void setStartFrame(IFrame f) {
        if (f != this.startFrame) {
            this.startFrame = f;
            if (!this.scriptSteps.isEmpty()) {
                throw new IllegalStateException("Performing a setStartFrame on a scriptwith a non empty list will bring you to an unexpected state");
            }
        }
    }

    public boolean getHandStartsOnMouse() {
        return this.handStartsOnMouse;
    }

    public void setHandStartsOnMouse(boolean handOnMouse) {
        this.handStartsOnMouse = handOnMouse;
        this.stepGenerator.setInitialState(null, null, handOnMouse);
        this.rebuildScript(true);
    }

    public List getScriptSteps() {
        return this.scriptSteps;
    }

    protected void setScriptSteps(List scriptSteps) {
        this.scriptSteps = scriptSteps;
    }

    public IScriptStep getScriptStep(int index) {
        return (IScriptStep)this.scriptSteps.get(index);
    }

    public void addScriptStep(int index, IScriptStep newStep) {
        this.scriptSteps.add(index, newStep);
        this.raiseAlert(new IScript.ScriptStepChange(this, newStep, index, 0));
    }

    public void addScriptSteps(int index, ArrayList newSteps) {
        this.scriptSteps.addAll(index, newSteps);
        this.raiseAlert(new IScript.ScriptStepChange(this, newSteps, index + newSteps.size(), 3));
    }

    public void addScriptStepsBeforeScriptStep(IScriptStep selectedStep, ArrayList newSteps) {
        int index = this.scriptSteps.indexOf(selectedStep);
        if (index == -1) {
            throw new InvalidParameterException("selectedStep is not in list");
        }
        this.addScriptSteps(index, newSteps);
    }

    public void addScriptStepsAfterScriptStep(IScriptStep selectedStep, ArrayList newSteps) {
        int index = this.scriptSteps.indexOf(selectedStep);
        if (index == -1) {
            throw new InvalidParameterException("selectedStep is not in list");
        }
        this.addScriptSteps(index + 1, newSteps);
    }

    public void addScriptSteps(ArrayList listItems) {
        this.addScriptSteps(this.scriptSteps.size(), listItems);
    }

    public void addScriptStep(IScriptStep newStep) {
        this.addScriptStep(this.scriptSteps.size(), newStep);
    }

    public void removeScriptSteps(ArrayList listItems) {
        IScriptStep lastSS = (IScriptStep)listItems.get(listItems.size() - 1);
        int lastIndex = this.scriptSteps.indexOf(lastSS);
        this.scriptSteps.removeAll(listItems);
        this.raiseAlert(new IScript.ScriptStepChange(this, listItems, lastIndex, 4));
    }

    protected IScriptStep silentRemoveScriptStep(int index) {
        return (IScriptStep)this.scriptSteps.remove(index);
    }

    public IScriptStep removeScriptStep(int index) {
        IScriptStep removedStep = this.silentRemoveScriptStep(index);
        this.raiseAlert(new IScript.ScriptStepChange(this, removedStep, index, 1));
        return removedStep;
    }

    public IScriptStep removeScriptStep(IScriptStep stepToRemove) {
        int index = this.scriptSteps.indexOf(stepToRemove);
        return this.removeScriptStep(index);
    }

    public ArrayList removeAllSubsequentScriptSteps(IScriptStep ss) {
        int index = this.scriptSteps.indexOf(ss);
        ArrayList<IScriptStep> deletedItems = new ArrayList<IScriptStep>();
        for (int i = this.scriptSteps.size() - 1; i > index; --i) {
            IScriptStep removed = this.silentRemoveScriptStep(i);
            deletedItems.add(0, removed);
        }
        this.raiseAlert(new IScript.ScriptStepChange(this, deletedItems, index + 1, 4));
        return deletedItems;
    }

    public boolean replaceScriptStep(IScriptStep oldStep, IScriptStep newStep) {
        int indexOld = this.scriptSteps.indexOf(oldStep);
        if (indexOld == -1) {
            return false;
        }
        this.silentRemoveScriptStep(indexOld);
        this.addScriptStep(indexOld, newStep);
        return true;
    }

    public ArrayList removeScriptStepAndAllSubsequent(IScriptStep stepToRemove) {
        int index = this.scriptSteps.indexOf(stepToRemove);
        ArrayList<IScriptStep> deletedItems = new ArrayList<IScriptStep>();
        for (int i = this.scriptSteps.size() - 1; i >= index; --i) {
            IScriptStep ss = this.silentRemoveScriptStep(i);
            deletedItems.add(0, ss);
        }
        this.raiseAlert(new IScript.ScriptStepChange(this, deletedItems, index, 4));
        return deletedItems;
    }

    protected boolean isSimpleChange(int index) {
        if (index == -1) {
            throw new InvalidParameterException("Passed ScriptStep is not in list");
        }
        return index == this.scriptSteps.size() - 1;
    }

    public boolean isSimpleGroupAdd(ArrayList exsistingSteps, ArrayList newSteps, boolean insertBefore) {
        if (exsistingSteps.size() <= 0) {
            return true;
        }
        IScriptStep inListFirst = (IScriptStep)exsistingSteps.get(0);
        IScriptStep inListLast = (IScriptStep)exsistingSteps.get(exsistingSteps.size() - 1);
        IScriptStep newFirst = (IScriptStep)newSteps.get(0);
        IScriptStep newLast = (IScriptStep)newSteps.get(newSteps.size() - 1);
        int insertIndexFirst = this.scriptSteps.indexOf(inListFirst);
        int insertIndexLast = this.scriptSteps.indexOf(inListLast);
        if (!insertBefore && this.isSimpleChange(insertIndexLast)) {
            return true;
        }
        if (insertBefore && inListFirst.getDestinationFrame().equals(newFirst.getCurrentFrame())) {
            return inListLast.getCurrentFrame().equals(newFirst.getCurrentFrame());
        }
        if (inListLast.getDestinationFrame().equals(newLast.getCurrentFrame())) {
            return newLast.getDestinationFrame().equals(inListLast.getDestinationFrame());
        }
        return false;
    }

    public boolean isSimpleGroupReplace(ArrayList replaceSteps, ArrayList newSteps) {
        if (replaceSteps.size() <= 0) {
            return true;
        }
        IScriptStep replaceFirst = (IScriptStep)replaceSteps.get(0);
        IScriptStep replaceLast = (IScriptStep)replaceSteps.get(replaceSteps.size() - 1);
        IScriptStep newFirst = (IScriptStep)newSteps.get(0);
        IScriptStep newLast = (IScriptStep)newSteps.get(newSteps.size() - 1);
        if (!this.scriptSteps.contains(replaceFirst) || !this.scriptSteps.contains(replaceLast)) {
            return false;
        }
        if (newLast.getDestinationFrame().equals(replaceLast.getDestinationFrame())) {
            return replaceFirst.getCurrentFrame().equals(newFirst.getCurrentFrame());
        }
        return false;
    }

    public boolean isSimpleGroupDelete(ArrayList ss) {
        if (ss.size() <= 0) {
            return true;
        }
        IScriptStep listFirst = (IScriptStep)ss.get(0);
        IScriptStep listLast = (IScriptStep)ss.get(ss.size() - 1);
        int indexFirst = this.scriptSteps.indexOf(listFirst);
        int indexLast = this.scriptSteps.indexOf(listLast);
        int nextIndex = indexLast + 1;
        int previousIndex = indexFirst - 1;
        IScriptStep next = null;
        IScriptStep prev = null;
        if (nextIndex >= this.scriptSteps.size()) {
            return true;
        }
        next = this.getScriptStep(nextIndex);
        if (previousIndex >= 0) {
            prev = this.getScriptStep(previousIndex);
        }
        if (prev != null) {
            return prev.getDestinationFrame().equals(next.getCurrentFrame());
        }
        return listFirst.getCurrentFrame().equals(next.getCurrentFrame()) && listLast.getCurrentFrame().equals(next.getCurrentFrame());
    }

    public IFrame getSourceFrame(IScriptStep scriptStep) {
        IFrame result = null;
        while (result == null) {
            IScriptStep ss = this.getPreviousStep(scriptStep);
            if (ss == null) {
                result = this.startFrame;
                continue;
            }
            result = ss.getDestinationFrame();
        }
        return result;
    }

    public IFrame getResult() {
        int index = this.scriptSteps.size() - 1;
        if (index < 0) {
            return this.startFrame;
        }
        IFrame result = null;
        while (result == null) {
            if (index < 0) {
                result = this.startFrame;
            } else {
                IScriptStep ss = (IScriptStep)this.scriptSteps.get(index);
                result = ss.getDestinationFrame();
            }
            --index;
        }
        return result;
    }

    public IScriptStep getNextStep(IScriptStep scriptStep) {
        int index = this.scriptSteps.indexOf(scriptStep);
        if (++index == this.scriptSteps.size()) {
            return null;
        }
        return (IScriptStep)this.scriptSteps.get(index);
    }

    public IScriptStep getPreviousStep(IScriptStep scriptStep) {
        int index = this.scriptSteps.indexOf(scriptStep);
        if (--index < 0) {
            return null;
        }
        return (IScriptStep)this.scriptSteps.get(index);
    }

    public IScriptStep getLastStep() {
        if (this.scriptSteps.size() <= 0) {
            return null;
        }
        return (IScriptStep)this.scriptSteps.get(this.scriptSteps.size() - 1);
    }

    public ArrayList getScriptStepGroup(IScriptStep ss) {
        IScriptStep checkSS;
        int i;
        ArrayList<IScriptStep> result = new ArrayList<IScriptStep>();
        if (ss.getInsertedByUser() && !ss.isParentScriptStep()) {
            result.add(ss);
            return result;
        }
        if (ss instanceof IThinkScriptStep) {
            result.add(ss);
            return result;
        }
        for (i = this.scriptSteps.indexOf(ss) - 1; !(i < 0 || (checkSS = this.getScriptStep(i)).getInsertedByUser() && checkSS.isParentScriptStep()); --i) {
            result.add(0, checkSS);
        }
        for (i = this.scriptSteps.indexOf(ss); i < this.scriptSteps.size(); ++i) {
            checkSS = this.getScriptStep(i);
            if (checkSS.getInsertedByUser() && checkSS instanceof IActionScriptStep) {
                result.add(checkSS);
                break;
            }
            result.add(checkSS);
        }
        return result;
    }

    public boolean usesFrame(IFrame frame) {
        if (this.getStartFrame() == frame) {
            return true;
        }
        Iterator steps = this.getScriptSteps().iterator();
        while (steps.hasNext()) {
            IScriptStep step = (IScriptStep)steps.next();
            if (!step.usesFrame(frame)) continue;
            return true;
        }
        return false;
    }

    public boolean usesWidget(IWidget widget) {
        Iterator steps = this.getScriptSteps().iterator();
        while (steps.hasNext()) {
            IScriptStep step = (IScriptStep)steps.next();
            if (!step.usesWidget(widget)) continue;
            return true;
        }
        return false;
    }

    public boolean usesTransition(ITransition transition) {
        Iterator steps = this.getScriptSteps().iterator();
        while (steps.hasNext()) {
            IScriptStep step = (IScriptStep)steps.next();
            if (!step.usesTransition(transition)) continue;
            return true;
        }
        return false;
    }

    public IScriptStepGeneration getScriptGenerator() {
        return this.stepGenerator;
    }

    public int getScriptStepIndex(IScriptStep ss) {
        return this.scriptSteps.indexOf(ss);
    }

    public void rebuildScript(boolean stopOnSynchronized) {
        ArrayList<IScriptStep> newScriptSteps = new ArrayList<IScriptStep>();
        Iterator iter = this.scriptSteps.iterator();
        boolean broken = false;
        boolean addAllRemaining = false;
        IFrame destination = null;
        this.stepGenerator.setState(this.stepGenerator.getInitialState());
        while (iter.hasNext()) {
            IScriptStep step = (IScriptStep)iter.next();
            if (addAllRemaining) {
                if (broken && step.getInsertedByUser()) {
                    step.setValidScriptStep(!broken);
                    newScriptSteps.add(step);
                    continue;
                }
                newScriptSteps.add(step);
                continue;
            }
            if (!(destination == null || destination == step.getCurrentFrame() && destination.getName().equals(step.getCurrentFrame().getName()))) {
                broken = true;
            } else if (step.getInsertedByUser()) {
                IFrame currentFrame = null;
                currentFrame = destination != null ? destination : step.getCurrentFrame();
                if (!this.design.getFrames().contains(currentFrame)) {
                    currentFrame = this.design.getFrame(currentFrame.getName());
                }
                if (currentFrame == null) {
                    broken = true;
                } else if (step instanceof IActionScriptStep) {
                    ITransition t;
                    IActionScriptStep astep = (IActionScriptStep)step;
                    ITransitionSource source = astep.getStepFocus();
                    if (source instanceof IInputDevice) {
                        if (!astep.getCurrentFrame().getInputDevices().contains(source)) {
                            IInputDevice iDevice = (IInputDevice)source;
                            source = currentFrame.getInputDevice(iDevice.getDeviceType());
                        }
                        if (source != null) {
                            t = source.getTransition(astep.getAction());
                            if (t != null) {
                                destination = t.getDestination();
                                newScriptSteps.addAll(this.stepGenerator.produceDeviceScriptSteps(astep.getAction(), source, astep.getCurrentFrame()));
                            } else {
                                broken = true;
                            }
                        } else {
                            broken = true;
                        }
                    } else {
                        if (!currentFrame.getWidgets().contains(source)) {
                            IWidget w = (IWidget)source;
                            source = currentFrame.getWidget(w.getName());
                        }
                        if (source != null) {
                            t = source.getTransition(astep.getAction());
                            if (t != null) {
                                destination = t.getDestination();
                                newScriptSteps.addAll(this.stepGenerator.produceScriptSteps(astep.getAction(), (IWidget)source, astep.getCurrentFrame()));
                            } else {
                                broken = true;
                            }
                        } else {
                            broken = true;
                        }
                    }
                } else {
                    if (step instanceof ILookAtScriptStep) {
                        LookAtScriptStep lookat = (LookAtScriptStep)step;
                        IWidget target = lookat.getLookAtTarget();
                        if (!step.getCurrentFrame().getWidgets().contains(target)) {
                            target = step.getCurrentFrame().getWidget(target.getName());
                        }
                        if (target == null) {
                            broken = true;
                        } else {
                            lookat.lookAtTarget = target;
                        }
                    }
                    newScriptSteps.addAll(this.stepGenerator.produceScriptSteps(step, step.getCurrentFrame()));
                }
            }
            if (broken) {
                step.setValidScriptStep(false);
                newScriptSteps.add(step);
                System.out.println("BROKEN " + step.getStepLocalizedString());
                addAllRemaining = true;
                continue;
            }
            if (!stopOnSynchronized || newScriptSteps.size() <= 0 || !step.equals(newScriptSteps.get(newScriptSteps.size() - 1))) continue;
            addAllRemaining = true;
        }
        this.setScriptSteps(newScriptSteps);
        this.raiseAlert(new IScript.ScriptStepChange(this, newScriptSteps, newScriptSteps.size(), 3));
    }

    public IScript duplicate() {
        Script copy = new Script(this.design);
        copy.setStartFrame(this.startFrame);
        copy.setHandStartsOnMouse(this.handStartsOnMouse);
        int numSteps = this.scriptSteps.size();
        for (int i = 0; i < numSteps; ++i) {
            copy.addScriptStep(this.getScriptStep(i).duplicate());
        }
        return copy;
    }
}

