/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IResultRevalidator;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.RandomGUID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Project
extends GlobalAttributed
implements IProject {
    public static final int edu_cmu_cs_hcii_cogtool_model_Project_version = 0;
    protected static final String nameVAR = "name";
    protected static final String designsVAR = "designs";
    protected static final String undertakingsVAR = "undertakings";
    protected static final String taskApplicationsVAR = "taskApplications";
    protected static final String buildVersionVAR = "buildVersion";
    protected static final String uuidVAR = "uuid";
    protected String name;
    protected List designs = new ArrayList();
    protected List undertakings = new ArrayList();
    protected Map taskApplications = new HashMap();
    protected String buildVersion = NOT_YET_SAVED;
    protected String uuid = Project.createUUID();
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            Project v = (Project)value;
            saver.saveString(v.name, Project.nameVAR);
            saver.saveObject(v.designs, Project.designsVAR);
            saver.saveObject(v.undertakings, Project.undertakingsVAR);
            saver.saveObject(v.taskApplications, Project.taskApplicationsVAR);
            saver.saveObject(v.buildVersion, Project.buildVersionVAR);
            saver.saveObject(v.uuid, Project.uuidVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new Project();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(Project.nameVAR)) {
                    ((Project)target).name = (String)value;
                }
                if (variable.equals(Project.buildVersionVAR)) {
                    ((Project)target).buildVersion = (String)value;
                }
                if (variable.equals(Project.uuidVAR)) {
                    ((Project)target).uuid = (String)value;
                }
            }
        }

        public Collection createCollection(Object target, String variable, int size) {
            if (variable != null) {
                if (variable.equals(Project.designsVAR)) {
                    return ((Project)target).designs;
                }
                if (variable.equals(Project.undertakingsVAR)) {
                    return ((Project)target).undertakings;
                }
            }
            return null;
        }

        public Map createMap(Object target, String variable, int size) {
            if (variable != null && variable.equals(Project.taskApplicationsVAR)) {
                return ((Project)target).taskApplications;
            }
            return null;
        }
    };
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign;

    public static void registerSaver() {
        ObjectSaver.registerSaver(Project.class.getName(), SAVER);
        TaskDesign.registerSaver();
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(Project.class.getName(), 0, LOADER);
        TaskDesign.registerLoader();
    }

    public Project(String nm) {
        if (nm == null || nm.equals("")) {
            throw new IllegalArgumentException("Project name cannot be null or empty!");
        }
        this.name = nm;
    }

    protected Project() {
        this.buildVersion = "";
    }

    protected static String createUUID() {
        RandomGUID uuidGen = new RandomGUID(true);
        return uuidGen.toString();
    }

    public void setBuildVersion(String version) {
        this.buildVersion = version;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null || newName.equals("")) {
            throw new IllegalArgumentException("Project name cannot be null or empty!");
        }
        this.name = newName;
        this.raiseAlert(new NameChangeAlert(this));
    }

    public List getDesigns() {
        return this.designs;
    }

    public IDesign getDesign(String designName) {
        Iterator designIterator = this.designs.iterator();
        while (designIterator.hasNext()) {
            IDesign testDesign = (IDesign)designIterator.next();
            if (!testDesign.getName().equals(designName)) continue;
            return testDesign;
        }
        return null;
    }

    public void addDesign(IDesign newDesign) {
        if (this.getDesign(newDesign.getName()) != null) {
            throw new IllegalArgumentException("Cannot add design of the same name to a project.");
        }
        this.designs.add(newDesign);
        this.raiseAlert(new IProject.DesignChange(this, newDesign));
    }

    public void addDesign(int index, IDesign newDesign) {
        if (this.getDesign(newDesign.getName()) != null) {
            throw new IllegalArgumentException("Cannot add design of the same name to a project.");
        }
        this.designs.add(index, newDesign);
        this.raiseAlert(new IProject.DesignChange(this, newDesign, index, true));
    }

    public boolean removeDesign(String designName) {
        IDesign designToRemove = this.getDesign(designName);
        if (designToRemove != null) {
            return this.removeDesign(designToRemove);
        }
        return false;
    }

    public boolean removeDesign(IDesign designToRemove) {
        int index = this.designs.indexOf(designToRemove);
        if (index != -1) {
            this.designs.remove(designToRemove);
            this.raiseAlert(new IProject.DesignChange(this, designToRemove, index, false));
            return true;
        }
        return false;
    }

    public ITaskApplication getTaskApplication(IUndertaking task, IDesign design) {
        TaskDesign td = TaskDesign.COMPUTE_HASH;
        td.setValues(task, design);
        ITaskApplication ta = (ITaskApplication)this.taskApplications.get(td);
        td.setValues(null, null);
        return ta;
    }

    public void setTaskApplication(IUndertaking task, IDesign design, ITaskApplication ta) {
        if (!this.designs.contains(design)) {
            throw new IllegalArgumentException("Cannot add ITaskApplication because the referenced design does not exist in this project!");
        }
        TaskDesign td = new TaskDesign(task, design);
        this.taskApplications.put(td, ta);
    }

    public ITaskApplication removeTaskApplication(IUndertaking task, IDesign design) {
        TaskDesign td = TaskDesign.COMPUTE_HASH;
        td.setValues(task, design);
        ITaskApplication ta = (ITaskApplication)this.taskApplications.remove(td);
        td.setValues(null, null);
        return ta;
    }

    public Map taskApplicationsForTask(IUndertaking task) {
        HashMap result = new HashMap();
        TAsForTaskIterator filterTAs = new TAsForTaskIterator(task);
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            result.put(taskDesignTA.getKey(), taskDesignTA.getValue());
        }
        return result;
    }

    public Map taskApplicationsForDesign(IDesign design) {
        HashMap result = new HashMap();
        TAsForDesignIterator filterTAs = new TAsForDesignIterator(design);
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            result.put(taskDesignTA.getKey(), taskDesignTA.getValue());
        }
        return result;
    }

    public Map taskApplicationsForRemovedTask(IUndertaking task) {
        HashMap result = new HashMap();
        TAsForTaskIterator filterTAs = new TAsForTaskIterator(task);
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            filterTAs.remove();
            result.put(taskDesignTA.getKey(), taskDesignTA.getValue());
        }
        return result;
    }

    public Map taskApplicationsForRemovedDesign(IDesign design) {
        HashMap result = new HashMap();
        TAsForDesignIterator filterTAs = new TAsForDesignIterator(design);
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            filterTAs.remove();
            result.put(taskDesignTA.getKey(), taskDesignTA.getValue());
        }
        return result;
    }

    public void restoreRemovedTaskApplications(Map taskApps) {
        if (taskApps == null) {
            throw new IllegalArgumentException("TaskApplication map cannot be null!");
        }
        Iterator taskDesignApps = taskApps.entrySet().iterator();
        while (taskDesignApps.hasNext()) {
            Map.Entry taskDesignApp = taskDesignApps.next();
            IProject.ITaskDesign td = (IProject.ITaskDesign)taskDesignApp.getKey();
            this.setTaskApplication(td.getTask(), td.getDesign(), (ITaskApplication)taskDesignApp.getValue());
        }
    }

    public List getUndertakings() {
        return this.undertakings;
    }

    public IUndertaking getUndertaking(String undertakingName) {
        Iterator undertakingIterator = this.undertakings.iterator();
        while (undertakingIterator.hasNext()) {
            IUndertaking testUndertaking = (IUndertaking)undertakingIterator.next();
            if (!testUndertaking.getName().equals(undertakingName)) continue;
            return testUndertaking;
        }
        return null;
    }

    public void addUndertaking(IUndertaking newUndertaking) {
        if (this.getUndertaking(newUndertaking.getName()) != null) {
            throw new IllegalArgumentException("Cannot add undertaking of the same name to a project.");
        }
        this.undertakings.add(newUndertaking);
        this.raiseAlert(new IProject.TaskChange(this, newUndertaking));
    }

    public void addUndertaking(int index, IUndertaking newUndertaking) {
        if (this.getUndertaking(newUndertaking.getName()) != null) {
            throw new IllegalArgumentException("Cannot add undertaking of the same name to a project.");
        }
        this.undertakings.add(index, newUndertaking);
        this.raiseAlert(new IProject.TaskChange(this, newUndertaking, index, true));
    }

    public boolean removeUndertaking(String undertakingName) {
        IUndertaking undertakingToRemove = this.getUndertaking(undertakingName);
        if (undertakingToRemove != null) {
            return this.removeUndertaking(undertakingToRemove);
        }
        return false;
    }

    public boolean removeUndertaking(IUndertaking undertakingToRemove) {
        int index = this.undertakings.indexOf(undertakingToRemove);
        if (index != -1) {
            this.undertakings.remove(undertakingToRemove);
            this.raiseAlert(new IProject.TaskChange(this, undertakingToRemove, index, false));
            return true;
        }
        return false;
    }

    public Set invalidateResultsUsing(IDesign design, IFrame frame, Set resultsToIgnore) {
        TAsForDesignIterator filterTAs = new TAsForDesignIterator(design);
        HashSet<IResultRevalidator> resultUndoers = new HashSet<IResultRevalidator>();
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            ITaskApplication ta = (ITaskApplication)taskDesignTA.getValue();
            if (ta == null) continue;
            Iterator algoScripts = ta.getScripts().entrySet().iterator();
            while (algoScripts.hasNext()) {
                Map.Entry algoScript = algoScripts.next();
                if (!((IScript)algoScript.getValue()).usesFrame(frame)) continue;
                IPredictionAlgo algo = (IPredictionAlgo)algoScript.getKey();
                if (resultsToIgnore != null && resultsToIgnore.contains(ta.getResult(algo))) continue;
                resultUndoers.add(ta.invalidateResult(algo));
            }
        }
        return resultUndoers;
    }

    public Set invalidateResultsUsing(IDesign design, IWidget widget, Set resultsToIgnore) {
        TAsForDesignIterator filterTAs = new TAsForDesignIterator(design);
        HashSet<IResultRevalidator> resultUndoers = new HashSet<IResultRevalidator>();
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            ITaskApplication ta = (ITaskApplication)taskDesignTA.getValue();
            if (ta == null) continue;
            Iterator algoScripts = ta.getScripts().entrySet().iterator();
            while (algoScripts.hasNext()) {
                Map.Entry algoScript = algoScripts.next();
                if (!((IScript)algoScript.getValue()).usesWidget(widget)) continue;
                IPredictionAlgo algo = (IPredictionAlgo)algoScript.getKey();
                if (resultsToIgnore != null && resultsToIgnore.contains(ta.getResult(algo))) continue;
                resultUndoers.add(ta.invalidateResult(algo));
            }
        }
        return resultUndoers;
    }

    public Set invalidateResultsUsing(IDesign design, ITransition transition, Set resultsToIgnore) {
        TAsForDesignIterator filterTAs = new TAsForDesignIterator(design);
        HashSet<IResultRevalidator> resultUndoers = new HashSet<IResultRevalidator>();
        while (filterTAs.hasNext()) {
            Map.Entry taskDesignTA = (Map.Entry)filterTAs.next();
            ITaskApplication ta = (ITaskApplication)taskDesignTA.getValue();
            if (ta == null) continue;
            Iterator algoScripts = ta.getScripts().entrySet().iterator();
            while (algoScripts.hasNext()) {
                Map.Entry algoScript = algoScripts.next();
                IScript script = (IScript)algoScript.getValue();
                if (!script.usesTransition(transition)) continue;
                IPredictionAlgo algo = (IPredictionAlgo)algoScript.getKey();
                if (resultsToIgnore != null && resultsToIgnore.contains(ta.getResult(algo))) continue;
                resultUndoers.add(ta.invalidateResult(algo));
            }
        }
        return resultUndoers;
    }

    protected class TAsForDesignIterator
    extends FilteredTAsIterator {
        protected IDesign forDesign;

        public TAsForDesignIterator(IDesign d) {
            this.forDesign = d;
            this.hasNext();
        }

        protected boolean passesFilter(Map.Entry entry) {
            return this.forDesign == ((TaskDesign)entry.getKey()).getDesign();
        }
    }

    protected class TAsForTaskIterator
    extends FilteredTAsIterator {
        protected IUndertaking forTask;

        public TAsForTaskIterator(IUndertaking t) {
            this.forTask = t;
            this.hasNext();
        }

        protected boolean passesFilter(Map.Entry entry) {
            return this.forTask == ((TaskDesign)entry.getKey()).getTask();
        }
    }

    protected abstract class FilteredTAsIterator
    implements Iterator {
        protected Iterator allTAs;
        protected Map.Entry nextEntry = null;

        public FilteredTAsIterator() {
            this.allTAs = Project.this.taskApplications.entrySet().iterator();
        }

        protected abstract boolean passesFilter(Map.Entry var1);

        public boolean hasNext() {
            if (this.nextEntry == null) {
                if (this.allTAs != null) {
                    while (this.allTAs.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.allTAs.next();
                        if (!this.passesFilter(entry)) continue;
                        this.nextEntry = entry;
                        return true;
                    }
                    this.nextEntry = null;
                    this.allTAs = null;
                }
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.nextEntry != null || this.hasNext()) {
                Map.Entry thisEntry = this.nextEntry;
                this.nextEntry = null;
                return thisEntry;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.allTAs != null) {
                this.allTAs.remove();
            }
        }
    }

    public static class TaskDesign
    implements IProject.ITaskDesign {
        public static final int edu_cmu_cs_hcii_cogtool_model_Project$TaskDesign_version = 0;
        protected static final String designVAR = "design";
        protected static final String taskVAR = "task";
        public IDesign design;
        public IUndertaking task;
        private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

            public int getVersion() {
                return 0;
            }

            public void saveData(Object value, ObjectSaver saver) throws IOException {
                TaskDesign v = (TaskDesign)value;
                saver.saveObject(v.design, "design");
                saver.saveObject(v.task, "task");
            }
        };
        private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

            public Object createObject() {
                return new TaskDesign();
            }

            public void set(Object target, String variable, Object value) {
                if (variable != null) {
                    if (variable.equals("design")) {
                        ((TaskDesign)target).design = (IDesign)value;
                    } else if (variable.equals("task")) {
                        ((TaskDesign)target).task = (IUndertaking)value;
                    }
                }
            }
        };
        public static final TaskDesign COMPUTE_HASH = new TaskDesign();

        public static void registerSaver() {
            ObjectSaver.registerSaver((class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign == null ? (class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign = Project.class$("edu.cmu.cs.hcii.cogtool.model.Project$TaskDesign")) : class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign).getName(), SAVER);
        }

        public static void registerLoader() {
            ObjectLoader.registerLoader((class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign == null ? (class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign = Project.class$("edu.cmu.cs.hcii.cogtool.model.Project$TaskDesign")) : class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign).getName(), 0, LOADER);
        }

        public TaskDesign(IUndertaking t, IDesign d) {
            this.task = t;
            this.design = d;
        }

        protected TaskDesign() {
        }

        protected boolean valueEquals(TaskDesign other) {
            return this.design == other.design && this.task == other.task;
        }

        public boolean equals(Object other) {
            return other.getClass() == (class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign == null ? (class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign = Project.class$("edu.cmu.cs.hcii.cogtool.model.Project$TaskDesign")) : class$edu$cmu$cs$hcii$cogtool$model$Project$TaskDesign) && this.valueEquals((TaskDesign)other);
        }

        public int hashCode() {
            return new HashCodeBuilder(41, 55).append(this.design.hashCode()).append(this.task.hashCode()).toHashCode();
        }

        private void setValues(IUndertaking t, IDesign d) {
            this.design = d;
            this.task = t;
        }

        public IDesign getDesign() {
            return this.design;
        }

        public IUndertaking getTask() {
            return this.task;
        }
    }
}

