/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.AAction;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IKeyAction;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class KeyAction
extends AAction
implements IKeyAction {
    public static final int edu_cmu_cs_hcii_cogtool_model_KeyAction_version = 0;
    protected static final String textVAR = "text";
    protected static final String isCommandVAR = "isCommand";
    protected static final String pressTypeVAR = "pressType";
    protected static final String modifiersVAR = "modifiers";
    protected String text;
    protected boolean isCommand;
    protected KeyPressType pressType = KeyPressType.Stroke;
    protected int modifiers = 0;
    private int myHashCode;
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            KeyAction v = (KeyAction)value;
            saver.saveString(v.text, KeyAction.textVAR);
            saver.saveBoolean(v.isCommand, KeyAction.isCommandVAR);
            saver.saveObject(v.pressType, KeyAction.pressTypeVAR);
            saver.saveInt(v.modifiers, KeyAction.modifiersVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new KeyAction();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(KeyAction.textVAR)) {
                    ((KeyAction)target).text = (String)value;
                } else if (variable.equals(KeyAction.pressTypeVAR)) {
                    ((KeyAction)target).pressType = (KeyPressType)value;
                }
            }
        }

        public void set(Object target, String variable, boolean value) {
            if (variable != null && variable.equals(KeyAction.isCommandVAR)) {
                ((KeyAction)target).isCommand = value;
            }
        }

        public void set(Object target, String variable, int value) {
            if (variable != null && variable.equals(KeyAction.modifiersVAR)) {
                ((KeyAction)target).modifiers = value;
            }
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(KeyAction.class.getName(), SAVER);
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(KeyAction.class.getName(), 0, LOADER);
    }

    protected KeyAction() {
        super(ActionType.KeyPress);
    }

    public KeyAction(String cmd, boolean isCmd, int modifiers) {
        super(ActionType.KeyPress);
        if (cmd == null) {
            throw new IllegalArgumentException("Key command string cannot be null!");
        }
        this.text = cmd;
        this.modifiers = modifiers;
        this.isCommand = isCmd;
    }

    public KeyAction(char key, KeyPressType clk, boolean isCmd, int modifiers) {
        super(ActionType.KeyPress);
        this.text = String.valueOf(key);
        this.pressType = clk;
        this.modifiers = modifiers;
        this.isCommand = isCmd;
    }

    public KeyAction(char key, KeyPressType clk, int modifiers) {
        this(key, clk, true, modifiers);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String str) {
        if (str == null || str.equals("")) {
            throw new IllegalArgumentException("Key command string cannot be null or empty!");
        }
        this.text = str;
    }

    public KeyPressType getPressType() {
        return this.pressType;
    }

    public void setPressType(KeyPressType clk) {
        this.pressType = clk;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int newState) {
        this.modifiers = newState;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public void setIsCommand(boolean isCmd) {
        this.isCommand = isCmd;
    }

    public IAction duplicate() {
        KeyAction action = new KeyAction(this.text, this.isCommand, this.modifiers);
        action.setPressType(this.pressType);
        return action;
    }

    public String getLocalizedString() {
        String clickStr = this.pressType.toString();
        String stateStr = "";
        String separator = "";
        if ((this.modifiers & 0x10) != 0) {
            stateStr = L10N.get("BACT.FUNCTION", "FN");
            separator = "-";
        }
        if ((this.modifiers & 8) != 0) {
            stateStr = L10N.get("BACT.COMMAND", "COMMAND");
            separator = "-";
        }
        if ((this.modifiers & 2) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.CTRL", "CTRL");
            separator = "-";
        }
        if ((this.modifiers & 4) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.ALT", "ALT");
            separator = "-";
        }
        if ((this.modifiers & 1) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.SHIFT", "SHIFT");
            separator = "-";
        }
        String result = null;
        result = stateStr.equals("") ? stateStr : stateStr + " ";
        return clickStr + " " + result + "'" + this.text + "'";
    }

    public void accept(IAction.IActionVisitor visitor) {
        visitor.visit(this);
    }

    protected boolean valueEquals(KeyAction other) {
        return super.valueEquals(other) && this.pressType == other.getPressType() && this.isCommand == other.isCommand() && (this.text == null && other.getText() == null || this.text.equals(other.getText())) && this.modifiers == other.getModifiers();
    }

    public boolean equals(Object other) {
        return other.getClass() == KeyAction.class && this.valueEquals((KeyAction)other);
    }

    public int hashCode() {
        if (this.myHashCode == 0) {
            this.myHashCode = new HashCodeBuilder(73, 31).appendSuper(super.hashCode()).append((Object)this.getText()).append((Object)this.getPressType()).append(this.getModifiers()).toHashCode();
        }
        return this.myHashCode;
    }
}

