/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.AShape;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.GraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.ShapeOval;
import edu.cmu.cs.hcii.cogtool.model.ShapeRectangle;
import edu.cmu.cs.hcii.cogtool.model.ShapeRoundedRectangle;
import edu.cmu.cs.hcii.cogtool.model.TapAction;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.VoiceAction;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImportCogTool {
    protected String directoryPath = "";
    protected ObjectLoader objLoader = new ObjectLoader();
    protected IDesign design = null;
    protected static ObjectLoader.IObjectLoader designLoader = Design.getImportLoader();
    protected static ObjectLoader.IObjectLoader frameLoader = Frame.getImportLoader();
    protected static ObjectLoader.IObjectLoader widgetLoader = Widget.getImportLoader();

    public boolean importXMLDesign(File inputFile) throws IOException, SAXException {
        InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8");
        return this.importXMLDesign(input, inputFile.getParent() + File.separator);
    }

    public boolean importXMLDesign(Reader input, String imageDirPath) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        this.directoryPath = imageDirPath;
        parser.parse(new InputSource(input));
        Document document = parser.getDocument();
        this.parseFile(document);
        return true;
    }

    public IDesign getDesign() {
        return this.design;
    }

    protected String getAttributeValue(Node node, String attr) {
        Node attributeNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attributeNode = attributes.getNamedItem(attr)) != null) {
            return attributeNode.getNodeValue();
        }
        return null;
    }

    protected String getElementText(Node node) {
        if (node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }

    protected void parseFile(Node node) throws IOException {
        block4: {
            NodeList children = node.getChildNodes();
            if (children == null) break block4;
            if (node.getNodeName().equalsIgnoreCase("cogtoolimport")) {
                String version = this.getAttributeValue(node, "version");
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    String nodeName = child.getNodeName();
                    if (!nodeName.equalsIgnoreCase("design")) continue;
                    this.parseDesign(child);
                }
            } else {
                for (int i = 0; i < children.getLength(); ++i) {
                    this.parseFile(children.item(i));
                }
            }
        }
    }

    protected void parseDesign(Node node) throws IOException {
        NodeList children = node.getChildNodes();
        if (children != null) {
            this.design = (IDesign)designLoader.createObject();
            designLoader.set((Object)this.design, "name", this.getAttributeValue(node, "name"));
            Collection deviceTypes = designLoader.createCollection(this.design, "deviceTypes", 1);
            Collection frames = designLoader.createCollection(this.design, "frames", 1);
            ObjectLoader.IAggregateLoader deviceTypesLoader = designLoader.getLoader("deviceTypes");
            ObjectLoader.IAggregateLoader framesLoader = designLoader.getLoader("frames");
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.equalsIgnoreCase("device")) {
                    String device = this.getElementText(child);
                    if (device.equalsIgnoreCase("keyboard")) {
                        deviceTypesLoader.addToCollection(this.objLoader, deviceTypes, DeviceType.Keyboard);
                        continue;
                    }
                    if (device.equalsIgnoreCase("mouse")) {
                        deviceTypesLoader.addToCollection(this.objLoader, deviceTypes, DeviceType.Mouse);
                        continue;
                    }
                    if (device.equalsIgnoreCase("touchscreen")) {
                        deviceTypesLoader.addToCollection(this.objLoader, deviceTypes, DeviceType.Touchscreen);
                        continue;
                    }
                    if (!device.equalsIgnoreCase("microphone")) continue;
                    deviceTypesLoader.addToCollection(this.objLoader, deviceTypes, DeviceType.Voice);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("frame")) continue;
                this.parseFrame(this.design, child);
            }
            if (this.design.getName() == null || deviceTypes.size() == 0 || frames.size() == 0) {
                this.design = null;
            }
        }
    }

    protected IFrame parseFrame(IDesign design, Node node) throws IOException {
        NodeList children = node.getChildNodes();
        if (children != null) {
            String frameName = this.getAttributeValue(node, "name");
            if (frameName == null || frameName.equals("")) {
                return null;
            }
            IFrame frame = this.getFrame(frameName);
            Frame.setFrameDevices((Frame)frame, design.getDeviceTypes());
            IInputDevice keyboardDevice = frame.getInputDevice(DeviceType.Keyboard);
            IInputDevice voiceDevice = frame.getInputDevice(DeviceType.Voice);
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.equalsIgnoreCase("backgroundImagePath")) {
                    String backgroundImagePath = this.getElementText(child);
                    byte[] image = GraphicsUtil.loadImageFromFile(this.directoryPath + backgroundImagePath);
                    frameLoader.set((Object)frame, "background", image);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("topLeftOrigin")) {
                    double x = Double.parseDouble(this.getAttributeValue(child, "x"));
                    double y = Double.parseDouble(this.getAttributeValue(child, "y"));
                    DoublePoint origin = new DoublePoint(x, y);
                    frameLoader.set((Object)frame, "origin", origin);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("widget")) {
                    IWidget w = this.parseWidget(child);
                    if (w == null) continue;
                    frame.addWidget(w);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("keyboardTransitions")) {
                    if (keyboardDevice == null) continue;
                    this.parseTransitions(keyboardDevice, child);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("voiceTransitions") || voiceDevice == null) continue;
                this.parseTransitions(voiceDevice, child);
            }
            if (frame.getName() != null) {
                return frame;
            }
        }
        return null;
    }

    protected IFrame getFrame(String frameName) {
        if (frameName != null) {
            IFrame frame = this.design.getFrame(frameName);
            if (frame == null) {
                frame = (IFrame)frameLoader.createObject();
                frame.setName(frameName);
                this.design.addFrame(frame);
            }
            return frame;
        }
        return null;
    }

    protected WidgetType getWidgetType(String widgetType) {
        if (widgetType.equalsIgnoreCase("button")) {
            return WidgetType.Button;
        }
        if (widgetType.equalsIgnoreCase("check box")) {
            return WidgetType.Check;
        }
        if (widgetType.equalsIgnoreCase("radio button")) {
            return WidgetType.Radio;
        }
        if (widgetType.equalsIgnoreCase("text box")) {
            return WidgetType.TextBox;
        }
        if (widgetType.equalsIgnoreCase("pull-down list")) {
            return WidgetType.PullDownList;
        }
        if (widgetType.equalsIgnoreCase("pull-down item")) {
            return WidgetType.PullDownItem;
        }
        if (widgetType.equalsIgnoreCase("list box item")) {
            return WidgetType.ListBoxItem;
        }
        if (widgetType.equalsIgnoreCase("menu")) {
            return WidgetType.Menu;
        }
        if (widgetType.equalsIgnoreCase("submenu")) {
            return WidgetType.Submenu;
        }
        if (widgetType.equalsIgnoreCase("menu item")) {
            return WidgetType.MenuItem;
        }
        if (widgetType.equalsIgnoreCase("graffiti")) {
            return WidgetType.Graffiti;
        }
        if (widgetType.equalsIgnoreCase("non-interactive")) {
            return WidgetType.Noninteractive;
        }
        return null;
    }

    protected IWidget parseWidget(Node node) throws IOException {
        NodeList children = node.getChildNodes();
        if (children != null) {
            IWidget widget = (IWidget)widgetLoader.createObject();
            widget.setName(this.getAttributeValue(node, "name"));
            WidgetType widgetType = this.getWidgetType(this.getAttributeValue(node, "type"));
            if (widgetType != null) {
                widgetLoader.set((Object)widget, "widgetType", widgetType);
            }
            for (int i = 0; i < children.getLength(); ++i) {
                ITransition t;
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.equalsIgnoreCase("displayLabel")) {
                    widgetLoader.set((Object)widget, "title", this.getElementText(child));
                    continue;
                }
                if (nodeName.equalsIgnoreCase("extent")) {
                    double x = Double.parseDouble(this.getAttributeValue(child, "x"));
                    double y = Double.parseDouble(this.getAttributeValue(child, "y"));
                    double width = Double.parseDouble(this.getAttributeValue(child, "width"));
                    double height = Double.parseDouble(this.getAttributeValue(child, "height"));
                    DoubleRectangle extent = new DoubleRectangle(x, y, width, height);
                    AShape widgetShape = null;
                    String shapeType = this.getAttributeValue(node, "shape");
                    if (shapeType == null || shapeType.equalsIgnoreCase("rectangle")) {
                        widgetShape = new ShapeRectangle(extent);
                    } else if (shapeType.equalsIgnoreCase("ellipse")) {
                        widgetShape = new ShapeOval(extent);
                    } else if (shapeType.equalsIgnoreCase("rounded rectangle")) {
                        widgetShape = new ShapeRoundedRectangle(extent);
                    }
                    if (widgetShape == null) continue;
                    widgetLoader.set((Object)widget, "shape", widgetShape);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("backgroundImagePath")) {
                    String backgroundImagePath = this.getElementText(child);
                    byte[] image = GraphicsUtil.loadImageFromFile(this.directoryPath + backgroundImagePath);
                    widgetLoader.set((Object)widget, "widgetImage", image);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("transition") || (t = this.parseTransition(widget, child)) == null) continue;
                widget.addTransition(t);
            }
            if (widget.getName() != null && widget.getWidgetType() != null && widget.getShape() != null) {
                return widget;
            }
        }
        return null;
    }

    protected void parseTransitions(ITransitionSource source, Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                ITransition t;
                Node child = children.item(i);
                if (!child.getNodeName().equalsIgnoreCase("transition") || (t = this.parseTransition(source, child)) == null) continue;
                source.addTransition(t);
            }
        }
    }

    protected ITransition parseTransition(ITransitionSource source, Node node) {
        IFrame destination;
        NodeList children = node.getChildNodes();
        if (children != null && (destination = this.getFrame(this.getAttributeValue(node, "destinationFrameName"))) != null) {
            IAction action = null;
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (!nodeName.equalsIgnoreCase("action")) continue;
                action = this.parseAction(child);
            }
            if (action != null) {
                return new Transition(source, destination, action);
            }
        }
        return null;
    }

    protected IAction parseAction(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.equalsIgnoreCase("mouseAction")) {
                    return this.parseMouseAction(child);
                }
                if (nodeName.equalsIgnoreCase("touchscreenAction")) {
                    return this.parseTouchscreenAction(child);
                }
                if (nodeName.equalsIgnoreCase("graffitiAction")) {
                    return this.parseGraffitiAction(child);
                }
                if (nodeName.equalsIgnoreCase("keyboardAction")) {
                    return this.parseKeyboardAction(child);
                }
                if (!nodeName.equalsIgnoreCase("voiceAction")) continue;
                return this.parseVoiceAction(child);
            }
        }
        return null;
    }

    protected IAction parseMouseAction(Node node) {
        String buttonAttr = this.getAttributeValue(node, "button");
        String actionAttr = this.getAttributeValue(node, "action");
        MouseButtonState button = null;
        MousePressType mouseAction = null;
        if (buttonAttr == null || buttonAttr.equalsIgnoreCase("left")) {
            button = MouseButtonState.Left;
        } else if (buttonAttr.equalsIgnoreCase("middle")) {
            button = MouseButtonState.Middle;
        } else if (buttonAttr.equalsIgnoreCase("right")) {
            button = MouseButtonState.Right;
        }
        if (actionAttr == null || actionAttr.equalsIgnoreCase("downUp")) {
            mouseAction = MousePressType.Click;
        } else if (actionAttr.equalsIgnoreCase("double")) {
            mouseAction = MousePressType.Double;
        } else if (actionAttr.equalsIgnoreCase("down")) {
            mouseAction = MousePressType.Down;
        } else if (actionAttr.equalsIgnoreCase("up")) {
            mouseAction = MousePressType.Up;
        } else if (actionAttr.equalsIgnoreCase("hover")) {
            mouseAction = MousePressType.Hover;
        }
        if (button != null && actionAttr != null) {
            return new ButtonAction(button, mouseAction, 0);
        }
        return null;
    }

    protected IAction parseTouchscreenAction(Node node) {
        String actionAttr = this.getAttributeValue(node, "action");
        TapPressType tapAction = null;
        if (actionAttr == null || actionAttr.equalsIgnoreCase("downUp")) {
            tapAction = TapPressType.Tap;
        } else if (actionAttr.equalsIgnoreCase("double")) {
            tapAction = TapPressType.DoubleTap;
        } else if (actionAttr.equalsIgnoreCase("down")) {
            tapAction = TapPressType.Down;
        } else if (actionAttr.equalsIgnoreCase("up")) {
            tapAction = TapPressType.Up;
        } else if (actionAttr.equalsIgnoreCase("hover")) {
            tapAction = TapPressType.Hover;
        }
        if (actionAttr != null) {
            return new TapAction(tapAction);
        }
        return null;
    }

    protected boolean isAttributeTRUE(String isAttr, boolean defaultsTRUE) {
        if (isAttr == null) {
            return defaultsTRUE;
        }
        return isAttr.equalsIgnoreCase("true") || isAttr.equalsIgnoreCase("t") || isAttr.equals("1");
    }

    protected IAction parseGraffitiAction(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equalsIgnoreCase("gestures")) continue;
                boolean isCommand = this.isAttributeTRUE(this.getAttributeValue(node, "is-command"), true);
                return new GraffitiAction(this.getElementText(child), isCommand);
            }
        }
        return null;
    }

    protected KeyPressType getPressType(String type) {
        if (type != null) {
            if (type.equalsIgnoreCase("press")) {
                return KeyPressType.Stroke;
            }
            if (type.equalsIgnoreCase("up")) {
                return KeyPressType.Up;
            }
            if (type.equalsIgnoreCase("down")) {
                return KeyPressType.Down;
            }
        }
        return KeyPressType.Stroke;
    }

    protected IAction parseKeyboardAction(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            String text = null;
            int modifiers = 0;
            KeyPressType pressType = this.getPressType(this.getAttributeValue(node, "type"));
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (!nodeName.equalsIgnoreCase("text")) continue;
                text = this.getElementText(child);
            }
            if (text != null) {
                boolean isCommand = this.isAttributeTRUE(this.getAttributeValue(node, "is-command"), true);
                if (text.length() == 1 && isCommand) {
                    return new KeyAction(text.charAt(0), pressType, modifiers);
                }
                return new KeyAction(text, isCommand, modifiers);
            }
        }
        return null;
    }

    protected int addKeyboardModifier(int modifiers, String addModifier) {
        if (addModifier != null) {
            if (addModifier.equalsIgnoreCase("SHIFT")) {
                return modifiers | 1;
            }
            if (addModifier.equalsIgnoreCase("CTRL")) {
                return modifiers | 2;
            }
            if (addModifier.equalsIgnoreCase("ALT")) {
                return modifiers | 4;
            }
            if (addModifier.equalsIgnoreCase("COMMAND")) {
                return modifiers | 8;
            }
            if (addModifier.equalsIgnoreCase("FUNCTION")) {
                return modifiers | 0x10;
            }
        }
        return modifiers;
    }

    protected IAction parseVoiceAction(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equalsIgnoreCase("text")) continue;
                boolean isCommand = this.isAttributeTRUE(this.getAttributeValue(node, "is-command"), true);
                return new VoiceAction(this.getElementText(child), isCommand);
            }
        }
        return null;
    }
}

