/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IMenuHeader;
import edu.cmu.cs.hcii.cogtool.model.IMenuItem;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.InputDevice;
import edu.cmu.cs.hcii.cogtool.model.SimpleWidgetGroup;
import edu.cmu.cs.hcii.cogtool.util.DuplicateNameException;
import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Frame
extends GlobalAttributed
implements IFrame,
Cloneable {
    public static final int edu_cmu_cs_hcii_cogtool_model_Frame_version = 1;
    protected static final String nameVAR = "name";
    protected static final String widgetColorVAR = "widgetColor";
    protected static final String widgetsVAR = "widgets";
    protected static final String devicesVAR = "devices";
    protected static final String originVAR = "origin";
    protected static final String backgroundVAR = "background";
    protected static final String backgroundBoundsVAR = "backgroundBounds";
    protected static final String incidentTransitionsVAR = "incidentTransitions";
    protected IDesign design;
    protected String name;
    protected Set widgets = new LinkedHashSet();
    protected Map devices = new LinkedHashMap();
    protected DoublePoint origin = new DoublePoint(0.0, 0.0);
    protected byte[] background = null;
    protected DoubleRectangle backgroundBounds = null;
    protected Set incidentTransitions = new HashSet();
    protected int widgetColor = GraphicsUtil.defaultWidgetColor;
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 1;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            Frame v = (Frame)value;
            saver.saveString(v.name, Frame.nameVAR);
            saver.saveInt(v.widgetColor, Frame.widgetColorVAR);
            saver.saveObject(v.widgets, Frame.widgetsVAR);
            saver.saveObject(v.devices, Frame.devicesVAR);
            saver.saveObject(v.origin, Frame.originVAR);
            saver.saveObject(v.background, Frame.backgroundVAR);
            saver.saveObject(v.backgroundBounds, Frame.backgroundBoundsVAR);
            Object purpose = saver.getPurpose();
            if (purpose == "FrameOnly") {
                saver.saveObject(new HashSet(), Frame.incidentTransitionsVAR);
            } else {
                saver.saveObject(v.incidentTransitions, Frame.incidentTransitionsVAR);
            }
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new FrameLoader();
    private static ObjectLoader.IObjectLoader frameLoaderV0 = new FrameLoader(){

        public void set(Object target, String variable, Object value) {
            if (variable.equals(Frame.backgroundVAR) && value != null) {
                ((Frame)target).backgroundBounds = GraphicsUtil.getImageBounds((byte[])value);
            }
            super.set(target, variable, value);
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(Frame.class.getName(), SAVER);
    }

    public static ObjectLoader.IObjectLoader getImportLoader() {
        return frameLoaderV0;
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(Frame.class.getName(), 0, frameLoaderV0);
        ObjectLoader.registerLoader(Frame.class.getName(), 1, LOADER);
    }

    public static boolean isIdentical(Frame l, Frame r) {
        return l.name.equals(r.name) && ((Object)l.widgets).equals(r.widgets) && ((Object)l.devices).equals(r.devices) && l.origin.equals(r.origin) && (l.background == r.background || l.background != null && Arrays.equals(l.background, r.background)) && ((Object)l.incidentTransitions).equals(r.incidentTransitions) && l.widgetColor == r.widgetColor;
    }

    public Object clone() {
        Frame clone = new Frame();
        clone.name = this.name;
        clone.widgets = new HashSet(this.widgets);
        clone.devices = new HashMap(this.devices);
        clone.origin = new DoublePoint(this.origin.x, this.origin.y);
        if (this.background == null) {
            clone.background = null;
        } else {
            clone.background = new byte[this.background.length];
            System.arraycopy(this.background, 0, clone.background, 0, this.background.length);
        }
        clone.incidentTransitions = new HashSet(this.incidentTransitions);
        clone.widgetColor = this.widgetColor;
        return clone;
    }

    protected static void setFrameDevices(Frame f, Set deviceTypes) {
        if (deviceTypes == null) {
            throw new IllegalArgumentException("InputDeviceType set cannot be null!");
        }
        Iterator types = deviceTypes.iterator();
        while (types.hasNext()) {
            DeviceType type = (DeviceType)types.next();
            if (type.isModeledByDisplay()) continue;
            InputDevice newDevice = new InputDevice(type.toString(), type);
            f.devices.put(type, newDevice);
            newDevice.setFrame(f);
        }
    }

    public Frame(String nm, Set deviceTypes) {
        if (nm == null || nm.equals("")) {
            throw new IllegalArgumentException("Frame name cannot be null or empty!");
        }
        this.name = nm;
        Frame.setFrameDevices(this, deviceTypes);
    }

    protected Frame() {
    }

    public IDesign getDesign() {
        return this.design;
    }

    public void setDesign(IDesign d) {
        this.design = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null || newName.equals("")) {
            throw new IllegalArgumentException("Frame name cannot be null or empty!");
        }
        this.name = newName;
        this.raiseAlert(new NameChangeAlert(this));
    }

    public DoublePoint getFrameOrigin() {
        return this.origin;
    }

    public void setFrameOrigin(double newX, double newY) {
        DoublePoint oldOrigin = new DoublePoint(this.origin);
        this.origin.x = newX;
        this.origin.y = newY;
        this.raiseAlert(new IFrame.OriginChange(this, oldOrigin));
    }

    public void setFrameOrigin(DoublePoint newOrigin) {
        DoublePoint oldOrigin = new DoublePoint(this.origin);
        this.origin.x = newOrigin.x;
        this.origin.y = newOrigin.y;
        this.raiseAlert(new IFrame.OriginChange(this, oldOrigin));
    }

    public void moveFrameOrigin(double deltaX, double deltaY) {
        DoublePoint oldOrigin = new DoublePoint(this.origin);
        this.origin.x += deltaX;
        this.origin.y += deltaY;
        this.raiseAlert(new IFrame.OriginChange(this, oldOrigin));
    }

    public void moveFrameOrigin(DoublePoint deltaOrigin) {
        DoublePoint oldOrigin = new DoublePoint(this.origin);
        this.origin.x += deltaOrigin.x;
        this.origin.y += deltaOrigin.y;
        this.raiseAlert(new IFrame.OriginChange(this, oldOrigin));
    }

    public byte[] getBackgroundImage() {
        return this.background;
    }

    public void setBackgroundImage(byte[] img, DoubleRectangle bounds) {
        if (img != this.background) {
            this.background = img;
            this.backgroundBounds = bounds;
            this.raiseAlert(new IFrame.BackgroundImageChange(this, IFrame.BackgroundImageChange.IMAGE_CONTENT_CHANGE));
        }
    }

    public DoubleRectangle getBackgroundBounds() {
        return this.backgroundBounds;
    }

    public void setBackgroundBounds(DoubleRectangle bounds) {
        if (this.background == null && bounds != null) {
            throw new RcvrUIException("Trying to set a non-null bounds for a null background on Frame: " + this.toString());
        }
        if (this.background != null && bounds == null) {
            throw new RcvrUIException("Trying to set a null bounds for a non-null background on Frame: " + this.toString());
        }
        if (this.background == null && bounds == null) {
            bounds = null;
        } else if (!bounds.equals(this.backgroundBounds)) {
            this.backgroundBounds = bounds;
            this.raiseAlert(new IFrame.BackgroundImageChange(this, IFrame.BackgroundImageChange.IMAGE_BOUNDS_CHANGE));
        }
    }

    public Set getWidgets() {
        return this.widgets;
    }

    public IWidget getWidget(String widgetName) {
        Iterator widgetIterator = this.widgets.iterator();
        while (widgetIterator.hasNext()) {
            IWidget testWidget = (IWidget)widgetIterator.next();
            if (!testWidget.getName().equals(widgetName)) continue;
            return testWidget;
        }
        return null;
    }

    public void addWidget(IWidget newWidget) throws DuplicateNameException {
        if (this.isWidgetNameTaken(newWidget.getName())) {
            throw new DuplicateNameException();
        }
        newWidget.setLevel(this.widgets.size());
        this.widgets.add(newWidget);
        newWidget.setFrame(this);
        this.raiseAlert(new IFrame.WidgetChange(this, newWidget, 0));
    }

    public boolean removeWidget(String widgetName) {
        IWidget widgetToRemove = this.getWidget(widgetName);
        if (widgetToRemove != null) {
            return this.removeWidget(widgetToRemove);
        }
        return false;
    }

    public boolean removeWidget(IWidget widgetToRemove) {
        this.setWidgetLevel(Integer.MAX_VALUE, widgetToRemove);
        if (this.widgets.remove(widgetToRemove)) {
            this.raiseAlert(new IFrame.WidgetChange(this, widgetToRemove, 1));
            return true;
        }
        return false;
    }

    public void setWidgetLevel(int newLevel, IWidget widget) {
        int oldLevel = widget.getLevel();
        int maxLevel = this.widgets.size() - 1;
        if (newLevel > maxLevel) {
            newLevel = maxLevel;
        } else if (newLevel < 0) {
            newLevel = 0;
        }
        if (newLevel != oldLevel) {
            Iterator widgetIterator = this.widgets.iterator();
            while (widgetIterator.hasNext()) {
                IWidget theWidget = (IWidget)widgetIterator.next();
                int level = theWidget.getLevel();
                if (oldLevel < level && level <= newLevel) {
                    theWidget.setLevel(level - 1);
                    continue;
                }
                if (newLevel > level || level >= oldLevel) continue;
                theWidget.setLevel(level + 1);
            }
            widget.setLevel(newLevel);
            this.raiseAlert(new IFrame.WidgetChange(this, widget, 2));
        }
    }

    public IInputDevice getInputDevice(DeviceType type) {
        return (IInputDevice)this.devices.get(type);
    }

    public Collection getInputDevices() {
        return this.devices.values();
    }

    public void addIncidentTransition(ITransition transition) {
        if (transition == null) {
            throw new IllegalArgumentException("Incident transition to add must not be null!");
        }
        if (this != transition.getDestination()) {
            throw new IllegalArgumentException("Transition to add must be incident on this Frame!");
        }
        this.incidentTransitions.add(transition);
    }

    public void addIncidentTransitions(ITransition[] transitions) {
        for (int i = 0; i < transitions.length; ++i) {
            this.addIncidentTransition(transitions[i]);
        }
    }

    public boolean removeIncidentTransition(ITransition transition) {
        if (transition == null) {
            throw new IllegalArgumentException("Incident transition to remove must not be null!");
        }
        return this.incidentTransitions.remove(transition);
    }

    public ITransition[] removeIncidentTransitions() {
        int i = -1;
        ITransition[] transitions = new ITransition[this.incidentTransitions.size()];
        Iterator iTransitions = this.incidentTransitions.iterator();
        while (iTransitions.hasNext()) {
            ITransition transition = (ITransition)iTransitions.next();
            transitions[++i] = transition;
            iTransitions.remove();
            transition.getSource().removeTransition(transition);
        }
        return transitions;
    }

    public Set getIncidentTransitions() {
        return this.incidentTransitions;
    }

    public boolean isWidgetNameTaken(String name) {
        Iterator w = this.widgets.iterator();
        while (w.hasNext()) {
            IWidget widget = (IWidget)w.next();
            if (!widget.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setWidgetName(String name, IWidget widget) throws DuplicateNameException {
        if (!widget.getName().equals(name)) {
            if (this.isWidgetNameTaken(name)) {
                throw new DuplicateNameException();
            }
            widget.setName(name);
        }
    }

    public int getWidgetColor() {
        return this.widgetColor;
    }

    public void setWidgetColor(int color) {
        if (this.widgetColor != color) {
            this.widgetColor = color;
            this.raiseAlert(new IFrame.WidgetChange(this, null, 3));
        }
    }

    protected void duplicateMenu(IMenuHeader menuHeader, final IFrame frameCopy, IFrame.FrameDuplicator duplicator) {
        IWidgetGroup.WidgetDuplicator widgetSituator = new IWidgetGroup.WidgetDuplicator(){

            public void placeInContext(IWidget widgetCopy) {
                frameCopy.addWidget(widgetCopy);
            }
        };
        SimpleWidgetGroup newHeaderGroup = new SimpleWidgetGroup(menuHeader.getParentGroup().getOrientation());
        frameCopy.addWidget(menuHeader.duplicate(newHeaderGroup, duplicator, widgetSituator));
    }

    public IFrame duplicate(String newName, IFrame.FrameDuplicator duplicator) {
        Frame frameCopy = new Frame(newName, this.devices.keySet());
        duplicator.recordDuplicateFrame(this, frameCopy);
        Iterator deviceIt = this.devices.values().iterator();
        while (deviceIt.hasNext()) {
            IInputDevice device = (IInputDevice)deviceIt.next();
            IInputDevice deviceCopy = frameCopy.getInputDevice(device.getDeviceType());
            device.duplicateTransitions(deviceCopy, duplicator);
        }
        frameCopy.setFrameOrigin(this.origin);
        frameCopy.setBackgroundImage(this.background, this.backgroundBounds);
        frameCopy.setWidgetColor(this.widgetColor);
        ArrayList widgetsCopy = new ArrayList(this.widgets);
        Collections.sort(widgetsCopy, IWidget.WidgetLevelComparator.ONLY);
        Iterator widgetIt = widgetsCopy.iterator();
        while (widgetIt.hasNext()) {
            IWidget childWidget = (IWidget)widgetIt.next();
            if (childWidget instanceof IMenuHeader) {
                this.duplicateMenu((IMenuHeader)childWidget, frameCopy, duplicator);
                continue;
            }
            if (childWidget instanceof IMenuItem) continue;
            frameCopy.addWidget(childWidget.duplicate(duplicator));
        }
        return frameCopy;
    }

    public static class FrameLoader
    extends ObjectLoader.AObjectLoader {
        public Object createObject() {
            return new Frame();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(Frame.nameVAR)) {
                    ((Frame)target).name = (String)value;
                } else if (variable.equals(Frame.originVAR)) {
                    ((Frame)target).origin = (DoublePoint)value;
                } else if (variable.equals(Frame.backgroundVAR)) {
                    ((Frame)target).background = (byte[])value;
                } else if (variable.equals(Frame.backgroundBoundsVAR)) {
                    ((Frame)target).backgroundBounds = (DoubleRectangle)value;
                }
            }
        }

        public void set(Object target, String variable, int value) {
            if (variable != null && variable.equals(Frame.widgetColorVAR)) {
                ((Frame)target).widgetColor = value;
            }
        }

        public Collection createCollection(Object target, String variable, int size) {
            if (variable != null) {
                if (variable.equals(Frame.widgetsVAR)) {
                    return ((Frame)target).widgets;
                }
                if (variable.equals(Frame.incidentTransitionsVAR)) {
                    return ((Frame)target).incidentTransitions;
                }
            }
            return null;
        }

        public Map createMap(Object target, String variable, int size) {
            if (variable != null && variable.equals(Frame.devicesVAR)) {
                return ((Frame)target).devices;
            }
            return null;
        }

        public ObjectLoader.IAggregateLoader getLoader(String variable) {
            if (variable.equals(Frame.widgetsVAR)) {
                return new ObjectLoader.AAggregateLoader(this){
                    private final /* synthetic */ FrameLoader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void addToCollection(ObjectLoader l, Collection c, Object v) {
                        super.addToCollection(l, c, v);
                        Object parent = l.getPendingObject(1);
                        ((IWidget)v).setFrame((IFrame)parent);
                    }
                };
            }
            if (variable.equals(Frame.devicesVAR)) {
                return new ObjectLoader.AAggregateLoader(this){
                    private final /* synthetic */ FrameLoader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void putInMap(ObjectLoader l, Map m, Object key, Object v) {
                        super.putInMap(l, m, key, v);
                        Object parent = l.getPendingObject(1);
                        ((IInputDevice)v).setFrame((IFrame)parent);
                    }
                };
            }
            return super.getLoader(variable);
        }
    }
}

