/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DoubleRectangle {
    public static final int edu_cmu_cs_hcii_cogtool_model_DoubleRectangle_version = 0;
    protected static final String xVAR = "x";
    protected static final String yVAR = "y";
    protected static final String widthVAR = "width";
    protected static final String heightVAR = "height";
    public double x;
    public double y;
    public double width;
    public double height;
    private int myHashCode = this.hashCode();
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            DoubleRectangle v = (DoubleRectangle)value;
            saver.saveDouble(v.x, DoubleRectangle.xVAR);
            saver.saveDouble(v.y, DoubleRectangle.yVAR);
            saver.saveDouble(v.width, DoubleRectangle.widthVAR);
            saver.saveDouble(v.height, DoubleRectangle.heightVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new DoubleRectangle();
        }

        public void set(Object target, String variable, double value) {
            if (variable != null) {
                if (variable.equals(DoubleRectangle.xVAR)) {
                    ((DoubleRectangle)target).x = value;
                } else if (variable.equals(DoubleRectangle.yVAR)) {
                    ((DoubleRectangle)target).y = value;
                } else if (variable.equals(DoubleRectangle.widthVAR)) {
                    ((DoubleRectangle)target).width = value;
                } else if (variable.equals(DoubleRectangle.heightVAR)) {
                    ((DoubleRectangle)target).height = value;
                }
            }
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(DoubleRectangle.class.getName(), SAVER);
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(DoubleRectangle.class.getName(), 0, LOADER);
    }

    public DoubleRectangle(double newX, double newY, double newWidth, double newHeight) {
        this.x = newX;
        this.y = newY;
        this.width = newWidth;
        this.height = newHeight;
    }

    public DoubleRectangle(DoublePoint o, DoubleSize s) {
        this(o.x, o.y, s.width, s.height);
    }

    public DoubleRectangle(DoubleRectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    protected DoubleRectangle() {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    protected boolean valueEquals(DoubleRectangle other) {
        return this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height;
    }

    public boolean equals(Object other) {
        return other.getClass() == DoubleRectangle.class && this.valueEquals((DoubleRectangle)other);
    }

    public int hashCode() {
        if (this.myHashCode == 0) {
            this.myHashCode = new HashCodeBuilder(67, 71).append(this.x).append(this.y).append(this.width).append(this.height).toHashCode();
        }
        return this.myHashCode;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.width + "," + this.height + ")";
    }

    public boolean intersects(DoubleRectangle rect) {
        return rect.x < this.x + this.width && rect.y < this.y + this.height && rect.x + rect.width > this.x && rect.y + rect.height > this.y;
    }

    public boolean intersects(double testX, double testY, double testWidth, double testHeight) {
        return testX < this.x + this.width && testY < this.y + this.height && testX + testWidth > this.x && testY + testHeight > this.y;
    }

    public DoubleRectangle intersect(DoubleRectangle r) {
        double intersectionWidth = this.x + this.width > r.x + r.width ? r.x + r.width - this.x : this.width;
        double intersectionHeight = this.y + this.height > r.y + r.height ? r.y + r.height - this.y : this.height;
        return new DoubleRectangle(Math.max(this.x, r.x), Math.max(this.y, r.y), intersectionWidth, intersectionHeight);
    }

    public DoubleRectangle union(DoubleRectangle r) {
        double unionWidth = this.x + this.width < r.x + r.width ? r.x + r.width - this.x : this.width;
        double unionHeight = this.y + this.height < r.y + r.height ? r.y + r.height - this.y : this.height;
        return new DoubleRectangle(Math.min(this.x, r.x), Math.min(this.y, r.y), unionWidth, unionHeight);
    }
}

