/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ATransitionSource;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Design
extends GlobalAttributed
implements IDesign {
    public static final int edu_cmu_cs_hcii_cogtool_model_Design_version = 0;
    protected static final String nameVAR = "name";
    protected static final String deviceTypesVAR = "deviceTypes";
    protected static final String framesVAR = "frames";
    protected static final String skinVAR = "skin";
    protected String name;
    protected Set deviceTypes;
    protected Set frames = new HashSet();
    protected SkinType skin = SkinType.None;
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            Design v = (Design)value;
            saver.saveString(v.name, Design.nameVAR);
            saver.saveObject(v.deviceTypes, Design.deviceTypesVAR);
            saver.saveObject(v.frames, Design.framesVAR);
            saver.saveObject(v.skin, Design.skinVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new Design();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(Design.nameVAR)) {
                    ((Design)target).name = (String)value;
                } else if (variable.equals(Design.deviceTypesVAR)) {
                    ((Design)target).deviceTypes = (Set)value;
                } else if (variable.equals(Design.skinVAR)) {
                    ((Design)target).skin = (SkinType)value;
                }
            }
        }

        public Collection createCollection(Object target, String variable, int size) {
            if (variable != null) {
                if (variable.equals(Design.deviceTypesVAR)) {
                    ((Design)target).deviceTypes = new HashSet();
                    return ((Design)target).deviceTypes;
                }
                if (variable.equals(Design.framesVAR)) {
                    return ((Design)target).frames;
                }
            }
            return null;
        }

        public ObjectLoader.IAggregateLoader getLoader(String variable) {
            if (variable.equals(Design.framesVAR)) {
                return new ObjectLoader.AAggregateLoader(this){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void addToCollection(ObjectLoader l, Collection c, Object v) {
                        super.addToCollection(l, c, v);
                        Object parent = l.getPendingObject(1);
                        ((IFrame)v).setDesign((IDesign)parent);
                    }
                };
            }
            return super.getLoader(variable);
        }

        protected void evolveTransitionSources(Iterator sources) {
            while (sources.hasNext()) {
                ITransitionSource source = (ITransitionSource)sources.next();
                Collection transitions = source.getTransitions().values();
                int[] indexes = new int[transitions.size()];
                Iterator fixTransitions = transitions.iterator();
                while (fixTransitions.hasNext()) {
                    ITransition t = (ITransition)fixTransitions.next();
                    Iterator testTrans = transitions.iterator();
                    if (t.getCurveIndex() != 0) continue;
                    int newCurveIndex = ATransitionSource.computeCurveIndex(t, testTrans, indexes);
                    t.setCurveIndex(newCurveIndex);
                }
            }
        }

        public void evolve(Object target) {
            IDesign design = (IDesign)target;
            Iterator frames = design.getFrames().iterator();
            while (frames.hasNext()) {
                IFrame frame = (IFrame)frames.next();
                this.evolveTransitionSources(frame.getInputDevices().iterator());
                this.evolveTransitionSources(frame.getWidgets().iterator());
            }
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(Design.class.getName(), SAVER);
    }

    public static ObjectLoader.IObjectLoader getImportLoader() {
        return LOADER;
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(Design.class.getName(), 0, LOADER);
    }

    public static boolean isIdentical(Design l, Design r) {
        return l.name.equals(r.name) && ((Object)l.frames).equals(r.frames) && l.skin.equals(r.skin);
    }

    public Object clone() {
        Design clone = new Design();
        clone.name = this.name;
        clone.frames = new HashSet(this.frames);
        clone.skin = this.skin;
        return clone;
    }

    public Design(String nm, Set devTypes) {
        if (nm == null || nm.equals("")) {
            throw new IllegalArgumentException("Design name cannot be null or empty!");
        }
        this.name = nm;
        this.deviceTypes = devTypes;
    }

    protected Design() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null || newName.equals("")) {
            throw new IllegalArgumentException("Design name cannot be null or empty!");
        }
        this.name = newName;
        this.raiseAlert(new NameChangeAlert(this));
    }

    public Set getDeviceTypes() {
        return this.deviceTypes;
    }

    public WidgetType getDefaultWidgetType() {
        if (this.deviceTypes.contains(DeviceType.Mouse) || this.deviceTypes.contains(DeviceType.Touchscreen)) {
            return WidgetType.Button;
        }
        return WidgetType.Noninteractive;
    }

    public Set getFrames() {
        return this.frames;
    }

    public IFrame getFrame(String frameName) {
        Iterator frameIterator = this.frames.iterator();
        while (frameIterator.hasNext()) {
            IFrame testFrame = (IFrame)frameIterator.next();
            if (!testFrame.getName().equals(frameName)) continue;
            return testFrame;
        }
        return null;
    }

    public void addFrame(IFrame newFrame) {
        if (this.getFrame(newFrame.getName()) != null) {
            throw new IllegalArgumentException("Cannot add frame of the same name to a design.");
        }
        this.frames.add(newFrame);
        newFrame.setDesign(this);
        this.raiseAlert(new IDesign.FrameChange(this, newFrame, true));
    }

    public void addFrames(IFrame[] newFrames) {
        int i;
        for (i = 0; i < newFrames.length; ++i) {
            if (this.getFrame(newFrames[i].getName()) == null) continue;
            throw new IllegalArgumentException("Cannot add frame of the same name to a design.");
        }
        for (i = 0; i < newFrames.length; ++i) {
            this.frames.add(newFrames[i]);
            newFrames[i].setDesign(this);
        }
        this.raiseAlert(new IDesign.FrameSetChange(this, newFrames, true));
    }

    public boolean removeFrame(String frameName) {
        IFrame frameToRemove = this.getFrame(frameName);
        if (frameToRemove != null) {
            return this.removeFrame(frameToRemove);
        }
        return false;
    }

    public boolean removeFrame(IFrame frameToRemove) {
        if (this.frames.remove(frameToRemove)) {
            frameToRemove.removeIncidentTransitions();
            this.raiseAlert(new IDesign.FrameChange(this, frameToRemove, false));
            return true;
        }
        return false;
    }

    public boolean removeFrames(IFrame[] framesToRemove) {
        boolean okRemoval = true;
        for (int i = 0; i < framesToRemove.length; ++i) {
            if (!this.frames.remove(framesToRemove[i])) {
                okRemoval = false;
                break;
            }
            framesToRemove[i].removeIncidentTransitions();
            this.raiseAlert(new IDesign.FrameChange(this, framesToRemove[i], false));
        }
        return okRemoval;
    }

    public IDesign duplicate(String newName) {
        Design designCopy = new Design(newName, this.deviceTypes);
        DesignFrameDuplicator duplicator = new DesignFrameDuplicator(designCopy);
        Iterator frameIt = this.frames.iterator();
        while (frameIt.hasNext()) {
            IFrame childFrameToCopy = (IFrame)frameIt.next();
            duplicator.getOrDuplicate(childFrameToCopy);
        }
        return designCopy;
    }

    public SkinType getSkin() {
        return this.skin;
    }

    public void setSkin(SkinType newSkin) {
        if (newSkin != null) {
            if (this.skin != newSkin) {
                this.skin = newSkin;
                this.raiseAlert(new IDesign.WidgetAppearanceChange(this));
            }
        } else {
            throw new IllegalArgumentException("Skin cannot be null!");
        }
    }

    protected static class DesignFrameDuplicator
    implements IFrame.FrameDuplicator {
        protected IDesign scopeDesign;

        public DesignFrameDuplicator(IDesign design) {
            this.scopeDesign = design;
        }

        public IFrame getOrDuplicate(IFrame frameToCopy) {
            String frameName = frameToCopy.getName();
            IFrame frame = this.scopeDesign.getFrame(frameName);
            if (frame == null) {
                frame = frameToCopy.duplicate(frameName, this);
            }
            return frame;
        }

        public void recordDuplicateFrame(IFrame originalFrame, IFrame frameDuplicate) {
            this.scopeDesign.addFrame(frameDuplicate);
        }
    }
}

