/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ITraceParser;
import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CORETraceParser
implements ITraceParser {
    public List parseTrace(List traceLines) {
        ArrayList<ResultStep> steps = new ArrayList<ResultStep>();
        Iterator traceIterator = traceLines.iterator();
        int currentLine = 0;
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        while (traceIterator.hasNext()) {
            String[] stepComponents;
            String line = ((String)traceIterator.next()).trim();
            if (line.length() > 0 && (stepComponents = line.split(",")).length > 0 && !stepComponents[0].equals("strategy")) {
                ResultStep newStep;
                if (stepComponents.length == 7) {
                    resourceMap.put(stepComponents[4].trim(), stepComponents[3].trim());
                    try {
                        newStep = new ResultStep(Integer.parseInt(stepComponents[1].trim()), Integer.parseInt(stepComponents[2].trim()), stepComponents[3].trim(), stepComponents[6].trim(), "none", currentLine, currentLine + 1);
                    }
                    catch (Exception e) {
                        newStep = null;
                    }
                    if (newStep != null) {
                        try {
                            newStep.colorVal = Integer.parseInt(stepComponents[5].trim(), 16);
                        }
                        catch (Exception e) {
                            newStep.colorVal = 0x999999;
                        }
                        steps.add(newStep);
                    }
                } else if (stepComponents.length == 6) {
                    int startTime = 0;
                    int duration = 0;
                    try {
                        startTime = Integer.parseInt(stepComponents[1].trim());
                        duration = Integer.parseInt(stepComponents[3].trim()) - startTime;
                        String resource = (String)resourceMap.get(stepComponents[2].trim());
                        String targetResource = (String)resourceMap.get(stepComponents[4].trim());
                        if (resource != null && targetResource != null) {
                            newStep = new ResultStep(startTime, duration, resource, "Cascade", "none", currentLine, currentLine + 1);
                            newStep.targetResource = targetResource;
                        } else {
                            newStep = null;
                        }
                    }
                    catch (Exception e) {
                        newStep = null;
                    }
                    if (newStep != null) {
                        try {
                            int redVal = Integer.parseInt(stepComponents[5].substring(0, 2), 16);
                            int greenVal = Integer.parseInt(stepComponents[5].substring(2, 4), 16);
                            int blueVal = Integer.parseInt(stepComponents[5].substring(4), 16);
                            redVal += (int)((double)(255 - redVal) * 0.5);
                            greenVal += (int)((double)(255 - greenVal) * 0.5);
                            blueVal += (int)((double)(255 - blueVal) * 0.5);
                            newStep.colorVal = redVal * 65536 + greenVal * 256 + blueVal;
                        }
                        catch (Exception e) {
                            newStep.colorVal = 0xBBBBBB;
                        }
                        steps.add(newStep);
                    }
                }
            }
            ++currentLine;
        }
        return steps;
    }
}

