/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.AAction;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IButtonAction;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ButtonAction
extends AAction
implements IButtonAction {
    public static final int edu_cmu_cs_hcii_cogtool_model_ButtonAction_version = 0;
    protected static final String buttonVAR = "button";
    protected static final String pressTypeVAR = "pressType";
    protected static final String modifiersVAR = "modifiers";
    protected MouseButtonState button;
    protected MousePressType pressType;
    protected int modifiers = 0;
    private int myHashCode = this.hashCode();
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            ButtonAction v = (ButtonAction)value;
            saver.saveObject(v.button, ButtonAction.buttonVAR);
            saver.saveObject(v.pressType, ButtonAction.pressTypeVAR);
            saver.saveInt(v.modifiers, ButtonAction.modifiersVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public Object createObject() {
            return new ButtonAction();
        }

        public void set(Object target, String variable, Object value) {
            if (variable != null) {
                if (variable.equals(ButtonAction.buttonVAR)) {
                    ((ButtonAction)target).button = (MouseButtonState)value;
                } else if (variable.equals(ButtonAction.pressTypeVAR)) {
                    if (MousePressType.Hover == (MousePressType)value) {
                        ((ButtonAction)target).actionType = ActionType.MouseOver;
                    }
                    ((ButtonAction)target).pressType = (MousePressType)value;
                }
            }
        }

        public void set(Object target, String variable, int value) {
            if (variable != null && variable.equals(ButtonAction.modifiersVAR)) {
                ((ButtonAction)target).modifiers = value;
            }
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(ButtonAction.class.getName(), SAVER);
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(ButtonAction.class.getName(), 0, LOADER);
    }

    public ButtonAction(MouseButtonState btn, MousePressType clk, int modifiers) {
        super(clk == MousePressType.Hover ? ActionType.MouseOver : ActionType.ButtonPress);
        this.button = btn;
        this.pressType = clk;
        this.modifiers = modifiers;
    }

    protected ButtonAction() {
        super(ActionType.ButtonPress);
    }

    public MouseButtonState getButton() {
        return this.button;
    }

    public void setButton(MouseButtonState btn) {
        this.button = btn;
    }

    public MousePressType getPressType() {
        return this.pressType;
    }

    public void setPressType(MousePressType clk) {
        this.pressType = clk;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int newState) {
        this.modifiers = newState;
    }

    public IAction duplicate() {
        return new ButtonAction(this.button, this.pressType, this.modifiers);
    }

    public String getLocalizedString() {
        String buttonStr = "";
        buttonStr = this.button == null ? "" : this.button.toString() + " ";
        String clickStr = this.pressType.toString();
        if (this.modifiers == 0) {
            return buttonStr + clickStr;
        }
        String stateStr = "";
        String separator = "";
        if ((this.modifiers & 0x10) != 0) {
            stateStr = L10N.get("BACT.FUNCTION", "FN");
            separator = "-";
        }
        if ((this.modifiers & 8) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.COMMAND", "COMMAND");
            separator = "-";
        }
        if ((this.modifiers & 2) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.CTRL", "CTRL");
            separator = "-";
        }
        if ((this.modifiers & 4) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.ALT", "ALT");
            separator = "-";
        }
        if ((this.modifiers & 1) != 0) {
            stateStr = stateStr + separator + L10N.get("BACT.SHIFT", "SHIFT");
            separator = "-";
        }
        return stateStr + " " + buttonStr + " " + clickStr;
    }

    public void accept(IAction.IActionVisitor visitor) {
        visitor.visit(this);
    }

    protected boolean valueEquals(ButtonAction other) {
        return super.valueEquals(other) && this.button == other.getButton() && this.pressType == other.getPressType() && this.modifiers == other.getModifiers();
    }

    public boolean equals(Object other) {
        return other.getClass() == ButtonAction.class && this.valueEquals((ButtonAction)other);
    }

    public int hashCode() {
        if (this.myHashCode == 0) {
            this.myHashCode = new HashCodeBuilder(53, 91).appendSuper(super.hashCode()).append((Object)this.getButton()).append((Object)this.getPressType()).append(this.getModifiers()).toHashCode();
        }
        return this.myHashCode;
    }
}

