/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.AAction;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IScriptStepGeneration;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.RecordedBehavior;
import edu.cmu.cs.hcii.cogtool.model.Script;
import edu.cmu.cs.hcii.cogtool.model.TaskApplication;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.Subprocess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class BehaviorRecorder {
    public static RecordedBehavior captureUserBehavior(boolean screenCapEveryKeystroke) {
        IInputDevice device;
        IAction action;
        IWidget widget;
        IFrame frame;
        IFrame lastFrame;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
            tempDir = tempDir + System.getProperty("file.separator");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<IFrame> frames = new ArrayList<IFrame>();
        ArrayList<IWidget> widgets = new ArrayList<IWidget>();
        ArrayList<AAction> actions = new ArrayList<AAction>();
        ArrayList<IInputDevice> devices = new ArrayList<IInputDevice>();
        String fName = tempDir + "ruilog.txt";
        fileNames.add(fName);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(new File("bin", "rui").getPath());
        if (screenCapEveryKeystroke) {
            cmds.add("-k");
        }
        cmds.add(fName);
        LinkedList traceLines = new LinkedList();
        LinkedList errorLines = new LinkedList();
        Subprocess.exec(cmds, traceLines, errorLines);
        int counter = 1;
        String designName = "Demonstrated Design";
        HashSet<DeviceType> deviceSet = new HashSet<DeviceType>();
        deviceSet.add(DeviceType.Keyboard);
        deviceSet.add(DeviceType.Mouse);
        Design newDesign = new Design(designName, deviceSet);
        String typedString = "";
        String filePath = tempDir;
        try {
            String line;
            BufferedReader logReader = new BufferedReader(new FileReader(new File(filePath + "ruilog.txt")));
            int lastx = 0;
            int lasty = 0;
            Object lastWidget = null;
            lastFrame = null;
            IInputDevice lastDevice = null;
            frame = null;
            widget = null;
            action = null;
            device = null;
            double frameWidth = 1.0;
            double frameHeight = 1.0;
            while ((line = logReader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String[] eventComponents = line.split("\t");
                System.out.println("got a good line (" + eventComponents.length + "): " + line);
                if (eventComponents.length == 2 && eventComponents[1].equals("Captured screen") && !eventComponents[0].equals("0")) {
                    Transition transition;
                    String tStampStr = eventComponents[0].trim();
                    String imgFile = filePath + "ruilog.txt" + tStampStr + ".png";
                    fileNames.add(imgFile);
                    byte[] imageData = GraphicsUtil.loadImageFromFile(imgFile);
                    DoubleRectangle imageSize = GraphicsUtil.getImageBounds(imageData);
                    lastFrame = frame;
                    lastDevice = device;
                    System.out.println("Creating new frame...");
                    frame = new Frame("Frame" + counter, newDesign.getDeviceTypes());
                    frame.setBackgroundImage(imageData, imageSize);
                    if (lastFrame == null) {
                        DoubleRectangle bRect = frame.getBackgroundBounds();
                        frameWidth = bRect.width / 3.0;
                        frameHeight = bRect.height / 3.0;
                    }
                    double frameX = (double)((counter - 1) % 5) * frameWidth;
                    double frameY = Math.floor((counter - 1) / 5) * frameHeight;
                    frame.setFrameOrigin(frameX, frameY);
                    device = frame.getInputDevice(DeviceType.Keyboard);
                    if (typedString.length() > 0) {
                        KeyAction kAction = new KeyAction(typedString, false, 0);
                        transition = new Transition(lastDevice, frame, kAction);
                        System.out.println("Made transition");
                        lastDevice.addTransition(transition);
                        newDesign.addFrame(frame);
                        ++counter;
                        action = kAction;
                        actions.add(kAction);
                        frames.add(lastFrame);
                        widgets.add(null);
                        devices.add(lastDevice);
                        if (widget == null) {
                            typedString = "";
                        }
                    }
                    if (widget == null) continue;
                    if (typedString.length() > 0) {
                        lastFrame.removeWidget(widget);
                        frame.addWidget(widget);
                        lastFrame = frame;
                        lastDevice = device;
                        System.out.println("Creating new frame...");
                        frame = new Frame("Frame" + counter, newDesign.getDeviceTypes());
                        frame.setBackgroundImage(imageData, imageSize);
                        if (lastFrame == null) {
                            DoubleRectangle bRect = frame.getBackgroundBounds();
                            frameWidth = bRect.width / 3.0;
                            frameHeight = bRect.height / 3.0;
                        }
                        frameX = (double)((counter - 1) % 5) * frameWidth;
                        frameY = Math.floor((counter - 1) / 5) * frameHeight;
                        frame.setFrameOrigin(frameX, frameY);
                        device = frame.getInputDevice(DeviceType.Keyboard);
                    }
                    ButtonAction bAction = new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0);
                    transition = new Transition(widget, frame, bAction);
                    newDesign.addFrame(frame);
                    ++counter;
                    widget.addTransition(transition);
                    actions.add(bAction);
                    frames.add(lastFrame);
                    widgets.add(widget);
                    devices.add(lastDevice);
                    widget = null;
                    typedString = "";
                    continue;
                }
                if (eventComponents.length == 4 && eventComponents[1].equals("Moved")) {
                    lastx = Integer.parseInt(eventComponents[2]);
                    lasty = Integer.parseInt(eventComponents[3]);
                    System.out.println("lastx: " + lastx + " lasty: " + lasty);
                    continue;
                }
                if (eventComponents.length == 3 && eventComponents[1].equals("Pressed")) {
                    widget = new Widget(new DoubleRectangle(lastx - 50, lasty - 50, 100.0, 100.0));
                    widget.setName("Widget" + counter);
                    frame.addWidget(widget);
                    continue;
                }
                if (eventComponents.length < 3 || !eventComponents[1].equals("KEY") || lastFrame == null) continue;
                String[] cmdArray = eventComponents[eventComponents.length - 1].split(" ");
                for (int c = 0; c < cmdArray.length; ++c) {
                    if (cmdArray[c].equals("+")) continue;
                    typedString = cmdArray[c].equals("RETURN") ? typedString + "'" : (cmdArray[c].equals("SPACE") ? typedString + " " : (cmdArray[c].equals("SHIFT") ? typedString + "z" : (cmdArray[c].equals("RSHIFT") ? typedString + "/" : (cmdArray[c].equals("COMMAND") ? typedString + "x" : (cmdArray[c].equals("OPTION") ? typedString + "z" : (cmdArray[c].equals("ROPTION") ? typedString + "/" : (cmdArray[c].equals("CTRL") ? typedString + "z" : (cmdArray[c].equals("RCTRL") ? typedString + "/" : (cmdArray[c].equals("DELETE") ? typedString + "\\" : typedString + cmdArray[c])))))))));
                }
            }
        }
        catch (Exception e) {
            System.out.println("oops:" + e.getMessage());
            return null;
        }
        Iterator fIt = fileNames.iterator();
        while (fIt.hasNext()) {
            String fn = (String)fIt.next();
            if (new File(fn).delete()) continue;
            System.out.println("Could not delete " + fn);
        }
        TaskApplication ta = new TaskApplication();
        Script newScript = new Script(newDesign);
        IScriptStepGeneration gen = newScript.getScriptGenerator();
        lastFrame = null;
        if (frames.size() > 0) {
            for (int x = 0; x < frames.size(); ++x) {
                frame = (IFrame)frames.get(x);
                widget = (IWidget)widgets.get(x);
                action = (IAction)actions.get(x);
                device = (IInputDevice)devices.get(x);
                if (x == 0) {
                    newScript.setStartFrame(frame);
                    continue;
                }
                if (widget == null && action != null) {
                    ArrayList newSteps = gen.produceDeviceScriptSteps(action, device, frame);
                    newScript.addScriptSteps(newSteps);
                    continue;
                }
                if (action == null) continue;
                ArrayList newSteps = gen.produceScriptSteps(action, widget, frame);
                newScript.addScriptSteps(newSteps);
            }
        }
        RecordedBehavior recording = new RecordedBehavior(newDesign, newScript);
        return recording;
    }
}

