/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ATransitionSource
extends GlobalAttributed
implements ITransitionSource {
    public static final int edu_cmu_cs_hcii_cogtool_model_ATransitionSource_version = 0;
    protected static final String nameVAR = "name";
    protected static final String transitionsVAR = "transitions";
    protected IFrame frame;
    protected String name = "";
    protected Map transitions = new HashMap();
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            ATransitionSource v = (ATransitionSource)value;
            saver.saveString(v.name, ATransitionSource.nameVAR);
            Object purpose = saver.getPurpose();
            if (purpose != IProject.FILE_PERSISTENCE && purpose != "EntireDesign") {
                saver.saveObject(new HashMap(), ATransitionSource.transitionsVAR);
                Iterator transitionsToBeFiltered = v.transitions.values().iterator();
                while (transitionsToBeFiltered.hasNext()) {
                    ITransition t = (ITransition)transitionsToBeFiltered.next();
                    saver.filterObject(t);
                }
            } else {
                saver.saveObject(v.transitions, ATransitionSource.transitionsVAR);
            }
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public void set(Object target, String variable, Object value) {
            if (variable != null && variable.equals(ATransitionSource.nameVAR)) {
                ((ATransitionSource)target).name = (String)value;
            }
        }

        public Map createMap(Object target, String variable, int size) {
            if (variable != null && variable.equals(ATransitionSource.transitionsVAR)) {
                return ((ATransitionSource)target).transitions;
            }
            return null;
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(ATransitionSource.class.getName(), SAVER);
    }

    protected static ObjectLoader.IObjectLoader getImportLoader() {
        return LOADER;
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(ATransitionSource.class.getName(), 0, LOADER);
    }

    protected ATransitionSource() {
    }

    public IFrame getFrame() {
        return this.frame;
    }

    public void setFrame(IFrame f) {
        this.frame = f;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    public Map getTransitions() {
        return this.transitions;
    }

    public void addTransition(ITransition newTransition) {
        IAction action = newTransition.getAction();
        if (this.transitions.containsKey(action)) {
            throw new IllegalArgumentException("Cannot add transition with the same action to a source.");
        }
        this.assignCurveIndex(newTransition);
        this.transitions.put(action, newTransition);
        newTransition.getDestination().addIncidentTransition(newTransition);
        this.raiseAlert(new ITransitionSource.TransitionChange(this, newTransition, true));
    }

    public void assignCurveIndex(ITransition transition) {
        Iterator testTransitions = this.transitions.values().iterator();
        int[] indexes = new int[this.transitions.size()];
        transition.setCurveIndex(ATransitionSource.computeCurveIndex(transition, testTransitions, indexes));
    }

    public static int computeCurveIndex(ITransition transition, Iterator transitions, int[] indexes) {
        IFrame destination = transition.getDestination();
        int count = 0;
        while (transitions.hasNext()) {
            int curveIndex;
            ITransition t = (ITransition)transitions.next();
            if (t == transition || t.getDestination() != destination || (curveIndex = t.getCurveIndex()) == 0) continue;
            indexes[count++] = curveIndex;
        }
        if (count > 0) {
            Arrays.sort(indexes, 0, count);
            for (int i = 0; i < count; ++i) {
                if (indexes[i] <= i + 1) continue;
                return i + 1;
            }
        }
        return count + 1;
    }

    public ITransition removeTransition(IAction action) {
        ITransition transition = (ITransition)this.transitions.remove(action);
        if (transition != null) {
            transition.getDestination().removeIncidentTransition(transition);
            this.raiseAlert(new ITransitionSource.TransitionChange(this, transition, false));
            return transition;
        }
        return null;
    }

    public ITransition removeTransition(ITransition transition) {
        return this.removeTransition(transition.getAction());
    }

    public ITransition getTransition(IAction action) {
        return (ITransition)this.transitions.get(action);
    }

    public void resetAction(ITransition transition, IAction oldAction) {
        this.transitions.remove(oldAction);
        this.transitions.put(transition.getAction(), transition);
    }

    public void duplicateTransitions(ITransitionSource sourceCopy, IFrame.FrameDuplicator duplicator) {
        Iterator transitionIt = this.transitions.values().iterator();
        while (transitionIt.hasNext()) {
            ITransition childTransition = (ITransition)transitionIt.next();
            sourceCopy.addTransition(childTransition.duplicate(sourceCopy, duplicator));
        }
    }
}

