/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IShape;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import java.io.IOException;
import java.security.InvalidParameterException;

public abstract class AShape
implements IShape {
    public static final int edu_cmu_cs_hcii_cogtool_model_AShape_version = 0;
    protected static final String rVAR = "r";
    protected DoubleRectangle r;
    private static ObjectSaver.IDataSaver SAVER = new ObjectSaver.ADataSaver(){

        public int getVersion() {
            return 0;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            saver.saveObject(((AShape)value).r, AShape.rVAR);
        }
    };
    private static ObjectLoader.IObjectLoader LOADER = new ObjectLoader.AObjectLoader(){

        public void set(Object target, String variable, Object value) {
            if (variable != null && variable.equals(AShape.rVAR)) {
                ((AShape)target).r = (DoubleRectangle)value;
            }
        }
    };

    public static void registerSaver() {
        ObjectSaver.registerSaver(AShape.class.getName(), SAVER);
    }

    public static void registerLoader() {
        ObjectLoader.registerLoader(AShape.class.getName(), 0, LOADER);
    }

    public abstract Object clone();

    public String toString() {
        return this.getBounds().toString();
    }

    public AShape(DoubleRectangle inRec) {
        this.setBounds(inRec);
    }

    public AShape(double x, double y, double width, double height) {
        this.r = new DoubleRectangle(x, y, width, height);
    }

    protected AShape() {
    }

    public DoublePoint getOrigin() {
        return new DoublePoint(this.r.x, this.r.y);
    }

    public DoubleRectangle getBounds() {
        return this.r;
    }

    public DoubleSize getSize() {
        return new DoubleSize(this.r.width, this.r.height);
    }

    public void setSize(double width, double height) {
        if (Math.round(height) == 0L || Math.round(width) == 0L) {
            throw new InvalidParameterException("New rectangle's height or width is too close to zero");
        }
        if (this.r.width != width) {
            this.r.width = width;
        }
        if (this.r.height != height) {
            this.r.height = height;
        }
    }

    public void setSize(DoubleSize s) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot set the Size of a Shape to NULL");
        }
        this.setSize(s.width, s.height);
    }

    public void setOrigin(double x, double y) {
        if (this.r.x != x) {
            this.r.x = x;
        }
        if (this.r.y != y) {
            this.r.y = y;
        }
    }

    public void setOrigin(DoublePoint p) {
        if (p == null) {
            throw new IllegalArgumentException("Cannot set the Origin of a Shape to NULL");
        }
        this.setOrigin(p.x, p.y);
    }

    public void setBounds(DoubleRectangle rec) {
        if (rec == null) {
            throw new IllegalArgumentException("Cannot set the Bounds of a Shape to NULL");
        }
        if (Math.round(rec.height) == 0L || Math.round(rec.width) == 0L) {
            throw new InvalidParameterException("New rectangle's height or width is too close to zero");
        }
        this.r = rec;
    }

    public boolean sameBounds(IShape lhs) {
        return lhs.getBounds().equals(this.getBounds());
    }

    public boolean intersectBounds(IShape lhs) {
        return lhs.getBounds().intersects(this.getBounds());
    }
}

