/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ITraceParser;
import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ACTR6TraceParser
implements ITraceParser {
    public List parseTrace(List traceLines) {
        ArrayList<ResultStep> steps = new ArrayList<ResultStep>();
        Iterator lIt = traceLines.iterator();
        double timeStamp = -1.0;
        int currentLineNum = 0;
        double lastVisionEncodingTime = 0.0;
        int visionLineEncodingStart = 0;
        double lastVisionPrepTime = 0.0;
        int visionLinePrepStart = 0;
        double lastVisionMoveTime = 0.0;
        int visionLineMoveStart = 0;
        ResultStep visionPreceedingProductionStep = null;
        int productionState = 0;
        String productionName = null;
        double lastProductionTime = 0.0;
        int productionLineStart = 0;
        ResultStep lastProductionStep = null;
        String currentFrameName = null;
        double lastFrameTime = 0.0;
        int frameLineStart = 0;
        ResultStep productionStepBeforeFrame = null;
        LinkedList<ITraceParser.InterimResultState> motorStates = new LinkedList<ITraceParser.InterimResultState>();
        ITraceParser.InterimResultState mState = null;
        ResultStep newStep = null;
        while (lIt.hasNext()) {
            block57: {
                String[] words;
                block59: {
                    block58: {
                        String line = (String)lIt.next();
                        words = line.split("\\p{Space}+");
                        try {
                            String timeString = words[1];
                            timeString = timeString.substring(0, timeString.length());
                            timeStamp = Double.parseDouble(timeString);
                        }
                        catch (Exception e) {
                            timeStamp = -1.0;
                        }
                        if (!(timeStamp >= 0.0) || words.length <= 3) break block57;
                        if (!words[2].equals("MOTOR")) break block58;
                        if (words[3].equals("MOVE-CURSOR")) {
                            mState = new ITraceParser.InterimResultState();
                            mState.actionName = words[3];
                            mState.state = 1;
                            mState.type = 1;
                            mState.lineStart = currentLineNum;
                            mState.lastTime = timeStamp;
                            mState.preceedingProductionStep = lastProductionStep;
                            motorStates.add(mState);
                        } else if (words[3].equals("CLICK-MOUSE")) {
                            mState = new ITraceParser.InterimResultState();
                            mState.actionName = words[3];
                            mState.state = 1;
                            mState.type = 2;
                            mState.lineStart = currentLineNum;
                            mState.lastTime = timeStamp;
                            mState.preceedingProductionStep = lastProductionStep;
                            motorStates.add(mState);
                        } else if (words[3].equals("HAND-TO-HOME") || words[3].equals("HAND-TO-MOUSE")) {
                            mState = new ITraceParser.InterimResultState();
                            mState.actionName = words[3];
                            mState.state = 1;
                            mState.type = 3;
                            mState.lineStart = currentLineNum;
                            mState.lastTime = timeStamp;
                            mState.preceedingProductionStep = lastProductionStep;
                            motorStates.add(mState);
                        } else if (words[3].equals("PRESS-KEY")) {
                            mState = new ITraceParser.InterimResultState();
                            mState.actionName = words[3];
                            mState.state = 1;
                            mState.type = 4;
                            mState.lineStart = currentLineNum;
                            mState.lastTime = timeStamp;
                            mState.preceedingProductionStep = lastProductionStep;
                            motorStates.add(mState);
                        } else if (words[3].equals("GRAFFITI-GESTURE")) {
                            mState = new ITraceParser.InterimResultState();
                            mState.actionName = words[3];
                            mState.state = 1;
                            mState.type = 5;
                            mState.lineStart = currentLineNum;
                            mState.lastTime = timeStamp;
                            mState.preceedingProductionStep = lastProductionStep;
                            motorStates.add(mState);
                        } else if (words[3].equals("PREPARE")) {
                            String actionName = "";
                            for (int x = 3; x < words.length; ++x) {
                                if (x > 3) {
                                    actionName = actionName + " ";
                                }
                                actionName = actionName + words[x];
                            }
                            mState = new ITraceParser.InterimResultState();
                            mState.actionName = actionName;
                            mState.state = 1;
                            mState.type = 0;
                            mState.lineStart = currentLineNum;
                            mState.lastTime = timeStamp;
                            mState.preceedingProductionStep = lastProductionStep;
                            motorStates.add(mState);
                        } else if (words[3].equals("PREPARATION-COMPLETE")) {
                            boolean stateFound = false;
                            int mCnt = 0;
                            while (mCnt < motorStates.size() && !stateFound) {
                                mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                if (mState.state == 1) {
                                    stateFound = true;
                                    continue;
                                }
                                ++mCnt;
                            }
                            if (stateFound) {
                                newStep = new ResultStep(mState.lastTime * 1000.0, (timeStamp - mState.lastTime) * 1000.0, ResultStep.MOTOR_PREP_RESOURCE, mState.actionName);
                                newStep.traceStart = mState.lineStart;
                                newStep.traceEnd = currentLineNum + 1;
                                if (mState.preceedingProductionStep != null) {
                                    newStep.addDependency(mState.preceedingProductionStep);
                                }
                                steps.add(newStep);
                                mState.lastResultStep = newStep;
                                mState.lastTime = timeStamp;
                                mState.lineStart = currentLineNum;
                                mState.state = mState.type == 0 ? 5 : 4;
                            }
                        } else if (words[3].equals("FINISH-MOVEMENT")) {
                            boolean stateFound = false;
                            int mCnt = 0;
                            while (mCnt < motorStates.size() && !stateFound) {
                                mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                if (mState.state == 4) {
                                    stateFound = true;
                                    continue;
                                }
                                if (mState.type == 5 && mState.state == 3) {
                                    stateFound = true;
                                    continue;
                                }
                                ++mCnt;
                            }
                            if (stateFound) {
                                newStep = new ResultStep(mState.lastTime * 1000.0, (timeStamp - mState.lastTime) * 1000.0, ResultStep.MOTOR_EXEC_RESOURCE, mState.actionName);
                                newStep.traceStart = mState.lineStart;
                                newStep.traceEnd = currentLineNum + 1;
                                if (mState.lastResultStep != null) {
                                    newStep.addDependency(mState.lastResultStep);
                                }
                                steps.add(newStep);
                                mState.lastResultStep = newStep;
                                mState.lineStart = currentLineNum;
                                mState.lastTime = timeStamp;
                                mState.state = 5;
                            }
                        }
                        break block57;
                    }
                    if (!words[2].equals("PROCEDURAL")) break block59;
                    switch (productionState) {
                        case 1: {
                            if (words[3].equals("PRODUCTION-FIRED")) {
                                newStep = new ResultStep(lastProductionTime * 1000.0, (timeStamp - lastProductionTime) * 1000.0, ResultStep.PRODUCTIONS_RESOURCE, words[4]);
                                newStep.traceStart = productionLineStart;
                                newStep.traceEnd = currentLineNum + 1;
                                lastProductionStep = newStep;
                                steps.add(newStep);
                                productionState = 2;
                                lastProductionTime = timeStamp;
                                break;
                            }
                            break block57;
                        }
                        default: {
                            if (words[3].equals("PRODUCTION-SELECTED")) {
                                productionLineStart = currentLineNum;
                                lastProductionTime = timeStamp;
                                productionState = 1;
                                productionName = words[4];
                                break;
                            }
                            break block57;
                        }
                    }
                    break block57;
                }
                if (words[2].equals("VISION")) {
                    if (words[3].equals("Move-attention")) {
                        visionPreceedingProductionStep = lastProductionStep;
                        visionLineEncodingStart = currentLineNum;
                        lastVisionEncodingTime = timeStamp;
                    } else if (words[3].equals("Encoding-Complete")) {
                        if (lastVisionEncodingTime > 0.0) {
                            newStep = new ResultStep(lastVisionEncodingTime * 1000.0, (timeStamp - lastVisionEncodingTime) * 1000.0, ResultStep.VISION_ENC_RESOURCE, "Encoding " + words[4]);
                            newStep.traceStart = visionLineEncodingStart;
                            newStep.traceEnd = currentLineNum + 1;
                            if (visionPreceedingProductionStep != null) {
                                newStep.addDependency(visionPreceedingProductionStep);
                            }
                            steps.add(newStep);
                            lastVisionEncodingTime = 0.0;
                        }
                    } else if (words[3].equals("PREPARE-EYE-MOVEMENT")) {
                        lastVisionPrepTime = timeStamp;
                        visionLinePrepStart = currentLineNum;
                        lastVisionMoveTime = 0.0;
                        visionLineMoveStart = 0;
                    } else if (words[3].equals("Preparation-complete")) {
                        lastVisionMoveTime = timeStamp;
                        visionLineMoveStart = currentLineNum;
                    } else if (words[3].equals("Complete-eye-movement") && lastVisionPrepTime > 0.0 && lastVisionMoveTime > 0.0) {
                        ResultStep prepStep = new ResultStep(lastVisionPrepTime * 1000.0, (lastVisionMoveTime - lastVisionPrepTime) * 1000.0, ResultStep.VISION_PREP_RESOURCE, "Eye Prep");
                        prepStep.traceStart = visionLinePrepStart;
                        prepStep.traceEnd = visionLineMoveStart + 1;
                        steps.add(prepStep);
                        newStep = new ResultStep(lastVisionMoveTime * 1000.0, (timeStamp - lastVisionMoveTime) * 1000.0, ResultStep.VISION_EXEC_RESOURCE, "Eye Movement");
                        newStep.traceStart = visionLineMoveStart;
                        newStep.traceEnd = currentLineNum + 1;
                        newStep.addDependency(prepStep);
                        steps.add(newStep);
                        lastVisionPrepTime = 0.0;
                        visionLinePrepStart = 0;
                        lastVisionMoveTime = 0.0;
                        visionLineMoveStart = 0;
                    }
                } else if (words[2].equals("COGTOOL")) {
                    if (words[3].equals("SET-INITIAL-FRAME")) {
                        currentFrameName = words[4];
                        lastFrameTime = timeStamp;
                        frameLineStart = currentLineNum;
                        productionStepBeforeFrame = lastProductionStep;
                    } else if (words[3].equals("TRANSITION-TO")) {
                        if (currentFrameName != null) {
                            newStep = new ResultStep(lastFrameTime * 1000.0, (timeStamp - lastFrameTime) * 1000.0, ResultStep.FRAME_RESOURCE, currentFrameName);
                            newStep.traceStart = frameLineStart;
                            newStep.traceEnd = currentLineNum + 1;
                            if (productionStepBeforeFrame != null) {
                                // empty if block
                            }
                            steps.add(newStep);
                        }
                        currentFrameName = words[4];
                        lastFrameTime = timeStamp;
                        frameLineStart = currentLineNum;
                        productionStepBeforeFrame = lastProductionStep;
                    } else if (words[3].equals("START-SCRIPT-STEP")) {
                        // empty if block
                    }
                } else if (words[2].equals("------")) {
                    newStep = new ResultStep(lastFrameTime * 1000.0, (timeStamp - lastFrameTime) * 1000.0, ResultStep.FRAME_RESOURCE, currentFrameName);
                    newStep.traceStart = frameLineStart;
                    newStep.traceEnd = currentLineNum + 1;
                    steps.add(newStep);
                }
            }
            ++currentLineNum;
        }
        return steps;
    }
}

