/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.model;

import edu.cmu.cs.hcii.cogtool.model.ITraceParser;
import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ACTR5TraceParser
implements ITraceParser {
    public List parseTrace(List traceLines) {
        ArrayList<ResultStep> steps = new ArrayList<ResultStep>();
        Iterator lIt = traceLines.iterator();
        double timeStamp = -1.0;
        int currentLineNum = 0;
        int visionState = 0;
        double lastVisionTime = 0.0;
        int visionLineStart = 0;
        ResultStep visionPreceedingProductionStep = null;
        String productionName = null;
        double lastProductionTime = 0.0;
        int productionLineStart = 0;
        ResultStep lastProductionStep = null;
        String currentFrameName = null;
        double lastFrameTime = 0.0;
        int frameLineStart = 0;
        LinkedList<ITraceParser.InterimResultState> motorStates = new LinkedList<ITraceParser.InterimResultState>();
        ITraceParser.InterimResultState mState = null;
        ResultStep newStep = null;
        while (lIt.hasNext()) {
            String line = (String)lIt.next();
            String[] words = line.split("\\p{Space}+");
            try {
                if (words[1].equals("Time")) {
                    int mCnt;
                    boolean stateFound;
                    String timeString = words[2];
                    timeString = timeString.substring(0, timeString.length() - 1);
                    timeStamp = Double.parseDouble(timeString);
                    if (words[3].equals("Module")) {
                        if (words[4].equals(":MOTOR")) {
                            if (words[7].equals("PREPARATION-COMPLETE")) {
                                stateFound = false;
                                mCnt = 0;
                                while (mCnt < motorStates.size() && !stateFound) {
                                    mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                    if (mState.state == 1) {
                                        stateFound = true;
                                        continue;
                                    }
                                    ++mCnt;
                                }
                                if (stateFound) {
                                    newStep = new ResultStep(mState.lastTime * 1000.0, (timeStamp - mState.lastTime) * 1000.0, ResultStep.MOTOR_PREP_RESOURCE, "Preparing " + mState.actionName);
                                    newStep.traceStart = mState.lineStart;
                                    newStep.traceEnd = currentLineNum + 1;
                                    if (mState.preceedingProductionStep != null) {
                                        newStep.addDependency(mState.preceedingProductionStep);
                                    }
                                    steps.add(newStep);
                                    mState.lastResultStep = newStep;
                                    mState.lastTime = timeStamp;
                                    mState.lineStart = currentLineNum;
                                    mState.state = mState.actionName.equals("PREPARE") ? 5 : 2;
                                }
                            } else if (words[7].equals("INITIATION-COMPLETE")) {
                                stateFound = false;
                                mCnt = 0;
                                while (mCnt < motorStates.size() && !stateFound) {
                                    mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                    if (mState.state == 2) {
                                        stateFound = true;
                                        continue;
                                    }
                                    ++mCnt;
                                }
                                if (stateFound) {
                                    newStep = new ResultStep(mState.lastTime * 1000.0, (timeStamp - mState.lastTime) * 1000.0, ResultStep.MOTOR_INIT_RESOURCE, "Initializing " + mState.actionName);
                                    newStep.traceStart = mState.lineStart;
                                    newStep.traceEnd = currentLineNum + 1;
                                    if (mState.lastResultStep != null) {
                                        newStep.addDependency(mState.lastResultStep);
                                    }
                                    steps.add(newStep);
                                    mState.lastResultStep = newStep;
                                    mState.lineStart = currentLineNum;
                                    mState.lastTime = timeStamp;
                                    mState.state = 3;
                                }
                            } else if (words[7].equals("MOVE-A-HAND")) {
                                stateFound = false;
                                mCnt = 0;
                                while (mCnt < motorStates.size() && !stateFound) {
                                    mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                    if (mState.state == 3) {
                                        stateFound = true;
                                        continue;
                                    }
                                    ++mCnt;
                                }
                                if (stateFound) {
                                    mState.lastTime = timeStamp;
                                    mState.lineStart = currentLineNum;
                                    mState.state = 4;
                                }
                            } else if (words[7].equals("FINISH-MOVEMENT")) {
                                stateFound = false;
                                mCnt = 0;
                                while (mCnt < motorStates.size() && !stateFound) {
                                    mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                    if (mState.state == 4) {
                                        stateFound = true;
                                        continue;
                                    }
                                    ++mCnt;
                                }
                                if (stateFound) {
                                    newStep = new ResultStep(mState.lastTime * 1000.0, (timeStamp - mState.lastTime) * 1000.0, ResultStep.MOTOR_EXEC_RESOURCE, "Executing " + mState.actionName);
                                    newStep.traceStart = mState.lineStart;
                                    newStep.traceEnd = currentLineNum + 1;
                                    if (mState.lastResultStep != null) {
                                        newStep.addDependency(mState.lastResultStep);
                                    }
                                    steps.add(newStep);
                                    mState.lastResultStep = newStep;
                                    mState.lineStart = currentLineNum;
                                    mState.lastTime = timeStamp;
                                    mState.state = 5;
                                }
                            } else {
                                stateFound = false;
                                mCnt = 0;
                                while (mCnt < motorStates.size() && !stateFound) {
                                    mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                                    if (mState.state == 1) {
                                        stateFound = true;
                                        continue;
                                    }
                                    ++mCnt;
                                }
                                if (stateFound) {
                                    newStep = new ResultStep(mState.lastTime * 1000.0, 0.0, ResultStep.MOTOR_PREP_RESOURCE, "NOOP " + mState.actionName);
                                    newStep.traceStart = mState.lineStart;
                                    newStep.traceEnd = mState.lineStart + 10;
                                    if (mState.preceedingProductionStep != null) {
                                        newStep.addDependency(mState.preceedingProductionStep);
                                    }
                                    steps.add(newStep);
                                    mState.lastResultStep = newStep;
                                    mState.lineStart = currentLineNum;
                                    mState.lastTime = timeStamp;
                                    mState.state = 5;
                                }
                                mState = new ITraceParser.InterimResultState();
                                mState.actionName = words[7];
                                mState.state = 1;
                                mState.lineStart = currentLineNum;
                                mState.lastTime = timeStamp;
                                mState.preceedingProductionStep = lastProductionStep;
                                motorStates.add(mState);
                            }
                        } else if (words[4].equals(":VISION")) {
                            switch (visionState) {
                                case 1: {
                                    if (!words[7].equals("ENCODING-COMPLETE")) break;
                                    newStep = new ResultStep(lastVisionTime * 1000.0, (timeStamp - lastVisionTime) * 1000.0, ResultStep.VISION_RESOURCE, "Move Attention");
                                    newStep.traceStart = visionLineStart;
                                    newStep.traceEnd = currentLineNum + 1;
                                    if (visionPreceedingProductionStep != null) {
                                        newStep.addDependency(visionPreceedingProductionStep);
                                    }
                                    steps.add(newStep);
                                    visionState = 0;
                                    break;
                                }
                                case 0: {
                                    visionPreceedingProductionStep = lastProductionStep;
                                    if (words[7].equals("MOVE-ATTENTION")) {
                                        visionLineStart = currentLineNum;
                                        visionState = 1;
                                        break;
                                    }
                                    if (!words[7].equals("FIND-LOCATION")) break;
                                    visionLineStart = currentLineNum;
                                    visionState = 2;
                                    break;
                                }
                                case 2: {
                                    newStep = new ResultStep(lastVisionTime * 1000.0, (timeStamp - lastVisionTime) * 1000.0, ResultStep.VISION_RESOURCE, "Find Location");
                                    newStep.traceStart = visionLineStart;
                                    newStep.traceEnd = currentLineNum + 1;
                                    if (visionPreceedingProductionStep != null) {
                                        newStep.addDependency(visionPreceedingProductionStep);
                                    }
                                    steps.add(newStep);
                                    visionLineStart = currentLineNum;
                                    visionPreceedingProductionStep = lastProductionStep;
                                }
                            }
                            lastVisionTime = timeStamp;
                        }
                    } else if (words[3].equals("Device")) {
                        stateFound = false;
                        mCnt = 0;
                        while (mCnt < motorStates.size() && !stateFound) {
                            mState = (ITraceParser.InterimResultState)motorStates.get(mCnt);
                            if (mState.state == 3) {
                                stateFound = true;
                                continue;
                            }
                            ++mCnt;
                        }
                        if (stateFound) {
                            mState.lastTime = timeStamp;
                            mState.lineStart = currentLineNum;
                            mState.state = 4;
                        }
                    } else if (words[3].equals("Vision")) {
                        if (visionState == 2) {
                            newStep = new ResultStep(lastVisionTime * 1000.0, (timeStamp - lastVisionTime) * 1000.0, ResultStep.VISION_RESOURCE, "Find Location");
                            newStep.traceStart = visionLineStart;
                            newStep.traceEnd = currentLineNum + 1;
                            if (visionPreceedingProductionStep != null) {
                                newStep.addDependency(visionPreceedingProductionStep);
                            }
                            steps.add(newStep);
                            lastVisionTime = timeStamp;
                            visionState = 0;
                        }
                    } else if (words.length > 3 && (words[4].equals("Selected") || words[4].equals("Fired"))) {
                        productionName = words[3];
                        if (words[4].equals("Fired")) {
                            if (timeStamp < lastProductionTime) {
                                lastProductionTime -= 1.0;
                            }
                            newStep = new ResultStep(lastProductionTime * 1000.0, (timeStamp - lastProductionTime) * 1000.0, ResultStep.PRODUCTIONS_RESOURCE, productionName);
                            newStep.traceStart = productionLineStart;
                            newStep.traceEnd = currentLineNum + 1;
                            steps.add(newStep);
                            lastProductionStep = newStep;
                            lastProductionTime = timeStamp;
                        }
                        lastProductionTime = timeStamp;
                        productionLineStart = currentLineNum;
                    }
                } else if (words[0].equals("ATTEMPT")) {
                    String frameName = "";
                    if (words[3].equals("NIL:")) {
                        frameName = currentFrameName;
                    } else {
                        for (int x = 3; x < words.length; ++x) {
                            frameName = frameName + " " + words[x];
                        }
                        frameName = frameName.trim();
                        frameName = frameName.substring(0, frameName.length() - 1);
                    }
                    if (currentFrameName != null) {
                        newStep = new ResultStep(lastFrameTime * 1000.0, (timeStamp - lastFrameTime) * 1000.0, ResultStep.FRAME_RESOURCE, currentFrameName);
                        newStep.traceStart = frameLineStart;
                        newStep.traceEnd = currentLineNum + 1;
                        steps.add(newStep);
                    }
                    frameLineStart = currentLineNum;
                    lastFrameTime = timeStamp;
                    currentFrameName = frameName;
                }
            }
            catch (Exception e) {
                timeStamp = -1.0;
            }
            ++currentLineNum;
        }
        return steps;
    }
}

