/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.CannotRedoException;
import edu.cmu.cs.hcii.cogtool.util.CannotUndoException;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;

public class UndoController {
    static final String nothingToUndo = L10N.get("UNDO.NothingToUndo", "There is nothing to undo");
    static final String nothingToRedo = L10N.get("UNDO.NothingToRedo", "There is nothing to redo");
    static final String errorTitle = L10N.get("UNDO.ErrorTitle", "Undo/Redo Error");

    public static class RedoAction
    extends AListenerAction {
        protected UndoManager undoMgr;
        protected IInteraction interaction;

        public RedoAction(UndoManager mgr, IInteraction interactSpt) {
            this.undoMgr = mgr;
            this.interaction = interactSpt;
        }

        public boolean performAction(Object prms) {
            try {
                this.undoMgr.redo();
                return true;
            }
            catch (CannotRedoException ex) {
                this.interaction.reportProblem(errorTitle, nothingToRedo);
                return false;
            }
        }
    }

    public static class UndoAction
    extends AListenerAction {
        protected UndoManager undoMgr;
        protected IInteraction interaction;

        public UndoAction(UndoManager mgr, IInteraction interactSpt) {
            this.undoMgr = mgr;
            this.interaction = interactSpt;
        }

        public boolean performAction(Object prms) {
            try {
                this.undoMgr.undo();
                return true;
            }
            catch (CannotUndoException ex) {
                this.interaction.reportProblem(errorTitle, nothingToUndo);
                return false;
            }
        }
    }
}

