/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.controller.ZoomableController;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.ui.ISEFrameChooserInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEFrameChooserUI;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.ui.IZoomableUI;
import edu.cmu.cs.hcii.cogtool.ui.SEFrameChooserLID;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.security.InvalidParameterException;

public class SEFrameChooserController
extends ZoomableController {
    protected ITaskApplication taskApplication;
    protected IPredictionAlgo algorithm;
    protected IScript model;
    protected ITask task;
    protected IDesign design;
    protected UndoManager undoMgr;
    protected ISEFrameChooserUI ui;
    protected ISEFrameChooserInteraction interaction;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISEFrameChooserUI$OpenScriptParameters;

    public SEFrameChooserController(ITaskApplication ta, IPredictionAlgo alg, ITask taTask, IDesign taDesign, IProject taProject) {
        super(taProject);
        if (ta == null) {
            throw new InvalidParameterException("Cannot have a null TaskApp");
        }
        if (alg == null) {
            throw new InvalidParameterException("Cannot have a null Algorithm");
        }
        if (taDesign == null) {
            throw new InvalidParameterException("Can not have a null Design");
        }
        if (taTask == null) {
            throw new InvalidParameterException("Can not have a null Task");
        }
        this.task = taTask;
        this.design = taDesign;
        this.taskApplication = ta;
        this.algorithm = alg;
        this.model = ta.getScript(this.algorithm);
        if (this.model == null) {
            throw new InvalidParameterException("Must have already specified a Script for this Algorigthm");
        }
        this.undoMgr = CogTool.undoManagerFactory.getUndoManager(this.model, this.project);
        this.ui = CogTool.seFrameChooserUIFactory.createSEFrameChooserUI(this.model, this.task, this.design, this.project, this.undoMgr);
        this.interaction = this.ui.getInteraction();
        this.assignActions();
        this.ui.setVisible(true);
    }

    public void assignActions() {
        super.assignActions();
        this.ui.setAction(SEFrameChooserLID.OpenScriptDemonstrator, this.openDemonstrationWindow());
    }

    protected IUI getUI() {
        return this.ui;
    }

    protected IZoomableUI getZoomableUI() {
        return this.ui;
    }

    protected Object getModelObject() {
        return this.getModel();
    }

    public IScript getModel() {
        return this.model;
    }

    protected IListenerAction openDemonstrationWindow() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEFrameChooserUI$OpenScriptParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEFrameChooserUI$OpenScriptParameters = SEFrameChooserController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEFrameChooserUI$OpenScriptParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEFrameChooserUI$OpenScriptParameters;
            }

            public boolean performAction(Object prms) {
                ISEFrameChooserUI.OpenScriptParameters openPrms = (ISEFrameChooserUI.OpenScriptParameters)prms;
                IFrame selectedFrame = openPrms.selection.getSelectedFrame();
                if (selectedFrame != null) {
                    SEFrameChooserController.this.model.setStartFrame(selectedFrame);
                    SEFrameChooserController.this.model.setHandStartsOnMouse(openPrms.handStartsOnMouse);
                    SEFrameChooserController.this.closeWindow(false);
                    CogTool.seDemoControllerFactory.openController(SEFrameChooserController.this.taskApplication, SEFrameChooserController.this.algorithm, SEFrameChooserController.this.task, SEFrameChooserController.this.design, SEFrameChooserController.this.project);
                    return true;
                }
                SEFrameChooserController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }
}

