/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.ProjectController;
import edu.cmu.cs.hcii.cogtool.controller.UndoController;
import edu.cmu.cs.hcii.cogtool.controller.ZoomableController;
import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.DelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.DriveScriptStep;
import edu.cmu.cs.hcii.cogtool.model.GraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IDelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IResultRevalidator;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IScriptStepGeneration;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.IThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.TapScriptStep;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.model.ThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoUI;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.ui.IZoomableUI;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoLID;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.AUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.CSVSupport;
import edu.cmu.cs.hcii.cogtool.util.CompoundUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.RcvrCogModelException;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SEDemoController
extends ZoomableController {
    protected ITaskApplication taskApplication;
    protected IPredictionAlgo algorithm;
    protected IScript model;
    protected ITask task;
    protected IDesign design;
    protected UndoManager undoMgr;
    protected ISEDemoUI ui;
    protected ISEDemoInteraction interaction;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$LookAtTransition;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FollowTransition;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FreeFormTextTransition;

    public SEDemoController(ITaskApplication ta, IPredictionAlgo algo, ITask taTask, IDesign taDesign, IProject taProject) {
        super(taProject);
        this.taskApplication = ta;
        this.algorithm = algo;
        this.model = ta.getScript(this.algorithm);
        this.task = taTask;
        this.design = taDesign;
        this.undoMgr = CogTool.undoManagerFactory.getUndoManager(this.model, this.project);
        this.ui = CogTool.seDemoUIFactory.createSEDemoUI(this.model, this.task, this.design, this.project, this.undoMgr);
        this.interaction = this.ui.getInteraction();
        this.assignActions();
        this.ui.setVisible(true);
    }

    protected IDesign getDesign() {
        return this.design;
    }

    protected ITask getTask() {
        return this.task;
    }

    public void assignActions() {
        super.assignActions();
        this.ui.setAction(SEDemoLID.Undo, new UndoController.UndoAction(this.undoMgr, this.interaction));
        this.ui.setAction(SEDemoLID.Redo, new UndoController.RedoAction(this.undoMgr, this.interaction));
        this.ui.setAction(SEDemoLID.PerformTransition, this.createPerformTransitionAction());
        this.ui.setAction(SEDemoLID.PerformFreeformTextTransition, this.createFreeformTextTransitionScriptStep());
        this.ui.setAction(SEDemoLID.InsertThink, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
            }

            public boolean performAction(Object prms) {
                ISEDemoSelectionState selection = (ISEDemoSelectionState)prms;
                return SEDemoController.this.performInsertThink(selection);
            }
        });
        this.ui.setAction(SEDemoLID.ChangeThinkDuration, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
            }

            public boolean performAction(Object prms) {
                ISEDemoSelectionState selection = (ISEDemoSelectionState)prms;
                return SEDemoController.this.performChangeThink(selection);
            }
        });
        this.ui.setAction(SEDemoLID.InsertDelay, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
            }

            public boolean performAction(Object prms) {
                ISEDemoSelectionState selection = (ISEDemoSelectionState)prms;
                return SEDemoController.this.performInsertDelay(selection);
            }
        });
        this.ui.setAction(SEDemoLID.ChangeWaitDuration, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
            }

            public boolean performAction(Object prms) {
                ISEDemoSelectionState selection = (ISEDemoSelectionState)prms;
                return SEDemoController.this.performChangeDelay(selection);
            }
        });
        this.ui.setAction(SEDemoLID.InsertDrive, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
            }

            public boolean performAction(Object prms) {
                ISEDemoSelectionState selection = (ISEDemoSelectionState)prms;
                return SEDemoController.this.performInsertDrive(selection);
            }
        });
        this.ui.setAction(SEDemoLID.InsertLookAt, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$LookAtTransition == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$LookAtTransition = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoUI$LookAtTransition")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$LookAtTransition;
            }

            public boolean performAction(Object prms) {
                ISEDemoUI.LookAtTransition lookAt = (ISEDemoUI.LookAtTransition)prms;
                return SEDemoController.this.performInsertLookAt(lookAt);
            }
        });
        this.ui.setAction(SEDemoLID.Delete, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoSelectionState;
            }

            public boolean performAction(Object prms) {
                ISEDemoSelectionState selection = (ISEDemoSelectionState)prms;
                return SEDemoController.this.deleteScriptStep(selection);
            }
        });
        this.ui.setAction(SEDemoLID.RecomputeScript, this.createSaveScriptChangesAction());
        this.ui.setAction(SEDemoLID.ExportScriptToCSV, this.createExportScriptToCSVAction());
    }

    protected IListenerAction createPerformTransitionAction() {
        return new AListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FollowTransition == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FollowTransition = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoUI$FollowTransition")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FollowTransition;
            }

            public boolean performAction(Object prms) {
                ISEDemoUI.FollowTransition transition = (ISEDemoUI.FollowTransition)prms;
                ISEDemoSelectionState selection = transition.selection;
                ITransitionSource source = transition.source;
                ITransition trans = source.getTransition(transition.action);
                if (trans != null) {
                    return SEDemoController.this.performTransition(selection, trans, SEDemoLID.PerformTransition);
                }
                return false;
            }
        };
    }

    protected IListenerAction createFreeformTextTransitionScriptStep() {
        return new AListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FreeFormTextTransition == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FreeFormTextTransition = SEDemoController.class$("edu.cmu.cs.hcii.cogtool.ui.ISEDemoUI$FreeFormTextTransition")) : class$edu$cmu$cs$hcii$cogtool$ui$ISEDemoUI$FreeFormTextTransition;
            }

            public boolean performAction(Object prms) {
                String text;
                ISEDemoUI.FreeFormTextTransition transition = (ISEDemoUI.FreeFormTextTransition)prms;
                ISEDemoSelectionState selection = transition.selection;
                ITransitionSource target = transition.target;
                if (transition.action.getType() == ActionType.GraffitiStroke) {
                    text = SEDemoController.this.interaction.requestFreeFormGraffiti();
                    if (text == null) {
                        return false;
                    }
                    GraffitiAction ga = (GraffitiAction)transition.action;
                    ga.setText(text);
                } else if (transition.action.getType() == ActionType.KeyPress) {
                    text = SEDemoController.this.interaction.requestFreeFormText();
                    if (text == null) {
                        return false;
                    }
                    KeyAction ka = (KeyAction)transition.action;
                    ka.setText(text);
                }
                if (target.acceptsFreeFormInput() && (transition.action.getType() == ActionType.KeyPress || transition.action.getType() == ActionType.GraffitiStroke)) {
                    IScriptStep ss = selection.getSelectedStep();
                    IFrame resultFrame = null;
                    resultFrame = ss == null ? SEDemoController.this.model.getStartFrame() : ss.getCurrentFrame();
                    Transition trans = new Transition(target, resultFrame, transition.action);
                    return SEDemoController.this.performTransition(selection, trans, SEDemoLID.PerformFreeformTextTransition);
                }
                return false;
            }
        };
    }

    protected IListenerAction createSaveScriptChangesAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                IResultRevalidator[] validators = SEDemoController.this.taskApplication.recalculate(SEDemoController.this.algorithm);
                SEDemoController.this.dispose();
                return ProjectController.openProjectOnCompute(SEDemoController.this.project, validators);
            }
        };
    }

    protected boolean deleteScriptStep(ISEDemoSelectionState selection) {
        IScriptStep selectedStep = selection.getSelectedStep();
        boolean removeResultAction = false;
        String presentationName = L10N.get("UNDO.SEDemo.DeleteScriptSteps", "Delete Script Steps");
        CompoundUndoableEdit edit = new CompoundUndoableEdit(presentationName, SEDemoLID.Delete);
        if (selectedStep == null) {
            int index = this.model.getScriptSteps().size() - 1;
            if (index >= 0) {
                IScriptStep del = this.model.getScriptStep(index);
                ArrayList deleteSteps = this.model.getScriptStepGroup(del);
                int delIndex = this.model.getScriptStepIndex((IScriptStep)deleteSteps.get(0));
                this.model.removeScriptSteps(deleteSteps);
                this.addUndoDelete(deleteSteps, delIndex, presentationName, edit);
            } else {
                removeResultAction = true;
            }
        } else {
            ArrayList deleteSteps = this.model.getScriptStepGroup(selectedStep);
            if (!this.model.isSimpleGroupDelete(deleteSteps)) {
                if (!this.interaction.confirmDeleteScriptStep()) {
                    return false;
                }
                IScriptStep firstDeleted = (IScriptStep)deleteSteps.get(0);
                int index = this.model.getScriptStepIndex(firstDeleted);
                deleteSteps = this.model.removeScriptStepAndAllSubsequent(firstDeleted);
                this.addUndoDelete(deleteSteps, index, presentationName, edit);
            } else {
                int index = this.model.getScriptStepIndex((IScriptStep)deleteSteps.get(0));
                this.model.removeScriptSteps(deleteSteps);
                this.addUndoDelete(deleteSteps, index, presentationName, edit);
            }
        }
        edit.end();
        this.undoMgr.addEdit(edit);
        if (removeResultAction) {
            this.model.setStartFrame(null);
            this.dispose();
            CogTool.seFrameChooserControllerFactory.openController(this.taskApplication, this.algorithm, this.task, this.design, this.project);
        }
        return true;
    }

    protected boolean insertBeforeSS(IScriptStep insertBefore, ArrayList newSteps, CompoundUndoableEdit edit) {
        ArrayList insertBeforeGroup = this.model.getScriptStepGroup(insertBefore);
        if (!this.model.isSimpleGroupAdd(insertBeforeGroup, newSteps, true)) {
            if (!this.interaction.confirmDestructiveInsert()) {
                return false;
            }
            IScriptStep insertBeforeItem = (IScriptStep)insertBeforeGroup.get(0);
            this.model.addScriptStepsBeforeScriptStep(insertBeforeItem, newSteps);
            String presentationName = L10N.get("UNDO.SEDemo.InsertActionBefore", "Insert Action before Selection");
            this.addUndoInsertBefore(insertBeforeItem, newSteps, presentationName, edit);
            ArrayList deleteSteps = this.model.getScriptStepGroup(insertBefore);
            insertBefore = (IScriptStep)deleteSteps.get(0);
            int index = this.model.getScriptStepIndex(insertBefore);
            ArrayList deleted = this.model.removeAllSubsequentScriptSteps(insertBefore);
            presentationName = L10N.get("UNDO.SEDemo.DeleteMultipleScriptSteps", "Delete Multiple Script Steps");
            this.addUndoDelete(deleted, ++index, presentationName, edit);
        } else {
            insertBefore = (IScriptStep)insertBeforeGroup.get(0);
            this.model.addScriptStepsBeforeScriptStep(insertBefore, newSteps);
            String presentationName = L10N.get("UNDO.SEDemo.InsertActionBefore", "Insert Action before Selection");
            this.addUndoInsertBefore(insertBefore, newSteps, presentationName, edit);
        }
        return true;
    }

    protected boolean insertAfterSS(ArrayList insertAfterSteps, ArrayList newSteps, CompoundUndoableEdit edit) {
        IScriptStep insertAfterStep = (IScriptStep)insertAfterSteps.get(insertAfterSteps.size() - 1);
        if (!this.model.isSimpleGroupAdd(insertAfterSteps, newSteps, false)) {
            if (!this.interaction.confirmDestructiveInsert()) {
                return false;
            }
            int index = this.model.getScriptStepIndex(insertAfterStep);
            ArrayList deleted = this.model.removeAllSubsequentScriptSteps(insertAfterStep);
            String presentationName = L10N.get("UNDO.SEDemo.DeleteMultipleScriptSteps", "Delete Multiple Script Steps");
            this.addUndoDelete(deleted, ++index, presentationName, edit);
        }
        this.model.addScriptStepsAfterScriptStep(insertAfterStep, newSteps);
        String presentationName = L10N.get("UNDO.SEDemo.AddScriptAfterSelection", "Add Script After Selection");
        this.addUndoInsertAfter(insertAfterStep, newSteps, presentationName, edit);
        return true;
    }

    protected boolean insertScriptSteps(IScriptStep selectedStep, ArrayList steps, String presentationName, CogToolLID lid) {
        boolean result = true;
        CompoundUndoableEdit edit = new CompoundUndoableEdit(presentationName, lid);
        if (selectedStep == null) {
            this.model.addScriptSteps(steps);
            this.addUndoAddSteps(steps, presentationName, edit);
        } else {
            result = this.insertBeforeSS(selectedStep, steps, edit);
        }
        if (result) {
            edit.end();
            this.undoMgr.addEdit(edit);
        }
        return result;
    }

    protected void addUndoDelete(final ArrayList deleted, final int index, final String presentationName, CompoundUndoableEdit edit) {
        if (deleted.size() == 0) {
            return;
        }
        final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                SEDemoController.this.model.removeScriptSteps(deleted);
                result[0].revalidateResult();
            }

            public void undo() {
                super.undo();
                SEDemoController.this.model.addScriptSteps(index, deleted);
                result[0].revalidateResult();
            }
        });
    }

    protected void addUndoInsertBefore(final IScriptStep selected, final ArrayList newSSs, final String presentationName, CompoundUndoableEdit edit) {
        final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                SEDemoController.this.model.addScriptStepsBeforeScriptStep(selected, newSSs);
                result[0].revalidateResult();
            }

            public void undo() {
                super.undo();
                SEDemoController.this.model.removeScriptSteps(newSSs);
                result[0].revalidateResult();
            }
        });
    }

    protected void addUndoInsertAfter(final IScriptStep selected, final ArrayList newSSs, final String presentationName, CompoundUndoableEdit edit) {
        final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                SEDemoController.this.model.addScriptStepsAfterScriptStep(selected, newSSs);
                result[0].revalidateResult();
            }

            public void undo() {
                super.undo();
                SEDemoController.this.model.removeScriptSteps(newSSs);
                result[0].revalidateResult();
            }
        });
    }

    protected void addUndoDeleteSingle(final IScriptStep deleted, final int index, final String presentationName, CompoundUndoableEdit edit) {
        final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                SEDemoController.this.model.removeScriptStep(deleted);
                result[0].revalidateResult();
            }

            public void undo() {
                super.undo();
                SEDemoController.this.model.addScriptStep(index, deleted);
                result[0].revalidateResult();
            }
        });
    }

    protected void addUndoAdd(final IScriptStep added, final String presentationName, CompoundUndoableEdit edit) {
        final int index = this.model.getScriptStepIndex(added);
        final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                SEDemoController.this.model.addScriptStep(index, added);
                result[0].revalidateResult();
            }

            public void undo() {
                super.undo();
                SEDemoController.this.model.removeScriptStep(added);
                result[0].revalidateResult();
            }
        });
    }

    protected void addUndoAddSteps(final ArrayList added, final String presentationName, CompoundUndoableEdit edit) {
        if (added.size() == 0) {
            return;
        }
        final int index = this.model.getScriptStepIndex((IScriptStep)added.get(0));
        final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                SEDemoController.this.model.addScriptSteps(index, added);
                result[0].revalidateResult();
            }

            public void undo() {
                super.undo();
                SEDemoController.this.model.removeScriptSteps(added);
                result[0].revalidateResult();
            }
        });
    }

    protected boolean replaceScriptStepGroup(ArrayList replaceItems, ArrayList newSteps, CompoundUndoableEdit edit) {
        int index;
        IScriptStep firstReplaceItem = (IScriptStep)replaceItems.get(0);
        if (!this.model.isSimpleGroupReplace(replaceItems, newSteps)) {
            if (!this.interaction.confirmDestructiveInsert()) {
                return false;
            }
            index = this.model.getScriptStepIndex(firstReplaceItem);
            ArrayList deleted = this.model.removeAllSubsequentScriptSteps(firstReplaceItem);
            String presentationName = L10N.get("UNDO.SEDemo.DeleteMultipleScriptSteps", "Delete Multiple Script Steps");
            this.addUndoDelete(deleted, ++index, presentationName, edit);
        } else {
            replaceItems.remove(0);
            index = this.model.getScriptStepIndex((IScriptStep)replaceItems.get(0));
            this.model.removeScriptSteps(replaceItems);
            String presentationName = L10N.get("UNDO.SEDemo.DeleteMultipleScriptSteps", "Delete Multiple Script Steps");
            this.addUndoDelete(replaceItems, index, presentationName, edit);
        }
        this.model.addScriptStepsAfterScriptStep(firstReplaceItem, newSteps);
        String presentationName = L10N.get("UNDO.SEDemo.AddScriptStepAfterSelection", "Add Script Step After Selection");
        this.addUndoInsertAfter(firstReplaceItem, newSteps, presentationName, edit);
        int index2 = this.model.getScriptStepIndex(firstReplaceItem);
        IScriptStep deleted = this.model.removeScriptStep(firstReplaceItem);
        presentationName = L10N.get("UNDO.SEDemo.DeleteScriptSteps", "Delete Script Steps");
        this.addUndoDeleteSingle(deleted, index2, presentationName, edit);
        return true;
    }

    protected double getDurationFromUser(boolean think, double initialDuration) {
        String defaultTime;
        String newTime = defaultTime = Double.toString(initialDuration);
        boolean notDone = true;
        while (notDone) {
            newTime = think ? this.interaction.requestNewThinkDuration(newTime) : this.interaction.requestNewDelayDuration(newTime);
            if (newTime == null) {
                notDone = false;
                continue;
            }
            if (newTime.equals("")) {
                notDone = think ? this.interaction.protestEmptyThinkDuration() : this.interaction.protestEmptyDelayDuration();
                if (!notDone) continue;
                newTime = defaultTime;
                continue;
            }
            double duration = 0.0;
            try {
                duration = Double.valueOf(newTime);
            }
            catch (NumberFormatException e) {
                if (think) {
                    notDone = this.interaction.protestNonNumericThinkDuration();
                    continue;
                }
                notDone = this.interaction.protestNonNumericDelayDuration();
                continue;
            }
            if (duration <= 0.0) {
                if (think) {
                    notDone = this.interaction.protestZeroNegativeThinkDuration();
                    continue;
                }
                notDone = this.interaction.protestZeroNegativeDelayDuration();
                continue;
            }
            return duration;
        }
        return -1.0;
    }

    protected boolean performChangeDelay(ISEDemoSelectionState selection) {
        IScriptStep selectedStep = selection.getSelectedStep();
        if (selectedStep == null) {
            throw new InvalidParameterException("No selected ScriptStep");
        }
        if (selectedStep instanceof DelayScriptStep) {
            final DelayScriptStep delay = (DelayScriptStep)selectedStep;
            double previousDelay = delay.getDelayDuration();
            double duration = this.getDurationFromUser(false, previousDelay);
            final DelayScriptStep newStep = new DelayScriptStep(delay.getCurrentFrame(), duration, delay.getResultState(), true);
            if (duration != -1.0) {
                final String presentationName = L10N.get("UNDO.SEDemo.ChangeWaitDuration", "Change Wait Duration");
                final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
                this.model.replaceScriptStep(delay, newStep);
                this.undoMgr.addEdit(new AUndoableEdit(SEDemoLID.ChangeWaitDuration){

                    public String getPresentationName() {
                        return presentationName;
                    }

                    public void redo() {
                        super.redo();
                        SEDemoController.this.model.replaceScriptStep(delay, newStep);
                        result[0].revalidateResult();
                    }

                    public void undo() {
                        super.undo();
                        SEDemoController.this.model.replaceScriptStep(newStep, delay);
                        result[0].revalidateResult();
                    }
                });
                return true;
            }
        }
        return false;
    }

    protected boolean performChangeThink(ISEDemoSelectionState selection) {
        IScriptStep selectedStep = selection.getSelectedStep();
        if (selectedStep == null) {
            throw new InvalidParameterException("No selected ScriptStep");
        }
        if (selectedStep instanceof ThinkScriptStep) {
            final ThinkScriptStep think = (ThinkScriptStep)selectedStep;
            double previousThink = think.getThinkDuration();
            double duration = this.getDurationFromUser(true, previousThink);
            final ThinkScriptStep newStep = new ThinkScriptStep(think.getCurrentFrame(), duration, think.getResultState(), true);
            if (duration != -1.0) {
                final String presentationName = L10N.get("UNDO.SEDemo.ChangeThink", "Change Think Duration");
                final IResultRevalidator[] result = new IResultRevalidator[]{this.invalidateScript()};
                this.model.replaceScriptStep(think, newStep);
                this.undoMgr.addEdit(new AUndoableEdit(SEDemoLID.ChangeThinkDuration){

                    public String getPresentationName() {
                        return presentationName;
                    }

                    public void redo() {
                        super.redo();
                        SEDemoController.this.model.replaceScriptStep(think, newStep);
                        result[0].revalidateResult();
                    }

                    public void undo() {
                        super.undo();
                        SEDemoController.this.model.replaceScriptStep(newStep, think);
                        result[0].revalidateResult();
                    }
                });
                return true;
            }
        }
        return false;
    }

    protected boolean performInsertDelay(ISEDemoSelectionState selection) {
        double duration = this.getDurationFromUser(false, DelayScriptStep.DEFAULT_DELAY_DURATION);
        if (duration != -1.0) {
            IScriptStep selectedStep = selection.getSelectedStep();
            IScriptStep prevStep = null;
            prevStep = selectedStep == null ? this.model.getLastStep() : this.model.getPreviousStep(selectedStep);
            if (prevStep != null && prevStep instanceof IThinkScriptStep) {
                Boolean reposition = this.interaction.confirmNewDelayLocation();
                if (reposition == null) {
                    return false;
                }
                if (reposition.booleanValue()) {
                    selectedStep = prevStep;
                }
            }
            DelayScriptStep ss = selectedStep == null ? new DelayScriptStep(this.model.getResult(), duration, null, true) : new DelayScriptStep(selectedStep.getCurrentFrame(), duration, null, true);
            IFrame currentFrame = this.getCurrentFrame(selectedStep);
            IScriptStepGeneration fsm = this.model.getScriptGenerator();
            ArrayList generatedSteps = fsm.produceScriptSteps(ss, currentFrame);
            String presentationName = L10N.get("UNDO.SEDemo.InsertDelay", "Insert Delay");
            return this.insertScriptSteps(selectedStep, generatedSteps, presentationName, SEDemoLID.InsertDelay);
        }
        return false;
    }

    protected boolean performInsertThink(ISEDemoSelectionState selection) {
        double duration = this.getDurationFromUser(true, ThinkScriptStep.DEFAULT_THINK_DURATION);
        if (duration != -1.0) {
            IScriptStep selectedStep = selection.getSelectedStep();
            if (selectedStep instanceof IDelayScriptStep) {
                Boolean reposition = this.interaction.confirmNewThinkLocation();
                if (reposition == null) {
                    return false;
                }
                if (reposition.booleanValue()) {
                    selectedStep = this.model.getNextStep(selectedStep);
                }
            }
            IFrame currentFrame = this.getCurrentFrame(selectedStep);
            ThinkScriptStep ss = new ThinkScriptStep(currentFrame, duration, null, true);
            IScriptStepGeneration fsm = this.model.getScriptGenerator();
            ArrayList generatedSteps = fsm.produceScriptSteps(ss, currentFrame);
            String presentationName = L10N.get("UNDO.SEDemo.InsertThink", "Insert Think");
            return this.insertScriptSteps(selectedStep, generatedSteps, presentationName, SEDemoLID.InsertThink);
        }
        return false;
    }

    protected boolean performInsertLookAt(ISEDemoUI.LookAtTransition lookAt) {
        String presentationName;
        IScriptStep selectedStep = lookAt.selection.getSelectedStep();
        if (!(lookAt.target instanceof IWidget)) {
            this.ui.setLookAtSelected(this.interaction.protestInvalidLookAtTarget());
            return false;
        }
        IFrame currentFrame = this.getCurrentFrame(selectedStep);
        LookAtScriptStep ss = new LookAtScriptStep(currentFrame, (IWidget)lookAt.target, null, true);
        IScriptStepGeneration fsm = this.model.getScriptGenerator();
        ArrayList generatedSteps = fsm.produceScriptSteps(ss, currentFrame);
        boolean result = this.insertScriptSteps(selectedStep, generatedSteps, presentationName = L10N.get("UNDO.SEDemo.InsertLookAt", "Insert Look At"), SEDemoLID.InsertLookAt);
        if (result) {
            this.ui.setLookAtSelected(false);
        }
        return result;
    }

    protected boolean performInsertDrive(ISEDemoSelectionState selection) {
        IScriptStep selectedStep = selection.getSelectedStep();
        IFrame currentFrame = this.getCurrentFrame(selectedStep);
        DriveScriptStep ss = new DriveScriptStep(currentFrame, null, true);
        IScriptStepGeneration fsm = this.model.getScriptGenerator();
        ArrayList generatedSteps = fsm.produceScriptSteps(ss, currentFrame);
        String presentationName = L10N.get("UNDO.SEDemo.InsertDrive", "Insert Drive");
        return this.insertScriptSteps(selectedStep, generatedSteps, presentationName, SEDemoLID.InsertDrive);
    }

    protected boolean performTransition(ISEDemoSelectionState selection, ITransition transition, CogToolLID lid) {
        CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.SEDemo.PerformTransition", "Perform Transition"), lid);
        IScriptStep selectedStep = selection.getSelectedStep();
        if (this.model.getLastStep() == selectedStep) {
            selectedStep = null;
        }
        this.performBasicTransition(selectedStep, transition.getAction(), transition.getSource(), edit);
        edit.end();
        this.undoMgr.addEdit(edit);
        return true;
    }

    protected void performKeyTransition(IScriptStep selectedStep, IAction action, ITransitionSource source, CompoundUndoableEdit edit) {
        if (selectedStep != null) {
            ArrayList replaceSteps = this.model.getScriptStepGroup(selectedStep);
            IScriptStepGeneration fsm = this.model.getScriptGenerator();
            IScriptStep insertAfter = null;
            if (replaceSteps.size() > 0) {
                IScriptStep replacedStep = (IScriptStep)replaceSteps.get(0);
                insertAfter = this.model.getPreviousStep(replacedStep);
            }
            if (insertAfter != null) {
                fsm.setState(insertAfter.getResultState());
            } else {
                fsm.setState(fsm.getInitialState());
            }
            IFrame currentFrame = this.getCurrentFrame(insertAfter);
            ArrayList generatedSteps = null;
            generatedSteps = source instanceof IWidget ? fsm.produceScriptSteps(action, (IWidget)source, currentFrame) : fsm.produceDeviceScriptSteps(action, source, currentFrame);
            if (generatedSteps != null) {
                this.replaceScriptStepGroup(replaceSteps, generatedSteps, edit);
            }
        } else {
            IScriptStepGeneration fsm = this.model.getScriptGenerator();
            IScriptStep lastStep = this.model.getLastStep();
            if (lastStep != null) {
                fsm.setState(lastStep.getResultState());
            } else {
                fsm.setState(fsm.getInitialState());
            }
            ArrayList generatedSteps = null;
            generatedSteps = source instanceof IWidget ? fsm.produceScriptSteps(action, (IWidget)source, this.model.getResult()) : fsm.produceDeviceScriptSteps(action, source, this.model.getResult());
            if (generatedSteps == null) {
                throw new RcvrCogModelException("You have hit upon a sequence of actions which is not yet supported please email the developers with a description of what you were trying to accomplish.");
            }
            this.model.addScriptSteps(generatedSteps);
            String presentationName = L10N.get("UNDO.SEDemo.PerformTransition", "Perform Transition");
            this.addUndoAddSteps(generatedSteps, presentationName, edit);
        }
    }

    protected void performBasicTransition(IScriptStep selectedStep, IAction action, ITransitionSource source, CompoundUndoableEdit edit) {
        if (selectedStep != null) {
            ArrayList replaceSteps = this.model.getScriptStepGroup(selectedStep);
            IScriptStepGeneration fsm = this.model.getScriptGenerator();
            IScriptStep insertAfter = null;
            if (replaceSteps.size() > 0) {
                IScriptStep replacedStep = (IScriptStep)replaceSteps.get(0);
                insertAfter = this.model.getPreviousStep(replacedStep);
            }
            if (insertAfter != null) {
                fsm.setState(insertAfter.getResultState());
            } else {
                fsm.setState(fsm.getInitialState());
            }
            IFrame currentFrame = this.getCurrentFrame(insertAfter);
            ArrayList generatedSteps = null;
            generatedSteps = source instanceof IWidget ? fsm.produceScriptSteps(action, (IWidget)source, currentFrame) : fsm.produceDeviceScriptSteps(action, source, currentFrame);
            if (generatedSteps != null) {
                this.replaceScriptStepGroup(replaceSteps, generatedSteps, edit);
            }
        } else {
            IScriptStepGeneration fsm = this.model.getScriptGenerator();
            IScriptStep lastStep = this.model.getLastStep();
            if (lastStep != null) {
                fsm.setState(lastStep.getResultState());
            } else {
                fsm.setState(fsm.getInitialState());
            }
            ArrayList generatedSteps = null;
            generatedSteps = source instanceof IWidget ? fsm.produceScriptSteps(action, (IWidget)source, this.model.getResult()) : fsm.produceDeviceScriptSteps(action, source, this.model.getResult());
            if (generatedSteps == null) {
                throw new RcvrCogModelException("You have hit upon a sequence of actions which is not yet supported please email the developers with a description of what you were trying accomplish.");
            }
            this.model.addScriptSteps(generatedSteps);
            String presentationName = L10N.get("UNDO.SEDemo.PerformTransition", "Perform Transition");
            this.addUndoAddSteps(generatedSteps, presentationName, edit);
        }
    }

    public ArrayList getScriptStepsSinceLastTransition() {
        ArrayList result = new ArrayList();
        List scriptSteps = this.model.getScriptSteps();
        for (int i = scriptSteps.size() - 1; i >= 0; --i) {
            IScriptStep iss = (IScriptStep)scriptSteps.get(i);
            if (!(iss instanceof ActionScriptStep)) continue;
        }
        return result;
    }

    protected IUI getUI() {
        return this.ui;
    }

    protected IZoomableUI getZoomableUI() {
        return this.ui;
    }

    protected Object getModelObject() {
        return this.getModel();
    }

    public IScript getModel() {
        return this.model;
    }

    protected IFrame getCurrentFrame(IScriptStep ss) {
        IFrame currentFrame = null;
        currentFrame = ss != null ? ss.getCurrentFrame() : this.model.getResult();
        return currentFrame;
    }

    public ITaskApplication getTaskApplication() {
        return this.taskApplication;
    }

    public IPredictionAlgo getAlgorithm() {
        return this.algorithm;
    }

    protected IResultRevalidator invalidateScript() {
        return this.taskApplication.invalidateResult(this.algorithm);
    }

    protected IListenerAction createExportScriptToCSVAction() {
        return new AListenerAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean performAction(Object prms) {
                BufferedWriter buffer;
                OutputStreamWriter fw;
                block18: {
                    boolean bl;
                    block17: {
                        fw = null;
                        buffer = null;
                        try {
                            try {
                                String name = SEDemoController.this.getProject().getName();
                                File dest = SEDemoController.this.interaction.selectCSVFileDest(name);
                                if (dest == null) {
                                    bl = false;
                                    Object var17_10 = null;
                                    break block17;
                                }
                                fw = new FileWriter(dest);
                                buffer = new BufferedWriter(fw);
                                ToCSVScriptStepVisitor visitor = new ToCSVScriptStepVisitor();
                                Date now = new Date();
                                String date = DateFormat.getDateTimeInstance().format(now);
                                CSVSupport.writeCell("Date and Time:", buffer);
                                CSVSupport.addSeparator(buffer);
                                CSVSupport.writeCell(date, buffer);
                                CSVSupport.addLineEnding(buffer);
                                CSVSupport.writeCell("Project Name:", buffer);
                                CSVSupport.addSeparator(buffer);
                                CSVSupport.writeCell(SEDemoController.this.getProject().getName(), buffer);
                                CSVSupport.addLineEnding(buffer);
                                CSVSupport.writeCell("Design Name:", buffer);
                                CSVSupport.addSeparator(buffer);
                                CSVSupport.writeCell(SEDemoController.this.getDesign().getName(), buffer);
                                CSVSupport.addLineEnding(buffer);
                                CSVSupport.writeCell("Task Hierarchy:", buffer);
                                String task = SEDemoController.this.getTask().getFullName();
                                String[] cells = task.split(":");
                                for (int i = 0; i < cells.length; ++i) {
                                    CSVSupport.addSeparator(buffer);
                                    CSVSupport.writeCell(cells[i], buffer);
                                }
                                CSVSupport.addLineEnding(buffer);
                                CSVSupport.addSeparator(buffer);
                                CSVSupport.addLineEnding(buffer);
                                buffer.write("\"Frame\",\"Action\",\"Widget\"");
                                CSVSupport.addLineEnding(buffer);
                                Iterator steps = SEDemoController.this.model.getScriptSteps().iterator();
                                while (steps.hasNext()) {
                                    IScriptStep step = (IScriptStep)steps.next();
                                    step.accept(visitor);
                                    String frameName = step.getCurrentFrame().getName();
                                    String actionName = step.getStepLocalizedString();
                                    String widgetName = visitor.getWidgetName();
                                    CSVSupport.writeCell(frameName, buffer);
                                    CSVSupport.addSeparator(buffer);
                                    CSVSupport.writeCell(actionName, buffer);
                                    CSVSupport.addSeparator(buffer);
                                    CSVSupport.writeCell(widgetName, buffer);
                                    CSVSupport.addLineEnding(buffer);
                                }
                                IFrame resultFrame = SEDemoController.this.model.getResult();
                                if (resultFrame != null) {
                                    CSVSupport.writeCell(resultFrame.getName(), buffer);
                                }
                                SEDemoController.this.interaction.setStatusMessage(L10N.get("SE.ExportCompleted", "Export completed."));
                                break block18;
                            }
                            catch (IOException e) {
                                SEDemoController.this.interaction.reportProblem("File I/O Error", e.getMessage());
                                boolean bl2 = false;
                                Object var17_12 = null;
                                try {
                                    if (buffer != null) {
                                        buffer.close();
                                    }
                                    if (fw == null) return bl2;
                                    fw.close();
                                    return bl2;
                                }
                                catch (IOException e2) {
                                    SEDemoController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                    return false;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_13 = null;
                            try {}
                            catch (IOException e2) {
                                SEDemoController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                return false;
                            }
                            if (buffer != null) {
                                buffer.close();
                            }
                            if (fw == null) throw throwable;
                            fw.close();
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException e2) {
                        SEDemoController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                        return false;
                    }
                    if (buffer != null) {
                        buffer.close();
                    }
                    if (fw == null) return bl;
                    fw.close();
                    return bl;
                }
                Object var17_11 = null;
                try {}
                catch (IOException e2) {
                    SEDemoController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                    return false;
                }
                if (buffer != null) {
                    buffer.close();
                }
                if (fw == null) return true;
                fw.close();
                return true;
            }
        };
    }

    class ToCSVScriptStepVisitor
    implements IScriptStep.IScriptStepVisitor {
        String widgetName = "";

        ToCSVScriptStepVisitor() {
        }

        public void visit(ActionScriptStep ss) {
            this.widgetName = ss.getWidgetName();
        }

        public void visit(TapScriptStep tss) {
            this.widgetName = tss.getWidgetName();
        }

        public void visit(DelayScriptStep delayss) {
            this.widgetName = "";
        }

        public void visit(DriveScriptStep drivess) {
            this.widgetName = "";
        }

        public void visit(LookAtScriptStep lass) {
            this.widgetName = lass.getWidgetName();
        }

        public void visit(ThinkScriptStep tss) {
            this.widgetName = "";
        }

        public void visit(TextActionSegment tas) {
            this.widgetName = tas.getStepFocus().getName();
        }

        public String getWidgetName() {
            return this.widgetName;
        }
    }
}

