/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.controller.ProjectController;
import edu.cmu.cs.hcii.cogtool.controller.RootController;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.Project;
import edu.cmu.cs.hcii.cogtool.model.TapAction;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.model.Task;
import edu.cmu.cs.hcii.cogtool.model.TaskGroup;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.VoiceAction;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOException;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectLauncher {
    public static Set standardDeviceTypes = new HashSet<DeviceType>(Arrays.asList(DeviceType.Mouse, DeviceType.Keyboard, DeviceType.Voice));

    public static void main(String[] args) {
        try {
            if (OSUtils.MACOSX) {
                RootController root = new RootController();
            }
            Project proj = ProjectLauncher.createTestProject();
            ProjectController pmController = CogTool.projectControllerFactory.openController(proj, true, false);
            WindowUtil.interact();
        }
        catch (Exception e) {
            final Shell window = new Shell(WindowUtil.globalDisplay, 2144);
            window.setText(L10N.get("UncaughtException", "Unexpected Error"));
            GridLayout layout = new GridLayout(1, false);
            window.setLayout((Layout)layout);
            Label announcement = new Label((Composite)window, 16384);
            announcement.setText(L10N.get("ErrorHappened", "An unexpected error has occurred. Please contact CogTool support with the following information:"));
            GridData announcementLayout = new GridData();
            announcementLayout.grabExcessHorizontalSpace = true;
            announcement.setLayoutData((Object)announcementLayout);
            Text trace = new Text((Composite)window, 16394);
            StringWriter stringBuffer = new StringWriter();
            e.printStackTrace(new PrintWriter(stringBuffer));
            trace.setText(stringBuffer.toString());
            GridData traceLayout = new GridData();
            traceLayout.grabExcessHorizontalSpace = true;
            trace.setLayoutData((Object)traceLayout);
            Button okButton = new Button((Composite)window, 8);
            okButton.setText(L10N.get("B.OK", "OK"));
            okButton.setFocus();
            GridData okLayout = new GridData(64);
            okButton.setLayoutData((Object)okLayout);
            okButton.addListener(13, new Listener(){

                public void handleEvent(Event evt) {
                    window.close();
                }
            });
            e.printStackTrace();
            WindowUtil.displayAndInteract(window);
        }
    }

    public static Project createTestProject() {
        Project proj = new Project("TEST Project");
        Design d1 = new Design("Boeing 777", standardDeviceTypes);
        Design d2 = new Design("FDF", standardDeviceTypes);
        proj.addDesign(d1);
        proj.addDesign(d2);
        Frame f1 = ProjectLauncher.testFrame("Main");
        Frame f2 = ProjectLauncher.testFrame("Auto FLT");
        Frame f3 = ProjectLauncher.testFrame("HOLD");
        Frame f4 = ProjectLauncher.testFrame("A/T");
        f1.setFrameOrigin(0.0, 0.0);
        f2.setFrameOrigin(25.0, 200.0);
        f3.setFrameOrigin(340.0, 40.0);
        f4.setFrameOrigin(330.0, 210.0);
        IInputDevice v = f1.getInputDevice(DeviceType.Voice);
        v.addTransition(new Transition(v, f4, new VoiceAction("go", true)));
        IInputDevice k = f3.getInputDevice(DeviceType.Keyboard);
        k.addTransition(new Transition(k, f1, new KeyAction('\n', KeyPressType.Stroke, 0)));
        d2.addFrame(f1);
        d2.addFrame(f2);
        d2.addFrame(f3);
        d2.addFrame(f4);
        f1.getWidget("w5").addTransition(new Transition(f1.getWidget("w5"), f1, new TapAction(TapPressType.Tap)));
        f1.getWidget("w4").addTransition(new Transition(f1.getWidget("w4"), f3, new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0)));
        f1.getWidget("w3").addTransition(new Transition(f1.getWidget("w3"), f4, new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0)));
        f2.getWidget("w6").addTransition(new Transition(f2.getWidget("w6"), f1, new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0)));
        f3.getWidget("w7").addTransition(new Transition(f3.getWidget("w7"), f1, new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0)));
        f4.getWidget("w8").addTransition(new Transition(f4.getWidget("w8"), f1, new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0)));
        TaskGroup tgtop = new TaskGroup("TEST Task Group TOP", GroupNature.MEAN);
        TaskGroup tgmiddle = new TaskGroup("TEST Task Group MIDDLE", GroupNature.MEAN);
        TaskGroup t0 = new TaskGroup("TEST Task 0 TOP", GroupNature.SUM);
        Task t1 = new Task("TEST Task 1 TOP");
        Task t2 = new Task("TEST Task 2 MIDDLE");
        Task t3 = new Task("TEST Task 3 LEAF");
        TaskGroup t4 = new TaskGroup("TEST Task 4 LEAF", GroupNature.SUM);
        proj.addUndertaking(t0);
        proj.addUndertaking(t1);
        proj.addUndertaking(tgtop);
        tgtop.addUndertaking(t2);
        tgtop.addUndertaking(tgmiddle);
        tgmiddle.addUndertaking(t3);
        tgmiddle.addUndertaking(t4);
        Task m1 = new Task("TEST Method 1 for Task 0");
        Task m2 = new Task("TEST Method 2 for Task 0");
        Task m3 = new Task("TEST Method 3 for Task 4");
        Task m4 = new Task("TEST Method 4 for Task 4");
        Task m5 = new Task("TEST Method 5 for Task 4");
        Task m6 = new Task("TEST Method 6 for Task 4");
        Task m7 = new Task("TEST Method 7 for Task 4");
        TaskGroup mg1 = new TaskGroup("TEST Method Group 1 for Task 4", GroupNature.SUM);
        TaskGroup mg2 = new TaskGroup("TEST Method Group 2 for Task 4", GroupNature.SUM);
        mg1.addUndertaking(m3);
        mg1.addUndertaking(m4);
        mg2.addUndertaking(m5);
        mg2.addUndertaking(m6);
        t0.addUndertaking(m1);
        t0.addUndertaking(m2);
        t4.addUndertaking(mg1);
        t4.addUndertaking(mg2);
        t4.addUndertaking(m7);
        return proj;
    }

    public static Frame testFrame(String frameTitle) {
        Frame f = new Frame(frameTitle, standardDeviceTypes);
        InputStream stream = ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/fdf.jpg");
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        try {
            while (stream.available() > 0) {
                cache.write(stream.read());
            }
        }
        catch (IOException e) {
            throw new RcvrIOException("Resource InputStreams are crappy: " + e.getMessage(), e);
        }
        byte[] frameBG = cache.toByteArray();
        f.setBackgroundImage(frameBG, GraphicsUtil.getImageBounds(frameBG));
        Widget w1 = new Widget(new DoubleRectangle(507.0, 185.0, 49.0, 46.0), WidgetType.Button);
        Widget w2 = new Widget(new DoubleRectangle(737.0, 187.0, 48.0, 48.0), WidgetType.Button);
        Widget w3 = new Widget(new DoubleRectangle(374.0, 21.0, 47.0, 46.0), WidgetType.Button);
        Widget w4 = new Widget(new DoubleRectangle(284.0, 186.0, 51.0, 48.0), WidgetType.Button);
        Widget w5 = new Widget(new DoubleRectangle(364.0, 175.0, 68.0, 49.0), WidgetType.Button);
        Widget w6 = new Widget(new DoubleRectangle(463.0, 40.0, 35.0, 31.0), WidgetType.Button);
        Widget w7 = new Widget(new DoubleRectangle(1113.0, 35.0, 33.0, 34.0), WidgetType.Button);
        Widget w8 = new Widget(new DoubleRectangle(461.0, 150.0, 25.0, 68.0), WidgetType.Button);
        Widget w9 = new Widget(new DoubleRectangle(210.0, 197.0, 36.0, 34.0), WidgetType.Button);
        Widget w10 = new Widget(new DoubleRectangle(51.0, 192.0, 31.0, 33.0), WidgetType.Button);
        Widget w11 = new Widget(new DoubleRectangle(1061.0, 195.0, 30.0, 27.0), WidgetType.Button);
        Widget w12 = new Widget(new DoubleRectangle(948.0, 188.0, 43.0, 41.0), WidgetType.Button);
        Widget w13 = new Widget(new DoubleRectangle(632.0, 194.0, 37.0, 32.0), WidgetType.Button);
        Widget w14 = new Widget(new DoubleRectangle(10.0, 38.0, 34.0, 29.0), WidgetType.Button);
        Widget w15 = new Widget(new DoubleRectangle(10.0, 125.0, 36.0, 38.0), WidgetType.Button);
        w1.setName("w1");
        w2.setName("w2");
        w3.setName("w3");
        w4.setName("w4");
        w5.setName("w5");
        w6.setName("w6");
        w7.setName("w7");
        w8.setName("w8");
        w9.setName("w9");
        w10.setName("w10");
        w11.setName("w11");
        w12.setName("w12");
        w13.setName("w13");
        w14.setName("w14");
        w15.setName("w15");
        try {
            f.addWidget(w1);
            f.addWidget(w2);
            f.addWidget(w3);
            f.addWidget(w4);
            f.addWidget(w5);
            f.addWidget(w6);
            f.addWidget(w7);
            f.addWidget(w8);
            f.addWidget(w9);
            f.addWidget(w10);
            f.addWidget(w11);
            f.addWidget(w12);
            f.addWidget(w13);
            f.addWidget(w14);
            f.addWidget(w15);
        }
        catch (Exception e) {
            System.out.println("Exception while adding widgets to project view");
        }
        return f;
    }
}

