/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.ProjectController;
import edu.cmu.cs.hcii.cogtool.model.AUndertaking;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.Task;
import edu.cmu.cs.hcii.cogtool.model.TaskGroup;
import edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IProjectInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IProjectUI;
import edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ProjectContextSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ProjectInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ProjectLID;
import edu.cmu.cs.hcii.cogtool.ui.ProjectUI;
import edu.cmu.cs.hcii.cogtool.ui.SingleTaskSelection;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectControllerTest
extends TestCase {
    IProject model;
    ProjectUI ui;
    ProjectController controller;
    ProjectInteraction DUMMY_PROJECT_INTERACTION;

    protected void setUp() throws Exception {
        super.setUp();
        this.controller = CogTool.projectControllerFactory.newProjectController();
        this.model = this.controller.getModel();
        this.ui = (ProjectUI)this.controller.getUI();
        this.DUMMY_PROJECT_INTERACTION = new ProjectInteraction(this.ui.getView()){
            int i;

            public String requestNewDesignName(String defaultName) {
                return "test design " + this.i++;
            }

            public boolean requestNewTaskName(IProjectInteraction.TaskRequestData askData) {
                askData.taskName = "test task " + this.i++;
                return true;
            }
        };
    }

    protected void tearDown() throws Exception {
        this.ui.dispose();
        super.tearDown();
    }

    public void testGetUI() {
        ProjectControllerTest.assertNotSame((Object)this.controller.getUI(), (Object)new ProjectController(this.model, true, true).getUI());
    }

    public void testProjectController() {
        try {
            new ProjectController(null, true, true);
            ProjectControllerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetModel() {
        ProjectControllerTest.assertNotNull((Object)this.model);
        ProjectControllerTest.assertSame((Object)new ProjectController(this.model, true, true).getModel(), (Object)this.model);
    }

    public void testNewDesignAction() {
        final String[] name = new String[]{"new design 1"};
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public String requestNewDesignName(String defaultName) {
                return name[0];
            }

            public boolean protestNotUniqueDesignName() {
                protest[0] = true;
                return false;
            }
        };
        IDesignSelectionState selection = new IDesignSelectionState(){

            public IDesign getSelectedDesign() {
                return null;
            }
        };
        this.ui.performAction(ProjectLID.NewDesign, selection, false);
        ProjectControllerTest.assertEquals((int)this.model.getDesigns().size(), (int)1);
        ProjectControllerTest.assertTrue((boolean)(this.model.getDesigns().get(0) instanceof IDesign));
        final IDesign design = (IDesign)this.model.getDesigns().get(0);
        selection = new IDesignSelectionState(){

            public IDesign getSelectedDesign() {
                return design;
            }
        };
        name[0] = name[0] + "2";
        this.ui.performAction(ProjectLID.NewDesign, selection, false);
        ProjectControllerTest.assertEquals((int)this.model.getDesigns().size(), (int)2);
        Object last = this.model.getDesigns().get(1);
        name[0] = name[0] + "3";
        this.ui.performAction(ProjectLID.NewDesign, selection, false);
        ProjectControllerTest.assertEquals((int)this.model.getDesigns().size(), (int)3);
        ProjectControllerTest.assertEquals(this.model.getDesigns().get(2), last);
        this.ui.performAction(ProjectLID.NewDesign, selection, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
        ProjectControllerTest.assertEquals((int)this.model.getDesigns().size(), (int)3);
        this.ui.performAction(CogToolLID.Undo, null, false);
        ProjectControllerTest.assertEquals((int)this.model.getDesigns().size(), (int)2);
        ProjectControllerTest.assertTrue((boolean)this.model.getDesigns().contains(design));
        ProjectControllerTest.assertTrue((boolean)this.model.getDesigns().contains(last));
        this.ui.performAction(CogToolLID.Redo, null, false);
        ProjectControllerTest.assertEquals((int)this.model.getDesigns().size(), (int)3);
        ProjectControllerTest.assertTrue((boolean)this.model.getDesigns().contains(design));
        ProjectControllerTest.assertTrue((boolean)this.model.getDesigns().contains(last));
    }

    public void testDeleteDesignAction() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }

            public boolean confirmDeleteDesign(IDesign design) {
                return true;
            }
        };
        IDesignSelectionState sel = new IDesignSelectionState(){

            public IDesign getSelectedDesign() {
                return null;
            }
        };
        this.ui.performAction(ProjectLID.DeleteDesign, sel, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
        new DesignActionTester(ProjectLID.DeleteDesign){

            protected void setupTestParameters() {
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                List remain = ProjectControllerTest.this.model.getDesigns();
                Assert.assertEquals((int)remain.size(), (int)3);
                Assert.assertTrue((!remain.contains(this.d[0]) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)remain.contains(this.d[1]));
                Assert.assertTrue((boolean)remain.contains(this.d[2]));
                Assert.assertTrue((boolean)remain.contains(this.d[3]));
            }

            protected void assertNoneEffects() {
                List remain = ProjectControllerTest.this.model.getDesigns();
                Assert.assertEquals((int)remain.size(), (int)4);
                Assert.assertTrue((boolean)remain.contains(this.d[0]));
                Assert.assertTrue((boolean)remain.contains(this.d[1]));
                Assert.assertTrue((boolean)remain.contains(this.d[2]));
                Assert.assertTrue((boolean)remain.contains(this.d[3]));
            }
        }.test();
    }

    public void testEditDesignAction() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }
        };
        IDesignSelectionState selection = new IDesignSelectionState(){

            public IDesign getSelectedDesign() {
                return null;
            }
        };
        this.ui.performAction(ProjectLID.EditDesign, selection, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
    }

    public void testRenameDesignAction() {
        String testName = "valid testing name";
        final String[] name = new String[1];
        final boolean[] protest = new boolean[3];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }

            public boolean protestNotUniqueDesignName() {
                protest[1] = true;
                return false;
            }

            public boolean protestEmptyDesignName() {
                protest[2] = true;
                return false;
            }

            public String requestDesignRename(String oldDesignName) {
                return name[0];
            }
        };
        IDesignSelectionState selection = new IDesignSelectionState(){

            public IDesign getSelectedDesign() {
                return null;
            }
        };
        this.ui.performAction(ProjectLID.RenameDesign, selection, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
        ProjectControllerTest.assertTrue((!protest[1] ? 1 : 0) != 0);
        ProjectControllerTest.assertTrue((!protest[2] ? 1 : 0) != 0);
        protest[0] = false;
        new DesignActionTester(ProjectLID.RenameDesign){

            protected void setupTestParameters() {
                name[0] = "valid testing name";
                this.d[3].setName("valid testing name");
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((boolean)protest[1]);
                Assert.assertTrue((!protest[2] ? 1 : 0) != 0);
                protest[1] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new DesignActionTester(ProjectLID.RenameDesign){

            protected void setupTestParameters() {
                name[0] = "";
                this.d[3].setName("valid testing name");
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((String)this.d[3].getName(), (String)"valid testing name");
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
                Assert.assertTrue((boolean)protest[2]);
                protest[2] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new DesignActionTester(ProjectLID.RenameDesign){

            protected void setupTestParameters() {
                name[0] = null;
                this.d[3].setName("valid testing name");
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((String)this.d[3].getName(), (String)"valid testing name");
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[2] ? 1 : 0) != 0);
                protest[2] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new DesignActionTester(ProjectLID.RenameDesign){

            protected void setupTestParameters() {
                name[0] = "valid testing name";
                this.d[3].setName("some stupid name");
                this.param = this.selection;
            }

            protected void assertDoneEffectsOn(IDesign d) {
                Assert.assertEquals((String)d.getName(), (String)"valid testing name");
            }

            protected void assertDoneEffects() {
                super.assertDoneEffects();
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[2] ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testNewTaskGroupAction() {
        final String[] name = new String[]{"new task 1"};
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public boolean requestNewTaskName(IProjectInteraction.TaskRequestData askData) {
                askData.taskName = name[0];
                return true;
            }

            public boolean protestNotUniqueTaskName() {
                protest[0] = true;
                return false;
            }
        };
        new TaskActionTester(ProjectLID.NewTaskGroup){
            int size;

            protected void setupTestParameters() {
                this.size = ((ITaskGroup)this.u[1]).getUndertakings().size();
                SingleTaskSelection sel = new SingleTaskSelection(this.u[1], null);
                this.param = sel;
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((int)((ITaskGroup)this.u[1]).getUndertakings().size(), (int)(this.size + 1));
            }

            protected void assertNoneEffects() {
                Assert.assertEquals((int)((ITaskGroup)this.u[1]).getUndertakings().size(), (int)this.size);
            }
        }.test();
        new TaskActionTester(ProjectLID.NewTaskGroup){
            int size;

            protected void setupTestParameters() {
                this.size = ProjectControllerTest.this.model.getUndertakings().size();
                SingleTaskSelection sel = new SingleTaskSelection(this.u[2], null);
                this.param = sel;
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((int)ProjectControllerTest.this.model.getUndertakings().size(), (int)(this.size + 1));
            }

            protected void assertNoneEffects() {
                Assert.assertEquals((int)ProjectControllerTest.this.model.getUndertakings().size(), (int)this.size);
            }
        }.test();
        EmptyTaskSelectionState sel = new EmptyTaskSelectionState();
        name[0] = name[0] + "2";
        this.ui.performAction(CogToolLID.NewTaskGroup, sel, false);
        ProjectControllerTest.assertEquals((int)this.model.getUndertakings().size(), (int)1);
        this.ui.performAction(CogToolLID.NewTaskGroup, sel, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
        ProjectControllerTest.assertEquals((int)this.model.getUndertakings().size(), (int)1);
        this.ui.performAction(CogToolLID.Undo, null, false);
        ProjectControllerTest.assertEquals((int)this.model.getUndertakings().size(), (int)0);
        this.ui.performAction(CogToolLID.Redo, null, false);
        ProjectControllerTest.assertEquals((int)this.model.getUndertakings().size(), (int)1);
    }

    public void testDeleteTaskAction() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }

            public boolean confirmDeleteTasks(IUndertaking[] selectedTasks) {
                return true;
            }
        };
        EmptyTaskSelectionState sel = new EmptyTaskSelectionState();
        this.ui.performAction(ProjectLID.DeleteTask, sel, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
        new TaskActionTester(ProjectLID.DeleteTask){

            protected void setupTestParameters() {
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                List remain = ProjectControllerTest.this.model.getUndertakings();
                Assert.assertEquals((int)remain.size(), (int)2);
                Assert.assertTrue((!remain.contains(this.u[0]) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)remain.contains(this.u[1]));
                Assert.assertTrue((!remain.contains(this.u[2]) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)remain.contains(this.u[3]));
            }

            protected void assertNoneEffects() {
                List remain = ProjectControllerTest.this.model.getUndertakings();
                Assert.assertEquals((int)remain.size(), (int)4);
                Assert.assertTrue((boolean)remain.contains(this.u[0]));
                Assert.assertTrue((boolean)remain.contains(this.u[1]));
                Assert.assertTrue((boolean)remain.contains(this.u[2]));
                Assert.assertTrue((boolean)remain.contains(this.u[3]));
            }
        }.test();
    }

    public void testEditTaskAction() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }
        };
        EmptyTaskSelectionState sel = new EmptyTaskSelectionState();
        this.ui.performAction(ProjectLID.DeleteTask, sel, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
    }

    public void testInitiateTaskRenameAction() {
        final boolean[] protest = new boolean[1];
        final boolean[] rename = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }
        };
        this.controller.ui = new ProjectUI(this.model, new UndoManager(null, false)){

            public void initiateTaskRename(ITaskSelectionState taskToRename) {
                rename[0] = true;
            }
        };
        EmptyTaskSelectionState sel = new EmptyTaskSelectionState();
        this.ui.performAction(ProjectLID.InitiateTaskRename, sel, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
        ProjectControllerTest.assertTrue((!rename[0] ? 1 : 0) != 0);
        protest[0] = false;
        new TaskActionTester(ProjectLID.InitiateTaskRename){

            protected void setupTestParameters() {
                this.selection = new ITaskSelectionState(this){
                    private final /* synthetic */ 26 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public IUndertaking[] getSelectedTasks() {
                        return new IUndertaking[]{this.this$1.u[0], this.this$1.u[2]};
                    }

                    public int getSelectedTaskCount() {
                        return 2;
                    }

                    public ITaskGroup getSelectedTaskParent() {
                        return null;
                    }

                    public ITaskGroup[] getSelectedTaskParents() {
                        return null;
                    }

                    public boolean isTaskSelected(IUndertaking task) {
                        return task == this.this$1.u[0] || task == this.this$1.u[2];
                    }
                };
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!rename[0] ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new TaskActionTester(ProjectLID.InitiateTaskRename){

            protected void setupTestParameters() {
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rename[0]);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testRenameTaskAction() {
        String testName = "valid task name";
        final boolean[] protest = new boolean[2];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public boolean protestNotUniqueTaskName() {
                protest[0] = true;
                return false;
            }

            public boolean protestEmptyTaskName() {
                protest[1] = true;
                return false;
            }
        };
        new TaskActionTester(ProjectLID.RenameTask){

            protected void setupTestParameters() {
                this.u[2].setName("valid task name");
                this.param = new IProjectUI.TaskRenameEvent(this.selection.getSelectedTasks()[0], "valid task name", this.selection.getSelectedTaskParent());
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((boolean)protest[0]);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
                protest[0] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new TaskActionTester(ProjectLID.RenameTask){

            protected void setupTestParameters() {
                this.u[2].setName("some stupid name");
                this.param = new IProjectUI.TaskRenameEvent(this.selection.getSelectedTasks()[0], "", this.selection.getSelectedTaskParent());
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((boolean)protest[1]);
                protest[1] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new TaskActionTester(ProjectLID.RenameTask){

            protected void setupTestParameters() {
                this.u[2].setName("some stupid name");
                this.param = new IProjectUI.TaskRenameEvent(this.selection.getSelectedTasks()[0], "valid task name", this.selection.getSelectedTaskParent());
            }

            protected void assertDoneEffectsOn(IUndertaking d) {
                Assert.assertEquals((String)d.getName(), (String)"valid task name");
            }

            protected void assertDoneEffects() {
                super.assertDoneEffects();
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testEditScriptStep() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new ProjectInteraction(this.ui.getView()){

            public void protestNoSelection() {
                protest[0] = true;
            }
        };
        this.ui.performAction(ProjectLID.EditScript, null, false);
        ProjectControllerTest.assertTrue((boolean)protest[0]);
    }

    public void testDeselectAllAction() {
        Tree tree = new Tree((Composite)this.ui.getShell(), 0);
        ProjectContextSelectionState selection = new ProjectContextSelectionState();
        selection.addSelectedColumn(new TreeColumn(tree, 0));
        selection.addSelectedItem(new TreeItem(tree, 0));
        this.ui.performAction(ProjectLID.DeselectAll, selection, false);
        ProjectControllerTest.assertNull((Object)selection.getSelectedColumn());
        ProjectControllerTest.assertEquals((int)selection.getSelectedTaskCount(), (int)0);
    }

    protected abstract class TaskActionTester
    extends TaskTester {
        private CogToolLID lid;
        protected Object param;

        public TaskActionTester(CogToolLID LID) {
            this.lid = LID;
        }

        protected void test() {
            this.setupTestContext();
            ProjectControllerTest.this.ui.performAction(this.lid, this.param, false);
            this.assertTestEffects();
        }
    }

    protected abstract class TaskTester {
        protected Map und = new IdentityHashMap();
        protected IUndertaking[] u = new IUndertaking[4];
        protected ITaskSelectionState selection = new SingleTaskSelection(this.u[0], null);

        protected TaskTester() {
        }

        protected abstract void setupTestParameters();

        protected abstract void test();

        protected void assertDoneEffectsOn(IUndertaking task) {
        }

        protected void assertDoneEffects() {
            HashSet<IUndertaking> sel = new HashSet<IUndertaking>(Arrays.asList(this.selection.getSelectedTasks()));
            Iterator i = this.und.keySet().iterator();
            while (i.hasNext()) {
                IUndertaking next = (IUndertaking)i.next();
                if (sel.contains(next)) {
                    this.assertDoneEffectsOn(next);
                    continue;
                }
                if (next instanceof Task) {
                    Assert.assertTrue((boolean)Task.isIdentical((Task)next, (Task)this.und.get(next)));
                    continue;
                }
                if (next instanceof TaskGroup) {
                    Assert.assertTrue((boolean)TaskGroup.isIdentical((TaskGroup)next, (TaskGroup)this.und.get(next)));
                    continue;
                }
                throw new RuntimeException("Unrecognized IUndertaking implementation");
            }
        }

        protected void assertNoneEffects() {
            Iterator i = this.und.keySet().iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof Task) {
                    Assert.assertTrue((boolean)Task.isIdentical((Task)next, (Task)this.und.get(next)));
                    continue;
                }
                if (next instanceof TaskGroup) {
                    Assert.assertTrue((boolean)TaskGroup.isIdentical((TaskGroup)next, (TaskGroup)this.und.get(next)));
                    continue;
                }
                throw new RuntimeException("Unrecognized IUndertaking implementation");
            }
        }

        protected void setupTestContext() {
            int i;
            ProjectControllerTest.this.model.getDesigns().clear();
            ProjectControllerTest.this.model.getUndertakings().clear();
            ITaskSelectionState sel = new EmptyTaskSelectionState();
            IProjectInteraction old = ProjectControllerTest.this.controller.interaction;
            ProjectControllerTest.this.controller.interaction = ProjectControllerTest.this.DUMMY_PROJECT_INTERACTION;
            ProjectControllerTest.this.ui.performAction(CogToolLID.NewTaskGroup, sel, false);
            this.u[0] = (IUndertaking)ProjectControllerTest.this.model.getUndertakings().get(0);
            ProjectControllerTest.this.ui.performAction(CogToolLID.NewTaskGroup, sel, false);
            HashSet tasks = new HashSet(ProjectControllerTest.this.model.getUndertakings());
            tasks.remove(this.u[0]);
            this.u[1] = (IUndertaking)tasks.iterator().next();
            IUndertaking parent = this.u[1];
            ProjectControllerTest.this.ui.performAction(CogToolLID.NewTask, sel, false);
            tasks = new HashSet(ProjectControllerTest.this.model.getUndertakings());
            for (i = 0; i < 2; ++i) {
                tasks.remove(this.u[i]);
            }
            this.u[2] = (IUndertaking)tasks.iterator().next();
            sel = new SingleTaskSelection(parent, null);
            ProjectControllerTest.this.ui.performAction(CogToolLID.NewTask, sel, false);
            tasks = new HashSet(ProjectControllerTest.this.model.getUndertakings());
            for (i = 0; i < 3; ++i) {
                tasks.remove(this.u[i]);
            }
            this.u[3] = (IUndertaking)tasks.iterator().next();
            ProjectControllerTest.this.controller.interaction = old;
            this.setupTestParameters();
            for (i = 0; i < 4; ++i) {
                this.und.put(this.u[i], ((AUndertaking)this.u[i]).clone());
            }
        }

        protected void assertTestEffects() {
            this.assertDoneEffects();
            if (this.shouldTestUndoAndRedo()) {
                ProjectControllerTest.this.ui.performAction(CogToolLID.Undo, null, false);
                this.assertNoneEffects();
                ProjectControllerTest.this.ui.performAction(CogToolLID.Redo, null, false);
                this.assertDoneEffects();
            }
        }

        protected boolean shouldTestUndoAndRedo() {
            return true;
        }
    }

    protected abstract class DesignActionTester
    extends DesignTester {
        private CogToolLID lid;
        protected Object param;

        public DesignActionTester(CogToolLID LID) {
            this.lid = LID;
        }

        protected void test() {
            this.setupTestContext();
            ProjectControllerTest.this.ui.performAction(this.lid, this.param, false);
            this.assertTestEffects();
        }
    }

    protected abstract class DesignTester {
        protected Map des = new IdentityHashMap();
        protected Design[] d = new Design[4];
        protected IDesignSelectionState selection = new IDesignSelectionState(this){
            private final /* synthetic */ DesignTester this$1;
            {
                this.this$1 = this$1;
            }

            public IDesign getSelectedDesign() {
                return this.this$1.d[0];
            }
        };

        protected DesignTester() {
        }

        protected abstract void setupTestParameters();

        protected abstract void test();

        protected void assertDoneEffectsOn(IDesign design) {
        }

        protected void assertDoneEffects() {
            Iterator i = this.des.keySet().iterator();
            while (i.hasNext()) {
                Design next = (Design)i.next();
                if (this.selection.getSelectedDesign().equals(next)) {
                    this.assertDoneEffectsOn(next);
                    continue;
                }
                Assert.assertTrue((boolean)Design.isIdentical(next, (Design)this.des.get(next)));
            }
        }

        protected void assertNoneEffects() {
            Iterator i = this.des.keySet().iterator();
            while (i.hasNext()) {
                Design next = (Design)i.next();
                Assert.assertTrue((boolean)Design.isIdentical(next, (Design)this.des.get(next)));
            }
        }

        protected void setupTestContext() {
            int i;
            ProjectControllerTest.this.model.getDesigns().clear();
            ProjectControllerTest.this.model.getUndertakings().clear();
            IDesignSelectionState sel = new IDesignSelectionState(this){
                private final /* synthetic */ DesignTester this$1;
                {
                    this.this$1 = this$1;
                }

                public IDesign getSelectedDesign() {
                    return null;
                }
            };
            IProjectInteraction old = ProjectControllerTest.this.controller.interaction;
            ProjectControllerTest.this.controller.interaction = ProjectControllerTest.this.DUMMY_PROJECT_INTERACTION;
            for (int i2 = 0; i2 < 4; ++i2) {
                ProjectControllerTest.this.ui.performAction(ProjectLID.NewDesign, sel, false);
            }
            ProjectControllerTest.this.controller.interaction = old;
            Iterator designs = ProjectControllerTest.this.model.getDesigns().iterator();
            for (i = 0; i < 4; ++i) {
                this.d[i] = (Design)designs.next();
            }
            this.setupTestParameters();
            for (i = 0; i < 4; ++i) {
                this.des.put(this.d[i], this.d[i].clone());
            }
        }

        protected void assertTestEffects() {
            this.assertDoneEffects();
            if (this.shouldTestUndoAndRedo()) {
                ProjectControllerTest.this.ui.performAction(CogToolLID.Undo, null, false);
                this.assertNoneEffects();
                ProjectControllerTest.this.ui.performAction(CogToolLID.Redo, null, false);
                this.assertDoneEffects();
            }
        }

        protected boolean shouldTestUndoAndRedo() {
            return true;
        }
    }

    protected static class EmptyTaskSelectionState
    implements ITaskSelectionState {
        protected EmptyTaskSelectionState() {
        }

        public IUndertaking[] getSelectedTasks() {
            return new IUndertaking[0];
        }

        public int getSelectedTaskCount() {
            return 0;
        }

        public ITaskGroup getSelectedTaskParent() {
            return null;
        }

        public ITaskGroup[] getSelectedTaskParents() {
            return null;
        }

        public boolean isTaskSelected(IUndertaking task) {
            return false;
        }
    }
}

