/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolClipboard;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.AController;
import edu.cmu.cs.hcii.cogtool.controller.ControllerNexus;
import edu.cmu.cs.hcii.cogtool.controller.DefaultController;
import edu.cmu.cs.hcii.cogtool.controller.DesignEditorController;
import edu.cmu.cs.hcii.cogtool.controller.ExportToHTMLWorkThread;
import edu.cmu.cs.hcii.cogtool.controller.UndoController;
import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.CORETraceParser;
import edu.cmu.cs.hcii.cogtool.model.DelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DriveScriptStep;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IResultRevalidator;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.ImportCogTool;
import edu.cmu.cs.hcii.cogtool.model.LookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.Project;
import edu.cmu.cs.hcii.cogtool.model.Script;
import edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo;
import edu.cmu.cs.hcii.cogtool.model.TapScriptStep;
import edu.cmu.cs.hcii.cogtool.model.Task;
import edu.cmu.cs.hcii.cogtool.model.TaskApplication;
import edu.cmu.cs.hcii.cogtool.model.TaskGroup;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.model.ThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ToActr;
import edu.cmu.cs.hcii.cogtool.model.ToIRG;
import edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IProjectInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IProjectUI;
import edu.cmu.cs.hcii.cogtool.ui.ISelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.ui.ProjectLID;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.AUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.CSVSupport;
import edu.cmu.cs.hcii.cogtool.util.CompoundUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.RcvrClipboardException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOSaveException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOTempException;
import edu.cmu.cs.hcii.cogtool.util.RcvrParsingException;
import edu.cmu.cs.hcii.cogtool.util.ThreadManager;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProjectController
extends DefaultController {
    protected UndoManager undoMgr = CogTool.undoManagerFactory.getUndoManager(this.project);
    protected IProjectUI ui;
    protected IProjectInteraction interaction;
    protected int nextNewDesignSuffix = 1;
    protected static int nextNewProjectSuffix = 1;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IProjectUI$TaskRenameEvent;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;

    public ProjectController() {
        this(new Project(L10N.get("PM.NewProjectName", "Untitled Project") + " " + nextNewProjectSuffix++), true, true);
    }

    public ProjectController(IProject proj, boolean unregistered, boolean unmodified) {
        super(proj);
        if (unmodified) {
            this.undoMgr.markSavePoint();
        }
        if (unregistered) {
            try {
                this.persist.registerForPersistence(this.project);
            }
            catch (IOException e) {
                throw new RcvrIOTempException("Error persisting new project: " + e.getMessage(), e);
            }
        }
        this.ui = CogTool.projectUIFactory.createProjectUI(this.project, this.undoMgr);
        this.interaction = this.ui.getInteraction();
        this.assignActions();
        this.ui.setVisible(true);
    }

    public IProject getModel() {
        return this.project;
    }

    protected Object getModelObject() {
        return this.getModel();
    }

    public boolean openExistingProject(DoublePoint loc) {
        return this.performAction(ProjectLID.OpenProject, loc, false);
    }

    public void populateProject() {
        this.performAction(ProjectLID.NewProjectNewDesign, new IDesignSelectionState(){

            public IDesign getSelectedDesign() {
                return null;
            }
        }, false);
        this.performAction(ProjectLID.NewTask, new ITaskSelectionState(){

            public IUndertaking[] getSelectedTasks() {
                return null;
            }

            public int getSelectedTaskCount() {
                return 0;
            }

            public ITaskGroup getSelectedTaskParent() {
                return null;
            }

            public ITaskGroup[] getSelectedTaskParents() {
                return null;
            }

            public boolean isTaskSelected(IUndertaking t) {
                return false;
            }
        }, false);
    }

    public void assignActions() {
        super.assignActions();
        this.ui.setAction(ProjectLID.Undo, new UndoController.UndoAction(this.undoMgr, this.interaction));
        this.ui.setAction(ProjectLID.Redo, new UndoController.RedoAction(this.undoMgr, this.interaction));
        this.ui.setAction(ProjectLID.DeselectAll, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ISelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState;
            }

            public boolean performAction(Object prms) {
                ISelectionState selection = (ISelectionState)prms;
                selection.deselectAll();
                return true;
            }
        });
        this.ui.setAction(ProjectLID.Paste, this.createPasteAction());
        this.ui.setAction(ProjectLID.CaptureBehavior, this.createCaptureAction());
        this.ui.setAction(ProjectLID.CopyDesign, this.createCopyDesignAction());
        this.ui.setAction(ProjectLID.CopyTask, this.createCopyTaskAction());
        this.ui.setAction(ProjectLID.CutDesign, this.createCutDesignAction());
        this.ui.setAction(ProjectLID.CutTask, this.createCutTaskAction());
        this.ui.setAction(ProjectLID.SelectAll, new AListenerAction(){

            public boolean performAction(Object prms) {
                ProjectController.this.ui.selectAllTasks();
                return true;
            }
        });
        this.ui.setAction(ProjectLID.NewDesign, this.createNewDesignAction());
        this.ui.setAction(ProjectLID.NewProjectNewDesign, this.createNameProjectNewDesignAction());
        this.ui.setAction(ProjectLID.EditDesign, this.createEditDesignAction());
        this.ui.setAction(ProjectLID.EditTask, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState selection = (ITaskSelectionState)prms;
                IUndertaking[] selectedTasks = selection.getSelectedTasks();
                if (selectedTasks.length == 1) {
                    ProjectController.this.ui.initiateTaskRename(selectedTasks[0]);
                    return true;
                }
                return false;
            }
        });
        this.ui.setAction(ProjectLID.RenameDesign, this.createRenameDesignAction());
        this.ui.setAction(ProjectLID.InitiateTaskRename, this.createInitiateTaskRenameAction());
        this.ui.setAction(ProjectLID.RenameTask, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectUI$TaskRenameEvent == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectUI$TaskRenameEvent = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectUI$TaskRenameEvent")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectUI$TaskRenameEvent;
            }

            public boolean performAction(Object prms) {
                IProjectUI.TaskRenameEvent evt = (IProjectUI.TaskRenameEvent)prms;
                return ProjectController.this.renameTask(evt.task, evt.task.getName(), evt.newName, evt.parent);
            }
        });
        this.ui.setAction(ProjectLID.EditScript, this.createScriptEditorAction());
        this.ui.setAction(ProjectLID.DeleteDesign, this.createDeleteDesignAction());
        this.ui.setAction(ProjectLID.DeleteTask, this.createDeleteTaskAction());
        this.ui.setAction(ProjectLID.NewTask, this.createNewTaskAction());
        this.ui.setAction(ProjectLID.NewTaskGroup, this.createNewTaskGroupAction());
        this.ui.setAction(ProjectLID.ShowSum, this.createShowNatureAction(GroupNature.SUM, ProjectLID.ShowSum));
        this.ui.setAction(ProjectLID.ShowMean, this.createShowNatureAction(GroupNature.MEAN, ProjectLID.ShowMean));
        this.ui.setAction(ProjectLID.ShowMin, this.createShowNatureAction(GroupNature.MIN, ProjectLID.ShowMin));
        this.ui.setAction(ProjectLID.ShowMax, this.createShowNatureAction(GroupNature.MAX, ProjectLID.ShowMax));
        this.ui.setAction(ProjectLID.RecomputeScript, this.createRecomputeScriptAction());
        this.ui.setAction(ProjectLID.ShowModelVisualization, this.createShowModelVisualizationAction());
        this.ui.setAction(ProjectLID.ExportACTRTrace, this.createExportACTRTrace());
        this.ui.setAction(ProjectLID.ExportActrModelFile, this.createExportActrModelFile());
        this.ui.setAction(ProjectLID.ExportDesignToHTML, this.createExportDesignToHTMLAction());
        this.ui.setAction(ProjectLID.ImportXML, this.createImportAction());
        this.ui.setAction(ProjectLID.ExportScriptToCSV, this.createExportScriptToCSVAction());
        this.ui.setAction(ProjectLID.DuplicateDesign, this.createDuplicateDesignAction());
        this.ui.setAction(ProjectLID.ExportCoreCSVFile, this.createExportCoreCSVFileAction());
        this.ui.setAction(ProjectLID.ImportCoreCSVFile, this.createImportCoreCSVFileAction());
    }

    protected IListenerAction createExportACTRTrace() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean performAction(Object actionParms) {
                IProjectSelectionState sel = (IProjectSelectionState)actionParms;
                ArrayList traces = ProjectController.this.getTraces(sel, StandaloneAlgo.ONLY);
                File exportFile = ProjectController.this.interaction.selectExportLocation("Exported ACT-R trace", ".txt");
                if (exportFile == null) {
                    return false;
                }
                boolean okToProceed = false;
                PrintWriter writer = null;
                try {
                    FileOutputStream out = new FileOutputStream(exportFile);
                    writer = new PrintWriter(out);
                    Iterator iter = traces.iterator();
                    while (iter.hasNext()) {
                        String s = (String)iter.next();
                        writer.println(s);
                    }
                    writer.flush();
                    okToProceed = true;
                }
                catch (IOException e) {
                    ProjectController.this.interaction.reportProblem("ERROR Writing the trace logs", "Writing the trace logs failed. \n\nPlease try again.");
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                return okToProceed;
            }
        };
    }

    protected IListenerAction createExportActrModelFile() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean performAction(Object actionParms) {
                IProjectSelectionState sel = (IProjectSelectionState)actionParms;
                PrintWriter out = null;
                boolean okToProceed = false;
                try {
                    IDesign design = sel.getSelectedDesign();
                    IUndertaking[] tasks = sel.getSelectedTasks();
                    if (design == null || tasks == null || tasks.length == 0) {
                        boolean bl = false;
                        return bl;
                    }
                    File exportFile = ProjectController.this.interaction.selectExportLocation("Exported ACT-R Model", ".lisp");
                    if (exportFile == null) {
                        boolean bl = false;
                        return bl;
                    }
                    out = new PrintWriter(new BufferedWriter(new FileWriter(exportFile)));
                    StandaloneAlgo alg = StandaloneAlgo.ONLY;
                    for (int i = 0; i < tasks.length; ++i) {
                        ITaskApplication ta = ProjectController.this.project.getTaskApplication(tasks[i], design);
                        if (ta == null) continue;
                        IScript script = ta.getScript(alg);
                        if (script == null) {
                            script = new Script(design);
                            ta.setScript(alg, script);
                        }
                        out.write(";; For Design: " + design.getName() + "\n");
                        out.write(";; For Task: " + tasks[i].getName() + "\n\n");
                        ToActr.design(script.getDesign(), script.getStartFrame(), out);
                        ToActr.script(script, out);
                    }
                    okToProceed = true;
                }
                catch (IOException e) {
                    ProjectController.this.interaction.reportProblem("ERROR Writing the ACT-R model file", "Writing the ACT-R model file failed. \n\nPlease try again.");
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                return okToProceed;
            }
        };
    }

    protected ArrayList getTraces(final IUndertaking task, IDesign design, IPredictionAlgo alg) {
        IPredictionResult result;
        final ArrayList<String> traces = new ArrayList<String>();
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            traces.add("For TaskGroup " + task.getName());
            while (allTasks.hasNext()) {
                traces.addAll(this.getTraces((IUndertaking)allTasks.next(), design, alg));
            }
            return traces;
        }
        ITaskApplication taskApp = this.project.getTaskApplication(task, design);
        if (taskApp != null && taskApp.isResultCurrent(alg) && (result = taskApp.getResult(alg)) != null) {
            traces.add("Standard OUTPUT from Task " + task.getName());
            IPredictionResult.PredictionResultVisitorAdapter visitor = new IPredictionResult.PredictionResultVisitorAdapter(){

                public void visit(StandaloneAlgo.StandaloneResult result) {
                    traces.addAll(result.getTraceLines());
                    traces.add("\nStandard ERROR from Task " + task.getName());
                    traces.addAll(result.getErrorLines());
                }
            };
            result.accept(visitor);
        }
        return traces;
    }

    protected ArrayList getTraces(IProjectSelectionState sel, IPredictionAlgo alg) {
        ArrayList<String> traces;
        block7: {
            IUndertaking[] tasks;
            block6: {
                IDesign design = sel.getSelectedDesign();
                tasks = sel.getSelectedTasks();
                traces = new ArrayList<String>();
                if (design == null) break block6;
                traces.add("For Design " + design.getName());
                if (tasks != null && tasks.length > 0) {
                    for (int i = 0; i < tasks.length; ++i) {
                        traces.addAll(this.getTraces(tasks[i], design, alg));
                    }
                } else {
                    Iterator allTasks = this.project.getUndertakings().iterator();
                    while (allTasks.hasNext()) {
                        traces.addAll(this.getTraces((IUndertaking)allTasks.next(), design, alg));
                    }
                }
                break block7;
            }
            if (tasks == null || tasks.length <= 0) break block7;
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    IDesign d = (IDesign)allDesigns.next();
                    traces.add("For Design " + d.getName());
                    traces.addAll(this.getTraces(tasks[i], d, alg));
                }
            }
        }
        return traces;
    }

    public void dispose() {
        super.dispose();
        if (CogTool.PROJECT_MANAGES_OTHERS) {
            ControllerNexus.ONLY.closeControllers(this.project, false);
        }
    }

    protected void printTree(List tasks, String indent) {
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            IUndertaking u = (IUndertaking)it.next();
            if (u.isGroup()) {
                System.out.println(indent + "TaskGroup: " + u.getClass().getName());
                this.printTree(((ITaskGroup)u).getUndertakings(), indent + "  ");
                continue;
            }
            System.out.println(indent + "Task     : " + u);
        }
    }

    protected void makeDesignNameUnique(IDesign design) {
        design.setName(ProjectController.makeNameUnique(design.getName(), this.project.getDesigns()));
    }

    protected void makeTaskNameUnique(IUndertaking task) {
        task.setName(ProjectController.makeNameUnique(task.getName(), this.project.getUndertakings()));
    }

    protected void makeTaskNameUnique(ITaskGroup parent, IUndertaking task) {
        task.setName(ProjectController.makeNameUnique(task.getName(), parent.getUndertakings()));
    }

    protected IListenerAction createPasteAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                IProjectSelectionState seln = (IProjectSelectionState)prms;
                try {
                    Collection objects = CogToolClipboard.fetchCogToolObjects();
                    if (objects != null && objects.size() > 0) {
                        ITaskGroup taskParent = seln.getSelectedTaskParent();
                        int index = -1;
                        if (taskParent != null) {
                            IUndertaking[] selectedTasks = seln.getSelectedTasks();
                            IUndertaking last = selectedTasks[selectedTasks.length - 1];
                            index = taskParent.getUndertakings().indexOf(last) + 1;
                        }
                        String presentationName = L10N.get("UNDO.Paste", "Paste");
                        CompoundUndoableEdit edit = new CompoundUndoableEdit(presentationName, ProjectLID.Paste);
                        Iterator objIt = objects.iterator();
                        while (objIt.hasNext()) {
                            Object o = objIt.next();
                            if (o instanceof IDesign) {
                                IDesign design = (IDesign)o;
                                ProjectController.this.makeDesignNameUnique(design);
                                edit.addEdit(ProjectController.this.addNewDesign(design, seln, presentationName));
                                continue;
                            }
                            if (!(o instanceof IUndertaking)) continue;
                            IUndertaking task = (IUndertaking)o;
                            if (taskParent == null) {
                                ProjectController.this.makeTaskNameUnique(task);
                                ProjectController.this.project.addUndertaking(task);
                            } else {
                                ProjectController.this.makeTaskNameUnique(taskParent, task);
                                taskParent.addUndertaking(index, task);
                            }
                            edit.addEdit(ProjectController.this.createNewTaskUndo(taskParent, task));
                        }
                        edit.end();
                        ProjectController.this.undoMgr.addEdit(edit);
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        };
    }

    protected IListenerAction createCopyDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                IDesignSelectionState seln = (IDesignSelectionState)prms;
                IDesign design = seln.getSelectedDesign();
                if (design != null) {
                    try {
                        ObjectSaver s = CogToolClipboard.startClipboardSave("EntireDesign");
                        s.saveObject(design);
                        s.finish();
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    ProjectController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected IListenerAction createCutDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                IDesignSelectionState selection = (IDesignSelectionState)prms;
                IDesign selectedDesign = selection.getSelectedDesign();
                if (selectedDesign != null) {
                    if (ProjectController.this.interaction.confirmDeleteDesign(selectedDesign)) {
                        try {
                            ObjectSaver s = CogToolClipboard.startClipboardSave("EntireDesign");
                            ProjectController.this.deleteDesign(selectedDesign, s);
                            s.finish();
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    ProjectController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected boolean createNewDesign(Object prms, boolean newProjectMode) {
        IDesignSelectionState selection = (IDesignSelectionState)prms;
        String defaultDesignName = "NewDesign" + this.nextNewDesignSuffix;
        while (this.project.getDesign(defaultDesignName) != null) {
            defaultDesignName = "NewDesign" + ++this.nextNewDesignSuffix;
        }
        IProjectInteraction.DesignRequestData requestData = new IProjectInteraction.DesignRequestData();
        requestData.designName = defaultDesignName;
        requestData.deviceTypes = new HashSet();
        while (true) {
            boolean done;
            if (!this.interaction.requestNewDesignName(requestData, newProjectMode, this.project)) {
                return false;
            }
            if (requestData.designName.equals("")) {
                if (this.interaction.protestEmptyDesignName()) continue;
                return false;
            }
            if (requestData.deviceTypes.isEmpty()) {
                if (this.interaction.protestNoDeviceTypes()) continue;
                return false;
            }
            try {
                this.createNewDesign(requestData.designName, requestData.deviceTypes, selection);
                done = true;
                if (requestData.designName.equals(defaultDesignName)) {
                    ++this.nextNewDesignSuffix;
                }
            }
            catch (IllegalArgumentException e) {
                boolean bl = done = !this.interaction.protestNotUniqueDesignName();
            }
            if (done) break;
        }
        return true;
    }

    protected IListenerAction createNewDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                return ProjectController.this.createNewDesign(prms, false);
            }
        };
    }

    protected IListenerAction createNameProjectNewDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                return ProjectController.this.createNewDesign(prms, true);
            }
        };
    }

    protected boolean interactToRenameDesign(IDesign selectedDesign) {
        String oldDesignName;
        String designName = oldDesignName = selectedDesign.getName();
        while (true) {
            if ((designName = this.interaction.requestDesignRename(designName)) == null) {
                return false;
            }
            if (designName.equals("")) {
                if (this.interaction.protestEmptyDesignName()) {
                    designName = oldDesignName;
                    continue;
                }
                return false;
            }
            if (designName.equals(oldDesignName) || this.project.getDesign(designName) == null) {
                this.renameDesign(selectedDesign, oldDesignName, designName);
                return true;
            }
            if (!this.interaction.protestNotUniqueDesignName()) break;
        }
        return false;
    }

    protected boolean interactToRenameTask(IUndertaking selectedTask, ITaskSelectionState selection) {
        String oldTaskName = selectedTask.getName();
        IProjectInteraction.TaskRequestData requestData = new IProjectInteraction.TaskRequestData();
        requestData.taskName = oldTaskName;
        requestData.flags = 0;
        GroupNature oldNature = GroupNature.MEAN;
        if (selectedTask.isGroup()) {
            requestData.flags = 1;
            oldNature = ((ITaskGroup)selectedTask).getNature();
        }
        requestData.nature = oldNature;
        while (true) {
            if (!this.interaction.requestNewTaskName(requestData)) {
                return false;
            }
            if (requestData.taskName.equals("")) {
                if (this.interaction.protestEmptyTaskName()) continue;
                return false;
            }
            ITaskGroup parent = selection.getSelectedTaskParent();
            if (this.isTaskNameUnique(requestData.taskName, oldTaskName, parent)) {
                if (selectedTask.isGroup() && requestData.nature != oldNature) {
                    this.modifyTaskGroup((ITaskGroup)selectedTask, oldTaskName, requestData.taskName, oldNature, requestData.nature);
                    return true;
                }
                return this.renameTask(selectedTask, oldTaskName, requestData.taskName, parent);
            }
            if (!this.interaction.protestNotUniqueTaskName()) break;
        }
        return false;
    }

    protected IListenerAction createEditDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                IDesignSelectionState selection = (IDesignSelectionState)prms;
                IDesign selectedDesign = selection.getSelectedDesign();
                if (selectedDesign != null) {
                    CogTool.designEditorControllerFactory.openController(selectedDesign, ProjectController.this.project);
                    return true;
                }
                ProjectController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IListenerAction createRenameDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                IDesignSelectionState selection = (IDesignSelectionState)prms;
                IDesign selectedDesign = selection.getSelectedDesign();
                if (selectedDesign != null) {
                    return ProjectController.this.interactToRenameDesign(selectedDesign);
                }
                ProjectController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IListenerAction createCopyTaskAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState seln = (ITaskSelectionState)prms;
                IUndertaking[] tasks = seln.getSelectedTasks();
                if (tasks != null && tasks.length > 0) {
                    try {
                        ObjectSaver s = CogToolClipboard.startClipboardSave("Task");
                        for (int i = 0; i < tasks.length; ++i) {
                            s.saveObject(tasks[i]);
                        }
                        s.finish();
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    ProjectController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected IListenerAction createCutTaskAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState selection = (ITaskSelectionState)prms;
                IUndertaking[] selectedTasks = selection.getSelectedTasks();
                if (selectedTasks != null && selectedTasks.length > 0) {
                    try {
                        ObjectSaver saver = CogToolClipboard.startClipboardSave("Task");
                        ProjectController.this.deleteTasks(selectedTasks, saver);
                        saver.finish();
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    ProjectController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected IListenerAction createInitiateTaskRenameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState selection = (ITaskSelectionState)prms;
                int selectedTaskCount = selection.getSelectedTaskCount();
                if (selectedTaskCount == 1) {
                    ProjectController.this.ui.initiateTaskRename(selection.getSelectedTasks()[0]);
                    return true;
                }
                ProjectController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IListenerAction createDeleteDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                IDesignSelectionState selection = (IDesignSelectionState)prms;
                IDesign selectedDesign = selection.getSelectedDesign();
                if (selectedDesign != null) {
                    if (ProjectController.this.interaction.confirmDeleteDesign(selectedDesign)) {
                        ProjectController.this.deleteDesign(selectedDesign, null);
                        return true;
                    }
                } else {
                    ProjectController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected IListenerAction createDeleteTaskAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState selection = (ITaskSelectionState)prms;
                IUndertaking[] selectedTasks = selection.getSelectedTasks();
                if (selectedTasks != null && selectedTasks.length > 0) {
                    if (ProjectController.this.interaction.confirmDeleteTasks(selectedTasks)) {
                        try {
                            ProjectController.this.deleteTasks(selectedTasks, null);
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    ProjectController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected void createNewDesign(String newDesignName, Set deviceTypes, IDesignSelectionState selection) {
        Design design = new Design(newDesignName, deviceTypes);
        Frame frame = new Frame(DesignEditorController.INITIAL_FRAME_NAME, design.getDeviceTypes());
        frame.setFrameOrigin(16.0, 16.0);
        design.addFrame(frame);
        this.undoMgr.addEdit(this.addNewDesign(design, selection, L10N.get("UNDO.PM.NewDesign", "New Design")));
    }

    protected IUndoableEdit addNewDesign(final IDesign design, IDesignSelectionState selection, final String presentationName) {
        IDesign selectedDesign = selection.getSelectedDesign();
        final int beforeIndex = selectedDesign != null ? this.project.getDesigns().indexOf(selectedDesign) : this.project.getDesigns().size();
        this.project.addDesign(beforeIndex, design);
        return new AUndoableEdit(ProjectLID.NewDesign){
            protected Map associatedTDs;
            {
                super(x0);
                this.associatedTDs = null;
            }

            public String getPresentationName() {
                return presentationName;
            }

            public void redo() {
                super.redo();
                ProjectController.this.project.addDesign(beforeIndex, design);
                if (this.associatedTDs != null) {
                    ProjectController.this.project.restoreRemovedTaskApplications(this.associatedTDs);
                }
            }

            public void undo() {
                super.undo();
                this.associatedTDs = ProjectController.this.project.taskApplicationsForRemovedDesign(design);
                ProjectController.this.project.removeDesign(design);
            }
        };
    }

    protected void renameDesign(final IDesign renamedDesign, final String oldDesignName, final String newDesignName) {
        if (!newDesignName.equals(oldDesignName)) {
            renamedDesign.setName(newDesignName);
            this.undoMgr.addEdit(new AUndoableEdit(ProjectLID.RenameDesign){

                public String getPresentationName() {
                    return L10N.get("UNDO.PM.RenameDesign", "Rename Design");
                }

                public void redo() {
                    super.redo();
                    renamedDesign.setName(newDesignName);
                }

                public void undo() {
                    super.undo();
                    renamedDesign.setName(oldDesignName);
                }
            });
        }
    }

    protected void deleteDesign(final IDesign designToDelete, ObjectSaver saver) {
        final int designIndex = this.project.getDesigns().indexOf(designToDelete);
        final Map assocTDs = this.project.taskApplicationsForRemovedDesign(designToDelete);
        this.project.removeDesign(designToDelete);
        if (saver != null) {
            try {
                saver.saveObject(designToDelete);
            }
            catch (IOException ex) {
                throw new RcvrClipboardException(ex);
            }
        }
        AUndoableEdit edit = new AUndoableEdit(ProjectLID.DeleteDesign){
            protected Map associatedTDs;
            {
                super(x0);
                this.associatedTDs = assocTDs;
            }

            public String getPresentationName() {
                return L10N.get("UNDO.PM.DeleteDesign", "Delete Design");
            }

            public void redo() {
                super.redo();
                this.associatedTDs = ProjectController.this.project.taskApplicationsForRemovedDesign(designToDelete);
                ProjectController.this.project.removeDesign(designToDelete);
            }

            public void undo() {
                super.undo();
                ProjectController.this.project.addDesign(designIndex, designToDelete);
                ProjectController.this.project.restoreRemovedTaskApplications(this.associatedTDs);
            }
        };
        this.undoMgr.addEdit(edit);
    }

    protected IListenerAction createNewTaskAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState selection = (ITaskSelectionState)prms;
                IUndertaking[] selectedTasks = selection.getSelectedTasks();
                ITask newTask = null;
                if (selectedTasks == null || selectedTasks.length == 0) {
                    List pu = ProjectController.this.project.getUndertakings();
                    newTask = pu.size() == 0 ? ProjectController.this.addRootTask(null) : ProjectController.this.addRootTask((IUndertaking)pu.get(pu.size() - 1));
                } else {
                    ITaskGroup parent = selection.getSelectedTaskParent();
                    if (parent == null) {
                        newTask = ProjectController.this.addRootTask(ProjectController.this.findLastSelectedRoot(selectedTasks));
                    } else {
                        IUndertaking last = selectedTasks[selectedTasks.length - 1];
                        newTask = ProjectController.this.addTask(parent, last);
                    }
                }
                ProjectController.this.ui.initiateTaskRename(newTask);
                return true;
            }
        };
    }

    private IUndertaking findLastSelectedRoot(IUndertaking[] selectedTasks) {
        List roots = this.project.getUndertakings();
        for (int i = selectedTasks.length - 1; i >= 0; --i) {
            IUndertaking task = selectedTasks[i];
            if (!roots.contains(task)) continue;
            return task;
        }
        return (IUndertaking)roots.get(roots.size() - 1);
    }

    protected ITask addRootTask(IUndertaking prev) {
        String newTaskName;
        int index;
        int nextNewTaskSuffix = 0;
        int n = index = prev == null ? 0 : this.project.getUndertakings().indexOf(prev) + 1;
        while (this.project.getUndertaking(newTaskName = L10N.get("PM.NewTaskName", "Task") + " " + ++nextNewTaskSuffix) != null) {
        }
        Task newTask = new Task(newTaskName);
        this.project.addUndertaking(index, newTask);
        this.undoMgr.addEdit(this.createNewTaskUndo(null, newTask));
        return newTask;
    }

    protected ITask addTask(ITaskGroup parent, IUndertaking prev) {
        String newTaskName;
        int nextNewTaskSuffix = 0;
        int index = parent.getUndertakings().indexOf(prev) + 1;
        while (parent.getUndertaking(newTaskName = L10N.get("PM.NewTaskName", "Task") + " " + ++nextNewTaskSuffix) != null) {
        }
        Task newTask = new Task(newTaskName);
        parent.addUndertaking(index, newTask);
        this.undoMgr.addEdit(this.createNewTaskUndo(parent, newTask));
        return newTask;
    }

    protected IUndoableEdit createNewTaskUndo(final ITaskGroup parent, final IUndertaking newTask) {
        return new AUndoableEdit(ProjectLID.NewTask){
            protected Map associatedTDs;
            {
                super(x0);
                this.associatedTDs = null;
            }

            public String getPresentationName() {
                return L10N.get("UNDO.PM.NewTask", "New Task");
            }

            public void redo() {
                super.redo();
                if (parent != null) {
                    parent.addUndertaking(newTask);
                } else {
                    ProjectController.this.project.addUndertaking(newTask);
                }
                if (this.associatedTDs != null) {
                    ProjectController.this.project.restoreRemovedTaskApplications(this.associatedTDs);
                }
            }

            public void undo() {
                super.undo();
                this.associatedTDs = ProjectController.this.project.taskApplicationsForRemovedTask(newTask);
                if (parent != null) {
                    parent.removeUndertaking(newTask);
                } else {
                    ProjectController.this.project.removeUndertaking(newTask);
                }
            }
        };
    }

    protected IListenerAction createNewTaskGroupAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ITaskSelectionState selection = (ITaskSelectionState)prms;
                IUndertaking[] selectedTasks = selection.getSelectedTasks();
                ITaskGroup newGroup = null;
                if (selectedTasks == null || selectedTasks.length == 0) {
                    List pu = ProjectController.this.project.getUndertakings();
                    newGroup = pu.size() == 0 ? ProjectController.this.addRootTaskGroup(null, selection) : ProjectController.this.addRootTaskGroup((IUndertaking)pu.get(pu.size() - 1), selection);
                } else {
                    ITaskGroup parent = selection.getSelectedTaskParent();
                    if (parent == null) {
                        newGroup = ProjectController.this.addRootTaskGroup(ProjectController.this.findLastSelectedRoot(selectedTasks), selection);
                    } else {
                        IUndertaking last = selectedTasks[selectedTasks.length - 1];
                        newGroup = ProjectController.this.addTaskGroup(parent, last, selection);
                    }
                }
                ProjectController.this.ui.initiateTaskRename(newGroup);
                return true;
            }
        };
    }

    protected ITaskGroup addRootTaskGroup(IUndertaking prev, ITaskSelectionState selection) {
        String newTaskName;
        int nextNewTaskSuffix = 0;
        int index = this.project.getUndertakings().indexOf(prev) + 1;
        while (this.project.getUndertaking(newTaskName = L10N.get("PM.NewTaskGroupName", "Task Group") + " " + ++nextNewTaskSuffix) != null) {
        }
        TaskGroup newGroup = new TaskGroup(newTaskName, GroupNature.SUM);
        IUndertaking[] children = selection.getSelectedTasks();
        ITaskGroup[] oldParents = new ITaskGroup[children.length];
        int[] indexes = new int[children.length];
        this.project.addUndertaking(index, newGroup);
        this.removeChildTasks(children, oldParents, indexes);
        this.addToTaskGroup(children, newGroup);
        this.undoMgr.addEdit(this.createNewTaskGroupUndo(null, index, newGroup, oldParents, indexes, children));
        return newGroup;
    }

    protected ITaskGroup addTaskGroup(ITaskGroup parent, IUndertaking prev, ITaskSelectionState selection) {
        String newTaskName;
        int nextNewTaskSuffix = 0;
        int index = parent.getUndertakings().indexOf(prev) + 1;
        while (parent.getUndertaking(newTaskName = L10N.get("PM.NewTaskGroupName", "Task Group") + " " + ++nextNewTaskSuffix) != null) {
        }
        TaskGroup newGroup = new TaskGroup(newTaskName, GroupNature.SUM);
        IUndertaking[] children = selection.getSelectedTasks();
        ITaskGroup[] oldParents = new ITaskGroup[children.length];
        int[] indexes = new int[children.length];
        parent.addUndertaking(index, newGroup);
        this.removeChildTasks(children, oldParents, indexes);
        this.addToTaskGroup(children, newGroup);
        this.undoMgr.addEdit(this.createNewTaskGroupUndo(parent, index, newGroup, oldParents, indexes, children));
        return newGroup;
    }

    protected void removeChildTasks(IUndertaking[] children, ITaskGroup[] oldParents, int[] indexes) {
        for (int i = 0; i < children.length; ++i) {
            ITaskGroup group = children[i].getTaskGroup();
            if (group == null) {
                if (indexes != null) {
                    indexes[i] = this.project.getUndertakings().indexOf(children[i]);
                }
                this.project.removeUndertaking(children[i]);
            } else {
                if (indexes != null) {
                    indexes[i] = group.getUndertakings().indexOf(children[i]);
                }
                group.removeUndertaking(children[i]);
            }
            if (oldParents == null) continue;
            oldParents[i] = group;
        }
    }

    protected void addToTaskGroup(IUndertaking[] children, ITaskGroup newGroup) {
        for (int i = 0; i < children.length; ++i) {
            newGroup.addUndertaking(children[i]);
        }
    }

    protected IUndoableEdit createNewTaskGroupUndo(final ITaskGroup parent, final int index, final ITaskGroup newTaskGroup, final ITaskGroup[] oldParents, final int[] indexes, final IUndertaking[] children) {
        return new AUndoableEdit(ProjectLID.NewTaskGroup){

            public String getPresentationName() {
                return L10N.get("UNDO.PM.NewTaskGroup", "New Task Group");
            }

            public void redo() {
                super.redo();
                if (parent == null) {
                    ProjectController.this.project.addUndertaking(index, newTaskGroup);
                } else {
                    parent.addUndertaking(index, newTaskGroup);
                }
                ProjectController.this.removeChildTasks(children, null, null);
                ProjectController.this.addToTaskGroup(children, newTaskGroup);
            }

            public void undo() {
                super.undo();
                for (int i = children.length - 1; 0 <= i; --i) {
                    newTaskGroup.removeUndertaking(children[i]);
                    if (oldParents[i] == null) {
                        ProjectController.this.project.addUndertaking(indexes[i], children[i]);
                        continue;
                    }
                    oldParents[i].addUndertaking(indexes[i], children[i]);
                }
                if (parent == null) {
                    ProjectController.this.project.removeUndertaking(newTaskGroup);
                } else {
                    parent.removeUndertaking(newTaskGroup);
                }
            }
        };
    }

    protected boolean isTaskNameUnique(String newTaskName, String oldTaskName, ITaskGroup parent) {
        if (newTaskName.equals(oldTaskName)) {
            return true;
        }
        return parent != null ? parent.getUndertaking(newTaskName) == null : this.project.getUndertaking(newTaskName) == null;
    }

    protected boolean renameTask(final IUndertaking renamedTask, final String oldTaskName, final String newTaskName, ITaskGroup parent) {
        if (newTaskName.length() == 0) {
            if (this.interaction.protestEmptyTaskName()) {
                this.ui.initiateTaskRename(renamedTask);
                return true;
            }
            return false;
        }
        if (this.isTaskNameUnique(newTaskName, oldTaskName, parent)) {
            if (renamedTask.isGroup()) {
                ITaskGroup group = (ITaskGroup)renamedTask;
                this.modifyTaskGroup(group, oldTaskName, newTaskName, group.getNature(), group.getNature());
            } else if (!newTaskName.equals(oldTaskName)) {
                renamedTask.setName(newTaskName);
                this.undoMgr.addEdit(new AUndoableEdit(ProjectLID.RenameTask){

                    public String getPresentationName() {
                        return L10N.get("UNDO.PM.RenameTask", "Rename Task");
                    }

                    public void redo() {
                        super.redo();
                        renamedTask.setName(newTaskName);
                    }

                    public void undo() {
                        super.undo();
                        renamedTask.setName(oldTaskName);
                    }
                });
            }
            return true;
        }
        if (this.interaction.protestNotUniqueTaskName()) {
            this.ui.initiateTaskRename(renamedTask);
            return true;
        }
        return false;
    }

    protected void modifyTaskGroup(final ITaskGroup modifiedTaskGroup, final String oldTaskName, final String newTaskName, final GroupNature oldNature, final GroupNature newNature) {
        if (!newTaskName.equals(oldTaskName) || oldNature != newNature) {
            modifiedTaskGroup.setName(newTaskName);
            modifiedTaskGroup.setNature(newNature);
            this.undoMgr.addEdit(new AUndoableEdit(ProjectLID.EditTask){

                public String getPresentationName() {
                    return L10N.get("UNDO.PM.RenameTaskGroup", "Rename Task Group");
                }

                public void redo() {
                    super.redo();
                    modifiedTaskGroup.setName(newTaskName);
                    modifiedTaskGroup.setNature(newNature);
                }

                public void undo() {
                    super.undo();
                    modifiedTaskGroup.setName(oldTaskName);
                    modifiedTaskGroup.setNature(oldNature);
                }
            });
        }
    }

    protected void deleteTasks(final IUndertaking[] tasksToDelete, ObjectSaver saver) throws IOException {
        final Map[] assocTDs = new Map[tasksToDelete.length];
        for (int i = 0; i < tasksToDelete.length; ++i) {
            assocTDs[i] = this.project.taskApplicationsForRemovedTask(tasksToDelete[i]);
            if (saver == null) continue;
            saver.saveObject(tasksToDelete[i]);
        }
        final ITaskGroup[] oldParents = new ITaskGroup[tasksToDelete.length];
        final int[] indexes = new int[tasksToDelete.length];
        this.removeChildTasks(tasksToDelete, oldParents, indexes);
        AUndoableEdit edit = new AUndoableEdit(ProjectLID.DeleteTask){
            protected Map[] associatedTDs;
            {
                super(x0);
                this.associatedTDs = assocTDs;
            }

            public String getPresentationName() {
                return L10N.get("UNDO.PM.DeleteTasks", "Delete Task(s)");
            }

            public void redo() {
                super.redo();
                for (int i = 0; i < tasksToDelete.length; ++i) {
                    this.associatedTDs[i] = ProjectController.this.project.taskApplicationsForRemovedTask(tasksToDelete[i]);
                }
                ProjectController.this.removeChildTasks(tasksToDelete, null, null);
            }

            public void undo() {
                super.undo();
                for (int i = tasksToDelete.length - 1; 0 <= i; --i) {
                    if (oldParents[i] == null) {
                        ProjectController.this.project.addUndertaking(indexes[i], tasksToDelete[i]);
                    } else {
                        oldParents[i].addUndertaking(indexes[i], tasksToDelete[i]);
                    }
                    ProjectController.this.project.restoreRemovedTaskApplications(this.associatedTDs[i]);
                }
            }
        };
        this.undoMgr.addEdit(edit);
    }

    protected IListenerAction createScriptEditorAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                if (prms != null) {
                    IProjectSelectionState context = (IProjectSelectionState)prms;
                    IDesign design = context.getSelectedDesign();
                    IUndertaking[] tasks = context.getSelectedTasks();
                    if (design == null || tasks == null || tasks.length == 0) {
                        return false;
                    }
                    for (int i = 0; i < tasks.length; ++i) {
                        IScript script;
                        if (tasks[i].isGroup()) continue;
                        StandaloneAlgo alg = StandaloneAlgo.ONLY;
                        ITaskApplication ta = ProjectController.this.project.getTaskApplication(tasks[i], design);
                        if (ta == null) {
                            ta = new TaskApplication();
                            ProjectController.this.project.setTaskApplication(tasks[i], design, ta);
                        }
                        if ((script = ta.getScript(alg)) == null) {
                            script = new Script(design);
                            ta.setScript(alg, script);
                        }
                        if (script.getStartFrame() == null) {
                            CogTool.seFrameChooserControllerFactory.openController(ta, alg, (ITask)tasks[i], design, ProjectController.this.project);
                            continue;
                        }
                        CogTool.seDemoControllerFactory.openController(ta, alg, (ITask)tasks[i], design, ProjectController.this.project);
                    }
                    return true;
                }
                ProjectController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IListenerAction createShowNatureAction(final GroupNature nature, final CogToolLID lid) {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.ITaskSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITaskSelectionState;
            }

            public boolean performAction(Object prms) {
                ArrayList<ITaskGroup> groups = new ArrayList<ITaskGroup>();
                ArrayList<GroupNature> oldNatures = new ArrayList<GroupNature>();
                if (prms != null) {
                    ITaskSelectionState context = (ITaskSelectionState)prms;
                    IUndertaking[] tasks = context.getSelectedTasks();
                    for (int i = 0; i < tasks.length; ++i) {
                        ITaskGroup group;
                        GroupNature oldNature;
                        if (!tasks[i].isGroup() || (oldNature = (group = (ITaskGroup)tasks[i]).getNature()) == nature) continue;
                        oldNatures.add(oldNature);
                        groups.add(group);
                        group.setNature(nature);
                    }
                }
                if (groups.size() > 0) {
                    ProjectController.this.undoMgr.addEdit(new AUndoableEdit(this, lid, groups, oldNatures){
                        private final /* synthetic */ ArrayList val$groups;
                        private final /* synthetic */ ArrayList val$oldNatures;
                        private final /* synthetic */ 33 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$groups = val$groups;
                            this.val$oldNatures = val$oldNatures;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.PM.ChangeTaskGroupNature", "Change Group Type(s)");
                        }

                        public void redo() {
                            super.redo();
                            for (int i = 0; i < this.val$groups.size(); ++i) {
                                ITaskGroup group = (ITaskGroup)this.val$groups.get(i);
                                group.setNature(33.access$100(this.this$1));
                            }
                        }

                        public void undo() {
                            super.undo();
                            for (int i = 0; i < this.val$groups.size(); ++i) {
                                ITaskGroup group = (ITaskGroup)this.val$groups.get(i);
                                GroupNature oldNat = (GroupNature)this.val$oldNatures.get(i);
                                group.setNature(oldNat);
                            }
                        }
                    });
                }
                return true;
            }

            static /* synthetic */ GroupNature access$100(33 x0) {
                return x0.nature;
            }
        };
    }

    protected IListenerAction createRecomputeScriptAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                return ProjectController.this.recomputeScripts((IProjectSelectionState)prms);
            }
        };
    }

    public boolean createVisualization(IDesign design, IUndertaking task) {
        boolean visCreated = false;
        if (task.isGroup()) {
            Iterator childIter = ((ITaskGroup)task).getUndertakings().iterator();
            while (childIter.hasNext()) {
                visCreated = visCreated || this.createVisualization(design, (IUndertaking)childIter.next());
            }
        } else {
            StandaloneAlgo alg = StandaloneAlgo.ONLY;
            ITaskApplication ta = this.project.getTaskApplication(task, design);
            if (ta != null && ta.getResult(alg) != null) {
                CogTool.pertChartControllerFactory.openController((ITask)task, design, alg, this.project);
                visCreated = true;
            }
        }
        return visCreated;
    }

    protected IListenerAction createExportCoreCSVFileAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                IProjectSelectionState selState = (IProjectSelectionState)prms;
                IDesign design = selState.getSelectedDesign();
                IUndertaking[] tasks = selState.getSelectedTasks();
                if (design == null || tasks == null || tasks.length == 0) {
                    return false;
                }
                PrintWriter out = null;
                File outDir = ProjectController.this.interaction.selectDirectory("Select a directory to save CORE input files to.");
                if (outDir != null) {
                    File wdgtDescFile = new File(outDir, design.getName() + "_WdgtDesc.txt");
                    try {
                        out = new PrintWriter(new BufferedWriter(new FileWriter(wdgtDescFile)));
                        Iterator fIter = design.getFrames().iterator();
                        while (fIter.hasNext()) {
                            IFrame frm = (IFrame)fIter.next();
                            Iterator widIter = frm.getWidgets().iterator();
                            while (widIter.hasNext()) {
                                IWidget widget = (IWidget)widIter.next();
                                DoubleRectangle wBnds = widget.getShape().getBounds();
                                out.write("parameter(widget, info, " + widget.getName() + ", " + wBnds.x + ", " + wBnds.y + ", " + wBnds.width + ", " + wBnds.height + ")\n");
                            }
                            out.write("\n");
                        }
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (int i = 0; i < tasks.length; ++i) {
                        IScript script = ProjectController.this.project.getTaskApplication(tasks[i], design).getScript(StandaloneAlgo.ONLY);
                        String outId = design.getName() + "-" + tasks[i].getName();
                        File irgFile = new File(outDir, outId + "_irg.pl");
                        File cascadeFile = new File(outDir, outId + "_klm_CASCADE.pl");
                        try {
                            StandaloneAlgo.copyResourceToFile("edu/cmu/cs/hcii/cogtool/resources/cogtool.klm.CASCADE.PL", cascadeFile);
                        }
                        catch (IOException e) {
                            throw new RcvrIOSaveException("Error in copying requie core files.", e);
                        }
                        ToIRG irgCreator = new ToIRG();
                        try {
                            out = new PrintWriter(new BufferedWriter(new FileWriter(irgFile)));
                            irgCreator.createIRG(script, script.getDesign(), out);
                            out.close();
                            out = null;
                            continue;
                        }
                        catch (Exception e) {
                            throw new RcvrIOTempException("Error in generating core IRG inputs.", e);
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    ProjectController.this.interaction.setStatusMessage("Wrote Core files to " + outDir.getAbsolutePath());
                }
                return true;
            }
        };
    }

    protected IListenerAction createImportCoreCSVFileAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                double taskTime;
                LinkedList errorLines;
                LinkedList<String> outputLines;
                IUndertaking[] tasks;
                IDesign design;
                block16: {
                    IProjectSelectionState selState = (IProjectSelectionState)prms;
                    design = selState.getSelectedDesign();
                    tasks = selState.getSelectedTasks();
                    if (design == null || tasks == null || tasks.length == 0) {
                        return false;
                    }
                    Object lastGoodLine = null;
                    outputLines = new LinkedList<String>();
                    errorLines = new LinkedList();
                    taskTime = -1.0;
                    File dataFile = ProjectController.this.interaction.selectCSVFile();
                    if (dataFile == null) {
                        return false;
                    }
                    File cascadeFile = null;
                    try {
                        cascadeFile = new File(dataFile.getParentFile().getPath(), "cascades.csv");
                    }
                    catch (Exception e) {
                        cascadeFile = null;
                    }
                    try {
                        String line;
                        BufferedReader resultReader = new BufferedReader(new FileReader(dataFile));
                        while ((line = resultReader.readLine()) != null) {
                            outputLines.add(line);
                            if ((line = line.trim()).length() <= 0) continue;
                            String[] stepComponents = line.split(",");
                            double endTime = 0.0;
                            try {
                                endTime = (Double.parseDouble(stepComponents[1]) + Double.parseDouble(stepComponents[2])) / 1000.0;
                            }
                            catch (Exception e) {
                                endTime = 0.0;
                            }
                            taskTime = Math.max(taskTime, endTime);
                        }
                        if (cascadeFile == null) break block16;
                        try {
                            resultReader = new BufferedReader(new FileReader(cascadeFile));
                            while ((line = resultReader.readLine()) != null) {
                                outputLines.add(line);
                            }
                        }
                        catch (FileNotFoundException e) {
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RcvrIOTempException("Error in parsing core output", e);
                    }
                    catch (IOException e) {
                        throw new RcvrParsingException("Error in parsing core output", e);
                    }
                }
                StandaloneAlgo.StandaloneResult result = null;
                CORETraceParser parser = new CORETraceParser();
                List steps = parser.parseTrace(outputLines);
                Iterator stepIt = steps.iterator();
                while (stepIt.hasNext()) {
                    System.out.println(stepIt.next().toString());
                }
                result = taskTime < 0.0 ? null : new StandaloneAlgo.StandaloneResult(steps, taskTime, outputLines, errorLines);
                for (int i = 0; i < tasks.length; ++i) {
                    ITaskApplication ta = ProjectController.this.project.getTaskApplication(tasks[i], design);
                    if (ta == null) {
                        ta = new TaskApplication();
                        ta.setScript(StandaloneAlgo.ONLY, new Script(design));
                        ProjectController.this.project.setTaskApplication(tasks[i], design, ta);
                    }
                    ta.setResult(StandaloneAlgo.ONLY, result);
                }
                return true;
            }
        };
    }

    protected IListenerAction createShowModelVisualizationAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                IProjectSelectionState selState = (IProjectSelectionState)prms;
                IDesign design = selState.getSelectedDesign();
                IUndertaking[] tasks = selState.getSelectedTasks();
                if (design == null || tasks == null || tasks.length == 0) {
                    return false;
                }
                boolean visCreated = false;
                for (int i = 0; i < tasks.length; ++i) {
                    visCreated = visCreated || ProjectController.this.createVisualization(design, tasks[i]);
                }
                if (!visCreated) {
                    ProjectController.this.interaction.reportProblem(L10N.get("PC.VIS_ERROR", "VisualizationNot Created"), L10N.get("PC.VIS_ERROR_STRING", "There are no results to visualize from the selected cell(s)."));
                }
                return visCreated;
            }
        };
    }

    protected boolean recomputeScripts(IProjectSelectionState seln) {
        IDesign design = seln.getSelectedDesign();
        IUndertaking[] tasks = seln.getSelectedTasks();
        CompoundUndoableEdit comp = new CompoundUndoableEdit(L10N.get("UNDO.PM.RecomputeScript(s)", "Recompute Script(s)"), ProjectLID.RecomputeScript);
        IUndoableEdit edit = null;
        if (design != null) {
            if (tasks != null && tasks.length > 0) {
                for (int i = 0; i < tasks.length; ++i) {
                    edit = this.recomputeScripts(tasks[i], design);
                    if (edit == null) continue;
                    comp.addEdit(edit);
                }
            } else {
                Iterator allTasks = this.project.getUndertakings().iterator();
                while (allTasks.hasNext()) {
                    edit = this.recomputeScripts((IUndertaking)allTasks.next(), design);
                    if (edit == null) continue;
                    comp.addEdit(edit);
                }
            }
        } else if (tasks != null && tasks.length > 0) {
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    edit = this.recomputeScripts(tasks[i], (IDesign)allDesigns.next());
                    if (edit == null) continue;
                    comp.addEdit(edit);
                }
            }
        }
        comp.end();
        this.undoMgr.addEdit(comp);
        return true;
    }

    protected IUndoableEdit recomputeScripts(IUndertaking task, IDesign design) {
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            CompoundUndoableEdit comp = new CompoundUndoableEdit(L10N.get("UNDO.PM.RecomputeScript(s)", "Recompute Script(s)"), ProjectLID.RecomputeScript);
            while (allTasks.hasNext()) {
                IUndoableEdit edit = this.recomputeScripts((IUndertaking)allTasks.next(), design);
                if (edit == null) continue;
                comp.addEdit(edit);
            }
            comp.end();
            return comp;
        }
        ITaskApplication ta = this.project.getTaskApplication(task, design);
        AUndoableEdit edit = null;
        if (ta != null) {
            edit = this.createRecomputeUndo(ta.recalculateAll());
        }
        return edit;
    }

    protected AUndoableEdit createRecomputeUndo(final IResultRevalidator[][] validators) {
        return new AUndoableEdit(ProjectLID.RecomputeScript){

            public String getPresentationName() {
                return L10N.get("UNDO.PM.RecomputeScript(s)", "Recompute Script(s)");
            }

            public void redo() {
                super.redo();
                this.resetAll(false);
                for (int i = 0; i < validators[0].length; ++i) {
                    ITaskApplication taskApp = validators[0][i].getTaskApp();
                    IPredictionAlgo alg = validators[0][i].getAlgo();
                    IPredictionResult result = validators[0][i].getResult();
                    taskApp.setResult(alg, result);
                }
            }

            public void undo() {
                super.undo();
                this.resetAll(true);
            }

            protected void resetAll(boolean undo) {
                for (int i = 1; i < validators.length; ++i) {
                    for (int j = 0; j < validators[i].length; ++j) {
                        if (validators[i][j].isDead() ^ undo) {
                            validators[i][j].getTaskApp().restoreValidator(validators[i][j]);
                            continue;
                        }
                        validators[i][j].getTaskApp().removeValidator(validators[i][j]);
                    }
                    if (!undo || validators[i].length <= 0) continue;
                    ITaskApplication taskApp = validators[i][0].getTaskApp();
                    IPredictionAlgo alg = validators[i][0].getAlgo();
                    IPredictionResult result = validators[i][0].getResult();
                    taskApp.setResult(alg, result);
                }
            }
        };
    }

    protected IListenerAction createExportDesignToHTMLAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object actionParms) {
                IProjectSelectionState selection = (IProjectSelectionState)actionParms;
                IDesign d = selection.getSelectedDesign();
                if (d == null) {
                    ProjectController.this.interaction.protestNoSelection();
                    return false;
                }
                String dest = ProjectController.this.interaction.askUserForWebPageDestination();
                if (dest == null) {
                    return true;
                }
                ProjectController.this.createWebPages(d, dest);
                return true;
            }
        };
    }

    protected IListenerAction createCaptureAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object actionParms) {
                return false;
            }
        };
    }

    protected IListenerAction createImportAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            public boolean performAction(Object prms) {
                File importFile = ProjectController.this.interaction.selectXMLFile();
                if (importFile == null) {
                    return false;
                }
                IDesign parsedDesign = null;
                try {
                    ImportCogTool importer = new ImportCogTool();
                    if (importer.importXMLDesign(importFile) && importer.getDesign() == null) {
                        ProjectController.this.interaction.reportProblem(L10N.get("PC.ImportXML", "Import XML"), L10N.get("PC.ParseFailed", "XML parse failed."));
                        return false;
                    }
                    parsedDesign = importer.getDesign();
                }
                catch (Exception e) {
                    ProjectController.this.interaction.reportProblem(L10N.get("PC.ImportXML", "Import XML"), L10N.get("PC.ParseException", "XML parse had an exception."));
                    return false;
                }
                ProjectController.this.undoMgr.addEdit(ProjectController.this.addNewDesign(parsedDesign, (IDesignSelectionState)prms, L10N.get("UNDO.PM.DuplicateDesign", "Duplicate Design")));
                return true;
            }
        };
    }

    protected void createWebPages(IDesign design, String destDirectory) {
        ExportToHTMLWorkThread workThread = new ExportToHTMLWorkThread(this.interaction, design.duplicate(design.getName()), destDirectory);
        ThreadManager.ONLY.startNewThread(workThread);
    }

    protected IListenerAction createDuplicateDesignAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignSelectionState;
            }

            public boolean performAction(Object prms) {
                IDesignSelectionState seln = (IDesignSelectionState)prms;
                IDesign design = seln.getSelectedDesign();
                if (design == null) {
                    ProjectController.this.interaction.protestNoSelection();
                    return false;
                }
                String copyName = AController.makeNameUnique(design.getName(), ProjectController.this.project.getDesigns());
                IDesign designCopy = design.duplicate(copyName);
                ProjectController.this.undoMgr.addEdit(ProjectController.this.addNewDesign(designCopy, seln, L10N.get("UNDO.PM.DuplicateDesign", "Duplicate Design")));
                return true;
            }
        };
    }

    protected IUI getUI() {
        return this.ui;
    }

    public IProjectInteraction getInteraction() {
        return this.interaction;
    }

    public static boolean openProjectOnCompute(IProject project, final IResultRevalidator[] validators) {
        boolean notModified = !CogTool.undoManagerFactory.isAtSavePoint(project);
        ProjectController c = CogTool.projectControllerFactory.openController(project, false, notModified);
        c.undoMgr.addEdit(new AUndoableEdit(ProjectLID.RecomputeScript){

            public String getPresentationName() {
                return L10N.get("UNDO.PM.ComputeScript", "Compute Script");
            }

            public void redo() {
                super.redo();
                this.resetAll(false);
                for (int i = 0; i < validators.length; ++i) {
                    ITaskApplication taskApp = validators[i].getTaskApp();
                    IPredictionAlgo alg = validators[i].getAlgo();
                    IPredictionResult result = validators[i].getResult();
                    taskApp.setResult(alg, result);
                }
            }

            public void undo() {
                super.undo();
                this.resetAll(true);
            }

            private void resetAll(boolean undo) {
                for (int j = 0; j < validators.length; ++j) {
                    if (validators[j].isDead() ^ undo) {
                        validators[j].getTaskApp().restoreValidator(validators[j]);
                        continue;
                    }
                    validators[j].getTaskApp().removeValidator(validators[j]);
                }
                if (undo && validators.length > 0) {
                    ITaskApplication taskApp = validators[0].getTaskApp();
                    IPredictionAlgo alg = validators[0].getAlgo();
                    IPredictionResult result = validators[0].getResult();
                    taskApp.setResult(alg, result);
                }
            }
        });
        return true;
    }

    protected IListenerAction createExportScriptToCSVAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState = ProjectController.class$("edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IProjectSelectionState;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean performAction(Object actionParms) {
                BufferedWriter buffer;
                OutputStreamWriter fw;
                block34: {
                    boolean bl;
                    block33: {
                        boolean bl2;
                        block32: {
                            boolean bl3;
                            block31: {
                                boolean bl4;
                                block30: {
                                    boolean bl5;
                                    block29: {
                                        fw = null;
                                        buffer = null;
                                        try {
                                            try {
                                                IProjectSelectionState sel = (IProjectSelectionState)actionParms;
                                                IDesign design = sel.getSelectedDesign();
                                                if (design == null) {
                                                    ProjectController.this.interaction.protestNoSelection();
                                                    bl5 = false;
                                                    Object var25_10 = null;
                                                    break block29;
                                                }
                                                IUndertaking[] tasks = sel.getSelectedTasks();
                                                if (tasks.length == 0) {
                                                    ProjectController.this.interaction.protestNoSelection();
                                                    bl4 = false;
                                                    break block30;
                                                }
                                                IUndertaking task = tasks[0];
                                                String name = ProjectController.this.getProject().getName();
                                                File dest = ProjectController.this.interaction.selectCSVFileDest(name);
                                                if (dest == null) {
                                                    bl3 = false;
                                                    break block31;
                                                }
                                                ToCSVScriptStepVisitor visitor = new ToCSVScriptStepVisitor();
                                                IScript script = null;
                                                ITaskApplication taskApp = ProjectController.this.getProject().getTaskApplication(task, design);
                                                if (taskApp == null) {
                                                    ProjectController.this.interaction.protestNoSelection();
                                                    bl2 = false;
                                                    break block32;
                                                }
                                                Iterator iter = taskApp.getScripts().entrySet().iterator();
                                                if (!iter.hasNext()) {
                                                    ProjectController.this.interaction.protestNoSelection();
                                                    bl = false;
                                                    break block33;
                                                }
                                                Map.Entry entry = iter.next();
                                                script = taskApp.getScript((IPredictionAlgo)entry.getKey());
                                                fw = new FileWriter(dest);
                                                buffer = new BufferedWriter(fw);
                                                Date now = new Date();
                                                String date = DateFormat.getDateTimeInstance().format(now);
                                                CSVSupport.writeCell("Date and Time:", buffer);
                                                CSVSupport.addSeparator(buffer);
                                                CSVSupport.writeCell(date, buffer);
                                                CSVSupport.addLineEnding(buffer);
                                                CSVSupport.writeCell("Project Name:", buffer);
                                                CSVSupport.addSeparator(buffer);
                                                CSVSupport.writeCell(ProjectController.this.getProject().getName(), buffer);
                                                CSVSupport.addLineEnding(buffer);
                                                CSVSupport.writeCell("Design Name:", buffer);
                                                CSVSupport.addSeparator(buffer);
                                                CSVSupport.writeCell(design.getName(), buffer);
                                                CSVSupport.addLineEnding(buffer);
                                                CSVSupport.writeCell("Task Hierarchy:", buffer);
                                                String taskname = task.getFullName();
                                                String[] cells = taskname.split(":");
                                                for (int i = 0; i < cells.length; ++i) {
                                                    CSVSupport.addSeparator(buffer);
                                                    CSVSupport.writeCell(cells[i], buffer);
                                                }
                                                CSVSupport.addLineEnding(buffer);
                                                CSVSupport.addSeparator(buffer);
                                                CSVSupport.addLineEnding(buffer);
                                                buffer.write("\"Frame\",\"Action\",\"Widget\"");
                                                CSVSupport.addLineEnding(buffer);
                                                Iterator steps = script.getScriptSteps().iterator();
                                                while (steps.hasNext()) {
                                                    IScriptStep step = (IScriptStep)steps.next();
                                                    step.accept(visitor);
                                                    String frameName = step.getCurrentFrame().getName();
                                                    String actionName = step.getStepLocalizedString();
                                                    String widgetName = visitor.getWidgetName();
                                                    CSVSupport.writeCell(frameName, buffer);
                                                    CSVSupport.addSeparator(buffer);
                                                    CSVSupport.writeCell(actionName, buffer);
                                                    CSVSupport.addSeparator(buffer);
                                                    CSVSupport.writeCell(widgetName, buffer);
                                                    CSVSupport.addLineEnding(buffer);
                                                }
                                                IFrame resultFrame = script.getResult();
                                                if (resultFrame != null) {
                                                    CSVSupport.writeCell(resultFrame.getName(), buffer);
                                                }
                                                ProjectController.this.interaction.setStatusMessage(L10N.get("PR.ExportCompleted", "Export completed."));
                                                break block34;
                                            }
                                            catch (IOException e) {
                                                ProjectController.this.interaction.reportProblem("File I/O Error", e.getMessage());
                                                boolean bl6 = false;
                                                Object var25_16 = null;
                                                try {
                                                    if (buffer != null) {
                                                        buffer.close();
                                                    }
                                                    if (fw == null) return bl6;
                                                    fw.close();
                                                    return bl6;
                                                }
                                                catch (IOException e2) {
                                                    ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                                    return false;
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var25_17 = null;
                                            try {}
                                            catch (IOException e2) {
                                                ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                                return false;
                                            }
                                            if (buffer != null) {
                                                buffer.close();
                                            }
                                            if (fw == null) throw throwable;
                                            fw.close();
                                            throw throwable;
                                        }
                                    }
                                    try {}
                                    catch (IOException e2) {
                                        ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                        return false;
                                    }
                                    if (buffer != null) {
                                        buffer.close();
                                    }
                                    if (fw == null) return bl5;
                                    fw.close();
                                    return bl5;
                                }
                                Object var25_11 = null;
                                try {}
                                catch (IOException e2) {
                                    ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                    return false;
                                }
                                if (buffer != null) {
                                    buffer.close();
                                }
                                if (fw == null) return bl4;
                                fw.close();
                                return bl4;
                            }
                            Object var25_12 = null;
                            try {}
                            catch (IOException e2) {
                                ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                                return false;
                            }
                            if (buffer != null) {
                                buffer.close();
                            }
                            if (fw == null) return bl3;
                            fw.close();
                            return bl3;
                        }
                        Object var25_13 = null;
                        try {}
                        catch (IOException e2) {
                            ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                            return false;
                        }
                        if (buffer != null) {
                            buffer.close();
                        }
                        if (fw == null) return bl2;
                        fw.close();
                        return bl2;
                    }
                    Object var25_14 = null;
                    try {}
                    catch (IOException e2) {
                        ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                        return false;
                    }
                    if (buffer != null) {
                        buffer.close();
                    }
                    if (fw == null) return bl;
                    fw.close();
                    return bl;
                }
                Object var25_15 = null;
                try {}
                catch (IOException e2) {
                    ProjectController.this.interaction.reportProblem("File I/O Error on Close", e2.getMessage());
                    return false;
                }
                if (buffer != null) {
                    buffer.close();
                }
                if (fw == null) return true;
                fw.close();
                return true;
            }
        };
    }

    protected class ToCSVScriptStepVisitor
    implements IScriptStep.IScriptStepVisitor {
        String widgetName = "";

        protected ToCSVScriptStepVisitor() {
        }

        public void visit(ActionScriptStep ss) {
            this.widgetName = ss.getWidgetName();
        }

        public void visit(TapScriptStep tss) {
            this.widgetName = tss.getWidgetName();
        }

        public void visit(DelayScriptStep delayss) {
            this.widgetName = "";
        }

        public void visit(DriveScriptStep drivess) {
            this.widgetName = "";
        }

        public void visit(LookAtScriptStep lass) {
            this.widgetName = lass.getWidgetName();
        }

        public void visit(ThinkScriptStep tss) {
            this.widgetName = "";
        }

        public void visit(TextActionSegment tas) {
            this.widgetName = tas.getStepFocus().getName();
        }

        public String getWidgetName() {
            return this.widgetName;
        }
    }
}

