/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.FrameEditorController;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.Project;
import edu.cmu.cs.hcii.cogtool.model.ShapeType;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI;
import edu.cmu.cs.hcii.cogtool.uimodel.IFrameUIModel;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class FrameEditorControllerTest
extends TestCase {
    public static Set standardDeviceTypes = new HashSet<DeviceType>(Arrays.asList(DeviceType.Mouse, DeviceType.Keyboard, DeviceType.Voice));
    Project project;
    Design design;
    Frame model;
    FrameEditorUI ui;
    FrameEditorController controller;
    FrameEditorSelectionState selection;

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new Project("Test Project");
        this.design = new Design("Test Design", standardDeviceTypes);
        this.project.addDesign(this.design);
        this.selection = new FrameEditorSelectionState();
        this.model = new Frame("Test Frame", standardDeviceTypes);
        this.design.addFrame(this.model);
        this.controller = new FrameEditorController(this.model, this.design, this.project);
        this.ui = (FrameEditorUI)this.controller.getUI();
    }

    protected void tearDown() throws Exception {
        this.ui.dispose();
        super.tearDown();
    }

    public void testGetUI() {
        FrameEditorControllerTest.assertNotSame((Object)this.ui, (Object)new FrameEditorController(this.model, this.design, this.project).getUI());
    }

    public void testFrameEditorController() {
        try {
            new FrameEditorController(null, this.design, this.project);
            FrameEditorControllerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new FrameEditorController(this.model, this.design, null);
            FrameEditorControllerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new FrameEditorController(this.model, null, this.project);
            FrameEditorControllerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new FrameEditorController(null, null, null);
            FrameEditorControllerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetModel() {
        FrameEditorControllerTest.assertNotNull((Object)this.controller.getModel());
        FrameEditorControllerTest.assertSame((Object)this.controller.getModel(), (Object)this.model);
    }

    public void testSetBackgroundImage() {
        new FrameTester(){
            byte[] image;

            protected void setupTestParameters() {
                this.image = GraphicsUtil.loadImage(ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/fdf.jpg"));
            }

            protected void test() {
                this.setupTestContext();
                FrameEditorControllerTest.this.controller.setBackgroundImage(this.image);
                this.assertTestEffects();
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((Object)FrameEditorControllerTest.this.model.getBackgroundImage(), (Object)this.image);
            }
        }.test();
    }

    public void testSetWidgetImages() {
        new WidgetTester(){
            byte[] image;

            protected void setupTestParameters() {
                this.image = GraphicsUtil.loadImage(ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/fdf.jpg"));
            }

            protected void test() {
                this.setupTestContext();
                FrameEditorControllerTest.this.controller.setWidgetImages(FrameEditorControllerTest.this.selection.getSelectedWidgetsIterator(), this.image);
                this.assertTestEffects();
            }

            protected void assertDoneEffectsOn(IWidget widget) {
                Assert.assertEquals((Object)widget.getImage(), (Object)this.image);
            }
        }.test();
    }

    public void testZoomInAction() {
        new FrameActionTester(CogToolLID.ZoomIn){
            double oldZoom;

            protected void setupTestParameters() {
                this.oldZoom = FrameEditorControllerTest.this.ui.getZoom();
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((Math.abs(FrameEditorControllerTest.this.ui.getZoom() - this.oldZoom * 1.15) < 0.01 ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testZoomOutAction() {
        new FrameActionTester(CogToolLID.ZoomOut){
            double oldZoom;

            protected void setupTestParameters() {
                this.oldZoom = FrameEditorControllerTest.this.ui.getZoom();
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((Math.abs(FrameEditorControllerTest.this.ui.getZoom() - this.oldZoom / 1.15) < 0.01 ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testZoomNormalAction() {
        new FrameActionTester(CogToolLID.ZoomNormal){

            protected void setupTestParameters() {
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((Math.abs(FrameEditorControllerTest.this.ui.getZoom() - 1.0) < 0.01 ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testRemoveBackgroundImageAction() {
        new FrameActionTester(CogToolLID.RemoveBackgroundImage){

            protected void setupTestParameters() {
                byte[] image = GraphicsUtil.loadImage(ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/fdf.jpg"));
                FrameEditorControllerTest.this.model.setBackgroundImage(image, GraphicsUtil.getImageBounds(image));
            }

            protected void assertDoneEffects() {
                Assert.assertNull((Object)FrameEditorControllerTest.this.model.getBackgroundImage());
            }
        }.test();
    }

    public void testNewWidgetAction() {
        DoubleRectangle loc = new DoubleRectangle(1.2, 3.4, 5.6, 7.8);
        this.controller.performAction(CogToolLID.NewWidget, loc, false);
        FrameEditorControllerTest.assertEquals((int)this.model.getWidgets().size(), (int)1);
        IWidget widget = (IWidget)this.model.getWidgets().iterator().next();
        FrameEditorControllerTest.assertEquals((Object)loc, (Object)widget.getShape().getBounds());
        this.controller.performAction(CogToolLID.NewWidget, null, false);
        FrameEditorControllerTest.assertEquals((int)this.model.getWidgets().size(), (int)2);
        FrameEditorControllerTest.assertTrue((boolean)this.model.getWidgets().contains(widget));
        this.controller.performAction(CogToolLID.Undo, null, false);
        FrameEditorControllerTest.assertEquals((int)this.model.getWidgets().size(), (int)1);
        FrameEditorControllerTest.assertTrue((boolean)this.model.getWidgets().contains(widget));
        this.controller.performAction(CogToolLID.Redo, null, false);
        FrameEditorControllerTest.assertEquals((int)this.model.getWidgets().size(), (int)2);
        FrameEditorControllerTest.assertTrue((boolean)this.model.getWidgets().contains(widget));
    }

    public void testDeleteAction() {
        new WidgetActionTester(CogToolLID.Delete){

            protected void setupTestParameters() {
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffects() {
                Set remain = FrameEditorControllerTest.this.model.getWidgets();
                Assert.assertEquals((int)remain.size(), (int)2);
                Assert.assertTrue((!remain.contains(this.w[0]) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)remain.contains(this.w[1]));
                Assert.assertTrue((!remain.contains(this.w[2]) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)remain.contains(this.w[3]));
            }

            protected void assertNoneEffects() {
                Set remain = FrameEditorControllerTest.this.model.getWidgets();
                Assert.assertEquals((int)remain.size(), (int)4);
                Assert.assertTrue((boolean)remain.contains(this.w[0]));
                Assert.assertTrue((boolean)remain.contains(this.w[1]));
                Assert.assertTrue((boolean)remain.contains(this.w[2]));
                Assert.assertTrue((boolean)remain.contains(this.w[3]));
            }
        }.test();
    }

    public void testSetWidgetColorAction() {
        new FrameActionTester(CogToolLID.SetWidgetColor){
            final int color = 7654321;
            {
                this.color = 7654321;
            }

            protected void setupTestParameters() {
                FrameEditorControllerTest.this.controller.interaction = new FrameEditorInteraction(this, FrameEditorControllerTest.this.ui.getView()){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Integer selectColor(int oldColor) {
                        return new Integer(7654321);
                    }
                };
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((int)FrameEditorControllerTest.this.model.getWidgetColor(), (int)7654321);
            }
        }.test();
    }

    public void testChangeShapePropertyAction() {
        new WidgetActionTester(FrameEditorLID.ChangeShapeProperty){
            ShapeType shape;

            protected void setupTestParameters() {
                this.shape = this.w[0].getShape().getShapeType();
                this.shape = this.shape.equals(ShapeType.Ellipse) ? ShapeType.Rectangle : ShapeType.Ellipse;
                this.param = new IFrameEditorUI.ShapeChangeParameters(this.shape, FrameEditorControllerTest.this.selection);
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getShape().getShapeType(), (Object)this.shape);
            }
        }.test();
    }

    public void testChangeTitlePropertyAction() {
        new WidgetActionTester(FrameEditorLID.ChangeTitleProperty){
            String title;

            protected void setupTestParameters() {
                this.title = this.w[0].getTitle();
                this.title = this.title.equals("") ? "test title" : "";
                this.param = new IFrameEditorUI.ActionStringParameters(this.title, FrameEditorControllerTest.this.selection);
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((String)w.getTitle(), (String)this.title);
            }
        }.test();
    }

    public void testChangeTypePropertyAction() {
        new WidgetActionTester(FrameEditorLID.ChangeTypeProperty){
            WidgetType type;

            protected void setupTestParameters() {
                this.type = this.w[0].getWidgetType();
                this.type = this.type.equals(WidgetType.Menu) ? WidgetType.Check : WidgetType.Menu;
                this.param = new IFrameEditorUI.TypeChangeParameters(this.type, FrameEditorControllerTest.this.selection);
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getWidgetType(), (Object)this.type);
            }
        }.test();
    }

    public void testRemoveImagePropertyAction() {
        new WidgetActionTester(FrameEditorLID.RemoveImageProperty){

            protected void setupTestParameters() {
                byte[] image = GraphicsUtil.loadImage(ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/fdf.jpg"));
                this.w[0].setImage(image);
                this.w[1].setImage(image);
                this.w[2].setImage(image);
                this.w[3].setImage(image);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertNull((Object)w.getImage());
            }
        }.test();
    }

    public void testMoveWidgetsAction() {
        new WidgetActionTester(FrameEditorLID.MoveWidgets){
            DoublePoint origin;
            DoublePoint move;
            {
                this.move = new DoublePoint(-4.5, 6.7);
            }

            protected void setupTestParameters() {
                this.origin = this.w[0].getShape().getOrigin();
                this.param = new IFrameEditorUI.MoveParameters(this.move, FrameEditorControllerTest.this.selection);
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getShape().getOrigin(), (Object)new DoublePoint(this.origin.x + this.move.x, this.origin.y + this.move.y));
            }
        }.test();
    }

    public void testMoveUpAction() {
        new WidgetActionTester(FrameEditorLID.NudgeUp){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = this.w[0].getShape().getOrigin();
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getShape().getOrigin(), (Object)new DoublePoint(this.origin.x, this.origin.y - 1.0));
            }
        }.test();
    }

    public void testMoveDownAction() {
        new WidgetActionTester(FrameEditorLID.NudgeDown){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = this.w[0].getShape().getOrigin();
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getShape().getOrigin(), (Object)new DoublePoint(this.origin.x, this.origin.y + 1.0));
            }
        }.test();
    }

    public void testMoveLeftAction() {
        new WidgetActionTester(FrameEditorLID.NudgeLeft){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = this.w[0].getShape().getOrigin();
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getShape().getOrigin(), (Object)new DoublePoint(this.origin.x - 1.0, this.origin.y));
            }
        }.test();
    }

    public void testMoveRightAction() {
        new WidgetActionTester(FrameEditorLID.NudgeRight){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = this.w[0].getShape().getOrigin();
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertEquals((Object)w.getShape().getOrigin(), (Object)new DoublePoint(this.origin.x + 1.0, this.origin.y));
            }
        }.test();
    }

    public void testAlignTopAction() {
        new WidgetActionTester(FrameEditorLID.AlignTop){
            DoublePoint origin;
            {
                this.origin = new DoublePoint(3.5, -50.34);
            }

            protected void setupTestParameters() {
                this.w[0].getShape().setOrigin(this.origin);
                this.w[1].getShape().setOrigin(-1.0, -2.0);
                this.w[2].getShape().setOrigin(-1.7976931348623157E308, Double.MAX_VALUE);
                this.w[3].getShape().setOrigin(0.0, 0.0);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                IWidget old = (IWidget)this.wid.get(w);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().y - this.origin.y) < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().x - old.getShape().getOrigin().x) < 0.01 ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testAlignBottomAction() {
        new WidgetActionTester(FrameEditorLID.AlignBottom){
            DoublePoint origin;
            {
                this.origin = new DoublePoint(5.4, 59.34);
            }

            protected void setupTestParameters() {
                this.w[0].getShape().setOrigin(this.origin);
                this.w[1].getShape().setOrigin(-1.0, -2.0);
                this.w[2].getShape().setOrigin(Double.MAX_VALUE, -1.7976931348623157E308);
                this.w[3].getShape().setOrigin(0.0, 0.0);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                IWidget old = (IWidget)this.wid.get(w);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().y - this.origin.y) < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().x - old.getShape().getOrigin().x) < 0.01 ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testAlignLeftAction() {
        new WidgetActionTester(FrameEditorLID.AlignLeft){
            DoublePoint origin;
            {
                this.origin = new DoublePoint(-5.29, 78.0);
            }

            protected void setupTestParameters() {
                this.w[0].getShape().setOrigin(this.origin);
                this.w[1].getShape().setOrigin(-1.0, -2.0);
                this.w[2].getShape().setOrigin(Double.MAX_VALUE, -1.7976931348623157E308);
                this.w[3].getShape().setOrigin(0.0, 0.0);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                IWidget old = (IWidget)this.wid.get(w);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().x - this.origin.x) < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().y - old.getShape().getOrigin().y) < 0.01 ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testAlignRightAction() {
        new WidgetActionTester(FrameEditorLID.AlignRight){
            DoublePoint origin;
            {
                this.origin = new DoublePoint(999934.0, 4324.45);
            }

            protected void setupTestParameters() {
                this.w[0].getShape().setOrigin(this.origin);
                this.w[1].getShape().setOrigin(-1.0, -2.0);
                this.w[2].getShape().setOrigin(-1.7976931348623157E308, Double.MAX_VALUE);
                this.w[3].getShape().setOrigin(0.0, 0.0);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffectsOn(IWidget w) {
                IWidget old = (IWidget)this.wid.get(w);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().x - this.origin.x) < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((Math.abs(w.getShape().getOrigin().y - old.getShape().getOrigin().y) < 0.01 ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testSpaceVerticallyAction() {
        new WidgetActionTester(FrameEditorLID.SpaceVertically){

            protected void setupTestParameters() {
                this.w[0].getShape().setOrigin(1.0, 1.0);
                this.w[0].getShape().setSize(8.0, 8.0);
                this.w[1].getShape().setOrigin(2.0, 2.0);
                this.w[1].getShape().setSize(4.0, 4.0);
                this.w[2].getShape().setOrigin(4.0, 4.0);
                this.w[2].getShape().setSize(2.0, 2.0);
                this.w[3].getShape().setOrigin(8.0, 8.0);
                this.w[3].getShape().setSize(1.0, 1.0);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void setupTestSelection() {
                IFrameUIModel frameUI = FrameEditorControllerTest.this.ui.getFrameUI();
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[0]));
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[1]));
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[2]));
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[3]));
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertTrue((w.getShape().getOrigin().x == ((IWidget)this.wid.get((Object)w)).getShape().getOrigin().x ? 1 : 0) != 0);
            }

            protected void assertDoneEffects() {
                double overlap = (this.w[0].getShape().getSize().height + this.w[1].getShape().getSize().height + this.w[2].getShape().getSize().height + this.w[3].getShape().getSize().height - (this.w[3].getShape().getOrigin().y + this.w[3].getShape().getSize().height - this.w[0].getShape().getOrigin().y)) / 3.0;
                Assert.assertTrue((this.w[0].getShape().getOrigin().y - 1.0 < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[1].getShape().getOrigin().y - (this.w[0].getShape().getOrigin().y + this.w[0].getShape().getSize().height) + overlap < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[2].getShape().getOrigin().y - (this.w[1].getShape().getOrigin().y + this.w[1].getShape().getSize().height) + overlap < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[3].getShape().getOrigin().y - (this.w[2].getShape().getOrigin().y + this.w[2].getShape().getSize().height) + overlap < 0.01 ? 1 : 0) != 0);
                Iterator i = FrameEditorControllerTest.this.selection.getSelectedWidgetsIterator();
                while (i.hasNext()) {
                    this.assertDoneEffectsOn((IWidget)i.next());
                }
            }
        }.test();
    }

    public void testSpaceHorizontallyAction() {
        new WidgetActionTester(FrameEditorLID.SpaceHorizontally){

            protected void setupTestParameters() {
                this.w[0].getShape().setOrigin(1.0, 1.0);
                this.w[0].getShape().setSize(8.0, 8.0);
                this.w[1].getShape().setOrigin(2.0, 2.0);
                this.w[1].getShape().setSize(4.0, 4.0);
                this.w[2].getShape().setOrigin(4.0, 4.0);
                this.w[2].getShape().setSize(2.0, 2.0);
                this.w[3].getShape().setOrigin(8.0, 8.0);
                this.w[3].getShape().setSize(1.0, 1.0);
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void setupTestSelection() {
                IFrameUIModel frameUI = FrameEditorControllerTest.this.ui.getFrameUI();
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[0]));
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[1]));
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[2]));
                FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[3]));
            }

            protected void assertDoneEffectsOn(IWidget w) {
                Assert.assertTrue((w.getShape().getOrigin().y == ((IWidget)this.wid.get((Object)w)).getShape().getOrigin().y ? 1 : 0) != 0);
            }

            protected void assertDoneEffects() {
                double overlap = (this.w[0].getShape().getSize().width + this.w[1].getShape().getSize().width + this.w[2].getShape().getSize().width + this.w[3].getShape().getSize().width - (this.w[3].getShape().getOrigin().x + this.w[3].getShape().getSize().width - this.w[0].getShape().getOrigin().x)) / 3.0;
                Assert.assertTrue((this.w[0].getShape().getOrigin().x - 1.0 < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[1].getShape().getOrigin().x - (this.w[0].getShape().getOrigin().x + this.w[0].getShape().getSize().width) + overlap < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[2].getShape().getOrigin().x - (this.w[1].getShape().getOrigin().x + this.w[1].getShape().getSize().width) + overlap < 0.01 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[3].getShape().getOrigin().x - (this.w[2].getShape().getOrigin().x + this.w[2].getShape().getSize().width) + overlap < 0.01 ? 1 : 0) != 0);
                Iterator i = FrameEditorControllerTest.this.selection.getSelectedWidgetsIterator();
                while (i.hasNext()) {
                    this.assertDoneEffectsOn((IWidget)i.next());
                }
            }
        }.test();
    }

    public void testBringToFrontAction() {
        new WidgetActionTester(CogToolLID.BringToFront){

            protected void setupTestParameters() {
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffects() {
                IWidget w0_old = (IWidget)this.wid.get(this.w[0]);
                IWidget w1_old = (IWidget)this.wid.get(this.w[1]);
                IWidget w2_old = (IWidget)this.wid.get(this.w[2]);
                IWidget w3_old = (IWidget)this.wid.get(this.w[3]);
                if (w0_old.getLevel() > w2_old.getLevel()) {
                    Assert.assertEquals((int)this.w[0].getLevel(), (int)3);
                    Assert.assertEquals((int)this.w[2].getLevel(), (int)2);
                } else {
                    Assert.assertEquals((int)this.w[0].getLevel(), (int)2);
                    Assert.assertEquals((int)this.w[2].getLevel(), (int)3);
                }
                if (w1_old.getLevel() > w3_old.getLevel()) {
                    Assert.assertEquals((int)this.w[1].getLevel(), (int)1);
                    Assert.assertEquals((int)this.w[3].getLevel(), (int)0);
                } else {
                    Assert.assertEquals((int)this.w[1].getLevel(), (int)0);
                    Assert.assertEquals((int)this.w[3].getLevel(), (int)1);
                }
            }
        }.test();
    }

    public void testBringForwardAction() {
        new WidgetActionTester(CogToolLID.BringForward){

            protected void setupTestParameters() {
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffects() {
                IWidget w0_old = (IWidget)this.wid.get(this.w[0]);
                IWidget w1_old = (IWidget)this.wid.get(this.w[1]);
                IWidget w2_old = (IWidget)this.wid.get(this.w[2]);
                IWidget w3_old = (IWidget)this.wid.get(this.w[3]);
                Assert.assertTrue((this.w[0].getLevel() == w0_old.getLevel() + 1 || this.w[0].getLevel() == 3 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[2].getLevel() == w2_old.getLevel() + 1 || this.w[2].getLevel() == 3 ? 1 : 0) != 0);
                if (w1_old.getLevel() > w3_old.getLevel()) {
                    Assert.assertTrue((this.w[1].getLevel() > this.w[3].getLevel() ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((this.w[1].getLevel() < this.w[3].getLevel() ? 1 : 0) != 0);
                }
            }
        }.test();
    }

    public void testSendBackwardAction() {
        new WidgetActionTester(CogToolLID.SendBackward){

            protected void setupTestParameters() {
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffects() {
                IWidget w0_old = (IWidget)this.wid.get(this.w[0]);
                IWidget w1_old = (IWidget)this.wid.get(this.w[1]);
                IWidget w2_old = (IWidget)this.wid.get(this.w[2]);
                IWidget w3_old = (IWidget)this.wid.get(this.w[3]);
                Assert.assertTrue((this.w[0].getLevel() == w0_old.getLevel() - 1 || this.w[0].getLevel() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((this.w[2].getLevel() == w2_old.getLevel() - 1 || this.w[2].getLevel() == 0 ? 1 : 0) != 0);
                if (w1_old.getLevel() > w3_old.getLevel()) {
                    Assert.assertTrue((this.w[1].getLevel() > this.w[3].getLevel() ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((this.w[1].getLevel() < this.w[3].getLevel() ? 1 : 0) != 0);
                }
            }
        }.test();
    }

    public void testSendToBackAction() {
        new WidgetActionTester(CogToolLID.SendToBack){

            protected void setupTestParameters() {
                this.param = FrameEditorControllerTest.this.selection;
            }

            protected void assertDoneEffects() {
                IWidget w0_old = (IWidget)this.wid.get(this.w[0]);
                IWidget w1_old = (IWidget)this.wid.get(this.w[1]);
                IWidget w2_old = (IWidget)this.wid.get(this.w[2]);
                IWidget w3_old = (IWidget)this.wid.get(this.w[3]);
                if (w0_old.getLevel() > w2_old.getLevel()) {
                    Assert.assertEquals((int)this.w[0].getLevel(), (int)1);
                    Assert.assertEquals((int)this.w[2].getLevel(), (int)0);
                } else {
                    Assert.assertEquals((int)this.w[0].getLevel(), (int)0);
                    Assert.assertEquals((int)this.w[2].getLevel(), (int)1);
                }
                if (w1_old.getLevel() > w3_old.getLevel()) {
                    Assert.assertEquals((int)this.w[1].getLevel(), (int)3);
                    Assert.assertEquals((int)this.w[3].getLevel(), (int)2);
                } else {
                    Assert.assertEquals((int)this.w[1].getLevel(), (int)2);
                    Assert.assertEquals((int)this.w[3].getLevel(), (int)3);
                }
            }
        }.test();
    }

    protected abstract class WidgetActionTester
    extends WidgetTester {
        private CogToolLID lid;
        protected Object param;

        public WidgetActionTester(CogToolLID LID) {
            this.lid = LID;
        }

        protected void test() {
            this.setupTestContext();
            FrameEditorControllerTest.this.controller.performAction(this.lid, this.param, false);
            this.assertTestEffects();
        }
    }

    protected abstract class WidgetTester {
        protected Map wid = new IdentityHashMap();
        protected Widget[] w = new Widget[4];

        protected WidgetTester() {
        }

        protected abstract void setupTestParameters();

        protected abstract void test();

        protected void assertDoneEffectsOn(IWidget widget) {
        }

        protected void setupTestSelection() {
            IFrameUIModel frameUI = FrameEditorControllerTest.this.ui.getFrameUI();
            FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[0]));
            FrameEditorControllerTest.this.selection.selectWidget(frameUI.getWidgetFigure(this.w[2]));
        }

        protected void assertDoneEffects() {
            HashSet sel = new HashSet();
            Iterator i = FrameEditorControllerTest.this.selection.getSelectedWidgetsIterator();
            while (i.hasNext()) {
                sel.add(i.next());
            }
            i = this.wid.keySet().iterator();
            while (i.hasNext()) {
                Widget next = (Widget)i.next();
                if (sel.contains(next)) {
                    this.assertDoneEffectsOn(next);
                    continue;
                }
                Assert.assertTrue((boolean)Widget.isIdentical(next, (Widget)this.wid.get(next)));
            }
        }

        protected void assertNoneEffects() {
            Iterator i = this.wid.keySet().iterator();
            while (i.hasNext()) {
                Widget next = (Widget)i.next();
                Assert.assertTrue((boolean)Widget.isIdentical(next, (Widget)this.wid.get(next)));
            }
        }

        protected void setupTestContext() {
            int i;
            for (int i2 = 0; i2 < this.w.length; ++i2) {
                FrameEditorControllerTest.this.controller.performAction(CogToolLID.NewWidget, null, false);
            }
            Iterator widgets = FrameEditorControllerTest.this.model.getWidgets().iterator();
            for (i = 0; i < this.w.length; ++i) {
                this.w[i] = (Widget)widgets.next();
            }
            this.setupTestParameters();
            for (i = 0; i < this.w.length; ++i) {
                this.wid.put(this.w[i], this.w[i].clone());
            }
            this.setupTestSelection();
        }

        protected void assertTestEffects() {
            this.assertDoneEffects();
            if (this.shouldTestUndoAndRedo()) {
                FrameEditorControllerTest.this.controller.performAction(CogToolLID.Undo, null, false);
                this.assertNoneEffects();
                FrameEditorControllerTest.this.controller.performAction(CogToolLID.Redo, null, false);
                this.assertDoneEffects();
            }
        }

        protected boolean shouldTestUndoAndRedo() {
            return true;
        }
    }

    protected abstract class FrameActionTester
    extends FrameTester {
        private CogToolLID lid;

        public FrameActionTester(CogToolLID LID) {
            this.lid = LID;
        }

        protected void test() {
            this.setupTestContext();
            FrameEditorControllerTest.this.controller.performAction(this.lid, null, false);
            this.assertTestEffects();
        }
    }

    protected abstract class FrameTester {
        Frame f_old;

        protected FrameTester() {
        }

        protected abstract void setupTestParameters();

        protected abstract void assertDoneEffects();

        protected abstract void test();

        protected void setupTestContext() {
            this.setupTestParameters();
            this.f_old = (Frame)FrameEditorControllerTest.this.model.clone();
        }

        protected void assertTestEffects() {
            this.assertDoneEffects();
            if (this.shouldTestUndoAndRedo()) {
                FrameEditorControllerTest.this.controller.performAction(CogToolLID.Undo, null, false);
                Assert.assertTrue((boolean)Frame.isIdentical(this.f_old, FrameEditorControllerTest.this.model));
                FrameEditorControllerTest.this.controller.performAction(CogToolLID.Redo, null, false);
                this.assertDoneEffects();
            }
        }

        protected boolean shouldTestUndoAndRedo() {
            return true;
        }
    }
}

