/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolClipboard;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.UndoController;
import edu.cmu.cs.hcii.cogtool.controller.ZoomableController;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IMenuHeader;
import edu.cmu.cs.hcii.cogtool.model.IMenuItem;
import edu.cmu.cs.hcii.cogtool.model.IMenuWidget;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IResultRevalidator;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.MenuHeader;
import edu.cmu.cs.hcii.cogtool.model.MenuItem;
import edu.cmu.cs.hcii.cogtool.model.ShapeType;
import edu.cmu.cs.hcii.cogtool.model.SimpleWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.ui.IZoomableUI;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.AUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.CompoundUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEditSequence;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FrameEditorController
extends ZoomableController {
    protected IFrameEditorUI ui;
    protected UndoManager undoMgr;
    protected IFrameEditorInteraction interaction;
    protected IFrame model;
    protected IDesign design;
    protected int widgetNameSuffix = 1;
    protected static IFrame.FrameDuplicator lookupFrameDuplicator = new IFrame.FrameDuplicator(){

        public IFrame getOrDuplicate(IFrame frameToCopy) {
            return frameToCopy;
        }

        public void recordDuplicateFrame(IFrame originalFrame, IFrame frameDuplicate) {
        }
    };
    protected final HashMap lastAttempt = new HashMap();
    protected static Comparator widgetHorizontalComparator = new Comparator(){

        public int compare(Object l, Object r) {
            DoubleRectangle left = ((IWidget)l).getShape().getBounds();
            DoubleRectangle right = ((IWidget)r).getShape().getBounds();
            double diff = left.x - right.x;
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        }
    };
    protected static Comparator widgetVerticalComparator = new Comparator(){

        public int compare(Object u, Object l) {
            DoubleRectangle upper = ((IWidget)u).getShape().getBounds();
            DoubleRectangle lower = ((IWidget)l).getShape().getBounds();
            double diff = upper.y - lower.y;
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        }
    };
    protected static DuplicateWidgetSituator widgetSituator = new DuplicateWidgetSituator();
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$MoveParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ResizeParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ShapeChangeParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$TypeChangeParameters;

    public FrameEditorController(IFrame f, IDesign d, IProject p) {
        super(p);
        this.model = f;
        this.design = d;
        this.undoMgr = CogTool.undoManagerFactory.getUndoManager(this.model, this.project);
        this.ui = CogTool.frameEditorUIFactory.createFrameEditorUI(this.model, this.design, this.project, this.undoMgr);
        this.interaction = this.ui.getInteraction();
        this.assignActions();
        this.ui.setVisible(true);
    }

    protected Object getModelObject() {
        return this.getModel();
    }

    public IFrame getModel() {
        return this.model;
    }

    public void assignActions() {
        super.assignActions();
        this.ui.setAction(FrameEditorLID.Undo, new UndoController.UndoAction(this.undoMgr, this.interaction));
        this.ui.setAction(FrameEditorLID.Redo, new UndoController.RedoAction(this.undoMgr, this.interaction));
        this.ui.setAction(FrameEditorLID.Paste, this.createPasteAction());
        this.ui.setAction(FrameEditorLID.Copy, this.createCopyWidgetAction());
        this.ui.setAction(FrameEditorLID.Cut, this.createCutWidgetAction());
        this.ui.setAction(FrameEditorLID.Rename, this.createInitiateRenameAction());
        this.ui.setAction(FrameEditorLID.SelectAll, new AListenerAction(){

            public boolean performAction(Object prms) {
                FrameEditorController.this.ui.selectAllWidgets();
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.NewWidget, this.createNewWidgetAction());
        this.ui.setAction(FrameEditorLID.Delete, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                return FrameEditorController.this.deleteWidgets(selection);
            }
        });
        this.ui.setAction(FrameEditorLID.SetBackgroundImage, this.createSetBackgroundImageAction());
        this.ui.setAction(FrameEditorLID.RemoveBackgroundImage, new AListenerAction(){

            public boolean performAction(Object prms) {
                FrameEditorController.this.setBackgroundImage(null);
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.SetWidgetColor, this.newSetWidgetColorAction());
        this.ui.setAction(DesignEditorLID.SkinNone, this.createSetSkinAction(SkinType.None, DesignEditorLID.SkinNone));
        this.ui.setAction(DesignEditorLID.SkinWireFrame, this.createSetSkinAction(SkinType.WireFrame, DesignEditorLID.SkinWireFrame));
        this.ui.setAction(DesignEditorLID.SkinMacOSX, this.createSetSkinAction(SkinType.MacOSX, DesignEditorLID.SkinMacOSX));
        this.ui.setAction(DesignEditorLID.SkinWinXP, this.createSetSkinAction(SkinType.WinXP, DesignEditorLID.SkinWinXP));
        this.ui.setAction(DesignEditorLID.SkinPalm, this.createSetSkinAction(SkinType.Palm, DesignEditorLID.SkinPalm));
        this.ui.setAction(FrameEditorLID.NudgeLeft, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                double dx = -1.0 / FrameEditorController.this.ui.getZoom();
                return FrameEditorController.this.moveWidgets(selection, new DoublePoint(dx, 0.0));
            }
        });
        this.ui.setAction(FrameEditorLID.NudgeRight, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                double dx = 1.0 / FrameEditorController.this.ui.getZoom();
                return FrameEditorController.this.moveWidgets(selection, new DoublePoint(dx, 0.0));
            }
        });
        this.ui.setAction(FrameEditorLID.NudgeUp, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                double dy = -1.0 / FrameEditorController.this.ui.getZoom();
                return FrameEditorController.this.moveWidgets(selection, new DoublePoint(0.0, dy));
            }
        });
        this.ui.setAction(FrameEditorLID.NudgeDown, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                double dy = 1.0 / FrameEditorController.this.ui.getZoom();
                return FrameEditorController.this.moveWidgets(selection, new DoublePoint(0.0, dy));
            }
        });
        this.ui.setAction(FrameEditorLID.AlignTop, new AlignmentAction(FrameEditorLID.AlignTop){

            protected void computeNewOrigin(DoubleRectangle bounds) {
                this.newX = bounds.x;
                this.newY = this.reference.y;
            }

            protected double getReferenceDimension(DoubleRectangle r) {
                return -r.y;
            }

            protected String getAlignmentName() {
                return L10N.get("UNDO.FE.AlignTop", "Align Top");
            }
        });
        this.ui.setAction(FrameEditorLID.AlignBottom, new AlignmentAction(FrameEditorLID.AlignBottom){

            protected void computeNewOrigin(DoubleRectangle bounds) {
                this.newX = bounds.x;
                this.newY = this.reference.y + this.reference.height - bounds.height;
            }

            protected double getReferenceDimension(DoubleRectangle r) {
                return r.y;
            }

            protected String getAlignmentName() {
                return L10N.get("UNDO.FE.AlignBottom", "Align Bottom");
            }
        });
        this.ui.setAction(FrameEditorLID.AlignLeft, new AlignmentAction(FrameEditorLID.AlignLeft){

            protected void computeNewOrigin(DoubleRectangle bounds) {
                this.newX = this.reference.x;
                this.newY = bounds.y;
            }

            protected double getReferenceDimension(DoubleRectangle r) {
                return -r.x;
            }

            protected String getAlignmentName() {
                return L10N.get("UNDO.FE.AlignLeft", "Align Left");
            }
        });
        this.ui.setAction(FrameEditorLID.AlignRight, new AlignmentAction(FrameEditorLID.AlignRight){

            protected void computeNewOrigin(DoubleRectangle bounds) {
                this.newX = this.reference.x + this.reference.width - bounds.width;
                this.newY = bounds.y;
            }

            protected double getReferenceDimension(DoubleRectangle r) {
                return r.x;
            }

            protected String getAlignmentName() {
                return L10N.get("UNDO.FE.AlignRight", "Align Right");
            }
        });
        this.ui.setAction(FrameEditorLID.SpaceVertically, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                boolean VERTICAL = true;
                return FrameEditorController.this.spaceWidgetsEqually(selection, true);
            }
        });
        this.ui.setAction(FrameEditorLID.SpaceHorizontally, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                boolean HORIZONTAL = false;
                return FrameEditorController.this.spaceWidgetsEqually(selection, false);
            }
        });
        this.ui.setAction(FrameEditorLID.BringToFront, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.BringToFront", "Bring to Front"), FrameEditorLID.BringToFront);
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                IWidget[] selected = FrameEditorController.this.getSelectedWidgetModels(selection, true);
                Arrays.sort(selected, IWidget.WidgetLevelComparator.ONLY);
                for (int i = 0; i < selected.length; ++i) {
                    FrameEditorController.this.adjustWidgetLevel(Integer.MAX_VALUE, selected[i], edit);
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.BringForward, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.BringForward", "Bring Forward"), FrameEditorLID.BringForward);
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                IWidget[] selected = FrameEditorController.this.getSelectedWidgetModels(selection, true);
                Arrays.sort(selected, IWidget.WidgetLevelComparator.ONLY);
                int maxLevel = FrameEditorController.this.model.getWidgets().size() - 1;
                int i = selected.length - 1;
                while (i >= 0) {
                    IWidget w = selected[i];
                    if (w.getLevel() < maxLevel) {
                        FrameEditorController.this.adjustWidgetLevel(w.getLevel() + 1, w, edit);
                    }
                    --i;
                    --maxLevel;
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.SendBackward, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.SendBackward", "Send Backward"), FrameEditorLID.SendBackward);
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                IWidget[] selected = FrameEditorController.this.getSelectedWidgetModels(selection, true);
                Arrays.sort(selected, IWidget.WidgetLevelComparator.ONLY);
                int minLevel = 0;
                int i = 0;
                while (i < selected.length) {
                    IWidget w = selected[i];
                    if (w.getLevel() > minLevel) {
                        FrameEditorController.this.adjustWidgetLevel(w.getLevel() - 1, w, edit);
                    }
                    ++i;
                    ++minLevel;
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.SendToBack, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.SendToBack", "Send to Back"), FrameEditorLID.SendToBack);
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                IWidget[] selected = FrameEditorController.this.getSelectedWidgetModels(selection, true);
                Arrays.sort(selected, IWidget.WidgetLevelComparator.ONLY);
                for (int i = selected.length - 1; i >= 0; --i) {
                    FrameEditorController.this.adjustWidgetLevel(0, selected[i], edit);
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.MoveWidgets, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$MoveParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$MoveParameters = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI$MoveParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$MoveParameters;
            }

            public boolean performAction(Object prms) {
                IFrameEditorUI.MoveParameters movePrms = (IFrameEditorUI.MoveParameters)prms;
                if (movePrms != null) {
                    return FrameEditorController.this.moveWidgets(movePrms.selection, movePrms.moveBy);
                }
                return false;
            }
        });
        this.ui.setAction(FrameEditorLID.ResizeWidgets, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ResizeParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ResizeParameters = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI$ResizeParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ResizeParameters;
            }

            public boolean performAction(Object prms) {
                IFrameEditorUI.ResizeParameters resizePrms = (IFrameEditorUI.ResizeParameters)prms;
                if (prms != null) {
                    return FrameEditorController.this.resizeWidgets(resizePrms.oldX, resizePrms.oldY, resizePrms.newX, resizePrms.newY, resizePrms.ratioX, resizePrms.ratioY, resizePrms.selection);
                }
                return false;
            }
        });
        this.ui.setAction(FrameEditorLID.ChangeShapeProperty, this.createChangeShapeAction());
        this.ui.setAction(FrameEditorLID.ChangeTitleProperty, this.createChangeTitlePropertyAction());
        this.ui.setAction(FrameEditorLID.ChangeNameProperty, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI$ActionStringParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters;
            }

            public boolean performAction(Object prms) {
                IFrameEditorUI.ActionStringParameters p = (IFrameEditorUI.ActionStringParameters)prms;
                int numWidgets = p.selection.getWidgetSelectionCount();
                if (numWidgets == 0) {
                    FrameEditorController.this.interaction.protestNoSelection();
                } else if (numWidgets > 1) {
                    FrameEditorController.this.interaction.protestTooManyWidgets();
                } else {
                    IWidget[] selectedWidget = p.selection.getSelectedIWidgets();
                    return FrameEditorController.this.updateWidgetName(selectedWidget[0], p.param);
                }
                return false;
            }
        });
        this.ui.setAction(FrameEditorLID.ChangeTypeProperty, this.createChangeTypeAction());
        this.ui.setAction(FrameEditorLID.SetImageProperty, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                FrameEditorSelectionState selection = (FrameEditorSelectionState)prms;
                Iterator selected = selection.getSelectedWidgetsIterator();
                String imageURL = FrameEditorController.this.interaction.selectImageFile();
                if (imageURL != null) {
                    try {
                        byte[] imageData = GraphicsUtil.loadImageFromFile(imageURL);
                        FrameEditorController.this.setWidgetImages(selected, imageData);
                        return true;
                    }
                    catch (IOException e) {
                        FrameEditorController.this.interaction.protestUnreadableFile();
                    }
                }
                return false;
            }
        });
        this.ui.setAction(FrameEditorLID.RemoveImageProperty, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                FrameEditorSelectionState selection = (FrameEditorSelectionState)prms;
                Iterator selected = selection.getSelectedWidgetsIterator();
                FrameEditorController.this.setWidgetImages(selected, null);
                return true;
            }
        });
        this.ui.setAction(FrameEditorLID.CaptureImageProperty, this.captureImageAction());
        this.ui.setAction(FrameEditorLID.Duplicate, this.duplicateWidgetsAction());
    }

    protected IListenerAction createNewWidgetAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                Widget widget = null;
                WidgetType defaultType = FrameEditorController.this.ui.getCurrentWidgetType();
                if (prms instanceof IFrameEditorUI.NewWidgetParameters) {
                    IFrameEditorUI.NewWidgetParameters nwp = (IFrameEditorUI.NewWidgetParameters)prms;
                    if (nwp.parentMenu != null) {
                        if (nwp.asNewHeader) {
                            IWidgetGroup menuHeaderGroup = nwp.parentMenu.getParentGroup();
                            widget = new MenuHeader(menuHeaderGroup, nwp.bounds, nwp.widgetTitle);
                        } else {
                            widget = new MenuItem(nwp.parentMenu, nwp.bounds, nwp.widgetTitle);
                        }
                    } else if (defaultType == WidgetType.Menu) {
                        SimpleWidgetGroup newMenuHeaderGroup = new SimpleWidgetGroup(2);
                        widget = new MenuHeader(newMenuHeaderGroup, nwp.bounds, nwp.widgetTitle);
                    } else {
                        widget = new Widget(nwp.bounds, defaultType);
                    }
                } else {
                    widget = new Widget(defaultType);
                }
                widget.setName(FrameEditorController.this.generateUniqueWidgetName());
                return FrameEditorController.this.createWidget(widget);
            }
        };
    }

    protected IListenerAction createSetBackgroundImageAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                String imageURL = FrameEditorController.this.interaction.selectImageFile();
                if (imageURL != null) {
                    try {
                        FrameEditorController.this.setBackgroundImage(GraphicsUtil.loadImageFromFile(imageURL));
                        return true;
                    }
                    catch (IOException e) {
                        FrameEditorController.this.interaction.protestUnreadableFile();
                    }
                }
                return false;
            }
        };
    }

    protected IListenerAction createChangeTitlePropertyAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI$ActionStringParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ActionStringParameters;
            }

            public boolean performAction(Object prms) {
                IFrameEditorUI.ActionStringParameters p = (IFrameEditorUI.ActionStringParameters)prms;
                Iterator selected = p.selection.getSelectedWidgetsIterator();
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.ChangeWidgetTitle", "Change Displayed Label"), FrameEditorLID.ChangeTitleProperty);
                while (selected.hasNext()) {
                    String newTitle;
                    IWidget w = (IWidget)selected.next();
                    String oldTitle = w.getTitle();
                    if (oldTitle.equals(newTitle = p.param)) continue;
                    w.setTitle(newTitle);
                    edit.addEdit(new AUndoableEdit(this, FrameEditorLID.ChangeTitleProperty, w, p, oldTitle){
                        private final /* synthetic */ IWidget val$w;
                        private final /* synthetic */ IFrameEditorUI.ActionStringParameters val$p;
                        private final /* synthetic */ String val$oldTitle;
                        private final /* synthetic */ 27 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$w = val$w;
                            this.val$p = val$p;
                            this.val$oldTitle = val$oldTitle;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.FE.ChangeWidgetTitle", "Change Displayed Label");
                        }

                        public void redo() {
                            super.redo();
                            this.val$w.setTitle(this.val$p.param);
                        }

                        public void undo() {
                            super.undo();
                            this.val$w.setTitle(this.val$oldTitle);
                        }
                    });
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }
        };
    }

    protected IListenerAction captureImageAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$FrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.CaptureBackgroundImage", "Capture Background"), FrameEditorLID.CaptureImageProperty);
                FrameEditorSelectionState selection = (FrameEditorSelectionState)prms;
                Iterator selected = selection.getSelectedWidgetsIterator();
                while (selected.hasNext()) {
                    IWidget w = (IWidget)selected.next();
                    DoubleRectangle bounds = w.getShape().getBounds();
                    byte[] bg = GraphicsUtil.cropImage(FrameEditorController.this.model.getBackgroundImage(), bounds.x, bounds.y, bounds.width, bounds.height);
                    byte[] old = w.getImage();
                    w.setImage(bg);
                    edit.addEdit(new AUndoableEdit(this, FrameEditorLID.CaptureImageProperty, w, bg, old){
                        private final /* synthetic */ IWidget val$w;
                        private final /* synthetic */ byte[] val$bg;
                        private final /* synthetic */ byte[] val$old;
                        private final /* synthetic */ 29 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$w = val$w;
                            this.val$bg = val$bg;
                            this.val$old = val$old;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.FE.CaptureBackgroundImage", "Capture Background");
                        }

                        public void redo() {
                            super.redo();
                            this.val$w.setImage(this.val$bg);
                        }

                        public void undo() {
                            super.undo();
                            this.val$w.setImage(this.val$old);
                        }
                    });
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }
        };
    }

    protected IListenerAction createChangeShapeAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ShapeChangeParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ShapeChangeParameters = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI$ShapeChangeParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$ShapeChangeParameters;
            }

            public boolean performAction(Object prms) {
                IFrameEditorUI.ShapeChangeParameters p = (IFrameEditorUI.ShapeChangeParameters)prms;
                Iterator selected = p.selection.getSelectedWidgetsIterator();
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.ChangeWidgetShape", "Change Widget Shape"), FrameEditorLID.ChangeShapeProperty);
                while (selected.hasNext()) {
                    ShapeType newShapeType;
                    IWidget w = (IWidget)selected.next();
                    ShapeType oldShapeType = w.getShape().getShapeType();
                    if (oldShapeType.equals(newShapeType = p.newShapeType)) continue;
                    Set validators = FrameEditorController.this.project.invalidateResultsUsing(FrameEditorController.this.design, w, null);
                    w.setShapeType(newShapeType);
                    edit.addEdit(new AUndoableEdit(this, FrameEditorLID.ChangeShapeProperty, w, validators, p, oldShapeType){
                        private final /* synthetic */ IWidget val$w;
                        private final /* synthetic */ Set val$validators;
                        private final /* synthetic */ IFrameEditorUI.ShapeChangeParameters val$p;
                        private final /* synthetic */ ShapeType val$oldShapeType;
                        private final /* synthetic */ 31 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$w = val$w;
                            this.val$validators = val$validators;
                            this.val$p = val$p;
                            this.val$oldShapeType = val$oldShapeType;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.FE.ChangeWidgetShape", "Change Widget Shape");
                        }

                        public void redo() {
                            super.redo();
                            31.access$100(this.this$1).revalidateWidget(this.val$w, this.val$validators);
                            this.val$w.setShapeType(this.val$p.newShapeType);
                        }

                        public void undo() {
                            super.undo();
                            this.val$w.setShapeType(this.val$oldShapeType);
                            31.access$100(this.this$1).revalidateWidget(this.val$w, this.val$validators);
                        }
                    });
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }

            static /* synthetic */ FrameEditorController access$100(31 x0) {
                return x0.FrameEditorController.this;
            }
        };
    }

    protected IListenerAction createChangeTypeAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$TypeChangeParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$TypeChangeParameters = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI$TypeChangeParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorUI$TypeChangeParameters;
            }

            public boolean performAction(Object prms) {
                IFrameEditorUI.TypeChangeParameters p = (IFrameEditorUI.TypeChangeParameters)prms;
                Iterator selected = p.selection.getSelectedWidgetsIterator();
                CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.ChangeWidgetType", "Change Widget Type"), FrameEditorLID.ChangeTypeProperty);
                while (selected.hasNext()) {
                    WidgetType newWidgetType;
                    IWidget w = (IWidget)selected.next();
                    WidgetType oldWidgetType = w.getWidgetType();
                    if (oldWidgetType.equals(newWidgetType = p.newWidgetType)) continue;
                    Set validators = FrameEditorController.this.project.invalidateResultsUsing(FrameEditorController.this.design, w, null);
                    w.setWidgetType(newWidgetType);
                    edit.addEdit(new AUndoableEdit(this, FrameEditorLID.ChangeTypeProperty, w, validators, p, oldWidgetType){
                        private final /* synthetic */ IWidget val$w;
                        private final /* synthetic */ Set val$validators;
                        private final /* synthetic */ IFrameEditorUI.TypeChangeParameters val$p;
                        private final /* synthetic */ WidgetType val$oldWidgetType;
                        private final /* synthetic */ 33 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$w = val$w;
                            this.val$validators = val$validators;
                            this.val$p = val$p;
                            this.val$oldWidgetType = val$oldWidgetType;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.FE.ChangeWidgetType", "Change Widget Type");
                        }

                        public void redo() {
                            super.redo();
                            33.access$200(this.this$1).revalidateWidget(this.val$w, this.val$validators);
                            this.val$w.setWidgetType(this.val$p.newWidgetType);
                        }

                        public void undo() {
                            super.undo();
                            this.val$w.setWidgetType(this.val$oldWidgetType);
                            33.access$200(this.this$1).revalidateWidget(this.val$w, this.val$validators);
                        }
                    });
                }
                edit.end();
                if (edit.isSignificant()) {
                    FrameEditorController.this.undoMgr.addEdit(edit);
                }
                return true;
            }

            static /* synthetic */ FrameEditorController access$200(33 x0) {
                return x0.FrameEditorController.this;
            }
        };
    }

    protected IListenerAction createCopyWidgetAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState seln = (IFrameEditorSelectionState)prms;
                if (seln.getWidgetSelectionCount() > 0) {
                    FrameEditorController.this.copyWidgets(seln);
                    return true;
                }
                FrameEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected void copyWidgets(IFrameEditorSelectionState seln) {
        try {
            ObjectSaver s = CogToolClipboard.startClipboardSave((Object)"TransitionSourceOnly", seln.getSelectedIWidgets());
            Iterator widgets = seln.getSelectedWidgetsIterator();
            while (widgets.hasNext()) {
                IWidget w = (IWidget)widgets.next();
                if (w instanceof IMenuItem) continue;
                s.saveObject(w);
            }
            s.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IListenerAction createCutWidgetAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState seln = (IFrameEditorSelectionState)prms;
                if (seln.getWidgetSelectionCount() > 0) {
                    FrameEditorController.this.copyWidgets(seln);
                    return FrameEditorController.this.deleteWidgets(seln);
                }
                FrameEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IListenerAction createInitiateRenameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
                int selectedFrameCount = selection.getWidgetSelectionCount();
                if (selectedFrameCount == 1) {
                    IWidget w = selection.getSelectedIWidgets()[0];
                    FrameEditorController.this.ui.initiateWidgetRename(w);
                    return true;
                }
                FrameEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected void makeWidgetNameUnique(IWidget widget) {
        widget.setName(FrameEditorController.makeNameUnique(widget.getName(), this.model.getWidgets()));
    }

    protected void addChildWidgets(IWidgetGroup widgetGroup, IUndoableEditSequence editSeq) {
        Iterator children = widgetGroup.getAllWidgets();
        while (children.hasNext()) {
            IMenuItem item;
            IWidget child = (IWidget)children.next();
            this.makeWidgetNameUnique(child);
            editSeq.addEdit(this.addWidget(child));
            if (!(child instanceof IMenuItem) || !(item = (IMenuItem)child).isSubmenu()) continue;
            this.addChildWidgets(item.getChildItems(), editSeq);
        }
    }

    protected IListenerAction createPasteAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                try {
                    if (CogToolClipboard.hasCogToolObjects()) {
                        Collection objects = CogToolClipboard.fetchCogToolObjects();
                        if (objects != null && objects.size() > 0) {
                            CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.Paste", "Paste"), FrameEditorLID.Paste);
                            Iterator objIt = objects.iterator();
                            while (objIt.hasNext()) {
                                Object o = objIt.next();
                                if (!(o instanceof IWidget)) continue;
                                IWidget widget = (IWidget)o;
                                FrameEditorController.this.makeWidgetNameUnique(widget);
                                edit.addEdit(FrameEditorController.this.addWidget(widget));
                                if (!(widget instanceof IMenuHeader)) continue;
                                IMenuHeader mh = (IMenuHeader)widget;
                                FrameEditorController.this.addChildWidgets(mh.getChildItems(), edit);
                            }
                            edit.end();
                            FrameEditorController.this.undoMgr.addEdit(edit);
                        }
                        return true;
                    }
                    if (CogToolClipboard.hasImageData()) {
                        byte[] img = CogToolClipboard.fetchImageData();
                        IFrameEditorSelectionState sel = FrameEditorController.this.ui.getSelectionState();
                        if (sel.getWidgetSelectionCount() > 0) {
                            FrameEditorController.this.setWidgetImages(sel.getSelectedWidgetsIterator(), img);
                        } else {
                            FrameEditorController.this.setBackgroundImage(img);
                        }
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        };
    }

    protected IListenerAction newSetWidgetColorAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                int oldColor = FrameEditorController.this.model.getWidgetColor();
                Integer newColorChoice = FrameEditorController.this.interaction.selectColor(oldColor, L10N.get("FRAME.WIDGET.selectColor", "Select Widget Color"));
                if (newColorChoice != null) {
                    int newColor = newColorChoice;
                    FrameEditorController.this.model.setWidgetColor(newColor);
                    FrameEditorController.this.undoMgr.addEdit(new AUndoableEdit(this, FrameEditorLID.SetWidgetColor, newColor, oldColor){
                        private final /* synthetic */ int val$newColor;
                        private final /* synthetic */ int val$oldColor;
                        private final /* synthetic */ 39 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$newColor = val$newColor;
                            this.val$oldColor = val$oldColor;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.FE.SetWidgetColor", "Set Widget Color");
                        }

                        public void redo() {
                            super.redo();
                            39.access$300(this.this$1).model.setWidgetColor(this.val$newColor);
                        }

                        public void undo() {
                            super.undo();
                            39.access$300(this.this$1).model.setWidgetColor(this.val$oldColor);
                        }
                    });
                    return true;
                }
                return false;
            }

            static /* synthetic */ FrameEditorController access$300(39 x0) {
                return x0.FrameEditorController.this;
            }
        };
    }

    protected void setBackgroundImage(final byte[] imageData) {
        try {
            final DoubleRectangle imageSize = GraphicsUtil.getImageBounds(imageData);
            final byte[] previousImageData = this.model.getBackgroundImage();
            final DoubleRectangle previmageSize = this.model.getBackgroundBounds();
            this.model.setBackgroundImage(imageData, imageSize);
            CogToolLID lid = imageData == null ? FrameEditorLID.RemoveBackgroundImage : FrameEditorLID.SetBackgroundImage;
            this.undoMgr.addEdit(new AUndoableEdit(lid){

                public String getPresentationName() {
                    return imageData == null ? L10N.get("UNDO.FE.RemoveBackgroundImage", "Remove Frame Background Image") : L10N.get("UNDO.FE.SetBackgroundImage", "Set Frame Background Image");
                }

                public void redo() {
                    super.redo();
                    FrameEditorController.this.model.setBackgroundImage(imageData, imageSize);
                }

                public void undo() {
                    super.undo();
                    FrameEditorController.this.model.setBackgroundImage(previousImageData, previmageSize);
                }
            });
        }
        catch (Exception e) {
            this.interaction.protestInvalidImageFile();
        }
    }

    protected IUndoableEdit addWidget(IWidget w) {
        this.model.addWidget(w);
        if (w instanceof IMenuItem) {
            IMenuItem mi = (IMenuItem)w;
            final IMenuWidget itemParent = mi.getParent();
            final int atIndex = itemParent.indexOf(mi);
            return new AddWidgetUndoableEdit(w){

                protected void redoHelper() {
                    itemParent.addItem(atIndex, (IMenuItem)this.widget);
                }

                protected void undoHelper() {
                    itemParent.removeItem((IMenuItem)this.widget);
                }
            };
        }
        final IWidgetGroup parentGroup = w.getParentGroup();
        final int atIndex = parentGroup != null ? parentGroup.indexOf(w) : -1;
        return new AddWidgetUndoableEdit(w){

            protected void redoHelper() {
                if (parentGroup != null) {
                    parentGroup.addWidget(atIndex, this.widget);
                }
            }

            protected void undoHelper() {
                if (parentGroup != null) {
                    parentGroup.removeWidget(this.widget);
                }
            }
        };
    }

    protected boolean createWidget(IWidget w) {
        if (this.model.isWidgetNameTaken(w.getName())) {
            String name = w.getName();
            while (this.model.isWidgetNameTaken(name = this.interaction.askWidgetName(name, this.generateUniqueWidgetName()))) {
            }
            w.setName(name);
        }
        this.undoMgr.addEdit(this.addWidget(w));
        return true;
    }

    protected boolean deleteWidgets(IFrameEditorSelectionState selection) {
        CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.DeleteWidget(s)", "Delete Widget(s)"), FrameEditorLID.Delete);
        Iterator widgets = selection.getSelectedWidgetsIterator();
        if (selection.getWidgetSelectionCount() > 0) {
            if (this.interaction.confirmDeleteWidgets(selection.getSelectedIWidgets())) {
                while (widgets.hasNext()) {
                    IWidget widget = (IWidget)widgets.next();
                    widgets.remove();
                    this.deleteWidget(widget, true, edit);
                }
                edit.end();
                this.undoMgr.addEdit(edit);
                return true;
            }
        } else {
            this.interaction.protestNoSelection();
        }
        return false;
    }

    protected void deleteWidget(IWidget w, boolean moveSiblings, CompoundUndoableEdit edit) {
        IMenuWidget itemParent;
        Set validators = this.project.invalidateResultsUsing(this.design, w, null);
        IWidgetGroup parentGroup = w.getParentGroup();
        int atIndex = parentGroup != null ? parentGroup.indexOf(w) : -1;
        double deltaX = 0.0;
        double deltaY = 0.0;
        if (parentGroup != null) {
            IMenuWidget mw;
            IWidgetGroup children;
            if (w instanceof IMenuWidget && (children = (mw = (IMenuWidget)w).getChildItems()) != null && children.widgetCount() > 0) {
                Iterator widgetIter = children.getAllWidgets();
                while (children.widgetCount() > 0) {
                    this.deleteWidget(children.getWidget(0), false, edit);
                }
            }
            if (moveSiblings) {
                int myGroupNum = parentGroup.widgetCount();
                if (parentGroup.getOrientation() == 2) {
                    deltaX = -w.getShape().getBounds().width;
                } else if (parentGroup.getOrientation() == 1) {
                    deltaY = -w.getShape().getBounds().height;
                }
                for (int i = atIndex + 1; i < myGroupNum; ++i) {
                    IWidget curWidget = parentGroup.getWidget(i);
                    curWidget.moveWidget(deltaX, deltaY);
                }
            }
            if (w instanceof IMenuItem) {
                IMenuItem miw = (IMenuItem)w;
                itemParent = miw.getParent();
                itemParent.removeItem(miw);
            } else {
                parentGroup.removeWidget(w);
            }
        }
        this.model.removeWidget(w);
        if (w instanceof IMenuItem) {
            IMenuItem mi = (IMenuItem)w;
            itemParent = mi.getParent();
            edit.addEdit(new DeleteWidgetUndoableEdit(w, validators, parentGroup, atIndex, deltaX, deltaY){

                public void redoHelper() {
                    itemParent.removeItem((IMenuItem)this.widget);
                }

                public void undoHelper() {
                    itemParent.addItem(this.atIndex, (IMenuItem)this.widget);
                }
            });
        } else {
            edit.addEdit(new DeleteWidgetUndoableEdit(w, validators, parentGroup, atIndex, deltaX, deltaY){

                public void redoHelper() {
                    this.parentGroup.removeWidget(this.widget);
                }

                public void undoHelper() {
                    this.parentGroup.addWidget(this.atIndex, this.widget);
                }
            });
        }
    }

    protected boolean resizeWidgets(double oldResizeX, double oldResizeY, double newResizeX, double newResizeY, double ratioX, double ratioY, IFrameEditorSelectionState selection) {
        Iterator selected = selection.getSelectedWidgetsIterator();
        CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.ResizeWidgets", "Resize Widget(s)"), FrameEditorLID.ResizeWidgets);
        while (selected.hasNext()) {
            IWidget widget = (IWidget)selected.next();
            if (widget instanceof IMenuWidget) {
                IWidgetGroup group = widget.getParentGroup();
                Iterator menuElts = group.getAllWidgets();
                while (menuElts.hasNext()) {
                    IWidget menuElt = (IWidget)menuElts.next();
                    this.resizeWidget(menuElt, oldResizeX, oldResizeY, newResizeX, newResizeY, ratioX, ratioY, edit);
                }
                continue;
            }
            this.resizeWidget(widget, oldResizeX, oldResizeY, newResizeX, newResizeY, ratioX, ratioY, edit);
        }
        edit.end();
        if (edit.isSignificant()) {
            this.undoMgr.addEdit(edit);
        }
        return true;
    }

    protected void resizeWidget(final IWidget widget, double oldResizeX, double oldResizeY, double newResizeX, double newResizeY, double ratioX, double ratioY, CompoundUndoableEdit edit) {
        DoubleRectangle oldBounds = widget.getShape().getBounds();
        final double oldWidgetX = oldBounds.x;
        final double oldWidgetY = oldBounds.y;
        final double oldWidth = oldBounds.width;
        final double oldHeight = oldBounds.height;
        final double newWidgetX = ratioX * (oldBounds.x - oldResizeX) + newResizeX;
        final double newWidgetY = ratioY * (oldBounds.y - oldResizeY) + newResizeY;
        final double newWidth = Math.max(ratioX * oldBounds.width, 1.0);
        final double newHeight = Math.max(ratioY * oldBounds.height, 1.0);
        final Set validators = this.project.invalidateResultsUsing(this.design, widget, null);
        widget.setWidgetOrigin(newWidgetX, newWidgetY);
        widget.setWidgetSize(newWidth, newHeight);
        edit.addEdit(new AUndoableEdit(FrameEditorLID.ResizeWidgets){

            public String getPresentationName() {
                return L10N.get("UNDO.FE.ResizeWidget", "Resize Widget");
            }

            public void redo() {
                super.redo();
                FrameEditorController.this.revalidateWidget(widget, validators);
                widget.setWidgetOrigin(newWidgetX, newWidgetY);
                widget.setWidgetSize(newWidth, newHeight);
            }

            public void undo() {
                super.undo();
                widget.setWidgetOrigin(oldWidgetX, oldWidgetY);
                widget.setWidgetSize(oldWidth, oldHeight);
                FrameEditorController.this.revalidateWidget(widget, validators);
            }
        });
    }

    protected boolean moveWidgets(IFrameEditorSelectionState selection, DoublePoint widgetMoveBy) {
        Iterator selected = selection.getSelectedWidgetsIterator();
        CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.FE.MoveWidget(s)", "Move Widget(s)"), FrameEditorLID.MoveWidgets);
        HashSet<IWidgetGroup> movedGroups = null;
        while (selected.hasNext()) {
            IWidget widget = (IWidget)selected.next();
            IWidgetGroup parentGroup = widget.getParentGroup();
            if (parentGroup == null) {
                this.moveWidget(widget, widgetMoveBy, edit);
                continue;
            }
            if (widget instanceof IMenuItem || movedGroups != null && movedGroups.contains(parentGroup)) continue;
            this.moveWidgetGroup(parentGroup, widgetMoveBy, edit);
            if (movedGroups == null) {
                movedGroups = new HashSet<IWidgetGroup>();
            }
            movedGroups.add(parentGroup);
        }
        edit.end();
        if (edit.isSignificant()) {
            this.undoMgr.addEdit(edit);
        }
        return true;
    }

    protected void moveWidget(final IWidget w, DoublePoint widgetMoveBy, CompoundUndoableEdit edit) {
        final Set validators = this.project.invalidateResultsUsing(this.design, w, null);
        DoublePoint oldLocation = w.getShape().getOrigin();
        final double oldX = oldLocation.x;
        final double oldY = oldLocation.y;
        final double newX = Math.max(oldX + widgetMoveBy.x, 0.0);
        final double newY = Math.max(oldY + widgetMoveBy.y, 0.0);
        w.setWidgetOrigin(newX, newY);
        edit.addEdit(new AUndoableEdit(FrameEditorLID.MoveWidgets){

            public String getPresentationName() {
                return L10N.get("UNDO.FE.MoveWidget", "Move Widget");
            }

            public void redo() {
                super.redo();
                FrameEditorController.this.revalidateWidget(w, validators);
                w.setWidgetOrigin(newX, newY);
            }

            public void undo() {
                super.undo();
                w.setWidgetOrigin(oldX, oldY);
                FrameEditorController.this.revalidateWidget(w, validators);
            }
        });
    }

    protected void moveWidgetGroup(final IWidgetGroup group, DoublePoint widgetMoveBy, CompoundUndoableEdit edit) {
        IWidget firstChildWidget = group.getWidget(0);
        DoublePoint oldLocation = firstChildWidget.getShape().getOrigin();
        final double deltaX = Math.max(widgetMoveBy.x, -oldLocation.x);
        final double deltaY = Math.max(widgetMoveBy.y, -oldLocation.y);
        final int numWidgets = group.widgetCount();
        final Set[] validators = new Set[numWidgets];
        for (int i = 0; i < numWidgets; ++i) {
            IWidget w = group.getWidget(i);
            validators[i] = this.project.invalidateResultsUsing(this.design, w, null);
            w.moveWidget(deltaX, deltaY);
        }
        edit.addEdit(new AUndoableEdit(FrameEditorLID.MoveWidgets){

            public String getPresentationName() {
                return L10N.get("UNDO.FE.MoveWidget", "Move Widget");
            }

            public void redo() {
                super.redo();
                for (int i = 0; i < numWidgets; ++i) {
                    IWidget w = group.getWidget(i);
                    FrameEditorController.this.revalidateWidget(w, validators[i]);
                    w.moveWidget(deltaX, deltaY);
                }
            }

            public void undo() {
                super.undo();
                for (int i = 0; i < numWidgets; ++i) {
                    IWidget w = group.getWidget(i);
                    w.moveWidget(-deltaX, -deltaY);
                    FrameEditorController.this.revalidateWidget(w, validators[i]);
                }
            }
        });
    }

    protected void adjustWidgetLevel(final int newLevel, final IWidget widget, CompoundUndoableEdit edit) {
        final int oldLevel = widget.getLevel();
        this.model.setWidgetLevel(newLevel, widget);
        edit.addEdit(new AUndoableEdit(edit.getLID()){

            public String getPresentationName() {
                return L10N.get("UNDO.FE.ChangeWidgetLevel", "Level Change");
            }

            public void redo() {
                super.redo();
                FrameEditorController.this.model.setWidgetLevel(newLevel, widget);
            }

            public void undo() {
                super.undo();
                FrameEditorController.this.model.setWidgetLevel(oldLevel, widget);
            }
        });
    }

    protected boolean spaceWidgetsEqually(IFrameEditorSelectionState selection, final boolean vertical) {
        final String undoRedoLabel = vertical ? L10N.get("UNDO.FE.SpaceVertically", "Space Vertically") : L10N.get("UNDO.FE.SpaceHorizontally", "Space Horizontally");
        CogToolLID lid = vertical ? FrameEditorLID.SpaceVertically : FrameEditorLID.SpaceHorizontally;
        CompoundUndoableEdit edit = new CompoundUndoableEdit(undoRedoLabel, lid);
        IWidget[] widgets = this.getSelectedWidgetModels(selection, false);
        Arrays.sort(widgets, vertical ? widgetVerticalComparator : widgetHorizontalComparator);
        double sum = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < widgets.length; ++i) {
            DoubleRectangle bounds = widgets[i].getShape().getBounds();
            double size = vertical ? bounds.height : bounds.width;
            double position = vertical ? bounds.y : bounds.x;
            sum += size;
            min = Math.min(min, position);
            max = Math.max(max, size + position);
        }
        double spacing = (max - min - sum) / (double)(widgets.length - 1);
        for (int i = 0; i < widgets.length; ++i) {
            final IWidget w = widgets[i];
            final DoubleRectangle bounds = w.getShape().getBounds();
            final double p_old = vertical ? bounds.y : bounds.x;
            final double p_new = min;
            final Set validators = this.project.invalidateResultsUsing(this.design, w, null);
            w.setWidgetOrigin(vertical ? bounds.x : p_new, vertical ? p_new : bounds.y);
            min += spacing + (vertical ? bounds.height : bounds.width);
            edit.addEdit(new AUndoableEdit(lid){

                public String getPresentationName() {
                    return undoRedoLabel;
                }

                public void redo() {
                    super.redo();
                    FrameEditorController.this.revalidateWidget(w, validators);
                    w.setWidgetOrigin(vertical ? bounds.x : p_new, vertical ? p_new : bounds.y);
                }

                public void undo() {
                    super.undo();
                    w.setWidgetOrigin(vertical ? bounds.x : p_old, vertical ? p_old : bounds.y);
                    FrameEditorController.this.revalidateWidget(w, validators);
                }
            });
        }
        edit.end();
        if (edit.isSignificant()) {
            this.undoMgr.addEdit(edit);
        }
        return true;
    }

    protected boolean updateWidgetName(final IWidget widget, String tryName) {
        final String oldName = widget.getName();
        boolean notDone = true;
        do {
            if (tryName.length() == 0) {
                tryName = this.interaction.protestWidgetCannotBeEmpty();
                if (tryName != null) continue;
                return false;
            }
            IWidget widgetForName = this.model.getWidget(tryName);
            if (widgetForName == widget) {
                notDone = false;
                continue;
            }
            if (widgetForName != null) {
                tryName = this.interaction.protestWidgetNameCollision();
                if (tryName != null) continue;
                return false;
            }
            notDone = false;
            final String newName = tryName;
            this.model.setWidgetName(newName, widget);
            this.undoMgr.addEdit(new AUndoableEdit(FrameEditorLID.ChangeNameProperty){

                public String getPresentationName() {
                    return L10N.get("UNDO.FE.ChangeWidgetName", "Change Widget Name");
                }

                public void redo() {
                    super.redo();
                    FrameEditorController.this.model.setWidgetName(newName, widget);
                }

                public void undo() {
                    super.undo();
                    FrameEditorController.this.model.setWidgetName(oldName, widget);
                }
            });
        } while (notDone);
        return true;
    }

    protected void duplicateMenu(IMenuHeader menuHeader, Collection widgetCopies) {
        IWidgetGroup newHeaderGroup = widgetSituator.getHeaderGroup(menuHeader);
        IMenuHeader widgetCopy = menuHeader.duplicate(newHeaderGroup, lookupFrameDuplicator, widgetSituator);
        widgetSituator.placeInContext(widgetCopy);
        widgetCopy.moveWidget(16.0, 16.0);
    }

    protected IListenerAction duplicateWidgetsAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameEditorSelectionState seln = (IFrameEditorSelectionState)prms;
                int widgetCount = seln.getWidgetSelectionCount();
                if (widgetCount > 0) {
                    IWidget widgetCopy;
                    ArrayList<IWidget> widgetCopies = new ArrayList<IWidget>();
                    widgetSituator.reset(widgetCopies);
                    Iterator widgets = seln.getSelectedWidgetsIterator();
                    while (widgets.hasNext()) {
                        IWidget widget = (IWidget)widgets.next();
                        if (widget instanceof IMenuHeader) {
                            FrameEditorController.this.duplicateMenu((IMenuHeader)widget, widgetCopies);
                            continue;
                        }
                        if (widget instanceof IMenuItem) continue;
                        widgetCopy = widget.duplicate(lookupFrameDuplicator);
                        widgetCopies.add(widgetCopy);
                        widgetCopy.moveWidget(16.0, 16.0);
                    }
                    Iterator copies = widgetCopies.iterator();
                    while (copies.hasNext()) {
                        widgetCopy = (IWidget)copies.next();
                        FrameEditorController.this.makeWidgetNameUnique(widgetCopy);
                        FrameEditorController.this.model.addWidget(widgetCopy);
                    }
                    FrameEditorController.this.undoMgr.addEdit(new AUndoableEdit(this, FrameEditorLID.Duplicate, widgetCopies){
                        private final /* synthetic */ Collection val$widgetCopies;
                        private final /* synthetic */ 54 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$widgetCopies = val$widgetCopies;
                            super(x0);
                        }

                        public String getPresentationName() {
                            return L10N.get("UNDO.FE.DuplicateWidgets", "Duplicate Widgets");
                        }

                        public void redo() {
                            super.redo();
                            Iterator<E> copies = this.val$widgetCopies.iterator();
                            while (copies.hasNext()) {
                                IWidget widgetCopy = (IWidget)copies.next();
                                54.access$400(this.this$1).model.addWidget(widgetCopy);
                            }
                        }

                        public void undo() {
                            super.undo();
                            Iterator<E> copies = this.val$widgetCopies.iterator();
                            while (copies.hasNext()) {
                                IWidget widgetCopy = (IWidget)copies.next();
                                54.access$400(this.this$1).model.removeWidget(widgetCopy);
                            }
                        }
                    });
                    return true;
                }
                FrameEditorController.this.interaction.protestNoSelection();
                return false;
            }

            static /* synthetic */ FrameEditorController access$400(54 x0) {
                return x0.FrameEditorController.this;
            }
        };
    }

    protected IUI getUI() {
        return this.ui;
    }

    protected IZoomableUI getZoomableUI() {
        return this.ui;
    }

    protected void addWidgetModels(IWidget[] widgets, Iterator iter) {
        int i = 0;
        while (iter.hasNext()) {
            widgets[i++] = (IWidget)iter.next();
        }
    }

    protected IWidget[] getSelectedWidgetModels(IFrameEditorSelectionState seln, boolean includeGroupMembers) {
        IWidget[] widgets;
        if (includeGroupMembers) {
            HashSet allWidgets = new HashSet();
            Iterator s = seln.getSelectedWidgetsIterator();
            while (s.hasNext()) {
                IWidget w = (IWidget)s.next();
                IWidgetGroup group = w.getParentGroup();
                if (group != null) {
                    Iterator mbrs = group.getAllWidgets();
                    while (mbrs.hasNext()) {
                        allWidgets.add(mbrs.next());
                    }
                    continue;
                }
                allWidgets.add(w);
            }
            widgets = new IWidget[allWidgets.size()];
            this.addWidgetModels(widgets, allWidgets.iterator());
        } else {
            widgets = new IWidget[seln.getWidgetSelectionCount()];
            this.addWidgetModels(widgets, seln.getSelectedWidgetsIterator());
        }
        return widgets;
    }

    protected String generateUniqueWidgetName() {
        String name = null;
        while (this.model.isWidgetNameTaken(name = L10N.get("FE.DefaultWidgetName", "Widget") + " " + this.widgetNameSuffix++)) {
        }
        return name;
    }

    protected void setWidgetImages(Iterator selected, final byte[] imageData) {
        final String undoRedoLabel = imageData == null ? L10N.get("UNDO.FE.RemoveWidgetImage", "Remove Widget Image") : L10N.get("UNDO.FE.SetWidgetImage", "Set Widget Image");
        FrameEditorLID lid = imageData == null ? FrameEditorLID.RemoveImageProperty : FrameEditorLID.SetImageProperty;
        CompoundUndoableEdit edit = new CompoundUndoableEdit(undoRedoLabel, lid);
        while (selected.hasNext()) {
            final IWidget w = (IWidget)selected.next();
            final byte[] previousImageData = w.getImage();
            w.setImage(imageData);
            edit.addEdit(new AUndoableEdit(lid){

                public String getPresentationName() {
                    return undoRedoLabel;
                }

                public void redo() {
                    super.redo();
                    w.setImage(imageData);
                }

                public void undo() {
                    super.undo();
                    w.setImage(previousImageData);
                }
            });
        }
        edit.end();
        if (edit.isSignificant()) {
            this.undoMgr.addEdit(edit);
        }
    }

    protected void revalidateWidget(IWidget w, Set validators) {
        HashSet<IPredictionResult> results = new HashSet<IPredictionResult>();
        Iterator it = validators.iterator();
        while (it.hasNext()) {
            IResultRevalidator val = (IResultRevalidator)it.next();
            val.revalidateResult();
            results.add(val.getResult());
        }
        validators.addAll(this.project.invalidateResultsUsing(this.design, w, results));
    }

    protected AListenerAction createSetSkinAction(final SkinType newSkin, final CogToolLID lid) {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                SkinType oldSkin = FrameEditorController.this.design.getSkin();
                FrameEditorController.this.design.setSkin(newSkin);
                FrameEditorController.this.undoMgr.addEdit(new AUndoableEdit(this, lid, oldSkin){
                    private final /* synthetic */ SkinType val$oldSkin;
                    private final /* synthetic */ 57 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$oldSkin = val$oldSkin;
                        super(x0);
                    }

                    public String getPresentationName() {
                        return L10N.get("UNDO.DE.ChangeSkin", "Change Skin");
                    }

                    public void redo() {
                        super.redo();
                        57.access$600(this.this$1).design.setSkin(57.access$500(this.this$1));
                    }

                    public void undo() {
                        super.undo();
                        57.access$600(this.this$1).design.setSkin(this.val$oldSkin);
                    }
                });
                return true;
            }

            static /* synthetic */ SkinType access$500(57 x0) {
                return x0.newSkin;
            }

            static /* synthetic */ FrameEditorController access$600(57 x0) {
                return x0.FrameEditorController.this;
            }
        };
    }

    protected static class DuplicateWidgetSituator
    implements IWidgetGroup.WidgetDuplicator {
        protected Map menuHeaderGroups = new HashMap();
        protected Collection widgetCopies;

        protected DuplicateWidgetSituator() {
        }

        public void placeInContext(IWidget widgetCopy) {
            this.widgetCopies.add(widgetCopy);
        }

        public IWidgetGroup getHeaderGroup(IMenuHeader menuHeader) {
            IWidgetGroup existingGroup = menuHeader.getParentGroup();
            IWidgetGroup headerGroup = (IWidgetGroup)this.menuHeaderGroups.get(existingGroup);
            if (headerGroup == null) {
                headerGroup = new SimpleWidgetGroup(existingGroup.getOrientation());
                this.menuHeaderGroups.put(existingGroup, headerGroup);
            }
            return headerGroup;
        }

        public void reset(Collection copies) {
            this.menuHeaderGroups.clear();
            this.widgetCopies = copies;
        }
    }

    protected class DeleteWidgetUndoableEdit
    extends AUndoableEdit {
        protected IWidget widget;
        protected Set validators;
        protected IWidgetGroup parentGroup;
        protected int atIndex;
        protected double deltaX;
        protected double deltaY;

        public DeleteWidgetUndoableEdit(IWidget w, Set v, IWidgetGroup pg, int index, double dx, double dy) {
            super(FrameEditorLID.Delete);
            this.widget = w;
            this.validators = v;
            this.parentGroup = pg;
            this.atIndex = index;
            this.deltaX = dx;
            this.deltaY = dy;
        }

        public String getPresentationName() {
            return L10N.get("UNDO.FE.DeleteWidget", "Delete Widget");
        }

        protected void redoHelper() {
        }

        protected void undoHelper() {
        }

        public void redo() {
            super.redo();
            FrameEditorController.this.revalidateWidget(this.widget, this.validators);
            if (this.parentGroup != null) {
                int numWidgets = this.parentGroup.widgetCount();
                for (int i = this.atIndex + 1; i < numWidgets; ++i) {
                    IWidget curWidget = this.parentGroup.getWidget(i);
                    curWidget.moveWidget(this.deltaX, this.deltaY);
                }
                this.redoHelper();
            }
            FrameEditorController.this.model.removeWidget(this.widget);
        }

        public void undo() {
            super.undo();
            if (this.parentGroup != null) {
                this.undoHelper();
                int numWidgets = this.parentGroup.widgetCount();
                for (int i = this.atIndex + 1; i < numWidgets; ++i) {
                    IWidget curWidget = this.parentGroup.getWidget(i);
                    curWidget.moveWidget(-this.deltaX, -this.deltaY);
                }
            }
            FrameEditorController.this.model.addWidget(this.widget);
            FrameEditorController.this.revalidateWidget(this.widget, this.validators);
        }
    }

    protected abstract class AddWidgetUndoableEdit
    extends AUndoableEdit {
        protected IWidget widget;

        public AddWidgetUndoableEdit(IWidget w) {
            super(FrameEditorLID.NewWidget);
            this.widget = w;
        }

        public String getPresentationName() {
            return L10N.get("UNDO.FE.NewWidget", "New Widget");
        }

        protected abstract void redoHelper();

        protected abstract void undoHelper();

        public void redo() {
            super.redo();
            this.redoHelper();
            FrameEditorController.this.model.addWidget(this.widget);
        }

        public void undo() {
            super.undo();
            this.undoHelper();
            FrameEditorController.this.model.removeWidget(this.widget);
        }
    }

    protected abstract class AlignmentAction
    implements IListenerAction {
        protected DoubleRectangle reference;
        protected double newX;
        protected double newY;
        protected CogToolLID lid;

        public AlignmentAction(CogToolLID listenerID) {
            this.lid = listenerID;
        }

        protected abstract void computeNewOrigin(DoubleRectangle var1);

        protected abstract double getReferenceDimension(DoubleRectangle var1);

        protected abstract String getAlignmentName();

        public Class getParameterClass() {
            return class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState = FrameEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameEditorSelectionState;
        }

        public boolean performAction(Object prms) {
            IFrameEditorSelectionState selection = (IFrameEditorSelectionState)prms;
            CompoundUndoableEdit edit = new CompoundUndoableEdit(this.getAlignmentName(), this.lid);
            Iterator widgets = selection.getSelectedWidgetsIterator();
            double refVal = Double.NEGATIVE_INFINITY;
            while (widgets.hasNext()) {
                DoubleRectangle r = ((IWidget)widgets.next()).getShape().getBounds();
                double newRefVal = this.getReferenceDimension(r);
                if (!(newRefVal >= refVal)) continue;
                refVal = newRefVal;
                this.reference = r;
            }
            widgets = selection.getSelectedWidgetsIterator();
            while (widgets.hasNext()) {
                IWidget w = (IWidget)widgets.next();
                DoubleRectangle bounds = w.getShape().getBounds();
                double oldX = bounds.x;
                double oldY = bounds.y;
                this.computeNewOrigin(bounds);
                double new_X = this.newX;
                double new_Y = this.newY;
                Set validators = FrameEditorController.this.project.invalidateResultsUsing(FrameEditorController.this.design, w, null);
                w.setWidgetOrigin(new_X, new_Y);
                edit.addEdit(new AUndoableEdit(this, this.lid, w, validators, new_X, new_Y, oldX, oldY){
                    private final /* synthetic */ IWidget val$w;
                    private final /* synthetic */ Set val$validators;
                    private final /* synthetic */ double val$new_X;
                    private final /* synthetic */ double val$new_Y;
                    private final /* synthetic */ double val$oldX;
                    private final /* synthetic */ double val$oldY;
                    private final /* synthetic */ AlignmentAction this$1;
                    {
                        this.this$1 = this$1;
                        this.val$w = val$w;
                        this.val$validators = val$validators;
                        this.val$new_X = val$new_X;
                        this.val$new_Y = val$new_Y;
                        this.val$oldX = val$oldX;
                        this.val$oldY = val$oldY;
                        super(x0);
                    }

                    public String getPresentationName() {
                        return this.this$1.getAlignmentName();
                    }

                    public void redo() {
                        super.redo();
                        AlignmentAction.access$000(this.this$1).revalidateWidget(this.val$w, this.val$validators);
                        this.val$w.setWidgetOrigin(this.val$new_X, this.val$new_Y);
                    }

                    public void undo() {
                        super.undo();
                        this.val$w.setWidgetOrigin(this.val$oldX, this.val$oldY);
                        AlignmentAction.access$000(this.this$1).revalidateWidget(this.val$w, this.val$validators);
                    }
                });
            }
            edit.end();
            if (edit.isSignificant()) {
                FrameEditorController.this.undoMgr.addEdit(edit);
            }
            return true;
        }

        static /* synthetic */ FrameEditorController access$000(AlignmentAction x0) {
            return x0.FrameEditorController.this;
        }
    }
}

