/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.ACogToolWorkThread;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.ui.DesignExportToHTML;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.RcvrExceptionHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;

public class ExportToHTMLWorkThread
extends ACogToolWorkThread {
    protected final String title = L10N.get("WPX.ExportingYourDesign", "Exporting your Design...");
    protected IInteraction.IProgressBar progressBar;
    protected DesignExportToHTML exportAlgorithm = new DesignExportToHTML();
    protected IDesign design;
    protected String destDirectory;
    protected IInteraction interaction;

    public ExportToHTMLWorkThread(IInteraction inter, IDesign d, String dir) {
        this.interaction = inter;
        this.progressBar = inter.createProgressBar(this.title, this, this.title, true);
        this.design = d;
        this.destDirectory = dir;
        this.setProgressCallback(this.progressBar);
        this.setDisabler(this.progressBar.getDisabler());
    }

    public void doWork() {
        this.exportAlgorithm.exportToHTML(this.design, this.destDirectory, this, this.progressBar);
    }

    public void doneCallback() {
        if (this.thrownException != null) {
            RcvrExceptionHandler.recover(this.thrownException, this.interaction);
        }
        super.doneCallback();
    }
}

