/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.DesignEditorController;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.Project;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.IStructureViewUIModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DesignEditorControllerTest
extends TestCase {
    public static Set standardDeviceTypes = new HashSet<DeviceType>(Arrays.asList(DeviceType.Mouse, DeviceType.Keyboard, DeviceType.Voice));
    Project project;
    Design model;
    IStructureViewUIModel structureView;
    DesignEditorUI ui;
    DesignEditorController controller;
    boolean rename;

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new Project("Test Project");
        this.model = new Design("Test Design", standardDeviceTypes);
        this.project.addDesign(this.model);
        this.controller = new DesignEditorController(this.model, this.project);
        this.ui = new DesignEditorUI(this.model, this.project, this.controller.undoMgr){

            public void initiateFrameRename(IFrameSelectionState sel) {
                DesignEditorControllerTest.this.rename = true;
            }
        };
        this.controller.ui = this.ui;
        this.controller.assignActions();
        this.structureView = this.ui.getUIModel().getStructureView();
    }

    protected void tearDown() throws Exception {
        this.rename = false;
        this.controller.getUI().dispose();
        super.tearDown();
    }

    public void testGetUI() {
        DesignEditorControllerTest.assertNotSame((Object)this.controller.getUI(), (Object)new DesignEditorController(this.model, this.project).getUI());
    }

    public void testDesignEditorController() {
        try {
            new DesignEditorController(null, this.project);
            DesignEditorControllerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new DesignEditorController(this.model, null);
            DesignEditorControllerTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new DesignEditorController(null, null);
            DesignEditorControllerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetModel() {
        DesignEditorControllerTest.assertNotNull((Object)this.controller.getModel());
        DesignEditorControllerTest.assertSame((Object)this.controller.getModel(), (Object)this.model);
    }

    public void testNewFrameAction() {
        this.controller.getUI().performAction(DesignEditorLID.NewFrame, null, false);
        DesignEditorControllerTest.assertEquals((int)this.model.getFrames().size(), (int)1);
        Object frame = this.model.getFrames().iterator().next();
        DesignEditorControllerTest.assertTrue((boolean)(frame instanceof IFrame));
        this.controller.getUI().performAction(CogToolLID.Undo, null, false);
        DesignEditorControllerTest.assertEquals((int)this.model.getFrames().size(), (int)0);
        this.controller.getUI().performAction(CogToolLID.Redo, null, false);
        DesignEditorControllerTest.assertEquals((int)this.model.getFrames().size(), (int)1);
        DesignEditorControllerTest.assertTrue((boolean)this.model.getFrames().contains(frame));
    }

    public void testInitiateFrameRenameAction() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new DesignEditorInteraction(this.ui.getView(), 0){

            public void protestNoSelection() {
                protest[0] = true;
            }
        };
        new FrameActionTester(DesignEditorLID.InitiateFrameRename){

            protected void setupTestParameters() {
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!DesignEditorControllerTest.this.rename ? 1 : 0) != 0);
                protest[0] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        this.controller.getUI().performAction(DesignEditorLID.InitiateFrameRename, new DesignEditorSelectionState(), false);
        DesignEditorControllerTest.assertTrue((boolean)protest[0]);
        DesignEditorControllerTest.assertTrue((!this.rename ? 1 : 0) != 0);
        protest[0] = false;
        new FrameActionTester(DesignEditorLID.InitiateFrameRename){

            protected void setupTestParameters() {
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((boolean)DesignEditorControllerTest.this.rename);
            }

            protected void assertTestEffects() {
                this.assertDoneEffects();
            }
        }.test();
    }

    public void testRenameFrameAction() {
        final boolean[] protest = new boolean[2];
        this.controller.interaction = new DesignEditorInteraction(this.ui.getView(), 0){

            public boolean protestNotUniqueFrameName() {
                protest[0] = true;
                return false;
            }

            public boolean protestEmptyFrameName() {
                protest[1] = true;
                return false;
            }
        };
        new FrameActionTester(DesignEditorLID.RenameFrame){
            String name;
            {
                super(x0);
                this.name = "duplicate frame name";
            }

            protected void setupTestParameters() {
                for (int i = 0; i < this.f.length; ++i) {
                    this.f[i].setName("test frame " + i);
                }
                this.f[1].setName(this.name);
                this.param = new IDesignEditorUI.FrameRenameEvent(this.f[0], this.name, this.selection);
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!this.f[0].getName().equals(this.name) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)protest[0]);
                Assert.assertTrue((!DesignEditorControllerTest.this.rename ? 1 : 0) != 0);
                protest[0] = false;
            }
        }.test();
        new FrameActionTester(DesignEditorLID.RenameFrame){

            protected void setupTestParameters() {
                for (int i = 0; i < this.f.length; ++i) {
                    this.f[i].setName("test frame " + i);
                }
                this.param = new IDesignEditorUI.FrameRenameEvent(this.f[0], "", this.selection);
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!this.f[0].getName().equals("") ? 1 : 0) != 0);
                Assert.assertTrue((boolean)protest[0]);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
                Assert.assertTrue((!DesignEditorControllerTest.this.rename ? 1 : 0) != 0);
                protest[0] = false;
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new FrameActionTester(DesignEditorLID.RenameFrame){
            String name;
            {
                super(x0);
                this.name = "valid frame name";
            }

            protected void setupTestParameters() {
                for (int i = 0; i < this.f.length; ++i) {
                    this.f[i].setName("test frame " + i);
                }
                this.param = new IDesignEditorUI.FrameRenameEvent(this.f[0], this.name, this.selection);
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((boolean)this.f[0].getName().equals(this.name));
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertTrue((!protest[1] ? 1 : 0) != 0);
                Assert.assertTrue((!DesignEditorControllerTest.this.rename ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testNewTransitionAction() {
        new FrameActionTester(DesignEditorLID.NewTransition){
            IWidget widget;
            IAction action;
            {
                this.widget = new Widget(WidgetType.Button);
                this.action = DesignEditorControllerTest.this.controller.createDefaultAction(this.widget, DesignEditorControllerTest.this.controller.ui.getCurrentDeviceType());
            }

            protected void setupTestParameters() {
                for (int i = 0; i < this.f.length; ++i) {
                    this.f[i].setName("test frame " + i);
                }
                this.param = new IDesignEditorUI.NewTransitionParameters(this.widget, null, 1.2, 3.4);
            }

            protected void assertDoneEffects() {
                HashSet frames = new HashSet(DesignEditorControllerTest.this.model.getFrames());
                Assert.assertEquals((int)frames.size(), (int)(this.f.length + 1));
                for (int i = 0; i < this.f.length; ++i) {
                    Assert.assertTrue((boolean)frames.remove(this.f[i]));
                }
                IFrame frame = (IFrame)DesignEditorControllerTest.this.model.getFrames().iterator().next();
                ITransition transition = this.widget.getTransition(this.action);
                Assert.assertNotNull((Object)transition);
                Assert.assertEquals((Object)transition.getDestination(), (Object)frame);
                Assert.assertEquals((Object)transition.getSource(), (Object)this.widget);
            }

            protected void assertNoneEffects() {
                HashSet frames = new HashSet(DesignEditorControllerTest.this.model.getFrames());
                Assert.assertEquals((int)frames.size(), (int)this.f.length);
                for (int i = 0; i < this.f.length; ++i) {
                    Assert.assertTrue((boolean)frames.contains(this.f[i]));
                }
                Assert.assertTrue((!this.widget.getTransitions().containsKey(this.action) ? 1 : 0) != 0);
            }
        }.test();
        new FrameActionTester(DesignEditorLID.NewTransition){
            IWidget widget;
            IAction action;
            {
                this.widget = new Widget(WidgetType.Button);
                this.action = DesignEditorControllerTest.this.controller.createDefaultAction(this.widget, DesignEditorControllerTest.this.controller.ui.getCurrentDeviceType());
            }

            protected void setupTestParameters() {
                for (int i = 0; i < this.f.length; ++i) {
                    this.f[i].setName("test frame " + i);
                }
                this.param = new IDesignEditorUI.NewTransitionParameters(this.widget, this.f[0], 5.6, 7.8);
            }

            protected void assertDoneEffects() {
                HashSet frames = new HashSet(DesignEditorControllerTest.this.model.getFrames());
                Assert.assertEquals((int)frames.size(), (int)this.f.length);
                for (int i = 0; i < this.f.length; ++i) {
                    Assert.assertTrue((boolean)frames.contains(this.f[i]));
                }
                ITransition transition = this.widget.getTransition(this.action);
                Assert.assertNotNull((Object)transition);
                Assert.assertEquals((Object)transition.getDestination(), (Object)this.f[0]);
                Assert.assertEquals((Object)transition.getSource(), (Object)this.widget);
            }

            protected void assertNoneEffects() {
                HashSet frames = new HashSet(DesignEditorControllerTest.this.model.getFrames());
                Assert.assertEquals((int)frames.size(), (int)this.f.length);
                for (int i = 0; i < this.f.length; ++i) {
                    Assert.assertTrue((boolean)frames.contains(this.f[i]));
                }
                Assert.assertTrue((!this.widget.getTransitions().containsKey(this.action) ? 1 : 0) != 0);
            }
        }.test();
    }

    public void testEditFrameAction() {
        final boolean[] protest = new boolean[1];
        this.controller.interaction = new DesignEditorInteraction(this.ui.getView(), 0){

            public void protestNoSelection() {
                protest[0] = true;
            }
        };
        this.controller.getUI().performAction(DesignEditorLID.EditFrame, new DesignEditorSelectionState(), false);
        DesignEditorControllerTest.assertTrue((boolean)protest[0]);
        protest[0] = false;
    }

    public void testDeleteFrameAction() {
        final boolean[] protest = new boolean[1];
        final boolean[] confirm = new boolean[1];
        this.controller.interaction = new DesignEditorInteraction(this.ui.getView(), 0){

            public void protestNoSelection() {
                protest[0] = true;
            }

            public boolean confirmDeleteFrames(IFrame[] frames) {
                return confirm[0];
            }
        };
        confirm[0] = false;
        this.controller.getUI().performAction(DesignEditorLID.DeleteFrame, new DesignEditorSelectionState(), false);
        DesignEditorControllerTest.assertTrue((boolean)protest[0]);
        protest[0] = false;
        new FrameActionTester(DesignEditorLID.DeleteFrame){

            protected void setupTestParameters() {
                confirm[0] = false;
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertEquals((int)DesignEditorControllerTest.this.model.getFrames().size(), (int)this.f.length);
                for (int i = 0; i < this.f.length; ++i) {
                    Assert.assertTrue((boolean)DesignEditorControllerTest.this.model.getFrames().contains(this.f[i]));
                }
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new FrameActionTester(DesignEditorLID.DeleteFrame){

            protected void setupTestParameters() {
                confirm[0] = true;
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((!protest[0] ? 1 : 0) != 0);
                Assert.assertEquals((int)DesignEditorControllerTest.this.model.getFrames().size(), (int)(this.f.length - 2));
                for (int i = 0; i < this.f.length; ++i) {
                    if (i != 0 && i != 2) {
                        Assert.assertTrue((boolean)DesignEditorControllerTest.this.model.getFrames().contains(this.f[i]));
                        continue;
                    }
                    Assert.assertTrue((!DesignEditorControllerTest.this.model.getFrames().contains(this.f[i]) ? 1 : 0) != 0);
                }
            }

            protected void assertNoneEffects() {
                Assert.assertEquals((int)DesignEditorControllerTest.this.model.getFrames().size(), (int)this.f.length);
                for (int i = 0; i < this.f.length; ++i) {
                    Assert.assertTrue((boolean)DesignEditorControllerTest.this.model.getFrames().contains(this.f[i]));
                }
            }
        }.test();
    }

    public void testDeleteTransitionAction() {
        final boolean[] protest = new boolean[1];
        final boolean[] confirm = new boolean[1];
        this.controller.interaction = new DesignEditorInteraction(this.ui.getView(), 0){

            public void protestNoSelection() {
                protest[0] = true;
            }

            public boolean confirmDeleteTransitions(ITransition[] transitions) {
                return confirm[0];
            }
        };
        confirm[0] = false;
        this.controller.getUI().performAction(DesignEditorLID.DeleteTransition, new DesignEditorSelectionState(), false);
        DesignEditorControllerTest.assertTrue((boolean)protest[0]);
        protest[0] = false;
        new TransitionActionTester(DesignEditorLID.DeleteTransition){

            protected void setupTestParameters() {
                confirm[0] = false;
                this.selection = new DesignEditorSelectionState(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int getSelectedTransitionCount() {
                        return 2;
                    }

                    public ITransition[] getSelectedTransitions() {
                        return new ITransition[]{this.this$1.t[0], this.this$1.t[2]};
                    }

                    public boolean isTransitionSelected(ITransition tr) {
                        return (Transition)tr == this.this$1.t[0] || (Transition)tr == this.this$1.t[2];
                    }
                };
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                this.assertNoneEffects();
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
        new TransitionActionTester(DesignEditorLID.DeleteTransition){

            protected void setupTestParameters() {
                confirm[0] = true;
                this.selection = new DesignEditorSelectionState(this){
                    private final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int getSelectedTransitionCount() {
                        return 2;
                    }

                    public ITransition[] getSelectedTransitions() {
                        return new ITransition[]{this.this$1.t[0], this.this$1.t[2]};
                    }

                    public boolean isTransitionSelected(ITransition tr) {
                        return (Transition)tr == this.this$1.t[0] || (Transition)tr == this.this$1.t[2];
                    }
                };
                this.param = this.selection;
            }

            protected void assertDoneEffectsOn(int i) {
                Assert.assertEquals((int)this.w[i].getTransitions().size(), (int)0);
                Assert.assertEquals((int)this.f[i].getIncidentTransitions().size(), (int)0);
            }
        }.test();
    }

    public void testChangeTargetAction() {
        new TransitionActionTester(DesignEditorLID.ChangeTarget){
            IAction action;
            {
                this.action = new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0);
            }

            protected void setupTestParameters() {
                this.t[1].setAction(this.action);
                this.param = new IDesignEditorUI.ChangeTargetParameters(this.t[1], this.f[2]);
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((Object)this.t[1].getSource(), (Object)this.w[1]);
                Assert.assertEquals((Object)this.t[1].getDestination(), (Object)this.f[2]);
                Assert.assertEquals((int)this.w[1].getTransitions().size(), (int)1);
                Assert.assertEquals(this.w[1].getTransitions().get(this.action), (Object)this.t[1]);
                Assert.assertEquals((int)this.f[1].getIncidentTransitions().size(), (int)0);
                Assert.assertEquals((int)this.f[2].getIncidentTransitions().size(), (int)2);
                Assert.assertEquals((Object)this.t[2].getSource(), (Object)this.w[2]);
                Assert.assertEquals((Object)this.t[1].getSource(), (Object)this.w[1]);
            }
        }.test();
    }

    public void testChangeSourceAction() {
        new TransitionActionTester(DesignEditorLID.ChangeSource){
            IAction action;
            {
                this.action = new ButtonAction(MouseButtonState.Left, MousePressType.Click, 0);
            }

            protected void setupTestParameters() {
                this.t[1].setAction(this.action);
                this.param = new IDesignEditorUI.ChangeSourceParameters(this.t[1], this.w[2]);
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((Object)this.t[1].getSource(), (Object)this.w[2]);
                Assert.assertEquals((Object)this.t[1].getDestination(), (Object)this.f[1]);
                Assert.assertEquals((int)this.w[1].getTransitions().size(), (int)0);
                Assert.assertEquals((int)this.w[2].getTransitions().size(), (int)2);
                Assert.assertEquals(this.w[2].getTransitions().get(this.act), (Object)this.t[2]);
                Assert.assertEquals(this.w[2].getTransitions().get(this.action), (Object)this.t[1]);
                Assert.assertEquals((int)this.f[1].getIncidentTransitions().size(), (int)1);
                Assert.assertEquals((int)this.f[2].getIncidentTransitions().size(), (int)1);
                Assert.assertEquals((Object)this.t[1].getSource(), (Object)this.w[2]);
                Assert.assertEquals((Object)this.t[2].getSource(), (Object)this.w[2]);
            }
        }.test();
    }

    public void testZoomInAction() {
        new DesignActionTester(CogToolLID.ZoomIn){
            double oldZoom;

            protected void setupTestParameters() {
                this.oldZoom = DesignEditorControllerTest.this.structureView.getZoom();
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((Math.abs(DesignEditorControllerTest.this.structureView.getZoom() - this.oldZoom * 1.15) < 0.01 ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testZoomOutAction() {
        new DesignActionTester(CogToolLID.ZoomOut){
            double oldZoom;

            protected void setupTestParameters() {
                this.oldZoom = DesignEditorControllerTest.this.structureView.getZoom();
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((Math.abs(DesignEditorControllerTest.this.structureView.getZoom() - this.oldZoom / 1.15) < 0.01 ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testZoomNormalAction() {
        new DesignActionTester(CogToolLID.ZoomNormal){

            protected void setupTestParameters() {
            }

            protected void assertDoneEffects() {
                Assert.assertTrue((Math.abs(DesignEditorControllerTest.this.structureView.getZoom() - 1.0) < 0.01 ? 1 : 0) != 0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testMoveFramesAction() {
        new FrameActionTester(DesignEditorLID.MoveFrames){
            DoublePoint origin;
            double x;
            double y;
            {
                this.x = -4.5;
                this.y = 6.7;
            }

            protected void setupTestParameters() {
                this.origin = new DoublePoint(this.f[0].getFrameOrigin());
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = new IDesignEditorUI.MoveParameters(this.x, this.y, this.selection);
            }

            protected void assertDoneEffectsOn(int i) {
                Assert.assertEquals((Object)this.f[i].getFrameOrigin(), (Object)new DoublePoint(this.origin.x + this.x, this.origin.y + this.y));
            }
        }.test();
    }

    public void testMoveUpAction() {
        new FrameActionTester(DesignEditorLID.NudgeUp){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = new DoublePoint(this.f[0].getFrameOrigin());
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffectsOn(int i) {
                Assert.assertEquals((Object)this.f[i].getFrameOrigin(), (Object)new DoublePoint(this.origin.x, this.origin.y - 1.0));
            }
        }.test();
    }

    public void testMoveDownAction() {
        new FrameActionTester(DesignEditorLID.NudgeDown){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = new DoublePoint(this.f[0].getFrameOrigin());
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffectsOn(int i) {
                Assert.assertEquals((Object)this.f[i].getFrameOrigin(), (Object)new DoublePoint(this.origin.x, this.origin.y + 1.0));
            }
        }.test();
    }

    public void testMoveLeftAction() {
        new FrameActionTester(DesignEditorLID.NudgeLeft){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = new DoublePoint(this.f[0].getFrameOrigin());
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffectsOn(int i) {
                Assert.assertEquals((Object)this.f[i].getFrameOrigin(), (Object)new DoublePoint(this.origin.x - 1.0, this.origin.y));
            }
        }.test();
    }

    public void testMoveRightAction() {
        new FrameActionTester(DesignEditorLID.NudgeRight){
            DoublePoint origin;

            protected void setupTestParameters() {
                this.origin = new DoublePoint(this.f[0].getFrameOrigin());
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
                this.selection.selectFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[2]));
                this.param = this.selection;
            }

            protected void assertDoneEffectsOn(int i) {
                Assert.assertEquals((Object)this.f[i].getFrameOrigin(), (Object)new DoublePoint(this.origin.x + 1.0, this.origin.y));
            }
        }.test();
    }

    public void testSelectAllAction() {
        new FrameActionTester(DesignEditorLID.SelectAll){
            DesignEditorSelectionState sel;
            int transitions;
            {
                this.sel = (DesignEditorSelectionState)((DesignEditorUI)DesignEditorControllerTest.this.controller.getUI()).getSelection();
            }

            protected void setupTestParameters() {
                this.transitions = this.sel.getSelectedTransitionCount();
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((int)this.sel.getSelectedFrameCount(), (int)this.f.length);
                Assert.assertEquals((int)this.sel.getSelectedTransitionCount(), (int)this.transitions);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }
        }.test();
    }

    public void testDeselectAllAction() {
        new FrameActionTester(DesignEditorLID.DeselectAll){

            protected void setupTestParameters() {
                this.selection = new DesignEditorSelectionState(this){
                    private final /* synthetic */ 32 this$1;
                    {
                        this.this$1 = this$1;
                        this.setSelectedFrame(32.access$000(this.this$1).structureView.getFrameFigure(this.this$1.f[0]));
                        this.setSelectedTransition(this.this$1.t[0]);
                    }

                    public void setSelectedTransition(ITransition t) {
                        this.selectedTransitions.put(t, null);
                    }
                };
                this.param = this.selection;
            }

            protected void assertDoneEffects() {
                Assert.assertEquals((int)this.selection.getSelectedFrameCount(), (int)0);
                Assert.assertEquals((int)this.selection.getSelectedTransitionCount(), (int)0);
            }

            protected boolean shouldTestUndoAndRedo() {
                return false;
            }

            static /* synthetic */ DesignEditorControllerTest access$000(32 x0) {
                return x0.DesignEditorControllerTest.this;
            }
        }.test();
    }

    protected abstract class TransitionActionTester
    extends ActionTester {
        public TransitionActionTester(CogToolLID LID) {
            super(LID);
        }

        protected void assertDoneEffects() {
            int i;
            HashSet<ITransition> sel = new HashSet<ITransition>();
            ITransition[] transitions = this.selection.getSelectedTransitions();
            for (i = 0; i < transitions.length; ++i) {
                sel.add(transitions[i]);
            }
            for (i = 0; i < this.t.length; ++i) {
                if (sel.contains(this.t[i])) {
                    this.assertDoneEffectsOn(i);
                    continue;
                }
                this.assertNoneEffectsOn(i);
            }
        }
    }

    protected abstract class FrameActionTester
    extends ActionTester {
        public FrameActionTester(CogToolLID LID) {
            super(LID);
        }

        protected void assertDoneEffects() {
            int i;
            HashSet<IFrame> sel = new HashSet<IFrame>();
            IFrame[] frames = this.selection.getSelectedFrames();
            for (i = 0; i < frames.length; ++i) {
                sel.add(frames[i]);
            }
            for (i = 0; i < this.f.length; ++i) {
                if (sel.contains(this.f[i])) {
                    this.assertDoneEffectsOn(i);
                    continue;
                }
                this.assertNoneEffectsOn(i);
            }
        }
    }

    protected abstract class ActionTester
    extends Tester {
        private CogToolLID lid;
        protected Object param;

        public ActionTester(CogToolLID LID) {
            this.lid = LID;
        }

        protected void test() {
            this.setupTestContext();
            DesignEditorControllerTest.this.controller.getUI().performAction(this.lid, this.param, false);
            this.assertTestEffects();
        }
    }

    protected abstract class Tester {
        protected DesignEditorSelectionState selection;
        protected final int SIZE = 4;
        protected final IAction act = new KeyAction('b', KeyPressType.Down, 8);
        protected Map fra = new IdentityHashMap();
        protected Frame[] f = new Frame[4];
        protected Map tra = new IdentityHashMap();
        protected Transition[] t = new Transition[4];
        protected Map wid = new IdentityHashMap();
        protected Widget[] w = new Widget[4];

        protected abstract void setupTestParameters();

        protected abstract void assertDoneEffects();

        protected abstract void test();

        public Tester() {
            DesignEditorControllerTest.this.model.getFrames().clear();
            for (int i = 0; i < 4; ++i) {
                DesignEditorControllerTest.this.controller.getUI().performAction(DesignEditorLID.NewFrame, null, false);
            }
            Iterator frames = DesignEditorControllerTest.this.model.getFrames().iterator();
            for (int i = 0; i < 4; ++i) {
                this.f[i] = (Frame)frames.next();
            }
            this.selection = new DesignEditorSelectionState(this){
                private final /* synthetic */ Tester this$1;
                {
                    this.this$1 = this$1;
                }

                public int getSelectedTransitionCount() {
                    return 1;
                }

                public ITransition[] getSelectedTransitions() {
                    return new ITransition[]{this.this$1.t[0]};
                }

                public boolean isTransitionSelected(ITransition tr) {
                    return (Transition)tr == this.this$1.t[0];
                }
            };
            this.selection.setSelectedFrame(DesignEditorControllerTest.this.structureView.getFrameFigure(this.f[0]));
        }

        protected void setupTestContext() {
            int i;
            for (i = 0; i < 4; ++i) {
                this.t[i] = new Transition(this.w[i], this.f[i], this.act);
                this.w[i] = new Widget(WidgetType.Button);
                this.w[i].setName("test widget" + i);
                this.w[i].addTransition(this.t[i]);
                this.f[i].addIncidentTransition(this.t[i]);
            }
            this.setupTestParameters();
            for (i = 0; i < 4; ++i) {
                this.fra.put(this.f[i], this.f[i].clone());
                this.tra.put(this.t[i], this.t[i].clone());
                this.wid.put(this.w[i], this.w[i].clone());
            }
        }

        protected void assertTestEffects() {
            this.assertDoneEffects();
            if (this.shouldTestUndoAndRedo()) {
                DesignEditorControllerTest.this.controller.getUI().performAction(CogToolLID.Undo, null, false);
                this.assertNoneEffects();
                DesignEditorControllerTest.this.controller.getUI().performAction(CogToolLID.Redo, null, false);
                this.assertDoneEffects();
            }
        }

        protected void assertDoneEffectsOn(int index) {
        }

        protected void assertNoneEffects() {
            for (int i = 0; i < 4; ++i) {
                this.assertNoneEffectsOn(i);
            }
        }

        protected boolean shouldTestUndoAndRedo() {
            return true;
        }

        protected void assertNoneEffectsOn(int index) {
            Assert.assertTrue((boolean)Frame.isIdentical(this.f[index], (Frame)this.fra.get(this.f[index])));
            Assert.assertTrue((boolean)Widget.isIdentical(this.w[index], (Widget)this.wid.get(this.w[index])));
            Assert.assertTrue((boolean)Transition.isIdentical(this.t[index], (Transition)this.tra.get(this.t[index])));
        }
    }

    protected abstract class DesignActionTester
    extends DesignTester {
        private CogToolLID lid;

        public DesignActionTester(CogToolLID LID) {
            this.lid = LID;
        }

        protected void test() {
            this.setupTestContext();
            DesignEditorControllerTest.this.controller.getUI().performAction(this.lid, null, false);
            this.assertTestEffects();
        }
    }

    protected abstract class DesignTester {
        Design d_old;

        protected DesignTester() {
        }

        protected abstract void setupTestParameters();

        protected abstract void assertDoneEffects();

        protected abstract void test();

        protected void setupTestContext() {
            this.setupTestParameters();
            this.d_old = (Design)DesignEditorControllerTest.this.model.clone();
        }

        protected void assertTestEffects() {
            this.assertDoneEffects();
            if (this.shouldTestUndoAndRedo()) {
                DesignEditorControllerTest.this.controller.getUI().performAction(CogToolLID.Undo, null, false);
                Assert.assertTrue((boolean)Design.isIdentical(this.d_old, DesignEditorControllerTest.this.model));
                DesignEditorControllerTest.this.controller.getUI().performAction(CogToolLID.Redo, null, false);
                this.assertDoneEffects();
            }
        }

        protected boolean shouldTestUndoAndRedo() {
            return true;
        }
    }
}

