/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.ACogToolWorkThread;
import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolClipboard;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.ExportToHTMLWorkThread;
import edu.cmu.cs.hcii.cogtool.controller.UndoController;
import edu.cmu.cs.hcii.cogtool.controller.ZoomableController;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.Frame;
import edu.cmu.cs.hcii.cogtool.model.GraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IResultRevalidator;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.TapAction;
import edu.cmu.cs.hcii.cogtool.model.Transition;
import edu.cmu.cs.hcii.cogtool.model.VoiceAction;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ITransitionSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.ui.IZoomableUI;
import edu.cmu.cs.hcii.cogtool.ui.RcvrExceptionHandler;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.AUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.CompoundUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.RcvrImageException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUnimplementedFnException;
import edu.cmu.cs.hcii.cogtool.util.ThreadManager;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesignEditorController
extends ZoomableController {
    protected static final String DEFAULT_FRAME_PREFIX = L10N.get("DE.FrameNamePrefix", "Frame");
    public static final int INITIAL_FRAME_SUFFIX = 1;
    public static final String INITIAL_FRAME_NAME = DEFAULT_FRAME_PREFIX + " " + 1;
    protected static final Pattern IMAGE_FILE_NAME = Pattern.compile("(.+)\\.(jpe?g|gif|png)", 2);
    protected IDesign design;
    protected IDesignEditorUI ui;
    protected UndoManager undoMgr;
    protected IDesignEditorInteraction interaction;
    protected int nextNewFrameSuffix = 1;
    protected IDesignEditorUI.ActionProperties properties = new IDesignEditorUI.ActionProperties(-1);
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$MoveParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$FrameRenameEvent;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$NewTransitionParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeTargetParameters;
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeSourceParameters;

    public DesignEditorController(IDesign designToEdit, IProject designProject) {
        super(designProject);
        this.design = designToEdit;
        this.undoMgr = CogTool.undoManagerFactory.getUndoManager(this.design, this.project);
        this.ui = CogTool.designEditorUIFactory.createDesignEditorUI(this.design, this.project, this.undoMgr);
        this.interaction = this.ui.getInteraction();
        this.assignActions();
        this.ui.setVisible(true);
    }

    protected Object getModelObject() {
        return this.getModel();
    }

    public IDesign getModel() {
        return this.design;
    }

    protected IUI getUI() {
        return this.ui;
    }

    protected IZoomableUI getZoomableUI() {
        return this.ui;
    }

    public void assignActions() {
        super.assignActions();
        this.ui.setAction(DesignEditorLID.ExportDesignToHTML, this.createExportDesignToHTMLAction());
        this.ui.setAction(DesignEditorLID.Undo, new UndoController.UndoAction(this.undoMgr, this.interaction));
        this.ui.setAction(DesignEditorLID.Redo, new UndoController.RedoAction(this.undoMgr, this.interaction));
        this.ui.setAction(DesignEditorLID.Paste, this.createPasteAction());
        this.ui.setAction(DesignEditorLID.CopyFrame, this.createCopyFrameAction());
        this.ui.setAction(DesignEditorLID.CutFrame, this.createCutFrameAction());
        this.ui.setAction(DesignEditorLID.DeselectAll, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.ISelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ISelectionState;
            }

            public boolean performAction(Object prms) {
                ISelectionState selection = (ISelectionState)prms;
                selection.deselectAll();
                return true;
            }
        });
        this.ui.setAction(DesignEditorLID.MoveFrames, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$MoveParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$MoveParameters = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI$MoveParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$MoveParameters;
            }

            public boolean performAction(Object prms) {
                IDesignEditorUI.MoveParameters movePrms = (IDesignEditorUI.MoveParameters)prms;
                if (movePrms != null) {
                    return DesignEditorController.this.moveFrames(movePrms.dx, movePrms.dy, movePrms.selection);
                }
                throw new RcvrUIException("Cannot move frames without parameters.");
            }
        });
        this.ui.setAction(DesignEditorLID.NewFrame, this.createNewFrameAction());
        this.ui.setAction(DesignEditorLID.InitiateFrameRename, this.createInitiateFrameRenameAction());
        this.ui.setAction(DesignEditorLID.RenameFrame, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$FrameRenameEvent == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$FrameRenameEvent = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI$FrameRenameEvent")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$FrameRenameEvent;
            }

            public boolean performAction(Object prms) {
                IDesignEditorUI.FrameRenameEvent evt = (IDesignEditorUI.FrameRenameEvent)prms;
                return DesignEditorController.this.renameFrame(evt.frame, evt.frame.getName(), evt.newName, evt.selection);
            }
        });
        this.ui.setAction(DesignEditorLID.NewTransition, this.createNewTransitionAction());
        this.ui.setAction(DesignEditorLID.EditFrame, this.createEditFrameAction());
        this.ui.setAction(DesignEditorLID.EditTransition, this.createEditTransitionAction());
        this.ui.setAction(DesignEditorLID.DeleteFrame, this.createDeleteFrameAction());
        this.ui.setAction(DesignEditorLID.DeleteTransition, this.createDeleteTransitionAction());
        this.ui.setAction(DesignEditorLID.NudgeLeft, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                double dx = -1.0 / DesignEditorController.this.ui.getZoom();
                return DesignEditorController.this.moveFrames(dx, 0.0, selection);
            }
        });
        this.ui.setAction(DesignEditorLID.NudgeRight, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                double dx = 1.0 / DesignEditorController.this.ui.getZoom();
                return DesignEditorController.this.moveFrames(dx, 0.0, selection);
            }
        });
        this.ui.setAction(DesignEditorLID.NudgeUp, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                double dy = -1.0 / DesignEditorController.this.ui.getZoom();
                return DesignEditorController.this.moveFrames(0.0, dy, selection);
            }
        });
        this.ui.setAction(DesignEditorLID.NudgeDown, new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                double dy = 1.0 / DesignEditorController.this.ui.getZoom();
                return DesignEditorController.this.moveFrames(0.0, dy, selection);
            }
        });
        this.ui.setAction(DesignEditorLID.SelectAll, new AListenerAction(){

            public boolean performAction(Object prms) {
                DesignEditorController.this.ui.selectAllFrames();
                return true;
            }
        });
        this.ui.setAction(DesignEditorLID.ChangeTarget, this.createChangeTargetAction());
        this.ui.setAction(DesignEditorLID.ChangeSource, this.createChangeSourceAction());
        this.ui.setAction(DesignEditorLID.SetBackgroundImage, this.createSetBackgroundImageAction());
        this.ui.setAction(DesignEditorLID.RemoveBackgroundImage, this.createRemoveBackgroundImageAction());
        this.ui.setAction(DesignEditorLID.SetWidgetColor, this.createSetWidgetColorAction());
        this.ui.setAction(DesignEditorLID.SkinNone, this.createSetSkinAction(SkinType.None, DesignEditorLID.SkinNone));
        this.ui.setAction(DesignEditorLID.SkinWireFrame, this.createSetSkinAction(SkinType.WireFrame, DesignEditorLID.SkinWireFrame));
        this.ui.setAction(DesignEditorLID.SkinMacOSX, this.createSetSkinAction(SkinType.MacOSX, DesignEditorLID.SkinMacOSX));
        this.ui.setAction(DesignEditorLID.SkinWinXP, this.createSetSkinAction(SkinType.WinXP, DesignEditorLID.SkinWinXP));
        this.ui.setAction(DesignEditorLID.SkinPalm, this.createSetSkinAction(SkinType.Palm, DesignEditorLID.SkinPalm));
        this.ui.setAction(DesignEditorLID.ImportImageDirectory, this.createImportImageDirectory());
        IListenerAction action = this.createChangeActionAction();
        this.ui.setAction(DesignEditorLID.ChangeWidgetAction, action);
        this.ui.setAction(DesignEditorLID.ChangeDeviceAction, action);
        this.ui.setAction(DesignEditorLID.DuplicateFrame, this.createDuplicateFrameAction());
    }

    protected IListenerAction createExportDesignToHTMLAction() {
        return new AListenerAction(){

            public boolean performAction(Object actionParms) {
                String destDirectory = DesignEditorController.this.interaction.askUserForWebPageDestination();
                if (destDirectory == null) {
                    return true;
                }
                ExportToHTMLWorkThread workThread = new ExportToHTMLWorkThread(DesignEditorController.this.interaction, DesignEditorController.this.design.duplicate(DesignEditorController.this.design.getName()), destDirectory);
                ThreadManager.ONLY.startNewThread(workThread);
                return true;
            }
        };
    }

    protected void makeFrameNameUnique(IFrame frame) {
        frame.setName(DesignEditorController.makeNameUnique(frame.getName(), this.design.getFrames()));
    }

    protected IListenerAction createRemoveBackgroundImageAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState seln = (IFrameSelectionState)prms;
                IFrame[] frames = seln.getSelectedFrames();
                DesignEditorController.this.setBackgroundImageOnFrames(frames, null);
                return true;
            }
        };
    }

    protected IListenerAction createSetBackgroundImageAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState seln = (IFrameSelectionState)prms;
                IFrame[] frames = seln.getSelectedFrames();
                String imageURL = DesignEditorController.this.interaction.selectImageFile();
                if (imageURL != null) {
                    try {
                        byte[] imageData = GraphicsUtil.loadImageFromFile(imageURL);
                        DesignEditorController.this.setBackgroundImageOnFrames(frames, imageData);
                        return true;
                    }
                    catch (IOException e) {
                        DesignEditorController.this.interaction.protestUnreadableFile();
                        Object imageData = null;
                    }
                }
                return false;
            }
        };
    }

    protected IListenerAction createSetWidgetColorAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState seln = (IFrameSelectionState)prms;
                IFrame[] frames = seln.getSelectedFrames();
                int oldColor = frames.length > 0 ? frames[0].getWidgetColor() : 128;
                Integer newColorChoice = DesignEditorController.this.interaction.selectColor(oldColor, L10N.get("DESIGN.WIDGET.selectColor", "Select Widget Color"));
                if (newColorChoice != null) {
                    DesignEditorController.this.setWidgetColorForFrames(frames, newColorChoice);
                    return true;
                }
                return false;
            }
        };
    }

    protected IListenerAction createPasteAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                try {
                    Collection objects = CogToolClipboard.fetchCogToolObjects();
                    if (objects != null && objects.size() > 0) {
                        CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.Paste", "Paste"), DesignEditorLID.Paste);
                        Iterator objIt = objects.iterator();
                        while (objIt.hasNext()) {
                            Object o = objIt.next();
                            if (o instanceof IFrame) {
                                IFrame frame = (IFrame)o;
                                DesignEditorController.this.makeFrameNameUnique(frame);
                                DoublePoint origin = frame.getFrameOrigin();
                                TreeSet frames = new TreeSet(new FramePositionComparator());
                                frames.addAll(DesignEditorController.this.design.getFrames());
                                boolean change = false;
                                Iterator it = frames.iterator();
                                while (it.hasNext()) {
                                    IFrame curFrame = (IFrame)it.next();
                                    DoublePoint other = curFrame.getFrameOrigin();
                                    if (other.x != origin.x || other.y != origin.y) continue;
                                    origin.x += 16.0;
                                    origin.y += 16.0;
                                    change = true;
                                }
                                if (change) {
                                    frame.setFrameOrigin(origin);
                                }
                                edit.addEdit(DesignEditorController.this.addFrame(frame));
                                continue;
                            }
                            if (!(o instanceof ITransition)) continue;
                            edit.addEdit(DesignEditorController.this.addTransition((ITransition)o));
                        }
                        edit.end();
                        DesignEditorController.this.undoMgr.addEdit(edit);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        };
    }

    protected IListenerAction createCopyFrameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState seln = (IFrameSelectionState)prms;
                IFrame[] frames = seln.getSelectedFrames();
                if (frames != null && frames.length > 0) {
                    DesignEditorController.this.copyFrames(frames);
                    return true;
                }
                DesignEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected void copyFrames(IFrame[] frames) {
        try {
            ObjectSaver s = CogToolClipboard.startClipboardSave((Object)"FrameOnly", frames);
            for (int i = 0; i < frames.length; ++i) {
                s.saveObject(frames[i]);
            }
            s.finish();
        }
        catch (Exception e) {
            throw new RcvrUIException(e);
        }
    }

    protected IListenerAction createCutFrameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState seln = (IFrameSelectionState)prms;
                IFrame[] frames = seln.getSelectedFrames();
                if (frames != null && frames.length > 0) {
                    DesignEditorController.this.copyFrames(frames);
                    DesignEditorController.this.deleteFrames(frames);
                    return true;
                }
                DesignEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IListenerAction createNewFrameAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                DoublePoint origin = new DoublePoint(10.0, 10.0);
                TreeSet frames = new TreeSet(new FramePositionComparator());
                frames.addAll(DesignEditorController.this.design.getFrames());
                Iterator it = frames.iterator();
                while (it.hasNext()) {
                    IFrame frame = (IFrame)it.next();
                    DoublePoint other = frame.getFrameOrigin();
                    if (other.x != origin.x || other.y != origin.y) continue;
                    origin.x += 16.0;
                    origin.y += 16.0;
                }
                IFrame newFrame = DesignEditorController.this.createNewFrame(origin.x, origin.y);
                DesignEditorController.this.ui.initiateFrameRename(newFrame);
                return true;
            }
        };
    }

    protected IFrame createNewFrame(double x, double y) {
        return this.createNewFrame(x, y, null);
    }

    protected IUndoableEdit addFrame(final IFrame frame) {
        this.design.addFrame(frame);
        return new AUndoableEdit(DesignEditorLID.NewFrame){

            public String getPresentationName() {
                return L10N.get("UNDO.DE.NewFrame", "New Frame");
            }

            public void redo() {
                super.redo();
                DesignEditorController.this.design.addFrame(frame);
            }

            public void undo() {
                super.undo();
                DesignEditorController.this.design.removeFrame(frame);
            }
        };
    }

    protected IUndoableEdit addTransition(final ITransition transition) {
        transition.getSource().addTransition(transition);
        return new AUndoableEdit(DesignEditorLID.NewTransition){

            public String getPresentationName() {
                return L10N.get("UNDO.DE.NewTransition", "New Transition");
            }

            public void redo() {
                super.redo();
                transition.getSource().addTransition(transition);
            }

            public void undo() {
                super.undo();
                transition.getSource().removeTransition(transition);
            }
        };
    }

    protected IFrame createFrame(String frameName, double x, double y) {
        Frame frame = new Frame(frameName, this.design.getDeviceTypes());
        frame.setFrameOrigin(x, y);
        return frame;
    }

    protected IFrame createNewFrame(double x, double y, CompoundUndoableEdit compoundUndo) {
        String frameNamePrefix = L10N.get("DE.FrameNamePrefix", "Frame") + " ";
        String frameName = frameNamePrefix + this.nextNewFrameSuffix;
        while (this.design.getFrame(frameName) != null) {
            frameName = frameNamePrefix + ++this.nextNewFrameSuffix;
        }
        IFrame frame = this.createFrame(frameName, x, y);
        IUndoableEdit edit = this.addFrame(frame);
        if (compoundUndo != null) {
            compoundUndo.addEdit(edit);
        } else {
            this.undoMgr.addEdit(edit);
        }
        return frame;
    }

    protected boolean moveFrames(double dx, double dy, IFrameSelectionState selection) {
        IFrame[] frames = selection.getSelectedFrames();
        if (frames != null && frames.length > 0) {
            CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.DE.MoveFrame(s)", "Move Frame(s)"), DesignEditorLID.MoveFrames);
            for (int i = 0; i < frames.length; ++i) {
                this.moveFrame(frames[i], dx, dy, edit);
            }
            edit.end();
            this.undoMgr.addEdit(edit);
        }
        return true;
    }

    protected void moveFrame(final IFrame frame, double dx, double dy, CompoundUndoableEdit edit) {
        final DoublePoint oldP = new DoublePoint(frame.getFrameOrigin());
        final DoublePoint p = new DoublePoint(oldP);
        p.x += dx;
        p.y += dy;
        if (p.x < 0.0) {
            p.x = 0.0;
        }
        if (p.y < 0.0) {
            p.y = 0.0;
        }
        frame.setFrameOrigin(p);
        edit.addEdit(new AUndoableEdit(DesignEditorLID.MoveFrames){

            public String getPresentationName() {
                return L10N.get("UNDO.DE.MoveFrame", "Move Frame");
            }

            public void redo() {
                super.redo();
                frame.setFrameOrigin(p);
            }

            public void undo() {
                super.undo();
                frame.setFrameOrigin(oldP);
            }
        });
    }

    protected IListenerAction createEditFrameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                IFrame[] frames = selection.getSelectedFrames();
                if (frames == null || frames.length == 0) {
                    DesignEditorController.this.interaction.protestNoSelection();
                    return false;
                }
                for (int i = 0; i < frames.length; ++i) {
                    CogTool.frameEditorControllerFactory.openController(frames[i], DesignEditorController.this.design, DesignEditorController.this.project);
                }
                return true;
            }
        };
    }

    protected IAction ensureActionIsUnique(ITransitionSource source, IAction action, int limitMode, ITransition currentTransition) {
        ITransition actionTransition = source.getTransition(action);
        while (actionTransition != null && actionTransition != currentTransition) {
            if (!this.interaction.determineNewAction(this.properties, limitMode, action, source, currentTransition)) {
                return null;
            }
            action = this.buildActionFromProperties(limitMode);
            if (action == null) {
                return null;
            }
            actionTransition = source.getTransition(action);
        }
        return action;
    }

    protected IListenerAction createEditTransitionAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.ITransitionSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState;
            }

            public boolean performAction(Object prms) {
                ITransitionSelectionState selection = (ITransitionSelectionState)prms;
                ITransition[] transitions = selection.getSelectedTransitions();
                if (transitions != null && transitions.length > 0) {
                    if (transitions.length == 1) {
                        ITransitionSource source = transitions[0].getSource();
                        IAction action = transitions[0].getAction();
                        int limitMode = DesignEditorController.this.ui.determineChangeActionMode(source);
                        DesignEditorController.this.ui.updateActionProperties(source, action, DesignEditorController.this.properties);
                        if (!DesignEditorController.this.interaction.determineNewAction(DesignEditorController.this.properties, limitMode)) {
                            return false;
                        }
                        action = DesignEditorController.this.buildActionFromProperties(limitMode);
                        if (action == null) {
                            return false;
                        }
                        if ((action = DesignEditorController.this.ensureActionIsUnique(source, action, limitMode, transitions[0])) == null) {
                            return false;
                        }
                        return DesignEditorController.this.changeTransitionsAction(transitions, action);
                    }
                    DesignEditorController.this.interaction.protestMultipleTransitionSelection();
                }
                return false;
            }
        };
    }

    protected IListenerAction createInitiateFrameRenameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                int selectedFrameCount = selection.getSelectedFrameCount();
                if (selectedFrameCount == 1) {
                    DesignEditorController.this.ui.initiateFrameRename(selection);
                    return true;
                }
                if (selectedFrameCount > 1) {
                    DesignEditorController.this.interaction.protestMultipleFrameSelection();
                    return false;
                }
                DesignEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected boolean isFrameNameUnique(String newFrameName, String oldFrameName) {
        if (newFrameName.equals(oldFrameName)) {
            return true;
        }
        return this.design.getFrame(newFrameName) == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean renameFrame(final IFrame renamedFrame, final String oldFrameName, final String newFrameName, IFrameSelectionState selection) {
        if (newFrameName.equals(oldFrameName)) return true;
        if (newFrameName.equals("")) {
            if (!this.interaction.protestEmptyFrameName()) return false;
            this.ui.initiateFrameRename(selection);
            return true;
        } else if (this.isFrameNameUnique(newFrameName, oldFrameName)) {
            renamedFrame.setName(newFrameName);
            this.undoMgr.addEdit(new AUndoableEdit(DesignEditorLID.RenameFrame){

                public String getPresentationName() {
                    return L10N.get("UNDO.DE.RenameFrame", "Rename Frame");
                }

                public void redo() {
                    super.redo();
                    renamedFrame.setName(newFrameName);
                }

                public void undo() {
                    super.undo();
                    renamedFrame.setName(oldFrameName);
                }
            });
            return true;
        } else {
            if (!this.interaction.protestNotUniqueFrameName()) return false;
            this.ui.initiateFrameRename(selection);
        }
        return true;
    }

    protected IListenerAction createNewTransitionAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$NewTransitionParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$NewTransitionParameters = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI$NewTransitionParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$NewTransitionParameters;
            }

            public boolean performAction(Object prms) {
                IDesignEditorUI.NewTransitionParameters newPrms = (IDesignEditorUI.NewTransitionParameters)prms;
                if (newPrms != null) {
                    IUndoableEdit edit;
                    CompoundUndoableEdit compoundUndo = null;
                    if (newPrms.target == null) {
                        compoundUndo = new CompoundUndoableEdit(L10N.get("UNDO.DE.NewTransition", "New Transition"), DesignEditorLID.NewTransition);
                        newPrms.target = DesignEditorController.this.createNewFrame(newPrms.x, newPrms.y, compoundUndo);
                    }
                    if ((edit = DesignEditorController.this.createNewTransition(newPrms.source, newPrms.target)) != null) {
                        if (compoundUndo != null) {
                            compoundUndo.addEdit(edit);
                            compoundUndo.end();
                            edit = compoundUndo;
                        }
                        DesignEditorController.this.undoMgr.addEdit(edit);
                        if (compoundUndo != null) {
                            DesignEditorController.this.ui.initiateFrameRename(newPrms.target);
                        }
                        return true;
                    }
                    if (compoundUndo != null) {
                        compoundUndo.end();
                        compoundUndo.undo();
                    }
                    return false;
                }
                throw new RcvrUIException("Cannot create transition without parameters.");
            }
        };
    }

    protected IAction buildActionFromProperties(int limitMode) {
        boolean notCanceled = true;
        block7: while (notCanceled) {
            switch (this.properties.useWhichParts) {
                case 2: {
                    if (this.properties.keyboardString.length() > 0) {
                        return this.createKeyAction();
                    }
                    notCanceled = this.interaction.protestEmptyKeys(this.properties, limitMode);
                    continue block7;
                }
                case 1: {
                    if (this.properties.voiceString.length() > 0) {
                        return this.createVoiceAction();
                    }
                    notCanceled = this.interaction.protestEmptyVoice(this.properties, limitMode);
                    continue block7;
                }
                case 3: {
                    if (this.properties.graffitiString.length() > 0) {
                        return this.createGraffitiAction();
                    }
                    notCanceled = this.interaction.protestEmptyGraffiti(this.properties, limitMode);
                    continue block7;
                }
                case 4: {
                    return this.createTouchAction();
                }
                case 0: {
                    return this.createMouseAction();
                }
            }
            notCanceled = false;
            throw new RcvrUnimplementedFnException("Unknown properties state.");
        }
        return null;
    }

    protected IAction createDefaultAction(ITransitionSource source, DeviceType desiredTransitionType) {
        this.ui.getDefaultProperties(source, this.properties);
        if (source instanceof IInputDevice) {
            IInputDevice device = (IInputDevice)source;
            DeviceType type = device.getDeviceType();
            if (type == DeviceType.Keyboard) {
                return this.createKeyAction();
            }
            if (type == DeviceType.Voice) {
                return this.createVoiceAction();
            }
        }
        if (source instanceof IWidget) {
            IWidget widget = (IWidget)source;
            if (desiredTransitionType == IDesignEditorUI.BASE_ACTION_ON_SOURCE) {
                if (widget.getWidgetType() == WidgetType.Graffiti) {
                    return this.createGraffitiAction();
                }
                if (this.design.getDeviceTypes().contains(DeviceType.Mouse)) {
                    return this.createMouseAction();
                }
                if (this.design.getDeviceTypes().contains(DeviceType.Touchscreen)) {
                    return this.createTouchAction();
                }
                if (this.design.getDeviceTypes().contains(DeviceType.Keyboard)) {
                    return this.createKeyAction();
                }
                if (this.design.getDeviceTypes().contains(DeviceType.Voice)) {
                    return this.createVoiceAction();
                }
            } else {
                if (desiredTransitionType == DeviceType.Mouse) {
                    return this.createMouseAction();
                }
                if (desiredTransitionType == DeviceType.Keyboard) {
                    return this.createKeyAction();
                }
                if (desiredTransitionType == DeviceType.Touchscreen) {
                    return this.createTouchAction();
                }
                if (desiredTransitionType == DeviceType.Voice) {
                    return this.createVoiceAction();
                }
            }
        }
        return null;
    }

    protected IAction createKeyAction() {
        String text = this.properties.keyboardString;
        int textLength = text.length();
        if (textLength > 0) {
            if (textLength == 1) {
                return new KeyAction(text.charAt(0), this.properties.keyboardAction, this.properties.keyboardIsCmd, 0);
            }
            return new KeyAction(text, this.properties.keyboardIsCmd, 0);
        }
        return null;
    }

    protected IAction createGraffitiAction() {
        String text = this.properties.graffitiString;
        int textLength = text.length();
        if (textLength > 0) {
            return new GraffitiAction(text, this.properties.graffitiIsCmd);
        }
        return null;
    }

    protected IAction createMouseAction() {
        return new ButtonAction(this.properties.mouseButton, this.properties.buttonAction, this.properties.buttonState);
    }

    protected IAction createTouchAction() {
        return new TapAction(this.properties.tapAction);
    }

    protected IAction createVoiceAction() {
        String text = this.properties.voiceString;
        int textLength = text.length();
        if (textLength > 0) {
            return new VoiceAction(text, this.properties.voiceIsCmd);
        }
        return null;
    }

    protected IUndoableEdit createNewTransition(final ITransitionSource source, IFrame target) {
        int limitMode = this.ui.determineChangeActionMode(source);
        DeviceType desiredTransitionType = this.ui.getCurrentDeviceType();
        IAction action = this.createDefaultAction(source, desiredTransitionType);
        if (action == null) {
            if (!this.interaction.determineNewAction(this.properties, limitMode)) {
                return null;
            }
            action = this.buildActionFromProperties(limitMode);
            if (action == null) {
                return null;
            }
        }
        if ((action = this.ensureActionIsUnique(source, action, limitMode, null)) == null) {
            return null;
        }
        final Transition transition = new Transition(source, target, action);
        source.addTransition(transition);
        return new AUndoableEdit(DesignEditorLID.NewTransition){

            public String getPresentationName() {
                return L10N.get("UNDO.DE.NewTransition", "New Transition");
            }

            public void redo() {
                super.redo();
                source.addTransition(transition);
            }

            public void undo() {
                super.undo();
                source.removeTransition(transition);
            }
        };
    }

    protected IListenerAction createDeleteFrameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState selection = (IFrameSelectionState)prms;
                IFrame[] frames = selection.getSelectedFrames();
                if (frames != null && frames.length > 0) {
                    if (DesignEditorController.this.interaction.confirmDeleteFrames(frames)) {
                        DesignEditorController.this.deleteFrames(frames);
                        return true;
                    }
                } else {
                    DesignEditorController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected IUndoableEdit deleteFrame(final IFrame frame, CogToolLID lid) {
        final ITransition[] incidentTransitions = frame.removeIncidentTransitions();
        final Set validators = this.project.invalidateResultsUsing(this.design, frame, null);
        this.design.removeFrame(frame);
        return new AUndoableEdit(lid){

            public void redo() {
                super.redo();
                frame.removeIncidentTransitions();
                DesignEditorController.this.design.removeFrame(frame);
                DesignEditorController.this.revalidateFrame(frame, validators);
            }

            public void undo() {
                super.undo();
                DesignEditorController.this.design.addFrame(frame);
                DesignEditorController.this.addIncidentTransitions(incidentTransitions);
                DesignEditorController.this.revalidateFrame(frame, validators);
            }
        };
    }

    protected void deleteFrames(final IFrame[] frames) {
        if (frames != null && frames.length > 0) {
            int i;
            final ITransition[][] incidentTransitions = new ITransition[frames.length][];
            final HashSet validators = new HashSet();
            for (i = 0; i < frames.length; ++i) {
                validators.addAll(this.project.invalidateResultsUsing(this.design, frames[i], null));
                incidentTransitions[i] = frames[i].removeIncidentTransitions();
            }
            for (i = 0; i < frames.length; ++i) {
                this.design.removeFrame(frames[i]);
            }
            this.undoMgr.addEdit(new AUndoableEdit(DesignEditorLID.DeleteFrame){

                public String getPresentationName() {
                    return L10N.get("UNDO.DE.DeleteFrames", "Delete Frame(s)");
                }

                public void redo() {
                    int i;
                    super.redo();
                    for (i = 0; i < frames.length; ++i) {
                        frames[i].removeIncidentTransitions();
                    }
                    for (i = 0; i < frames.length; ++i) {
                        DesignEditorController.this.design.removeFrame(frames[i]);
                    }
                    for (i = frames.length - 1; i >= 0; --i) {
                        DesignEditorController.this.revalidateFrame(frames[i], validators);
                    }
                }

                public void undo() {
                    int i;
                    super.undo();
                    for (i = frames.length - 1; i >= 0; --i) {
                        DesignEditorController.this.design.addFrame(frames[i]);
                    }
                    for (i = frames.length - 1; i >= 0; --i) {
                        DesignEditorController.this.addIncidentTransitions(incidentTransitions[i]);
                    }
                    for (i = frames.length - 1; i >= 0; --i) {
                        DesignEditorController.this.revalidateFrame(frames[i], validators);
                    }
                }
            });
        }
    }

    protected IListenerAction createDeleteTransitionAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.ITransitionSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$ITransitionSelectionState;
            }

            public boolean performAction(Object prms) {
                ITransitionSelectionState selection = (ITransitionSelectionState)prms;
                ITransition[] transitions = selection.getSelectedTransitions();
                if (transitions != null && transitions.length > 0) {
                    if (DesignEditorController.this.interaction.confirmDeleteTransitions(transitions)) {
                        DesignEditorController.this.deleteTransitions(transitions);
                        return true;
                    }
                } else {
                    DesignEditorController.this.interaction.protestNoSelection();
                }
                return false;
            }
        };
    }

    protected IListenerAction createChangeTargetAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeTargetParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeTargetParameters = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI$ChangeTargetParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeTargetParameters;
            }

            public boolean performAction(Object prms) {
                IDesignEditorUI.ChangeTargetParameters chgPrms = (IDesignEditorUI.ChangeTargetParameters)prms;
                DesignEditorController.this.changeTransitionTarget(chgPrms.transition, chgPrms.newDestination);
                return true;
            }
        };
    }

    protected IListenerAction createChangeSourceAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeSourceParameters == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeSourceParameters = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI$ChangeSourceParameters")) : class$edu$cmu$cs$hcii$cogtool$ui$IDesignEditorUI$ChangeSourceParameters;
            }

            public boolean performAction(Object prms) {
                IDesignEditorUI.ChangeSourceParameters chgPrms = (IDesignEditorUI.ChangeSourceParameters)prms;
                return DesignEditorController.this.changeTransitionSource(chgPrms.transition, chgPrms.newSource);
            }
        };
    }

    protected void deleteTransitions(final ITransition[] transitions) {
        if (transitions != null && transitions.length > 0) {
            final ITransitionSource[] sources = new ITransitionSource[transitions.length];
            final HashSet validators = new HashSet();
            for (int i = 0; i < transitions.length; ++i) {
                validators.addAll(this.project.invalidateResultsUsing(this.design, transitions[i], null));
                ITransition t = transitions[i];
                sources[i] = t.getSource();
                sources[i].removeTransition(t);
            }
            this.undoMgr.addEdit(new AUndoableEdit(DesignEditorLID.DeleteTransition){

                public String getPresentationName() {
                    return L10N.get("UNDO.DE.DeleteTransitions", "Delete Transition(s)");
                }

                public void redo() {
                    int i;
                    super.redo();
                    for (i = 0; i < transitions.length; ++i) {
                        ITransition t = transitions[i];
                        sources[i].removeTransition(t);
                    }
                    for (i = 0; i < transitions.length; ++i) {
                        DesignEditorController.this.revalidateTransition(transitions[i], validators);
                    }
                }

                public void undo() {
                    int i;
                    super.undo();
                    for (i = 0; i < transitions.length; ++i) {
                        ITransition t = transitions[i];
                        sources[i].addTransition(t);
                    }
                    for (i = 0; i < transitions.length; ++i) {
                        DesignEditorController.this.revalidateTransition(transitions[i], validators);
                    }
                }
            });
        }
    }

    protected void addIncidentTransitions(ITransition[] transitions) {
        for (int i = 0; i < transitions.length; ++i) {
            ITransitionSource sourceWidget = transitions[i].getSource();
            sourceWidget.addTransition(transitions[i]);
        }
    }

    protected void changeTransitionTarget(final ITransition transition, final IFrame newDestination) {
        final IFrame oldDestination = transition.getDestination();
        if (newDestination != oldDestination) {
            final Set validators = this.project.invalidateResultsUsing(this.design, transition, null);
            transition.setDestination(newDestination);
            this.undoMgr.addEdit(new AUndoableEdit(DesignEditorLID.ChangeTarget){

                public String getPresentationName() {
                    return L10N.get("UNDO.DE.ChangeTarget", "Change Target Frame");
                }

                public void redo() {
                    super.redo();
                    transition.setDestination(newDestination);
                    DesignEditorController.this.revalidateTransition(transition, validators);
                }

                public void undo() {
                    super.undo();
                    transition.setDestination(oldDestination);
                    DesignEditorController.this.revalidateTransition(transition, validators);
                }
            });
        }
    }

    protected boolean changeTransitionSource(final ITransition transition, final ITransitionSource newSource) {
        final ITransitionSource oldSource = transition.getSource();
        if (newSource != oldSource) {
            IAction action = transition.getAction();
            if (!newSource.canAccept(action)) {
                this.interaction.protestInconsistentSource();
                return false;
            }
            while (newSource.getTransition(action) != null) {
                if (this.interaction.protestNotUniqueAction(action, newSource, false)) continue;
                return false;
            }
            final Set validators = this.project.invalidateResultsUsing(this.design, transition, null);
            oldSource.removeTransition(transition);
            newSource.addTransition(transition);
            transition.setSource(newSource);
            this.undoMgr.addEdit(new AUndoableEdit(DesignEditorLID.ChangeSource){

                public String getPresentationName() {
                    return L10N.get("UNDO.DE.ChangeTarget", "Change Target Frame");
                }

                public void redo() {
                    super.redo();
                    oldSource.removeTransition(transition);
                    newSource.addTransition(transition);
                    transition.setSource(newSource);
                    DesignEditorController.this.revalidateTransition(transition, validators);
                }

                public void undo() {
                    super.undo();
                    newSource.removeTransition(transition);
                    oldSource.addTransition(transition);
                    transition.setSource(oldSource);
                    DesignEditorController.this.revalidateTransition(transition, validators);
                }
            });
        }
        return true;
    }

    protected IListenerAction createChangeActionAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                ITransition[] transitions;
                IDesignEditorUI.ChangeActionParameters chgPrms = (IDesignEditorUI.ChangeActionParameters)prms;
                if (chgPrms != null && (transitions = chgPrms.selection.getSelectedTransitions()) != null && transitions.length > 0) {
                    DesignEditorController.this.properties.copyValues(chgPrms.properties);
                    ITransitionSource source = transitions[0].getSource();
                    int limitMode = DesignEditorController.this.ui.determineChangeActionMode(source);
                    IAction newAction = DesignEditorController.this.buildActionFromProperties(limitMode);
                    newAction = DesignEditorController.this.ensureActionIsUnique(source, newAction, limitMode, transitions[0]);
                    if (newAction == null) {
                        return false;
                    }
                    return DesignEditorController.this.changeTransitionsAction(transitions, newAction);
                }
                return false;
            }
        };
    }

    protected boolean changeTransitionsAction(ITransition[] transitions, IAction newAction) {
        if (transitions != null && transitions.length > 0) {
            CompoundUndoableEdit edit = new CompoundUndoableEdit(L10N.get("UNDO.DE.ChangeAction", "Change Action"), DesignEditorLID.ChangeWidgetAction);
            for (int i = 0; i < transitions.length; ++i) {
                this.changeTransitionAction(transitions[i], newAction, edit);
            }
            edit.end();
            if (edit.isSignificant()) {
                this.undoMgr.addEdit(edit);
            }
        }
        return true;
    }

    protected void changeTransitionAction(final ITransition transition, final IAction newAction, CompoundUndoableEdit edit) {
        final IAction oldAction = transition.getAction();
        if (!oldAction.equals(newAction)) {
            final Set validators = this.project.invalidateResultsUsing(this.design, transition, null);
            transition.setAction(newAction);
            edit.addEdit(new AUndoableEdit(DesignEditorLID.ChangeWidgetAction){

                public String getPresentationName() {
                    return L10N.get("UNDO.DE.ChangeAction", "Change Action");
                }

                public void redo() {
                    super.redo();
                    transition.setAction(newAction);
                    DesignEditorController.this.revalidateTransition(transition, validators);
                }

                public void undo() {
                    super.undo();
                    transition.setAction(oldAction);
                    DesignEditorController.this.revalidateTransition(transition, validators);
                }
            });
        }
    }

    protected IListenerAction createDuplicateFrameAction() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState == null ? (class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState = DesignEditorController.class$("edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState")) : class$edu$cmu$cs$hcii$cogtool$ui$IFrameSelectionState;
            }

            public boolean performAction(Object prms) {
                IFrameSelectionState seln = (IFrameSelectionState)prms;
                IFrame[] framesToDuplicate = seln.getSelectedFrames();
                if (framesToDuplicate != null && framesToDuplicate.length > 0) {
                    FrameSubsetDuplicator duplicator = new FrameSubsetDuplicator(framesToDuplicate);
                    IFrame[] duplicatedFrames = new Frame[framesToDuplicate.length];
                    for (int i = 0; i < framesToDuplicate.length; ++i) {
                        duplicatedFrames[i] = duplicator.getOrDuplicate(framesToDuplicate[i]);
                        duplicatedFrames[i].moveFrameOrigin(16.0, 16.0);
                        DesignEditorController.this.makeFrameNameUnique(duplicatedFrames[i]);
                        DesignEditorController.this.design.addFrame(duplicatedFrames[i]);
                    }
                    DesignEditorController.this.undoMgr.addEdit(DesignEditorController.this.createDuplicateFramesEdit(duplicatedFrames));
                    return true;
                }
                DesignEditorController.this.interaction.protestNoSelection();
                return false;
            }
        };
    }

    protected IUndoableEdit createDuplicateFramesEdit(final IFrame[] frames) {
        return new AUndoableEdit(DesignEditorLID.DuplicateFrame){
            protected ITransition[][] incidentTransitions;
            protected Set validators;
            {
                super(x0);
                this.incidentTransitions = null;
                this.validators = null;
            }

            public String getPresentationName() {
                return L10N.get("UNDO.DE.DuplicateFrames", "Duplicate Frame(s)");
            }

            public void redo() {
                int i;
                super.redo();
                for (i = frames.length - 1; i >= 0; --i) {
                    DesignEditorController.this.design.addFrame(frames[i]);
                }
                for (i = frames.length - 1; i >= 0; --i) {
                    DesignEditorController.this.addIncidentTransitions(this.incidentTransitions[i]);
                }
                for (i = frames.length - 1; i >= 0; --i) {
                    DesignEditorController.this.revalidateFrame(frames[i], this.validators);
                }
            }

            public void undo() {
                super.undo();
                if (this.incidentTransitions == null) {
                    int i;
                    this.incidentTransitions = new ITransition[frames.length][];
                    this.validators = new HashSet();
                    for (i = 0; i < frames.length; ++i) {
                        this.validators.addAll(DesignEditorController.this.project.invalidateResultsUsing(DesignEditorController.this.design, frames[i], null));
                        this.incidentTransitions[i] = frames[i].removeIncidentTransitions();
                    }
                    for (i = 0; i < frames.length; ++i) {
                        DesignEditorController.this.design.removeFrame(frames[i]);
                    }
                } else {
                    int i;
                    for (i = 0; i < frames.length; ++i) {
                        frames[i].removeIncidentTransitions();
                    }
                    for (i = 0; i < frames.length; ++i) {
                        DesignEditorController.this.design.removeFrame(frames[i]);
                    }
                    for (i = frames.length - 1; i >= 0; --i) {
                        DesignEditorController.this.revalidateFrame(frames[i], this.validators);
                    }
                }
            }
        };
    }

    protected void revalidateFrame(IFrame f, Set validators) {
        HashSet<IPredictionResult> results = new HashSet<IPredictionResult>();
        Iterator it = validators.iterator();
        while (it.hasNext()) {
            IResultRevalidator val = (IResultRevalidator)it.next();
            val.revalidateResult();
            results.add(val.getResult());
        }
        validators.addAll(this.project.invalidateResultsUsing(this.design, f, results));
    }

    protected void revalidateTransition(ITransition t, Set validators) {
        HashSet<IPredictionResult> results = new HashSet<IPredictionResult>();
        Iterator it = validators.iterator();
        while (it.hasNext()) {
            IResultRevalidator val = (IResultRevalidator)it.next();
            val.revalidateResult();
            results.add(val.getResult());
        }
        validators.addAll(this.project.invalidateResultsUsing(this.design, t, results));
    }

    protected Map getBackgroundImageData(IFrame[] frames) {
        HashMap<IFrame, ImageData> previousImagesData = new HashMap<IFrame, ImageData>();
        for (int i = 0; i < frames.length; ++i) {
            previousImagesData.put(frames[i], new ImageData(frames[i].getBackgroundBounds(), frames[i].getBackgroundImage()));
        }
        return previousImagesData;
    }

    protected void setBackgroundImageOnFrames(final IFrame[] frames, final byte[] imageData) {
        try {
            final DoubleRectangle imageSize = GraphicsUtil.getImageBounds(imageData);
            final Map previousImageData = this.getBackgroundImageData(frames);
            for (int i = 0; i < frames.length; ++i) {
                frames[i].setBackgroundImage(imageData, imageSize);
            }
            CogToolLID editLID = imageData == null ? DesignEditorLID.RemoveBackgroundImage : DesignEditorLID.SetBackgroundImage;
            this.undoMgr.addEdit(new AUndoableEdit(editLID){

                public String getPresentationName() {
                    return imageData == null ? L10N.get("UNDO.FE.RemoveBackgroundImage", "Remove Frame Background Image") : L10N.get("UNDO.FE.SetBackgroundImage", "Set Frame Background Image");
                }

                public void redo() {
                    super.redo();
                    for (int i = 0; i < frames.length; ++i) {
                        frames[i].setBackgroundImage(imageData, imageSize);
                    }
                }

                public void undo() {
                    super.undo();
                    Iterator imageEntryIterator = previousImageData.entrySet().iterator();
                    while (imageEntryIterator.hasNext()) {
                        Map.Entry imageEntry = imageEntryIterator.next();
                        IFrame f = (IFrame)imageEntry.getKey();
                        ImageData id = (ImageData)imageEntry.getValue();
                        byte[] iData = id.data;
                        DoubleRectangle iSize = id.bounds;
                        f.setBackgroundImage(iData, iSize);
                    }
                }
            });
        }
        catch (Exception e) {
            this.interaction.protestInvalidImageFile();
        }
    }

    protected Map getWidgetColorData(IFrame[] frames) {
        HashMap<IFrame, Integer> widgetColorData = new HashMap<IFrame, Integer>();
        for (int i = 0; i < frames.length; ++i) {
            widgetColorData.put(frames[i], new Integer(frames[i].getWidgetColor()));
        }
        return widgetColorData;
    }

    protected void setWidgetColorForFrames(final IFrame[] frames, final int color) {
        final Map previousWidgetColorData = this.getWidgetColorData(frames);
        for (int i = 0; i < frames.length; ++i) {
            frames[i].setWidgetColor(color);
        }
        this.undoMgr.addEdit(new AUndoableEdit(DesignEditorLID.SetWidgetColor){

            public String getPresentationName() {
                return L10N.get("UNDO.FE.SetWidgetColor", "Set Widget Color");
            }

            public void redo() {
                super.redo();
                for (int i = 0; i < frames.length; ++i) {
                    frames[i].setWidgetColor(color);
                }
            }

            public void undo() {
                super.undo();
                Iterator colorEntryIterator = previousWidgetColorData.entrySet().iterator();
                while (colorEntryIterator.hasNext()) {
                    Map.Entry colorEntry = colorEntryIterator.next();
                    IFrame f = (IFrame)colorEntry.getKey();
                    int oldColor = (Integer)colorEntry.getValue();
                    f.setWidgetColor(oldColor);
                }
            }
        });
    }

    protected IListenerAction createImportImageDirectory() {
        return new IListenerAction(){

            public Class getParameterClass() {
                return null;
            }

            public boolean performAction(Object actionParms) {
                File dir;
                String filePath = DesignEditorController.this.interaction.askForImageDir();
                if (filePath != null && (dir = new File(filePath)).isDirectory()) {
                    File[] files = dir.listFiles(new FileFilter(this){
                        private final /* synthetic */ 41 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean accept(File pathname) {
                            Matcher imageFileNameMatcher = IMAGE_FILE_NAME.matcher(pathname.getName());
                            return imageFileNameMatcher.matches();
                        }
                    });
                    double originX = 10.0;
                    double originY = 10.0;
                    TreeSet frames = new TreeSet(new FramePositionComparator());
                    frames.addAll(DesignEditorController.this.design.getFrames());
                    Iterator it = frames.iterator();
                    while (it.hasNext()) {
                        IFrame frame = (IFrame)it.next();
                        DoublePoint other = frame.getFrameOrigin();
                        if (other.x != originX || other.y != originY) continue;
                        originX += 16.0;
                        originY += 16.0;
                    }
                    IFrame frameToDelete = DesignEditorController.this.design.getFrame(INITIAL_FRAME_NAME);
                    if (frameToDelete == null || DesignEditorController.this.design.getFrames().size() > 1 || frameToDelete.getWidgets().size() > 0 || frameToDelete.getBackgroundImage() != null) {
                        frameToDelete = null;
                    }
                    ImportImageDirThread workThread = new ImportImageDirThread(files, originX, originY, frameToDelete);
                    ThreadManager.ONLY.startNewThread(workThread);
                }
                return true;
            }
        };
    }

    protected AListenerAction createSetSkinAction(final SkinType newSkin, final CogToolLID lid) {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                SkinType oldSkin = DesignEditorController.this.design.getSkin();
                DesignEditorController.this.design.setSkin(newSkin);
                DesignEditorController.this.undoMgr.addEdit(new AUndoableEdit(this, lid, oldSkin){
                    private final /* synthetic */ SkinType val$oldSkin;
                    private final /* synthetic */ 43 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$oldSkin = val$oldSkin;
                        super(x0);
                    }

                    public String getPresentationName() {
                        return L10N.get("UNDO.DE.ChangeSkin", "Change Skin");
                    }

                    public void redo() {
                        super.redo();
                        43.access$100(this.this$1).design.setSkin(43.access$000(this.this$1));
                    }

                    public void undo() {
                        super.undo();
                        43.access$100(this.this$1).design.setSkin(this.val$oldSkin);
                    }
                });
                return true;
            }

            static /* synthetic */ SkinType access$000(43 x0) {
                return x0.newSkin;
            }

            static /* synthetic */ DesignEditorController access$100(43 x0) {
                return x0.DesignEditorController.this;
            }
        };
    }

    protected class ImportImageDirThread
    extends ACogToolWorkThread {
        protected final String title = L10N.get("WDX.ImportingImageDirectory", "Importing Images ...");
        protected IInteraction.IProgressBar progressBar;
        protected File[] imageList;
        protected IFrame[] createdFrames;
        protected double frameX;
        protected double frameY;
        protected boolean finished;
        protected IFrame frameToDelete;
        protected CompoundUndoableEdit edit;
        protected double completedCount;
        protected String errorMsg;

        public ImportImageDirThread(File[] images, double originX, double originY, IFrame deleteFrame) {
            this.progressBar = DesignEditorController.this.interaction.createProgressBar(this.title, this, this.title, true);
            this.finished = false;
            this.edit = new CompoundUndoableEdit(L10N.get("UNDO.DE.ImportBackgroundImages", "Import Background Images"), DesignEditorLID.ImportImageDirectory);
            this.completedCount = 0.0;
            this.errorMsg = null;
            if (images == null) {
                throw new RcvrImageException("Required images array was null");
            }
            this.imageList = images;
            this.frameX = originX;
            this.frameY = originY;
            this.createdFrames = new IFrame[this.imageList.length];
            this.frameToDelete = deleteFrame;
            this.setProgressCallback(this.progressBar);
            this.setDisabler(this.progressBar.getDisabler());
        }

        public void doWork() {
            int i = 0;
            while (!this.isCanceled() && this.errorMsg == null && i < this.imageList.length) {
                try {
                    byte[] imageData = GraphicsUtil.loadImageFromFile(this.imageList[i].getAbsolutePath());
                    DoubleRectangle imageSize = GraphicsUtil.getImageBounds(imageData);
                    String fileName = this.imageList[i].getName();
                    Matcher imageFileNameMatcher = IMAGE_FILE_NAME.matcher(fileName);
                    if (!imageFileNameMatcher.matches()) {
                        throw new RcvrImageException("Formerly matching image file name no longer matches: " + fileName);
                    }
                    IFrame frame = DesignEditorController.this.createFrame(imageFileNameMatcher.group(1), this.frameX, this.frameY);
                    frame.setBackgroundImage(imageData, imageSize);
                    this.createdFrames[i] = frame;
                    this.completedCount += 1.0;
                    this.setProgress(this.completedCount / (double)this.imageList.length, this.imageList[i].getName());
                    this.frameX += 16.0;
                    this.frameY += 16.0;
                    ++i;
                }
                catch (RcvrImageException e) {
                    this.errorMsg = L10N.get("ERROR.ImageMatching", "Image format does not match file extension: ") + this.imageList[i].getName();
                }
                catch (IOException e) {
                    this.errorMsg = L10N.get("ERROR.CannotReadFile", "File cannot be read: ") + this.imageList[i].getName();
                }
            }
            this.finished = true;
        }

        public void doneCallback() {
            if (!this.isCanceled() && this.finished && this.createdFrames.length > 0) {
                if (this.frameToDelete != null) {
                    this.edit.addEdit(DesignEditorController.this.deleteFrame(this.frameToDelete, DesignEditorLID.ImportImageDirectory));
                }
                for (int i = 0; i < this.createdFrames.length; ++i) {
                    DesignEditorController.this.makeFrameNameUnique(this.createdFrames[i]);
                    this.edit.addEdit(DesignEditorController.this.addFrame(this.createdFrames[i]));
                }
                this.edit.end();
                if (this.errorMsg != null) {
                    DesignEditorController.this.interaction.reportProblem(L10N.get("ERROR", "ERROR"), this.errorMsg);
                }
                DesignEditorController.this.undoMgr.addEdit(this.edit);
            }
            if (this.thrownException != null) {
                RcvrExceptionHandler.recover(this.thrownException, DesignEditorController.this.interaction);
            }
            this.progressBar.dispose();
        }
    }

    protected static class ImageData {
        public DoubleRectangle bounds;
        public byte[] data;

        public ImageData(DoubleRectangle bounds, byte[] data) {
            this.bounds = bounds;
            this.data = data;
        }
    }

    public class FrameSubsetDuplicator
    implements IFrame.FrameDuplicator {
        protected Set framesToCopy = new HashSet();
        protected Map copiedFrames = new HashMap();

        public FrameSubsetDuplicator(IFrame[] frames) {
            for (int i = 0; i < frames.length; ++i) {
                this.framesToCopy.add(frames[i]);
            }
        }

        public IFrame getOrDuplicate(IFrame frameToCopy) {
            IFrame frame = (IFrame)this.copiedFrames.get(frameToCopy);
            if (frame == null) {
                if (this.framesToCopy.contains(frameToCopy)) {
                    frame = frameToCopy.duplicate(frameToCopy.getName(), this);
                    DesignEditorController.this.makeFrameNameUnique(frame);
                } else {
                    frame = frameToCopy;
                }
            }
            return frame;
        }

        public void recordDuplicateFrame(IFrame originalFrame, IFrame frameDuplicate) {
            this.copiedFrames.put(originalFrame, frameDuplicate);
        }
    }

    public static final class FramePositionComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            if (a instanceof IFrame && b instanceof IFrame) {
                DoublePoint ao = ((IFrame)a).getFrameOrigin();
                DoublePoint bo = ((IFrame)b).getFrameOrigin();
                if (ao.y == bo.y) {
                    return (int)(ao.x - bo.x);
                }
                return (int)(ao.y - bo.y);
            }
            throw new IllegalArgumentException("IDesign.frames contains something other than IFrames!");
        }
    }
}

