/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.AController;
import edu.cmu.cs.hcii.cogtool.controller.ControllerNexus;
import edu.cmu.cs.hcii.cogtool.controller.ControllerRegistry;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOSaveException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOTempException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import java.io.File;
import java.io.IOException;

public abstract class DefaultController
extends AController {
    protected IProject project;

    public DefaultController(IProject proj) {
        this.project = proj;
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void assignActions() {
        super.assignActions();
        IUI ui = this.getUI();
        if (ui != null) {
            ui.setAction(CogToolLID.SaveProjectAs, new AListenerAction(){

                public boolean performAction(Object prms) {
                    return DefaultController.this.saveAs();
                }
            });
            ui.setAction(CogToolLID.SaveProject, new AListenerAction(){

                public boolean performAction(Object prms) {
                    return DefaultController.this.forceSave();
                }
            });
            ui.setAction(CogToolLID.CloseWindow, this.createCloseWindowAction());
            ui.setAction(CogToolLID.CloseProject, new AListenerAction(){

                public boolean performAction(Object prms) {
                    return DefaultController.this.closeProject(true);
                }
            });
            ui.setAction(CogToolLID.Properties, new AListenerAction(){

                public boolean performAction(Object prms) {
                    return DefaultController.this.showProperties();
                }
            });
        }
    }

    protected boolean forceSave() {
        if (this.persist.isPermanent(this.project)) {
            return this.save();
        }
        return this.saveAs();
    }

    protected boolean save() {
        try {
            this.project.setBuildVersion(CogTool.getVersion());
            this.persist.save(this.project, null);
            CogTool.undoManagerFactory.markSavePoint(this.project);
            return true;
        }
        catch (IOException e) {
            throw new RcvrIOSaveException("Error persisting project: " + e.getMessage(), e);
        }
    }

    protected boolean saveAs() {
        IInteraction stdInteraction = this.getUI().getStandardInteraction();
        try {
            File saveLoc;
            boolean nameIsInUse;
            do {
                if ((saveLoc = stdInteraction.selectFileDest(this.project.getName())) == null) {
                    return false;
                }
                nameIsInUse = this.persist.isRegistered(saveLoc, this.project);
                if (!nameIsInUse) continue;
                switch (stdInteraction.protestBeingEdited(saveLoc)) {
                    case 0: {
                        nameIsInUse = false;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            } while (nameIsInUse);
            String name = saveLoc.getName();
            int periodIndex = name.lastIndexOf(46);
            if (periodIndex > 0) {
                name = name.substring(0, periodIndex);
            }
            this.project.setName(name);
            this.project.setBuildVersion(CogTool.getVersion());
            this.persist.save(this.project, saveLoc);
            CogTool.undoManagerFactory.markSavePoint(this.project);
            return true;
        }
        catch (IOException e) {
            throw new RcvrIOSaveException("Error persisting project: " + e.getMessage(), e);
        }
    }

    protected abstract Object getModelObject();

    protected boolean closeWindow(boolean checkToSave) {
        if (checkToSave && (CogTool.PROJECT_MANAGES_OTHERS && this.project == this.getModelObject() || ControllerNexus.ONLY.getControllerCount(this.project) == 1)) {
            if (!CogTool.undoManagerFactory.isAtSavePoint(this.project)) {
                IInteraction interaction = this.getUI().getStandardInteraction();
                switch (interaction.askSaveBeforeClose(this.project.getName())) {
                    case 0: {
                        if (this.forceSave()) break;
                        return false;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
            this.dispose();
            try {
                this.persist.close(this.project);
            }
            catch (IOException ex) {
                throw new RcvrIOTempException("Error cleaning up temp files: " + ex.getMessage(), ex);
            }
            catch (Exception ex) {
                throw new RcvrUIException("Error closing project: " + ex.getMessage(), ex);
            }
        } else {
            this.dispose();
        }
        return true;
    }

    protected IListenerAction createCloseWindowAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                return DefaultController.this.closeWindow(true);
            }
        };
    }

    public boolean closeProject(boolean checkToSave) {
        return ControllerNexus.ONLY.closeControllers(this.project, checkToSave);
    }

    protected boolean showProperties() {
        IInteraction interaction = this.getUI().getStandardInteraction();
        interaction.showProjectProperties(this.project);
        return true;
    }

    public void dispose() {
        ControllerRegistry.ONLY.removeOpenController(this);
        this.getUI().dispose();
    }
}

