/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.controller.IController;
import edu.cmu.cs.hcii.cogtool.util.EmptyIterator;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Monitor;

public class ControllerNexus {
    public static ControllerNexus ONLY = new ControllerNexus();
    protected Map openControllers = new HashMap();
    protected Map controllerLocations = new HashMap();
    protected Map controllerZooms = new HashMap();

    protected ControllerNexus() {
    }

    public void addController(Object nexus, IController controller) {
        HashSet<IController> nexusControllers = (HashSet<IController>)this.openControllers.get(nexus);
        if (nexusControllers == null) {
            nexusControllers = new HashSet<IController>();
            this.openControllers.put(nexus, nexusControllers);
        }
        nexusControllers.add(controller);
    }

    public int getControllerCount(Object nexus) {
        Set nexusControllers = (Set)this.openControllers.get(nexus);
        return nexusControllers != null ? nexusControllers.size() : 0;
    }

    public boolean removeController(Object nexus, IController controller) {
        Set nexusControllers = (Set)this.openControllers.get(nexus);
        if (nexusControllers == null) {
            return false;
        }
        if (nexusControllers.remove(controller)) {
            if (nexusControllers.size() == 0) {
                this.openControllers.remove(nexus);
                this.controllerLocations.remove(nexus);
                this.controllerZooms.remove(nexus);
            }
            return true;
        }
        return false;
    }

    public Iterator getControllers(Object nexus) {
        Set nexusControllers = (Set)this.openControllers.get(nexus);
        if (nexusControllers == null) {
            return new EmptyIterator();
        }
        return nexusControllers.iterator();
    }

    public boolean closeControllers(Object nexus, boolean checkToSave) {
        Set nexusControllers = (Set)this.openControllers.get(nexus);
        if (nexusControllers != null) {
            Object[] controllers = nexusControllers.toArray();
            for (int i = 0; i < controllers.length; ++i) {
                IController c = (IController)controllers[i];
                if (checkToSave) {
                    if (c.requestClose()) continue;
                    return false;
                }
                c.dispose();
            }
        }
        return true;
    }

    public Set getControllerNexuses() {
        return this.openControllers.keySet();
    }

    protected static Rectangle checkWindowBounds(Rectangle loc) {
        if (loc == null) {
            return loc;
        }
        boolean safe = false;
        Monitor[] monitors = WindowUtil.globalDisplay.getMonitors();
        for (int i = 0; !safe && i < monitors.length; ++i) {
            Monitor monitor = monitors[i];
            safe = monitor.getClientArea().contains(loc.x, loc.y);
        }
        if (!safe) {
            Monitor prim = WindowUtil.globalDisplay.getPrimaryMonitor();
            Rectangle r = prim.getClientArea();
            loc.x = r.x;
            loc.y = r.y;
            if (loc.width > r.width) {
                loc.width = r.width;
            }
            if (loc.height > r.height) {
                loc.height = r.height;
            }
        }
        return loc;
    }

    public Rectangle getWindowLocation(Object nexus, Object model) {
        Map nexusLocations = (Map)this.controllerLocations.get(nexus);
        if (nexusLocations == null) {
            return null;
        }
        return ControllerNexus.checkWindowBounds((Rectangle)nexusLocations.get(model));
    }

    public void saveWindowLocation(Object nexus, Object model, Rectangle loc) {
        HashMap<Object, Rectangle> nexusLocations = (HashMap<Object, Rectangle>)this.controllerLocations.get(nexus);
        if (nexusLocations == null) {
            nexusLocations = new HashMap<Object, Rectangle>();
            this.controllerLocations.put(nexus, nexusLocations);
        }
        nexusLocations.put(model, loc);
    }

    public double getWindowZoom(Object nexus, Object model) {
        Map nexusZooms = (Map)this.controllerZooms.get(nexus);
        if (nexusZooms == null) {
            return 1.0;
        }
        Double zoom = (Double)nexusZooms.get(model);
        if (zoom == null) {
            return 1.0;
        }
        return zoom;
    }

    public void saveWindowZoom(Object nexus, Object model, double zoom) {
        HashMap<Object, Double> nexusZooms = (HashMap<Object, Double>)this.controllerZooms.get(nexus);
        if (nexusZooms == null) {
            nexusZooms = new HashMap<Object, Double>();
            this.controllerZooms.put(nexus, nexusZooms);
        }
        nexusZooms.put(model, new Double(zoom));
    }
}

