/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.controller;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.controller.ControllerNexus;
import edu.cmu.cs.hcii.cogtool.controller.ControllerRegistry;
import edu.cmu.cs.hcii.cogtool.controller.DefaultController;
import edu.cmu.cs.hcii.cogtool.controller.IController;
import edu.cmu.cs.hcii.cogtool.controller.ProjectController;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.ui.IUI;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.INamedObject;
import edu.cmu.cs.hcii.cogtool.util.IPersist;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOLoadException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AController
implements IController {
    protected IPersist persist = CogTool.persistenceFactory.createPersistenceManager();
    protected static final Pattern UNIQUE_NAME_INDEX_PATTERN = Pattern.compile("\\[(\\d+)\\]\\z");

    protected abstract IUI getUI();

    public boolean performAction(CogToolLID id, Object actionParms, boolean doCleanup) {
        IUI ui = this.getUI();
        if (ui != null) {
            return ui.performAction(id, actionParms, doCleanup);
        }
        return false;
    }

    public boolean performAction(CogToolLID id, Object actionParms) {
        return this.performAction(id, actionParms, true);
    }

    protected void assignActions() {
        IUI ui = this.getUI();
        if (ui != null) {
            ui.setAction(CogToolLID.About, ui.popAboutBox());
            ui.setAction(CogToolLID.OpenProject, new AListenerAction(){

                public boolean performAction(Object prms) {
                    if (!(prms instanceof DoublePoint)) {
                        prms = null;
                    }
                    return AController.this.open((DoublePoint)prms);
                }
            });
            ui.setAction(CogToolLID.NewProject, this.createNewProjectAction());
            ui.setAction(CogToolLID.ExitApplication, this.createExitAction());
        }
    }

    protected IListenerAction createNewProjectAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                ProjectController c = CogTool.projectControllerFactory.newProjectController();
                c.populateProject();
                return true;
            }
        };
    }

    protected boolean open(DoublePoint loc) {
        try {
            File[] openLocs = this.getUI().getStandardInteraction().selectFileSources();
            if (openLocs != null) {
                for (int i = 0; i < openLocs.length; ++i) {
                    IProject proj = (IProject)this.persist.load(openLocs[i]);
                    String name = openLocs[i].getName();
                    int periodIndex = name.lastIndexOf(46);
                    if (periodIndex > 0) {
                        name = name.substring(0, periodIndex);
                    }
                    proj.setName(name);
                    ProjectController c = CogTool.projectControllerFactory.openController(proj, false, true);
                    IUI ui = this.getUI();
                    if (loc == null || ui == null) continue;
                    c.getUI().setLocation(loc);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RcvrIOLoadException("Error loading project: " + e.getMessage(), e);
        }
    }

    public void takeFocus() {
        IUI ui = this.getUI();
        if (ui == null) {
            throw new RcvrUIException("No ui available for taking focus.");
        }
        ui.takeFocus();
    }

    public boolean requestClose() {
        IUI ui = this.getUI();
        if (ui != null) {
            return ui.requestClose();
        }
        throw new RcvrUIException("No ui available for close request.");
    }

    protected IListenerAction createExitAction() {
        return new AListenerAction(){

            public boolean performAction(Object prms) {
                int i;
                boolean old_PROJECT_MANAGES_OTHERS = CogTool.PROJECT_MANAGES_OTHERS;
                CogTool.PROJECT_MANAGES_OTHERS = true;
                Set projectSet = ControllerNexus.ONLY.getControllerNexuses();
                Object[] controllers = projectSet.toArray();
                for (i = 0; i < controllers.length; ++i) {
                    DefaultController projectController = ControllerRegistry.ONLY.findOpenController(controllers[i]);
                    if (projectController == null || projectController.requestClose()) continue;
                    CogTool.PROJECT_MANAGES_OTHERS = old_PROJECT_MANAGES_OTHERS;
                    return false;
                }
                CogTool.PROJECT_MANAGES_OTHERS = old_PROJECT_MANAGES_OTHERS;
                projectSet = ControllerNexus.ONLY.getControllerNexuses();
                controllers = projectSet.toArray();
                for (i = 0; i < controllers.length; ++i) {
                    if (ControllerNexus.ONLY.closeControllers(controllers[i], true)) continue;
                    return false;
                }
                System.exit(0);
                return true;
            }
        };
    }

    public void dispose() {
    }

    public void setVisible(boolean visible) {
        IUI ui = this.getUI();
        if (ui != null) {
            ui.setVisible(visible);
        }
    }

    public DoublePoint getLocation() {
        IUI ui = this.getUI();
        if (ui != null) {
            return ui.getLocation();
        }
        return null;
    }

    public static String makeNameUnique(String seedName, Collection col1, Collection col2) {
        if (AController.containsObjectWithName(seedName, col1)) {
            String testName;
            int index = 0;
            Matcher m = UNIQUE_NAME_INDEX_PATTERN.matcher(seedName);
            if (m.find()) {
                seedName = seedName.substring(0, m.start(0)) + '[';
                index = Integer.parseInt(m.group(1));
            } else {
                seedName = seedName + " [";
            }
            while (AController.containsObjectWithName(testName = seedName + Integer.toString(++index) + ']', col1) || col2 != null && AController.containsObjectWithName(testName, col2)) {
            }
            return testName;
        }
        return seedName;
    }

    public static String makeNameUnique(String seedName, Collection col) {
        return AController.makeNameUnique(seedName, col, null);
    }

    public static boolean containsObjectWithName(String name, Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            INamedObject obj = (INamedObject)it.next();
            if (!obj.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

